/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.GroundRaidObjectivesListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.graid.AICoreGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.BlueprintGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.CommodityGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.DisruptIndustryRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.graid.ShipWeaponsGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.SolarArrayGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.SpecialItemRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardGroundRaidObjectivesCreator
implements GroundRaidObjectivesListener {
    @Override
    public void modifyRaidObjectives(MarketAPI market, SectorEntityToken entity, List<GroundRaidObjectivePlugin> objectives, MarketCMD.RaidType type, int marineTokens, int priority) {
        if (priority != 0) {
            return;
        }
        if (market == null) {
            return;
        }
        if (type == MarketCMD.RaidType.VALUABLE) {
            BlueprintGroundRaidObjectivePluginImpl blueprints;
            Map<CommodityOnMarketAPI, Float> raidValuables = this.computeRaidValuables(market);
            ArrayList<CommodityOnMarketAPI> commodities = new ArrayList<CommodityOnMarketAPI>(raidValuables.keySet());
            for (CommodityOnMarketAPI com : commodities) {
                CommodityGroundRaidObjectivePluginImpl curr = new CommodityGroundRaidObjectivePluginImpl(market, com.getId());
                if (curr.getQuantity(1) <= 0.0f) continue;
                objectives.add(curr);
            }
            for (Industry ind : market.getIndustries()) {
                SpecialItemData sid;
                String coreId = ind.getAICoreId();
                if (coreId != null) {
                    AICoreGroundRaidObjectivePluginImpl core = new AICoreGroundRaidObjectivePluginImpl(market, coreId, ind);
                    objectives.add(core);
                }
                if ((sid = ind.getSpecialItem()) == null) continue;
                SpecialItemRaidObjectivePluginImpl special = new SpecialItemRaidObjectivePluginImpl(market, sid.getId(), null, ind);
                objectives.add(special);
            }
            ShipWeaponsGroundRaidObjectivePluginImpl weapons = new ShipWeaponsGroundRaidObjectivePluginImpl(market);
            if (weapons.getQuantity(1) > 0.0f) {
                objectives.add(weapons);
            }
            if ((blueprints = new BlueprintGroundRaidObjectivePluginImpl(market)).getQuantity(1) > 0.0f) {
                objectives.add(blueprints);
            }
            if (market.hasCondition("solar_array")) {
                objectives.add(new SolarArrayGroundRaidObjectivePluginImpl(market));
            }
        } else if (type == MarketCMD.RaidType.DISRUPT) {
            for (Industry ind : market.getIndustries()) {
                DisruptIndustryRaidObjectivePluginImpl curr;
                if (ind.getSpec().hasTag("unraidable") || (curr = new DisruptIndustryRaidObjectivePluginImpl(market, ind)).getBaseDisruptDuration(marineTokens) <= 0.0f) continue;
                objectives.add(curr);
            }
        }
    }

    protected Map<CommodityOnMarketAPI, Float> computeRaidValuables(MarketAPI market) {
        HashMap<CommodityOnMarketAPI, Float> result = new HashMap<CommodityOnMarketAPI, Float>();
        for (CommodityOnMarketAPI com : market.getAllCommodities()) {
            int a;
            if (com.isPersonnel() || com.getCommodity().hasTag("meta") || com.getCommodity().hasTag("nonecon") || (a = com.getAvailable()) <= 0) continue;
            float num = BaseIndustry.getSizeMult(a) * com.getCommodity().getEconUnit() * 0.5f;
            result.put(com, Float.valueOf(num));
        }
        return result;
    }

    @Override
    public void reportRaidObjectivesAchieved(GroundRaidObjectivesListener.RaidResultData data, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }
}

