/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Set;

public abstract class BaseMissionIntel
extends BaseIntelPlugin {
    public static String BUTTON_ACCEPT = "Accept";
    public static String BUTTON_ABANDON = "Abandon";
    protected IntervalUtil randomCancel = null;
    protected Float randomCancelProb = null;
    protected MissionResult missionResult;
    protected MissionState missionState = MissionState.POSTED;
    protected Float duration = null;
    protected float elapsedDays = 0.0f;

    protected void initRandomCancel() {
        this.initRandomCancel(0.5f);
    }

    protected void initRandomCancel(float prob) {
        this.randomCancel = new IntervalUtil(4.0f, 6.0f);
        this.randomCancelProb = Float.valueOf(prob);
    }

    protected void cancel() {
        this.setMissionState(MissionState.CANCELLED);
        this.missionResult = this.createCancelledResult();
        this.endMission();
        this.sendUpdateIfPlayerHasIntel((Object)this.missionResult, true);
    }

    @Override
    public void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.isPosted()) {
            if (this.randomCancel != null) {
                this.randomCancel.advance(days);
                if (this.randomCancel.intervalElapsed() && (float)Math.random() < this.randomCancelProb.floatValue()) {
                    this.cancel();
                }
            }
            return;
        }
        this.elapsedDays += days;
        if (this.duration != null && this.duration.floatValue() - this.elapsedDays <= 0.0f) {
            this.setMissionState(MissionState.FAILED);
            this.missionResult = this.createTimeRanOutFailedResult();
            this.endMission();
            this.sendUpdateIfPlayerHasIntel((Object)this.missionResult, false);
            return;
        }
        this.advanceMission(amount);
    }

    @Override
    public float getTimeRemainingFraction() {
        if (!this.isAccepted() || this.duration == null) {
            return super.getTimeRemainingFraction();
        }
        float f = 1.0f - this.elapsedDays / this.duration.floatValue();
        return f;
    }

    public boolean isPosted() {
        return this.missionState == MissionState.POSTED;
    }

    public boolean isCancelled() {
        return this.missionState == MissionState.CANCELLED;
    }

    public boolean isFailed() {
        return this.missionState == MissionState.FAILED;
    }

    public boolean isCompleted() {
        return this.missionState == MissionState.COMPLETED;
    }

    public boolean isAccepted() {
        return this.missionState == MissionState.ACCEPTED;
    }

    public boolean isAbandoned() {
        return this.missionState == MissionState.ABANDONED;
    }

    public boolean canAbandonWithoutPenalty() {
        return this.elapsedDays < this.getNoPenaltyAbandonDays();
    }

    protected float getNoPenaltyAbandonDays() {
        return 1.0f;
    }

    @Override
    public String getImportantIcon() {
        if (this.isAccepted()) {
            return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
        }
        return super.getImportantIcon();
    }

    public abstract void endMission();

    public abstract void advanceMission(float var1);

    public abstract void missionAccepted();

    protected abstract MissionResult createTimeRanOutFailedResult();

    protected abstract MissionResult createAbandonedResult(boolean var1);

    protected MissionResult createCancelledResult() {
        return new MissionResult();
    }

    protected String getMissionTypeNoun() {
        return "mission";
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_ACCEPT) {
            this.setImportant(true);
            this.setMissionState(MissionState.ACCEPTED);
            this.missionAccepted();
        } else if (buttonId == BUTTON_ABANDON) {
            this.setImportant(false);
            if (!this.canAbandonWithoutPenalty()) {
                this.setMissionState(MissionState.ABANDONED);
                this.missionResult = this.createAbandonedResult(true);
                this.endMission();
            } else {
                this.setMissionState(MissionState.ABANDONED);
                this.missionResult = this.createAbandonedResult(false);
                this.endMission();
            }
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        FactionAPI faction = this.getFactionForUIColors();
        if (buttonId == BUTTON_ACCEPT) {
            prompt.addPara("Accepting this " + this.getMissionTypeNoun() + " will commit you to completing it. " + "Failing to complete it within the required timeframe will result in a reputation penalty " + "with " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        } else if (buttonId == BUTTON_ABANDON) {
            if (this.canAbandonWithoutPenalty()) {
                prompt.addPara("It's been less than a day, and you can still abandon this " + this.getMissionTypeNoun() + " without a penalty.", 0.0f);
            } else {
                prompt.addPara("You can abandon this " + this.getMissionTypeNoun() + ", but will suffer " + "a reputation penalty with " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
            }
        } else {
            super.createConfirmationPrompt(buttonId, prompt);
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_ACCEPT || buttonId == BUTTON_ABANDON) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Missions");
        if (this.isAccepted() || this.isAbandoned() || this.isFailed() || this.isCompleted()) {
            tags.add("Accepted");
        }
        return tags;
    }

    protected void addGenericMissionState(TooltipMakerAPI info) {
        float opad = 10.0f;
        String noun = this.getMissionTypeNoun();
        if (this.isAccepted()) {
            info.addPara("You have accepted this " + noun + ".", opad);
        } else if (this.isFailed()) {
            info.addPara("You have failed this " + noun + ".", opad);
        } else if (this.isCompleted()) {
            info.addPara("You have completed this " + noun + ".", opad);
        } else if (this.isCancelled()) {
            info.addPara("This " + noun + " is no longer being offered.", opad);
        } else if (this.isAbandoned()) {
            info.addPara("You have abandoned this " + noun + ".", opad);
        } else if (this.isPosted()) {
            info.addPara("This " + noun + " posting may be withdrawn at any time unless it's accepted.", Misc.getHighlightColor(), opad);
        }
    }

    public String getPostfixForState() {
        if (this.isEnding()) {
            if (this.isCompleted()) {
                return " - Completed";
            }
            if (this.isFailed()) {
                return " - Failed";
            }
            if (this.isAbandoned()) {
                return " - Abandoned";
            }
            if (this.isCancelled()) {
                return " - Withdrawn";
            }
            return " - Terminated";
        }
        return "";
    }

    protected void addAcceptOrAbandonButton(TooltipMakerAPI info, float width) {
        this.addAcceptOrAbandonButton(info, width, "Accept", "Abandon");
    }

    protected void addAcceptOrAbandonButton(TooltipMakerAPI info, float width, String accept, String abandon) {
        if (this.isPosted()) {
            this.addAcceptButton(info, width, accept);
        } else if (this.isAccepted()) {
            this.addAbandonButton(info, width, abandon);
        }
    }

    protected void addAcceptButton(TooltipMakerAPI info, float width) {
        this.addAcceptButton(info, width, "Accept");
    }

    protected void addAcceptButton(TooltipMakerAPI info, float width, String accept) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(accept, BUTTON_ACCEPT, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(20, true);
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width) {
        this.addAbandonButton(info, width, "Abandon");
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width, String abandon) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(abandon, BUTTON_ABANDON, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(22, true);
    }

    public MissionResult getMissionResult() {
        return this.missionResult;
    }

    public void setMissionResult(MissionResult missionResult) {
        this.missionResult = missionResult;
    }

    public MissionState getMissionState() {
        return this.missionState;
    }

    public void setMissionState(MissionState missionState) {
        this.missionState = missionState;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public float getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(float elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.timestamp == null && this.isEnding()) {
            return true;
        }
        return this.isEnded();
    }

    public static class MissionResult {
        public int payment;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep1;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep2;
        public Object custom;

        public MissionResult() {
        }

        public MissionResult(int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep1) {
            this(payment, rep1, null);
        }

        public MissionResult(int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep1, ReputationActionResponsePlugin.ReputationAdjustmentResult rep2) {
            this.payment = payment;
            this.rep1 = rep1;
            this.rep2 = rep2;
        }
    }

    public static enum MissionState {
        POSTED,
        CANCELLED,
        FAILED,
        ACCEPTED,
        ABANDONED,
        COMPLETED;

    }
}

