/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.rulecmd.missions.Commission;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FactionCommissionIntel
extends BaseMissionIntel
implements EveryFrameScript,
FleetEventListener,
EconomyTickListener {
    public static Logger log = Global.getLogger(FactionCommissionIntel.class);
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected float baseBounty = 0.0f;
    protected FactionAPI faction = null;
    protected CommissionBountyResult latestResult;
    protected LinkedHashMap<String, RepChangeData> repChanges = new LinkedHashMap();

    public FactionCommissionIntel(FactionAPI faction) {
        this.faction = faction;
        this.baseBounty = Global.getSettings().getFloat("factionCommissionBounty");
    }

    protected Object readResolve() {
        this.baseBounty = Global.getSettings().getFloat("factionCommissionBounty");
        return this;
    }

    @Override
    public void advanceMission(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        RepLevel level = this.faction.getRelToPlayer().getLevel();
        if (!level.isAtWorst(RepLevel.NEUTRAL)) {
            this.setMissionResult(new BaseMissionIntel.MissionResult(-1, null));
            this.setMissionState(BaseMissionIntel.MissionState.COMPLETED);
            this.endMission();
            this.sendUpdateIfPlayerHasIntel((Object)this.missionResult, false);
        } else {
            this.makeRepChanges(null);
        }
    }

    @Override
    public void missionAccepted() {
        log.info((Object)String.format("Accepted commission with [%s]", this.faction.getDisplayName(), (int)this.baseBounty));
        this.setImportant(true);
        this.setMissionState(BaseMissionIntel.MissionState.ACCEPTED);
        Global.getSector().getIntelManager().addIntel(this, true);
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().addScript(this);
        Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$fcm_faction", this.faction.getId());
        Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$fcm_eventRef", this);
    }

    @Override
    public void endMission() {
        this.endMission(null);
    }

    public void endMission(InteractionDialogAPI dialog) {
        log.info((Object)String.format("Ending commission with [%s]", this.faction.getDisplayName()));
        Global.getSector().getListenerManager().removeListener(this);
        Global.getSector().removeScript(this);
        Global.getSector().getCharacterData().getMemoryWithoutUpdate().unset("$fcm_faction");
        Global.getSector().getCharacterData().getMemoryWithoutUpdate().unset("$fcm_eventRef");
        this.undoAllRepChanges(dialog);
        this.endImmediately();
        ListenerUtil.reportCommissionEnded(this);
    }

    public void makeRepChanges(InteractionDialogAPI dialog) {
        FactionAPI player = Global.getSector().getPlayerFaction();
        for (FactionAPI other : this.getRelevantFactions()) {
            RepChangeData change = this.repChanges.get(other.getId());
            boolean madeHostile = change != null;
            boolean factionHostile = this.faction.isHostileTo(other);
            boolean playerHostile = player.isHostileTo(other);
            if (factionHostile && !playerHostile && !madeHostile) {
                this.makeHostile(other, dialog);
            }
            if (factionHostile || !madeHostile) continue;
            this.undoRepChange(other, dialog);
        }
    }

    public void makeHostile(FactionAPI other, InteractionDialogAPI dialog) {
        ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MAKE_HOSTILE_AT_BEST, null, null, dialog != null ? dialog.getTextPanel() : null, false, true), other.getId());
        RepChangeData data = new RepChangeData();
        data.faction = other;
        data.delta = rep.delta;
        this.repChanges.put(other.getId(), data);
    }

    public void undoRepChange(FactionAPI other, InteractionDialogAPI dialog) {
        String id = other.getId();
        RepChangeData change = this.repChanges.get(id);
        if (change == null) {
            return;
        }
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = -change.delta;
        impact.delta = Math.max(0.0f, impact.delta - Global.getSettings().getFloat("factionCommissionRestoredRelationshipPenalty"));
        if (impact.delta > 0.0f) {
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, false, true), id);
        }
        this.repChanges.remove(id);
    }

    public void undoAllRepChanges(InteractionDialogAPI dialog) {
        for (RepChangeData data : new ArrayList<RepChangeData>(this.repChanges.values())) {
            this.undoRepChange(data.faction, dialog);
        }
    }

    public List<FactionAPI> getRelevantFactions() {
        LinkedHashSet<FactionAPI> factions = new LinkedHashSet<FactionAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            FactionAPI curr;
            if (market.isHidden() || factions.contains(curr = market.getFaction()) || !curr.isShowInIntelTab()) continue;
            factions.add(curr);
        }
        return new ArrayList<FactionAPI>(factions);
    }

    public List<FactionAPI> getHostileFactions() {
        FactionAPI player = Global.getSector().getPlayerFaction();
        ArrayList<FactionAPI> hostile = new ArrayList<FactionAPI>();
        for (FactionAPI other : this.getRelevantFactions()) {
            if (!this.faction.isHostileTo(other)) continue;
            hostile.add(other);
        }
        return hostile;
    }

    public float computeStipend() {
        float level = Global.getSector().getPlayerPerson().getStats().getLevel();
        return Global.getSettings().getFloat("factionCommissionStipendBase") + Global.getSettings().getFloat("factionCommissionStipendPerLevel") * level;
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        int payment = 0;
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            if (!this.faction.isHostileTo(otherFleet.getFaction())) continue;
            float bounty = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                float mult = Misc.getSizeNum(loss.getHullSpec().getHullSize());
                bounty += mult * this.baseBounty;
                fpDestroyed += (float)loss.getFleetPointCost();
            }
            payment += (int)(bounty * battle.getPlayerInvolvementFraction());
        }
        if (payment > 0) {
            Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
            float repFP = (int)(fpDestroyed * battle.getPlayerInvolvementFraction());
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMMISSION_BOUNTY_REWARD, (Object)new Float(repFP), null, null, true, false), this.faction.getId());
            this.latestResult = new CommissionBountyResult(payment, battle.getPlayerInvolvementFraction(), rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.latestResult, false);
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            return;
        }
        if (this.missionResult == null || this.missionResult.payment >= 0) {
            if (isUpdate && this.latestResult != null) {
                info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
                if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                    info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
                }
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.rep1.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
            } else if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("%s base bounty per hostile frigate", initPad, tc, h, Misc.getDGSCredits(this.baseBounty));
                info.addPara("%s monthly stipend", 0.0f, tc, h, Misc.getDGSCredits(this.computeStipend()));
            } else {
                info.addPara("%s base reward per frigate", initPad, tc, h, Misc.getDGSCredits(this.baseBounty));
                info.addPara("%s monthly stipend", 0.0f, tc, h, Misc.getDGSCredits(this.computeStipend()));
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "Commission";
    }

    @Override
    public String getName() {
        String prefix = String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefix())) + " Commission";
        if (this.isEnding()) {
            if (this.missionResult != null && this.missionResult.payment < 0) {
                if (this.isSendingUpdate()) {
                    return String.valueOf(prefix) + " - Annulled";
                }
                return String.valueOf(prefix) + " - Annulled";
            }
            return String.valueOf(prefix) + " - Resigned";
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            return String.valueOf(prefix) + " - Accepted";
        }
        return prefix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        this.createSmallDescription(info, width, height, false);
    }

    public void createSmallDescription(TooltipMakerAPI info, float width, float height, boolean forMarketConditionTooltip) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.faction.getLogo(), width, 128.0f, opad);
        if (this.isEnding()) {
            if (this.missionResult != null && this.missionResult.payment < 0) {
                info.addPara("Your commission was annulled by " + this.faction.getDisplayNameWithArticle() + " due to your standing falling too low.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
                CoreReputationPlugin.addRequiredStanding(this.faction, Commission.COMMISSION_REQ, null, null, info, tc, opad, true);
                CoreReputationPlugin.addCurrentStanding(this.faction, null, null, info, tc, opad);
            } else {
                info.addPara("You've resigned your commission with " + this.faction.getDisplayNameWithArticle() + ".", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            }
        } else {
            info.addPara("You've accepted a %s commission.", opad, this.faction.getBaseUIColor(), Misc.ucFirst(this.faction.getPersonNamePrefix()));
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            info.addPara("The combat bounty payment depends on the number and size of ships destroyed.", opad);
        }
        if (this.latestResult != null) {
            info.addPara("Most recent bounty:", opad);
            this.bullet(info);
            info.addPara("%s received", opad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            CoreReputationPlugin.addAdjustmentMessage(this.latestResult.rep1.delta, this.faction, null, null, null, info, tc, false, 0.0f);
            this.unindent(info);
        }
        if (!this.isEnding() && !this.isEnded()) {
            boolean plMember = PerseanLeagueMembership.isLeagueMember();
            if (!plMember) {
                this.addAbandonButton(info, width, "Resign commission");
            } else {
                info.addPara("You can not resign your commission while polities under your control are members of the League.", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.remove("Accepted");
        tags.remove("Missions");
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    @Override
    protected BaseMissionIntel.MissionResult createAbandonedResult(boolean withPenalty) {
        return this.createResignedCommissionResult(true, false, null);
    }

    public BaseMissionIntel.MissionResult createResignedCommissionResult(boolean withPenalty, boolean inPerson, InteractionDialogAPI dialog) {
        if (withPenalty) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = -1.0f * Global.getSettings().getFloat("factionCommissionResignPenalty");
            if (inPerson) {
                impact.delta = -1.0f * Global.getSettings().getFloat("factionCommissionResignPenaltyInPerson");
            }
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog != null ? dialog.getTextPanel() : null, false, true), this.faction.getId());
            return new BaseMissionIntel.MissionResult();
        }
        return new BaseMissionIntel.MissionResult();
    }

    @Override
    protected BaseMissionIntel.MissionResult createTimeRanOutFailedResult() {
        return new BaseMissionIntel.MissionResult();
    }

    @Override
    protected String getMissionTypeNoun() {
        return "commission";
    }

    @Override
    protected float getNoPenaltyAbandonDays() {
        return 0.0f;
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        float numIter = Global.getSettings().getFloat("economyIterPerMonth");
        float f = 1.0f / numIter;
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode fleetNode = report.getNode(MonthlyReport.FLEET);
        fleetNode.name = "Fleet";
        fleetNode.custom = MonthlyReport.FLEET;
        fleetNode.tooltipCreator = report.getMonthlyReportTooltip();
        float stipend = this.computeStipend();
        MonthlyReport.FDNode stipendNode = report.getNode(fleetNode, "node_id_stipend_" + this.faction.getId());
        stipendNode.income += stipend * f;
        if (stipendNode.name == null) {
            stipendNode.name = String.valueOf(this.faction.getDisplayName()) + " Commission";
            stipendNode.icon = this.faction.getCrest();
            stipendNode.tooltipCreator = new TooltipMakerAPI.TooltipCreator(){

                @Override
                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                @Override
                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    tooltip.addPara("Your monthly stipend for holding a " + FactionCommissionIntel.this.faction.getDisplayName() + " commission", 0.0f);
                }
            };
        }
    }

    public static class CommissionBountyResult
    extends BaseMissionIntel.MissionResult {
        public float fraction;

        public CommissionBountyResult(int payment, float fraction, ReputationActionResponsePlugin.ReputationAdjustmentResult rep) {
            super(payment, rep);
            this.fraction = fraction;
        }
    }

    public static class RepChangeData {
        public FactionAPI faction;
        public float delta;
    }
}

