/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class MessageIntel
extends BaseIntelPlugin {
    protected List<MessageLineData> lines = new ArrayList<MessageLineData>();
    protected String icon;
    protected String sound;
    protected String extra;

    public MessageIntel() {
    }

    public MessageIntel(String text) {
        this(text, null, null, null);
    }

    public MessageIntel(String text, Color color) {
        this(text, color, null, null);
    }

    public MessageIntel(String text, Color color, String[] highlights, Color ... colors) {
        this.addLine(text, color, highlights, colors);
    }

    public void addLine(String text) {
        this.addLine(text, null, null, null);
    }

    public void addLine(String text, Color color) {
        this.addLine(text, color, null, null);
    }

    public void addLine(String text, Color color, String[] highlights, Color ... colors) {
        MessageLineData line = new MessageLineData(text, color, highlights, colors);
        this.lines.add(line);
    }

    public void clearLines() {
        this.lines.clear();
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        float pad = 3.0f;
        boolean first = true;
        for (MessageLineData line : this.lines) {
            Color c = line.color;
            if (c == null) {
                c = Misc.getTextColor();
            }
            float currPad = pad;
            if (first) {
                currPad = 0.0f;
            }
            if (line.highlights != null) {
                LabelAPI label = info.addPara(line.text, currPad, c, c, line.highlights);
                label.setHighlight(line.highlights);
                label.setHighlightColors(line.colors);
            } else {
                info.addPara(line.text, c, currPad);
            }
            if (!first) {
                pad = 0.0f;
            }
            first = false;
        }
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    @Override
    public String getCommMessageSound() {
        if (this.sound != null) {
            return this.sound;
        }
        return MessageIntel.getSoundMinorMessage();
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public static class MessageLineData {
        protected String text;
        protected Color color;
        protected String[] highlights;
        protected Color[] colors;

        public MessageLineData(String text) {
            this(text, null, null, null);
        }

        public MessageLineData(String text, Color color) {
            this(text, color, null, null);
        }

        public MessageLineData(String text, Color color, String[] highlights, Color ... colors) {
            this.text = text;
            this.color = color;
            this.highlights = highlights;
            this.colors = colors;
        }
    }
}

