/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PersonBountyManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.impl.campaign.shared.PersonBountyEventData;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonBountyIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener {
    public static Logger log = Global.getLogger(PersonBountyIntel.class);
    public static float MAX_DURATION = 90.0f;
    public static float MAX_TIME_BASED_ADDED_LEVEL = 3.0f;
    private float elapsedDays = 0.0f;
    private float duration = MAX_DURATION;
    private float bountyCredits = 0.0f;
    private FactionAPI faction;
    private PersonAPI person;
    private CampaignFleetAPI fleet;
    private FleetMemberAPI flagship;
    private BountyType bountyType;
    private SectorEntityToken hideoutLocation = null;
    private int level = 0;
    protected BountyResult result = null;

    public float getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(float elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public static PersonBountyEventData getSharedData() {
        return SharedData.getData().getPersonBountyEventData();
    }

    public PersonBountyIntel() {
        this.pickLevel();
        this.pickFaction();
        if (this.isDone()) {
            return;
        }
        this.initBountyAmount();
        this.pickHideoutLocation();
        if (this.isDone()) {
            return;
        }
        this.pickBountyType();
        if (this.bountyType == BountyType.DESERTER) {
            this.bountyCredits *= 1.5f;
        }
        this.initPerson();
        if (this.isDone()) {
            return;
        }
        this.spawnFleet();
        if (this.isDone()) {
            return;
        }
        log.info((Object)String.format("Starting person bounty by faction [%s] for person %s", this.faction.getDisplayName(), this.person.getName().getFullName()));
        Global.getSector().getIntelManager().queueIntel(this);
    }

    @Override
    public void reportMadeVisibleToPlayer() {
        if (!this.isEnding() && !this.isEnded()) {
            this.duration = Math.max(this.duration * 0.5f, Math.min(this.duration * 2.0f, MAX_DURATION));
        }
    }

    protected void pickLevel() {
        int add;
        int base = PersonBountyIntel.getSharedData().getLevel();
        float timeFactor = (PirateBaseManager.getInstance().getDaysSinceStart() - 180.0f) / 730.0f;
        if (timeFactor < 0.0f) {
            timeFactor = 0.0f;
        }
        if (timeFactor > 1.0f) {
            timeFactor = 1.0f;
        }
        if ((base += (add = Math.round(MAX_TIME_BASED_ADDED_LEVEL * timeFactor))) > 10) {
            base = 10;
        }
        boolean hasLow = false;
        boolean hasHigh = false;
        for (EveryFrameScript s : PersonBountyManager.getInstance().getActive()) {
            PersonBountyIntel bounty = (PersonBountyIntel)s;
            int curr = bounty.getLevel();
            if (curr < base || curr == 0) {
                hasLow = true;
            }
            if (curr <= base) continue;
            hasHigh = true;
        }
        this.level = base;
        if (!hasLow) {
            this.level = 0;
        } else if (!hasHigh) {
            this.level += new Random().nextInt(3) + 2;
        }
        if (this.level < 0) {
            this.level = 0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    protected void pickHideoutLocation() {
        WeightedRandomPicker<StarSystemAPI> systemPicker = new WeightedRandomPicker<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float f = 0.0f;
            if (system.hasPulsar()) continue;
            if (system.hasTag("theme_misc_skip")) {
                f = 1.0f;
            } else if (system.hasTag("theme_misc")) {
                f = 3.0f;
            } else if (system.hasTag("theme_remnant_no_fleets")) {
                f = 3.0f;
            } else if (system.hasTag("theme_ruins")) {
                f = 5.0f;
            } else if (system.hasTag("theme_remnant_destroyed")) {
                f = 3.0f;
            } else if (system.hasTag("theme_core_unpopulated")) {
                f = 1.0f;
            }
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                if (market.isHidden()) continue;
                f = 0.0f;
                break;
            }
            float distToPlayer = Misc.getDistanceToPlayerLY(system.getLocation());
            float noSpawnRange = Global.getSettings().getFloat("personBountyNoSpawnRangeAroundPlayerLY");
            if (distToPlayer < noSpawnRange) {
                f = 0.0f;
            }
            if (f <= 0.0f) continue;
            float weight = system.getPlanets().size();
            for (PlanetAPI planet : system.getPlanets()) {
                if (planet.isStar() || planet.getMarket() == null) continue;
                float h = planet.getMarket().getHazardValue();
                if (h <= 0.0f) {
                    weight += 5.0f;
                    continue;
                }
                if (h <= 0.25f) {
                    weight += 3.0f;
                    continue;
                }
                if (!(h <= 0.5f)) continue;
                weight += 1.0f;
            }
            float dist = system.getLocation().length();
            float distMult = Math.max(0.0f, 50000.0f - dist);
            systemPicker.add(system, weight * f * distMult);
        }
        StarSystemAPI system2 = (StarSystemAPI)systemPicker.pick();
        if (system2 != null) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>();
            for (SectorEntityToken sectorEntityToken : system2.getPlanets()) {
                if (sectorEntityToken.isStar() || sectorEntityToken.getMarket() != null && !sectorEntityToken.getMarket().isPlanetConditionMarketOnly()) continue;
                picker.add(sectorEntityToken);
            }
            this.hideoutLocation = (SectorEntityToken)picker.pick();
        }
        if (this.hideoutLocation == null) {
            this.endImmediately();
        }
    }

    private void pickFaction() {
        MarketAPI market2;
        FactionAPI player = Global.getSector().getPlayerFaction();
        String commFacId = Misc.getCommissionFactionId();
        boolean forceCommissionFaction = true;
        if (commFacId != null && PersonBountyIntel.getSharedData().isParticipating(commFacId)) {
            for (EveryFrameScript s : PersonBountyManager.getInstance().getActive()) {
                PersonBountyIntel bounty = (PersonBountyIntel)s;
                if (bounty.faction == null || !bounty.faction.getId().equals(commFacId)) continue;
                forceCommissionFaction = false;
            }
        } else {
            forceCommissionFaction = false;
        }
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!PersonBountyIntel.getSharedData().isParticipating(market2.getFactionId()) || market2.getSize() < 3 || market2.isHidden() || market2.getFaction().isPlayerFaction()) continue;
            float weight = market2.getSize();
            if (market2.hasIndustry("patrolhq")) {
                weight *= 1.5f;
            }
            if (market2.hasIndustry("militarybase")) {
                weight *= 3.0f;
            }
            if (market2.hasIndustry("highcommand")) {
                weight *= 5.0f;
            }
            if (market2.getFaction() != null) {
                if (forceCommissionFaction && !market2.getFaction().getId().equals(commFacId)) continue;
                if (market2.getFaction().isHostileTo(player)) {
                    weight *= 0.5f;
                }
            }
            if (!(weight > 0.0f)) continue;
            picker.add(market2, weight);
        }
        if (picker.isEmpty()) {
            this.endImmediately();
            return;
        }
        market2 = (MarketAPI)picker.pick();
        this.faction = market2.getFaction();
    }

    private void initBountyAmount() {
        float highStabilityMult = 1.0f;
        float base = Global.getSettings().getFloat("basePersonBounty");
        float perLevel = Global.getSettings().getFloat("personBountyPerLevel");
        float random = perLevel * (float)((int)(Math.random() * 15.0)) / 15.0f;
        this.bountyCredits = (int)((base + perLevel * (float)this.level + random) * highStabilityMult);
    }

    private void initPerson() {
        String factionId = "pirates";
        if (this.bountyType == BountyType.DESERTER) {
            factionId = this.faction.getId();
        }
        int personLevel = (int)(5.0f + (float)this.level * 1.5f);
        this.person = OfficerManagerEvent.createOfficer(Global.getSector().getFaction(factionId), personLevel, false);
        if (this.level >= 7) {
            this.person.setRankId(Ranks.SPACE_ADMIRAL);
        } else {
            this.person.setRankId(Ranks.SPACE_CAPTAIN);
        }
    }

    private void pickBountyType() {
        WeightedRandomPicker<BountyType> picker = new WeightedRandomPicker<BountyType>();
        picker.add(BountyType.PIRATE, 10.0f);
        if (this.level >= 4) {
            picker.add(BountyType.DESERTER, 30.0f);
        }
        this.bountyType = (BountyType)((Object)picker.pick());
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= this.duration && !this.isDone()) {
            boolean canEnd;
            boolean bl = canEnd = this.fleet == null || !this.fleet.isInCurrentLocation();
            if (canEnd) {
                log.info((Object)String.format("Ending bounty on %s by %s", this.person.getName().getFullName(), this.faction.getDisplayName()));
                this.result = new BountyResult(BountyResultType.END_TIME, 0, null);
                this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
                this.cleanUpFleetAndEndIfNecessary();
                return;
            }
        }
        if (this.fleet == null) {
            return;
        }
        if (this.fleet.isInCurrentLocation() && !this.fleet.getFaction().getId().equals("pirates")) {
            this.fleet.setFaction("pirates", true);
        } else if (!this.fleet.isInCurrentLocation() && !this.fleet.getFaction().getId().equals("neutral")) {
            this.fleet.setFaction("neutral", true);
        }
        if (this.fleet.getFlagship() == null || this.fleet.getFlagship().getCaptain() != this.person) {
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            boolean current = this.fleet.isInCurrentLocation();
            this.sendUpdateIfPlayerHasIntel((Object)this.result, !current);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        this.cleanUpFleetAndEndIfNecessary();
    }

    protected void cleanUpFleetAndEndIfNecessary() {
        if (this.fleet != null) {
            Misc.makeUnimportant(this.fleet, "pbe");
            this.fleet.clearAssignments();
            if (this.hideoutLocation != null) {
                this.fleet.getAI().addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.hideoutLocation, 1000000.0f, null);
            } else {
                this.fleet.despawn();
            }
            this.fleet = null;
        }
        if (!this.isEnding() && !this.isEnded()) {
            this.endAfterDelay();
        }
    }

    protected boolean willPay() {
        return true;
    }

    protected boolean willRepIncrease() {
        return true;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        boolean playerInvolved;
        if (this.isDone() || this.result != null) {
            return;
        }
        float distToPlayer = Misc.getDistance(fleet, Global.getSector().getPlayerFleet());
        boolean bl = playerInvolved = battle.isPlayerInvolved() || fleet.isInCurrentLocation() && distToPlayer < 2000.0f;
        if (battle.isInvolved(fleet) && !playerInvolved && (fleet.getFlagship() == null || fleet.getFlagship().getCaptain() != this.person)) {
            fleet.setCommander(fleet.getFaction().createRandomPerson());
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerInvolved || !battle.isInvolved(fleet) || battle.onPlayerSide(fleet)) {
            return;
        }
        if (fleet.getFlagship() != null && fleet.getFlagship().getCaptain() == this.person) {
            return;
        }
        int payment = (int)this.bountyCredits;
        if (payment <= 0) {
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
            return;
        }
        if (this.willPay()) {
            log.info((Object)String.format("Paying bounty of %d from faction [%s]", payment, this.faction.getDisplayName()));
            playerFleet.getCargo().getCredits().add(payment);
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.PERSON_BOUNTY_REWARD, null, null, null, true, false), this.faction.getId());
            this.result = new BountyResult(BountyResultType.END_PLAYER_BOUNTY, payment, rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        } else if (this.willRepIncrease()) {
            log.info((Object)String.format("Not paying bounty, but improving rep with faction [%s]", this.faction.getDisplayName()));
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.PERSON_BOUNTY_REWARD, null, null, null, true, false), this.faction.getId());
            this.result = new BountyResult(BountyResultType.END_PLAYER_NO_BOUNTY, payment, rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        } else {
            log.info((Object)String.format("Not paying bounty or improving rep with faction [%s]", this.faction.getDisplayName()));
            this.result = new BountyResult(BountyResultType.END_PLAYER_NO_REWARD, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, false);
        }
        PersonBountyIntel.getSharedData().reportSuccess();
        this.cleanUpFleetAndEndIfNecessary();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isDone() || this.result != null) {
            return;
        }
        if (this.fleet == fleet) {
            fleet.setCommander(fleet.getFaction().createRandomPerson());
            this.result = new BountyResult(BountyResultType.END_OTHER, 0, null);
            this.sendUpdateIfPlayerHasIntel((Object)this.result, true);
            this.cleanUpFleetAndEndIfNecessary();
        }
    }

    private void spawnFleet() {
        FactionAPI faction;
        float maxFp;
        float qf;
        String fleetFactionId = "pirates";
        if (this.bountyType == BountyType.DESERTER) {
            fleetFactionId = this.faction.getId();
        }
        if ((qf = (float)this.level / 10.0f) > 1.0f) {
            qf = 1.0f;
        }
        String fleetName = "";
        fleetName = String.valueOf(this.person.getName().getLast()) + "'s" + " Fleet";
        float fp = (float)(5 + this.level * 5) * 5.0f;
        fp *= 0.75f + (float)Math.random() * 0.25f;
        if (this.level >= 7) {
            fp += 20.0f;
        }
        if (this.level >= 8) {
            fp += 30.0f;
        }
        if (this.level >= 9) {
            fp += 50.0f;
        }
        if (this.level >= 10) {
            fp += 50.0f;
        }
        if (fp > (maxFp = (faction = Global.getSector().getFaction(fleetFactionId)).getApproximateMaxFPPerFleet(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) * 1.1f)) {
            fp = maxFp;
        }
        FleetParamsV3 params = new FleetParamsV3(null, this.hideoutLocation.getLocationInHyperspace(), fleetFactionId, Float.valueOf(qf + 0.2f), "personBounty", fp, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        params.ignoreMarketFleetSizeMult = true;
        this.fleet = FleetFactoryV3.createFleet(params);
        if (this.fleet == null || this.fleet.isEmpty()) {
            this.endImmediately();
            return;
        }
        this.fleet.setCommander(this.person);
        this.fleet.getFlagship().setCaptain(this.person);
        FleetFactoryV3.addCommanderSkills(this.person, this.fleet, null);
        Misc.makeImportant(this.fleet, "pbe", this.duration + 20.0f);
        this.fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        this.fleet.getMemoryWithoutUpdate().set("$core_fleetNoMilitaryResponse", true);
        this.fleet.setNoFactionInName(true);
        this.fleet.setFaction("neutral", true);
        this.fleet.setName(fleetName);
        this.fleet.addEventListener(this);
        LocationAPI location = this.hideoutLocation.getContainingLocation();
        location.addEntity(this.fleet);
        this.fleet.setLocation(this.hideoutLocation.getLocation().x - 500.0f, this.hideoutLocation.getLocation().y + 500.0f);
        this.fleet.getAI().addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.hideoutLocation, 1000000.0f, null);
        this.flagship = this.fleet.getFlagship();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.result == null) {
            if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("%s reward", initPad, tc, h, Misc.getDGSCredits(this.bountyCredits));
                int days = (int)(this.duration - this.elapsedDays);
                if (days <= 1) {
                    days = 1;
                }
                this.addDays(info, "remaining", days, tc);
            } else {
                info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
                if (!this.isEnding()) {
                    int days = (int)(this.duration - this.elapsedDays);
                    String daysStr = "days";
                    if (days <= 1) {
                        days = 1;
                        daysStr = "day";
                    }
                    info.addPara("%s reward, %s " + daysStr + " remaining", 0.0f, tc, h, Misc.getDGSCredits(this.bountyCredits), "" + days);
                }
            }
            this.unindent(info);
            return;
        }
        switch (this.result.type) {
            case END_PLAYER_BOUNTY: {
                info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.result.payment));
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_PLAYER_NO_BOUNTY: {
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_PLAYER_NO_REWARD: {
                CoreReputationPlugin.addAdjustmentMessage(this.result.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
                break;
            }
            case END_TIME: {
                break;
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "Personal Bounty";
    }

    @Override
    public String getName() {
        String n = this.person.getName().getFullName();
        if (this.result != null) {
            switch (this.result.type) {
                case END_PLAYER_BOUNTY: 
                case END_PLAYER_NO_BOUNTY: 
                case END_PLAYER_NO_REWARD: {
                    return "Bounty Completed - " + n;
                }
                case END_OTHER: 
                case END_TIME: {
                    return "Bounty Ended - " + n;
                }
            }
        }
        return "Personal Bounty - " + n;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.person.getPortraitSprite(), width, 128.0f, opad);
        String type = "a notorious pirate";
        if (this.bountyType == BountyType.DESERTER) {
            type = "a deserter";
        }
        String has = this.faction.getDisplayNameHasOrHave();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + has + " posted a bounty for bringing " + this.person.getName().getFullName() + ", " + type + ", to justice.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        if (this.result != null) {
            if (this.result.type == BountyResultType.END_PLAYER_BOUNTY) {
                info.addPara("You have successfully completed this bounty.", opad);
            } else if (this.result.type == BountyResultType.END_PLAYER_NO_BOUNTY) {
                info.addPara("You have successfully completed this bounty, but received no credit reward because of your standing with " + Misc.ucFirst(this.faction.getDisplayNameWithArticle()) + ".", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else if (this.result.type == BountyResultType.END_PLAYER_NO_REWARD) {
                info.addPara("You have successfully completed this bounty, but received no reward because of your standing with " + Misc.ucFirst(this.faction.getDisplayNameWithArticle()) + ".", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara("This bounty is no longer on offer.", opad);
            }
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.result == null) {
            if (this.hideoutLocation != null) {
                SectorEntityToken fake = this.hideoutLocation.getContainingLocation().createToken(0.0f, 0.0f);
                fake.setOrbit(Global.getFactory().createCircularOrbit(this.hideoutLocation, 0.0f, 1000.0f, 100.0f));
                String loc = BreadcrumbSpecial.getLocatedString(fake);
                loc = loc.replaceAll("orbiting", "hiding out near");
                loc = loc.replaceAll("located in", "hiding out in");
                String sheIs = "She is";
                if (this.person.getGender() == FullName.Gender.MALE) {
                    sheIs = "He is";
                }
                info.addPara(String.valueOf(sheIs) + " rumored to be " + loc + ".", opad);
            }
            int cols = 7;
            float iconSize = width / (float)cols;
            if (DebugFlags.PERSON_BOUNTY_DEBUG_INFO) {
                boolean deflate = false;
                if (!this.fleet.isInflated()) {
                    this.fleet.setFaction("pirates", true);
                    this.fleet.inflateIfNeeded();
                    deflate = true;
                }
                String her = "her";
                if (this.person.getGender() == FullName.Gender.MALE) {
                    her = "his";
                }
                info.addPara("The bounty posting also contains partial intel on the ships under " + her + " command. (DEBUG: full info)", opad);
                info.addShipList(cols, 3, iconSize, this.getFactionForUIColors().getBaseUIColor(), this.fleet.getMembersWithFightersCopy(), opad);
                info.addPara("level: " + this.level, 3.0f);
                info.addPara("type: " + this.bountyType.name(), 3.0f);
                if (deflate) {
                    this.fleet.deflate();
                }
            } else {
                boolean deflate = false;
                if (!this.fleet.isInflated()) {
                    this.fleet.setFaction("pirates", true);
                    this.fleet.inflateIfNeeded();
                    deflate = true;
                }
                ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
                Random random = new Random(this.person.getNameString().hashCode() * 170000);
                List<FleetMemberAPI> members = this.fleet.getFleetData().getMembersListCopy();
                int max = 7;
                for (FleetMemberAPI member : members) {
                    if (list.size() >= max) break;
                    if (member.isFighterWing()) continue;
                    float prob = (float)member.getFleetPointCost() / 20.0f;
                    prob += (float)max / (float)members.size();
                    if (member.isFlagship()) {
                        prob = 1.0f;
                    }
                    if (random.nextFloat() > prob) continue;
                    FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
                    if (member.isFlagship()) {
                        copy.setCaptain(this.person);
                    }
                    list.add(copy);
                }
                if (!list.isEmpty()) {
                    String her = "her";
                    if (this.person.getGender() == FullName.Gender.MALE) {
                        her = "his";
                    }
                    info.addPara("The bounty posting also contains partial intel on some of the ships under " + her + " command.", opad);
                    info.addShipList(cols, 1, iconSize, this.getFactionForUIColors().getBaseUIColor(), list, opad);
                    int num = members.size() - list.size();
                    num = Math.round((float)num * (1.0f + random.nextFloat() * 0.5f));
                    num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
                    if (num > 1) {
                        info.addPara("The intel assessment notes the fleet may contain upwards of %s other ships of lesser significance.", opad, h, "" + num);
                    } else {
                        info.addPara("The intel assessment notes the fleet may contain several other ships of lesser significance.", opad);
                    }
                }
                if (deflate) {
                    this.fleet.deflate();
                }
            }
        }
    }

    @Override
    public String getIcon() {
        return this.person.getPortraitSprite();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Bounties");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        Constellation c = this.hideoutLocation.getConstellation();
        SectorEntityToken entity = null;
        if (c != null && map != null) {
            entity = map.getConstellationLabelEntity(c);
        }
        if (entity == null) {
            entity = this.hideoutLocation;
        }
        return entity;
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public float getBountyCredits() {
        return this.bountyCredits;
    }

    public void setBountyCredits(float bountyCredits) {
        this.bountyCredits = bountyCredits;
    }

    public BountyType getBountyType() {
        return this.bountyType;
    }

    public void setBountyType(BountyType bountyType) {
        this.bountyType = bountyType;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public FleetMemberAPI getFlagship() {
        return this.flagship;
    }

    public SectorEntityToken getHideoutLocation() {
        return this.hideoutLocation;
    }

    public BountyResult getResult() {
        return this.result;
    }

    public static class BountyResult {
        public BountyResultType type;
        public int payment;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep;

        public BountyResult(BountyResultType type, int payment, ReputationActionResponsePlugin.ReputationAdjustmentResult rep) {
            this.type = type;
            this.payment = payment;
            this.rep = rep;
        }
    }

    public static enum BountyResultType {
        END_PLAYER_BOUNTY,
        END_PLAYER_NO_BOUNTY,
        END_PLAYER_NO_REWARD,
        END_OTHER,
        END_TIME;

    }

    public static enum BountyType {
        PIRATE,
        DESERTER;

    }
}

