/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.intel.GenericMissionManager;
import com.fs.starfarer.api.impl.campaign.intel.SurveyPlanetMissionIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;

public class SurveyPlanetIntelCreator
implements GenericMissionManager.GenericMissionCreator {
    protected transient WeightedRandomPicker<PlanetAPI> planetPicker = null;

    @Override
    public EveryFrameScript createMissionIntel() {
        PlanetAPI planet = this.pickPlanet();
        if (planet == null) {
            return null;
        }
        return new SurveyPlanetMissionIntel(planet);
    }

    @Override
    public float getMissionFrequencyWeight() {
        return 10.0f;
    }

    protected void initPicker() {
        this.planetPicker = new WeightedRandomPicker();
        block0: for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            for (MarketAPI market : Misc.getMarketsInLocation(system)) {
                if (!market.isHidden()) continue block0;
            }
            for (PlanetAPI planet : system.getPlanets()) {
                if (!SurveyPlanetIntelCreator.isValidMissionTarget(planet) || Misc.isImportantForReason(planet.getMemoryWithoutUpdate(), "spm")) continue;
                float weight = 1.0f;
                for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
                    if (mc.getGenSpec() == null) continue;
                    weight += mc.getGenSpec().getXpMult();
                }
                this.planetPicker.add(planet);
            }
        }
    }

    protected void prunePicker() {
        for (PlanetAPI planet : new ArrayList<PlanetAPI>(this.planetPicker.getItems())) {
            if (SurveyPlanetIntelCreator.isValidMissionTarget(planet)) continue;
            this.planetPicker.remove(planet);
        }
    }

    public static boolean isValidMissionTarget(PlanetAPI planet) {
        if (planet.hasTag("not_random_mission_target")) {
            return false;
        }
        if (planet.isStar() || planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly() || planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            return false;
        }
        return planet.getContainingLocation() == null || !planet.getContainingLocation().hasTag("theme_hidden");
    }

    protected PlanetAPI pickPlanet() {
        if (this.planetPicker == null) {
            this.initPicker();
        }
        this.prunePicker();
        PlanetAPI planet = this.planetPicker.pick();
        for (EveryFrameScript s : GenericMissionManager.getInstance().getActive()) {
            SurveyPlanetMissionIntel intel;
            if (!(s instanceof SurveyPlanetMissionIntel) || planet != (intel = (SurveyPlanetMissionIntel)s).getPlanet()) continue;
            return null;
        }
        return planet;
    }
}

