/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.FactionCommissionIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SystemBountyIntel
extends BaseIntelPlugin
implements EveryFrameScript,
FleetEventListener {
    public static Logger log = Global.getLogger(SystemBountyIntel.class);
    public static float MAX_DURATION = 60.0f;
    protected MarketAPI market;
    protected LocationAPI location;
    protected float elapsedDays = 0.0f;
    protected float duration = MAX_DURATION;
    protected float baseBounty = 0.0f;
    protected FactionAPI faction = null;
    protected FactionAPI enemyFaction = null;
    protected SystemBountyResult latestResult;
    protected boolean commerceMode = false;
    protected MilitaryResponseScript script;

    public SystemBountyIntel(MarketAPI market) {
        this(market, -1, false);
    }

    public SystemBountyIntel(MarketAPI market, int baseReward, boolean commerceMode) {
        this.market = market;
        this.commerceMode = commerceMode;
        this.location = market.getContainingLocation();
        this.faction = market.getFaction();
        if (commerceMode) {
            this.faction = Global.getSector().getFaction("independent");
        }
        if (!commerceMode && market.getFaction().isPlayerFaction()) {
            this.endImmediately();
            return;
        }
        this.baseBounty = Global.getSettings().getFloat("baseSystemBounty");
        float marketSize = market.getSize();
        this.baseBounty *= (marketSize + 5.0f) / 10.0f;
        float highStabilityMult = BaseMarketConditionPlugin.getHighStabilityBonusMult(market);
        highStabilityMult = 1.0f + (highStabilityMult - 1.0f) * 0.5f;
        this.baseBounty *= highStabilityMult;
        this.baseBounty = (int)this.baseBounty;
        if (baseReward > 0) {
            this.baseBounty = baseReward;
        }
        log.info((Object)String.format("Starting bounty at market [%s], %d credits per frigate", market.getName(), (int)this.baseBounty));
        this.updateLikelyCauseFaction();
        if (commerceMode) {
            Global.getSector().getIntelManager().addIntel(this);
        } else {
            Global.getSector().getIntelManager().queueIntel(this);
        }
        Global.getSector().getListenerManager().addListener(this);
        if (!commerceMode) {
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "system_bounty_" + market.getId(), this.getFactionForUIColors(), market.getPrimaryEntity(), 0.75f, this.duration);
            this.script = new MilitaryResponseScript(params);
            this.location.addScript(this.script);
        }
    }

    @Override
    public void reportMadeVisibleToPlayer() {
        if (!this.isEnding() && !this.isEnded()) {
            this.duration = Math.max(this.duration * 0.5f, Math.min(this.duration * 2.0f, MAX_DURATION));
        }
    }

    public float getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(float elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public void reset() {
        this.elapsedDays = 0.0f;
        this.endingTimeRemaining = null;
        this.ending = null;
        this.ended = null;
        this.script.setElapsed(0.0f);
        if (!Global.getSector().getListenerManager().hasListener(this)) {
            Global.getSector().getListenerManager().addListener(this);
        }
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    private void updateLikelyCauseFaction() {
        int maxSize = 0;
        MarketAPI maxOther = null;
        for (MarketAPI other : Misc.getNearbyMarkets(this.market.getLocationInHyperspace(), 0.0f)) {
            int size;
            if (this.market.getFaction() == other.getFaction() || !this.market.getFaction().isHostileTo(other.getFaction()) || (size = other.getSize()) <= maxSize) continue;
            maxSize = size;
            maxOther = other;
        }
        this.enemyFaction = maxOther != null ? maxOther.getFaction() : Global.getSector().getFaction("pirates");
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= this.duration && !this.isDone() && !this.commerceMode) {
            this.endAfterDelay();
            boolean current = this.market.getContainingLocation() == Global.getSector().getCurrentLocation();
            this.sendUpdateIfPlayerHasIntel(new Object(), !current);
            return;
        }
        if (this.faction != this.market.getFaction() || !this.market.isInEconomy()) {
            this.endAfterDelay();
            boolean current = this.market.getContainingLocation() == Global.getSector().getCurrentLocation();
            this.sendUpdateIfPlayerHasIntel(new Object(), !current);
            return;
        }
    }

    @Override
    public float getTimeRemainingFraction() {
        if (this.commerceMode) {
            return 1.0f;
        }
        float f = 1.0f - this.elapsedDays / this.duration;
        return f;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        log.info((Object)String.format("Ending bounty at market [%s]", this.market.getName()));
        Global.getSector().getListenerManager().removeListener(this);
        this.location.removeScript(this.script);
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (!Misc.isNear(primaryWinner, this.market.getLocationInHyperspace())) {
            return;
        }
        int payment = 0;
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            if (this.commerceMode ? !this.market.getFaction().isHostileTo(otherFleet.getFaction()) && !otherFleet.getFaction().isHostileTo("independent") || Misc.isTrader(otherFleet) || "independent".equals(otherFleet.getFaction().getId()) : !this.market.getFaction().isHostileTo(otherFleet.getFaction())) continue;
            float bounty = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                float mult = Misc.getSizeNum(loss.getHullSpec().getHullSize());
                bounty += mult * this.baseBounty;
                fpDestroyed += (float)loss.getFleetPointCost();
            }
            payment += (int)(bounty * battle.getPlayerInvolvementFraction());
        }
        if (payment > 0) {
            Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
            float repFP = (int)(fpDestroyed * battle.getPlayerInvolvementFraction());
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.SYSTEM_BOUNTY_REWARD, (Object)new Float(repFP), null, null, true, false), this.market.getFaction().getId());
            this.latestResult = new SystemBountyResult(payment, battle.getPlayerInvolvementFraction(), rep);
            this.sendUpdateIfPlayerHasIntel((Object)this.latestResult, false);
        }
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (!this.isEnding() || !isUpdate) {
            if (isUpdate && this.latestResult != null) {
                info.addPara("%s received", initPad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
                if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                    info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
                }
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.rep.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
            } else if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                info.addPara("%s base reward per frigate", initPad, tc, h, Misc.getDGSCredits(this.baseBounty));
                if (!this.commerceMode) {
                    this.addDays(info, "remaining", this.duration - this.elapsedDays, tc);
                }
            } else if (!this.isEnding()) {
                info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
                info.addPara("%s base reward per frigate", 0.0f, tc, h, Misc.getDGSCredits(this.baseBounty));
                if (!this.commerceMode) {
                    this.addDays(info, "remaining", this.duration - this.elapsedDays, tc);
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getSortString() {
        return "System Bounty";
    }

    @Override
    public String getName() {
        String name = this.market.getName();
        StarSystemAPI system = this.market.getStarSystem();
        if (system != null) {
            name = system.getBaseName();
        }
        if (this.isEnding()) {
            return "Bounty Ended - " + name;
        }
        return "System Bounty - " + name;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        this.createSmallDescription(info, width, height, false);
    }

    public void createSmallDescription(TooltipMakerAPI info, float width, float height, boolean forMarketConditionTooltip) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (!forMarketConditionTooltip) {
            info.addImage(this.faction.getLogo(), width, 128.0f, opad);
        }
        String locStr = "near " + this.market.getName();
        if (this.market.getStarSystem() != null) {
            locStr = "in or near the " + this.market.getStarSystem().getNameWithLowercaseType();
        }
        if (this.commerceMode) {
            info.addPara("%s commercial concerns " + this.market.getOnOrAt() + " " + this.market.getName() + " have banded together and posted a modest but long-term bounty on all " + "hostile fleets " + locStr + ".", opad, this.faction.getBaseUIColor(), Misc.ucFirst(this.faction.getPersonNamePrefix()));
            info.addPara("The bounty stipulates that trade fleets are an exception - attacking them will not result in a reward, regardless of their faction.", opad);
        } else {
            info.addPara("%s authorities " + this.market.getOnOrAt() + " " + this.market.getName() + " have posted a bounty on all hostile fleets " + locStr + ".", opad, this.faction.getBaseUIColor(), Misc.ucFirst(this.faction.getPersonNamePrefix()));
        }
        if (this.isEnding()) {
            info.addPara("This bounty is no longer on offer.", opad);
            return;
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (!this.commerceMode) {
            if (this.enemyFaction != null) {
                info.addPara("Likely triggered by %s activity.", opad, this.enemyFaction.getBaseUIColor(), this.enemyFaction.getPersonNamePrefix());
            }
        } else {
            info.addPara("Triggered by the presence of Commerce on one of your colonies in-system, and by the level of hostile activity.", opad);
        }
        info.addPara("Payment depends on the number and size of ships destroyed. Standing with " + this.faction.getDisplayNameWithArticle() + " may also improve.", opad);
        if (!this.commerceMode) {
            String isOrAre = this.faction.getDisplayNameIsOrAre();
            FactionCommissionIntel temp = new FactionCommissionIntel(this.faction);
            List<FactionAPI> hostile = temp.getHostileFactions();
            if (hostile.isEmpty()) {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + isOrAre + " not currently hostile to any major factions.", 0.0f);
            } else {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + isOrAre + " currently hostile to:", opad);
                info.setParaFontDefault();
                info.setBulletedListMode("      ");
                float initPad = pad;
                for (FactionAPI other : hostile) {
                    info.addPara(Misc.ucFirst(other.getDisplayName()), other.getBaseUIColor(), initPad);
                    initPad = 0.0f;
                }
                info.setBulletedListMode(null);
            }
        }
        if (this.latestResult != null) {
            info.addPara("Most recent bounty:", opad);
            this.bullet(info);
            info.addPara("%s received", pad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("%s share based on damage dealt", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            CoreReputationPlugin.addAdjustmentMessage(this.latestResult.rep.delta, this.faction, null, null, null, info, tc, false, 0.0f);
            this.unindent(info);
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "system_bounty");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Bounties");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.market.getPrimaryEntity();
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public float getBaseBounty() {
        return this.baseBounty;
    }

    public void setBaseBounty(float baseBounty) {
        this.baseBounty = baseBounty;
    }

    public boolean isCommerceMode() {
        return this.commerceMode;
    }

    public void setCommerceMode(boolean commerceMode) {
        this.commerceMode = commerceMode;
    }

    public LocationAPI getLocation() {
        return this.location;
    }

    public static class SystemBountyResult {
        public int payment;
        public float fraction;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult rep;

        public SystemBountyResult(int payment, float fraction, ReputationActionResponsePlugin.ReputationAdjustmentResult rep) {
            this.payment = payment;
            this.fraction = fraction;
            this.rep = rep;
        }
    }
}

