/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class TriTachyonDeal
extends BaseIntelPlugin
implements EconomyAPI.EconomyUpdateListener {
    public static final String HAS_TRI_TACH_DEAL = "$hasTriTachDeal";
    public static final String BROKE_TRI_TACH_DEAL = "$brokeTriTachDeal";
    public static float REP_FOR_BREAKING_DEAL = 0.5f;
    public static float MARKET_SIZE_TO_ACCESSIBILITY = 0.01f;
    public static String KEY = "$triTachDeal_ref";
    public static String BUTTON_END = "End";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("tritachyon");
    protected AgreementEndingType endType = null;
    public static String ACCESS_MOD_ID = "ttDeal_access";

    public static boolean hasDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(HAS_TRI_TACH_DEAL);
    }

    public static void setHasDeal(boolean deal) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(HAS_TRI_TACH_DEAL, deal);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_TRI_TACH_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_TRI_TACH_DEAL, broke);
    }

    public static TriTachyonDeal get() {
        return (TriTachyonDeal)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public TriTachyonDeal(InteractionDialogAPI dialog) {
        this.setImportant(true);
        TriTachyonDeal.setHasDeal(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.economyUpdated();
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        TriTachyonDeal.setHasDeal(false);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getEconomy().removeUpdateListener(this);
        this.unapplyAccessModifier();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "Tri-Tachyon Strategic Partnership";
    }

    public String getAcceptedPostfix() {
        return "Accepted";
    }

    public String getBrokenPostfix() {
        return "Dissolved";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    protected float computeColonySize(String factionId) {
        float size = 0.0f;
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!factionId.equals(curr.getFactionId()) || curr.hasCondition("decivilized")) continue;
            size += (float)curr.getSize();
        }
        return size;
    }

    protected float computeAccessibilityBonusPlayer() {
        float size = this.computeColonySize("tritachyon");
        return size * MARKET_SIZE_TO_ACCESSIBILITY;
    }

    protected float computeAccessibilityBonusTriTach() {
        float size = this.computeColonySize("player");
        return size * MARKET_SIZE_TO_ACCESSIBILITY;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        int accessPlayer = Math.round(this.computeAccessibilityBonusPlayer() * 100.0f);
        int accessTriTach = Math.round(this.computeAccessibilityBonusTriTach() * 100.0f);
        if (!this.isEnded() && !this.isEnding()) {
            String fName = Global.getSector().getPlayerFaction().getDisplayName();
            LabelAPI label = info.addPara(String.valueOf(fName) + " colonies receive %s accessibility", initPad, tc, h, "+" + accessPlayer + "%");
            label.setHighlight(fName, "+" + accessPlayer + "%");
            label.setHighlightColors(Misc.getBasePlayerColor(), h);
            initPad = 0.0f;
            fName = this.faction.getDisplayName();
            label = info.addPara(String.valueOf(fName) + " colonies receive %s accessibility", initPad, tc, h, "+" + accessTriTach + "%");
            label.setHighlight(fName, "+" + accessTriTach + "%");
            label.setHighlightColors(this.faction.getBaseUIColor(), h);
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("Your agreement with the Tri-Tachyon Corporation is no longer in force.", opad);
            return;
        }
        info.addPara("A partnership with the %s that allows you to leverage your combined market power for mutual benefit.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameLong());
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        info.addPara("Each partner's accessibility bonus is based on the total size of the colonies of the other partner.", opad);
        info.addPara("The contract is carefully worded to survive even in the face of open hostilities, and is, from a legal perspective, perpetually binding.", opad);
        info.addPara("You can of course decide to end this partnership unilaterally, but there would be no possibility of re-negotiating a similar deal after displaying such a lack of respect for your contractual obligations.", opad);
        ButtonAPI button = info.addButton("End the partnership", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endAgreement(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (type == AgreementEndingType.BROKEN) {
                TriTachyonDeal.setBrokeDeal(true);
                Misc.incrUntrustwortyCount();
                TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
                Misc.adjustRep("tritachyon", -REP_FOR_BREAKING_DEAL, text);
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endAgreement(AgreementEndingType.BROKEN, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_END) {
            prompt.addPara("You can decide to end this partnership unilaterally, but taking this action would hurt your standing with %s, and there would be no possibility of re-negotiating a similar deal after displaying such a lack of respect for your contractual obligations.", 0.0f, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void economyUpdated() {
        float player = this.computeAccessibilityBonusPlayer();
        float triTach = this.computeAccessibilityBonusTriTach();
        String descPlayer = "Strategic partnership with " + this.faction.getDisplayName();
        String descTriTach = "Strategic partnership with " + Global.getSector().getPlayerFaction().getDisplayName();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            float mod = 0.0f;
            String desc = null;
            if ("tritachyon".equals(curr.getFactionId())) {
                mod = triTach;
                desc = descTriTach;
            } else if ("player".equals(curr.getFactionId())) {
                mod = player;
                desc = descPlayer;
            }
            if (mod != 0.0f) {
                curr.getAccessibilityMod().modifyFlat(ACCESS_MOD_ID, mod, desc);
                continue;
            }
            curr.getAccessibilityMod().unmodifyFlat(ACCESS_MOD_ID);
        }
    }

    public void unapplyAccessModifier() {
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            curr.getAccessibilityMod().unmodifyFlat(ACCESS_MOD_ID);
        }
    }

    @Override
    public boolean isEconomyListenerExpired() {
        return this.isEnding() || this.isEnded();
    }

    public static enum AgreementEndingType {
        BROKEN;

    }
}

