/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Map;
import java.util.Random;

public abstract class BaseGetCommodityBarEvent
extends BaseBarEvent {
    public static final String OPTION_CONFIRM = "confirm";
    public static final String OPTION_CANCEL = "cancel";
    public static final String OPTION_CONTINUE = "continue";
    protected long seed = Misc.random.nextLong();
    protected PersonAPI person;
    protected int quantity;
    protected int unitPrice;
    protected String commodity;
    protected transient Random random;
    protected MarketAPI market = null;

    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        this.market = market;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
        this.commodity = this.getCommodityId();
        if (this.commodity == null) {
            return;
        }
        this.person = this.createPerson();
        this.quantity = this.computeQuantity();
        float price = market.getSupplyPrice(this.commodity, 1.0, true);
        this.unitPrice = (int)(price * this.getPriceMult());
        if (this.unitPrice > 50) {
            this.unitPrice = this.unitPrice / 10 * 10;
        }
        if (this.unitPrice < 1 && this.unitPrice > 0) {
            this.unitPrice = 1;
        }
    }

    protected PersonAPI createPerson() {
        PersonAPI person = Global.getSector().getFaction(this.getPersonFaction()).createRandomPerson(this.random);
        person.setRankId(this.getPersonRank());
        person.setPostId(this.getPersonPost());
        this.adjustPerson(person);
        return person;
    }

    protected float getPriceMult() {
        return 0.75f;
    }

    protected String getCommodityId() {
        return this.commodity != null ? this.commodity : "food";
    }

    protected int computeQuantity() {
        int quantity = 50 + 10 * this.random.nextInt(6);
        int size = this.market.getSize();
        return quantity *= Math.max(1, size - 2);
    }

    protected void adjustPerson(PersonAPI person) {
    }

    protected String getPersonFaction() {
        return this.market.getFactionId();
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    protected String getManOrWoman() {
        String manOrWoman = "man";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            manOrWoman = "woman";
        }
        return manOrWoman;
    }

    protected String getHeOrShe() {
        String heOrShe = "he";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            heOrShe = "she";
        }
        return heOrShe;
    }

    protected String getHimOrHer() {
        String himOrHer = "him";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "her";
        }
        return himOrHer;
    }

    protected String getHimOrHerself() {
        String himOrHer = "himself";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "herself";
        }
        return himOrHer;
    }

    protected String getHisOrHer() {
        String hisOrHer = "his";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            hisOrHer = "her";
        }
        return hisOrHer;
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.addPromptAndOption(dialog, memoryMap);
        this.regen(dialog.getInteractionTarget().getMarket());
        TextPanelAPI text = dialog.getTextPanel();
        text.addPara(this.getPrompt());
        dialog.getOptionPanel().addOption(this.getOptionText(), this);
    }

    protected abstract String getPrompt();

    protected abstract String getOptionText();

    protected abstract String getConfirmText();

    protected abstract String getCancelText();

    protected abstract String getMainText();

    protected String[] getMainTextTokens() {
        return null;
    }

    protected Color[] getMainTextColors() {
        return null;
    }

    protected String getMainText2() {
        return null;
    }

    protected String[] getMainText2Tokens() {
        return null;
    }

    protected Color[] getMainText2Colors() {
        return null;
    }

    protected String getAcceptText() {
        return null;
    }

    protected String[] getAcceptTextTokens() {
        return null;
    }

    protected Color[] getAcceptTextColors() {
        return null;
    }

    protected String getDeclineText() {
        return null;
    }

    protected String[] getDeclineTextTokens() {
        return null;
    }

    protected Color[] getDeclineTextColors() {
        return null;
    }

    @Override
    public void init(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.init(dialog, memoryMap);
        this.done = false;
        dialog.getVisualPanel().showPersonInfo(this.person, true);
        TextPanelAPI text = dialog.getTextPanel();
        if (this.getMainTextTokens() != null) {
            LabelAPI main = text.addPara(this.getMainText(), Misc.getHighlightColor(), this.getMainTextTokens());
            main.setHighlightColors(this.getMainTextColors());
            main.setHighlight(this.getMainTextTokens());
        } else {
            text.addPara(this.getMainText());
        }
        if (this.getMainText2() == null) {
            this.showTotalAndOptions();
        } else {
            OptionPanelAPI options = dialog.getOptionPanel();
            options.clearOptions();
            options.addOption("Continue", OPTION_CONTINUE);
        }
    }

    protected boolean showCargoCap() {
        return true;
    }

    protected void showTotalAndOptions() {
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        TextPanelAPI text = this.dialog.getTextPanel();
        boolean canAccept = this.canAccept();
        if (this.showCargoCap() && this.commodity != null && this.quantity > 0) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.commodity);
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            String str = "";
            int cap = 0;
            str = spec.isFuel() ? ((cap = cargo.getFreeFuelSpace()) > 1 ? String.valueOf(str) + "Your fleet's fuel tanks can hold an additional %s units of fuel." : String.valueOf(str) + "Your fleet's fuel tanks are currently full.") : (spec.isPersonnel() ? ((cap = cargo.getFreeCrewSpace()) > 1 ? String.valueOf(str) + "Your fleet's crew quarters can accommodate an additional %s personnel." : String.valueOf(str) + "Your fleet's crew berths are currently full.") : ((cap = (int)cargo.getSpaceLeft()) > 1 ? String.valueOf(str) + "Your fleet's holds can accommodate an additional %s units of cargo." : String.valueOf(str) + "Your fleet's cargo holds are currently full."));
            text.addPara(str, h, Misc.getWithDGS(cap));
        }
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        int price = this.unitPrice * this.quantity;
        if (price > 0) {
            LabelAPI label = text.addPara("The total price is %s. You have %s available.", h, Misc.getDGSCredits(price), Misc.getDGSCredits(credits));
            label.setHighlightColors(canAccept ? h : n, h);
            label.setHighlight(Misc.getDGSCredits(price), Misc.getDGSCredits(credits));
        }
        OptionPanelAPI options = this.dialog.getOptionPanel();
        options.clearOptions();
        options.addOption(this.getConfirmText(), OPTION_CONFIRM);
        if (!canAccept) {
            options.setEnabled(OPTION_CONFIRM, false);
            String tooltip = this.getCanNotAcceptTooltip();
            if (tooltip != null) {
                options.setTooltip(OPTION_CONFIRM, tooltip);
            }
        }
        if (canAccept) {
            this.addStoryOption();
        }
        options.addOption(this.getCancelText(), OPTION_CANCEL);
    }

    protected void addStoryOption() {
    }

    protected boolean canAccept() {
        int price;
        float credits = Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        boolean canAfford = credits >= (float)(price = this.unitPrice * this.quantity);
        return canAfford;
    }

    protected String getCanNotAcceptTooltip() {
        return "You don't have enough credits.";
    }

    protected void doExtraConfirmActions() {
    }

    protected void doConfirmActionsPreAcceptText() {
    }

    protected void doStandardConfirmActions() {
        int price = this.unitPrice * this.quantity;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        if (price > 0) {
            cargo.getCredits().subtract(price);
        }
        cargo.addCommodity(this.commodity, this.quantity);
        TextPanelAPI text = this.dialog.getTextPanel();
        if (price > 0) {
            AddRemoveCommodity.addCreditsLossText(price, text);
        }
        AddRemoveCommodity.addCommodityGainText(this.commodity, this.quantity, text);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (optionData == OPTION_CONTINUE) {
            TextPanelAPI text = this.dialog.getTextPanel();
            if (this.getMainText2Tokens() != null) {
                LabelAPI main = text.addPara(this.getMainText2(), Misc.getHighlightColor(), this.getMainText2Tokens());
                main.setHighlightColors(this.getMainText2Colors());
                main.setHighlight(this.getMainText2Tokens());
            } else {
                text.addPara(this.getMainText2());
            }
            this.showTotalAndOptions();
        } else if (optionData == OPTION_CONFIRM) {
            this.done = true;
            BarEventManager.getInstance().notifyWasInteractedWith(this);
            this.doConfirmActionsPreAcceptText();
            TextPanelAPI text = this.dialog.getTextPanel();
            String acceptStr = this.getAcceptText();
            if (acceptStr != null) {
                if (this.getAcceptTextTokens() != null) {
                    LabelAPI accept = text.addPara(acceptStr, Misc.getHighlightColor(), this.getAcceptTextTokens());
                    accept.setHighlightColors(this.getAcceptTextColors());
                    accept.setHighlight(this.getAcceptTextTokens());
                } else {
                    text.addPara(acceptStr);
                }
            }
            this.doStandardConfirmActions();
            this.doExtraConfirmActions();
        } else if (optionData == OPTION_CANCEL) {
            TextPanelAPI text = this.dialog.getTextPanel();
            String declineStr = this.getDeclineText();
            if (declineStr != null) {
                if (this.getDeclineTextTokens() != null) {
                    LabelAPI decline = text.addPara(declineStr, Misc.getHighlightColor(), this.getAcceptTextTokens());
                    decline.setHighlightColors(this.getDeclineTextColors());
                    decline.setHighlight(this.getDeclineTextTokens());
                } else {
                    text.addPara(declineStr);
                }
            } else {
                this.noContinue = true;
            }
            this.done = true;
        }
    }

    @Override
    public boolean isDialogFinished() {
        return this.done;
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public PersonImportance pickImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.random);
        picker.add(PersonImportance.VERY_LOW, 1.0f);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        picker.add(PersonImportance.VERY_HIGH, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickMediumImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.random);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickHighImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.random);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        picker.add(PersonImportance.VERY_HIGH, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickLowImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.random);
        picker.add(PersonImportance.VERY_LOW, 10.0f);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public String pickOne(String ... options) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            picker.add(option);
            ++n2;
        }
        return (String)picker.pick();
    }
}

