/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.fleets.AutoDespawnScript;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.ScientistAICoreBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.raid.AssembleStage;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class ScientistAICoreIntel
extends BaseIntelPlugin {
    protected SectorEntityToken cache;
    protected StarSystemAPI cacheSystem;
    protected ScientistAICoreBarEvent event;
    protected boolean keptPromise = true;

    public ScientistAICoreIntel(SectorEntityToken cache, ScientistAICoreBarEvent event) {
        this.cache = cache;
        this.cacheSystem = cache.getStarSystem();
        this.event = event;
        Misc.makeImportant(cache, "saci");
        cache.getMemoryWithoutUpdate().set("$saic_eventRef", this);
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        MemoryAPI memory = this.cache.getMemoryWithoutUpdate();
        if (action.equals("putValuesInMemory")) {
            memory.set("$saic_marketOnOrAt", this.event.getShownAt().getOnOrAt(), 0.0f);
            memory.set("$saic_marketName", this.event.getShownAt().getName(), 0.0f);
            memory.set("$saic_heOrShe", this.event.getHeOrShe(), 0.0f);
        } else if (action.equals("genLootWithCore")) {
            this.genLoot(dialog, memoryMap, true);
        } else if (action.equals("genLootNoCore")) {
            this.genLoot(dialog, memoryMap, false);
        }
        return true;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    protected void genLoot(final InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, boolean withCore) {
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        MemoryAPI memory = this.cache.getMemoryWithoutUpdate();
        long seed = memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 100);
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 10;
        d.group = "blueprints";
        this.cache.addDropRandom(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "rare_tech";
        this.cache.addDropRandom(d);
        CargoAPI salvage = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, 1.0f, 1.0f, this.cache.getDropValue(), this.cache.getDropRandom());
        CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(memoryMap);
        salvage.addAll(extra);
        BaseSalvageSpecial.clearExtraSalvage(memoryMap);
        if (!extra.isEmpty()) {
            ListenerUtil.reportExtraSalvageShown(this.cache);
        }
        if (withCore) {
            salvage.addCommodity("alpha_core", 1.0f);
            this.keptPromise = false;
        } else {
            this.keptPromise = true;
        }
        dialog.getVisualPanel().showLoot("Salvaged", salvage, false, true, true, new CoreInteractionListener(){

            @Override
            public void coreUIDismissed() {
                dialog.dismiss();
                dialog.hideTextPanel();
                dialog.hideVisualPanel();
                Misc.fadeAndExpire(ScientistAICoreIntel.this.cache);
                Global.getSector().addScript(ScientistAICoreIntel.this);
                ScientistAICoreIntel.this.endAfterDelay();
                ScientistAICoreIntel.this.cache = null;
            }
        });
        options.clearOptions();
        dialog.setPromptText("");
        if (this.keptPromise && random.nextFloat() > 0.5f) {
            SectorEntityToken loc = this.cache.getContainingLocation().createToken(this.cache.getLocation());
            ScientistAICoreIntel.spawnPiratesToInvestigate(loc, 50.0f + random.nextFloat() * 50.0f);
            if (random.nextFloat() > 0.5f) {
                ScientistAICoreIntel.spawnPiratesToInvestigate(loc, 50.0f + random.nextFloat() * 50.0f);
            }
        }
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        initPad = 0.0f;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec("alpha_core");
        if (spec != null) {
            info.addImage(spec.getIconName(), width, 80.0f, opad);
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.cacheSystem == null) {
            return;
        }
        if (this.isEnding()) {
            info.addPara("You've found and looted the cache of pre-Collapse technology in the " + this.cacheSystem.getNameWithLowercaseType() + ".", opad);
            if (this.keptPromise) {
                info.addPara("You've kept your promise to the scientist and placed the AI core in a secure container, to be shipped to " + this.event.getHimOrHer() + " as soon as you're back " + "in civilized space.", opad);
            } else {
                info.addPara("You've taken the AI core promised to the scientist for yourself. Surely, " + this.event.getHeOrShe() + " was no-one important.", opad);
            }
        } else {
            info.addPara("You've learned that there is a cache of pre-Collapse technology to be found in the " + this.cacheSystem.getNameWithLowercaseType() + ".", opad);
            info.addPara("The scientist that informed you of this wants the Alpha Core from this cache as payment for " + this.event.getHisOrHer() + " services.", opad);
        }
    }

    @Override
    public String getIcon() {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec("alpha_core");
        return spec.getIconName();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Missions");
        tags.add("Accepted");
        tags.add("Exploration");
        return tags;
    }

    @Override
    public String getSortString() {
        if (this.getTagsForSort().contains("Fleet log") || this.getTagsForSort().contains("Exploration")) {
            return this.getSortStringNewestFirst();
        }
        return "Technology Cache";
    }

    @Override
    public String getName() {
        if (this.isEnded() || this.isEnding()) {
            return "Technology Cache - Looted";
        }
        return "Technology Cache";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.cache;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return super.shouldRemoveIntel();
    }

    @Override
    public String getCommMessageSound() {
        return "ui_discovered_entity";
    }

    public static void spawnPiratesToInvestigate(SectorEntityToken locToken, float fp) {
        FleetFactory.PatrolType type = fp < AssembleStage.FP_SMALL * 1.5f ? FleetFactory.PatrolType.FAST : (fp < AssembleStage.FP_MEDIUM * 1.5f ? FleetFactory.PatrolType.COMBAT : FleetFactory.PatrolType.HEAVY);
        FleetParamsV3 params = new FleetParamsV3(null, Global.getSector().getPlayerFleet().getLocationInHyperspace(), "pirates", null, type.getFleetType(), fp, 0.0f, fp * 0.1f, 0.0f, 0.0f, 0.0f, 0.0f);
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet.isEmpty()) {
            fleet = null;
        }
        if (fleet != null) {
            fleet.addScript(new AutoDespawnScript(fleet));
            fleet.setTransponderOn(false);
            fleet.getMemoryWithoutUpdate().set("$isPirate", true);
            float range = 2000.0f + (float)Math.random() * 2000.0f;
            Vector2f loc = Misc.getPointAtRadius(locToken.getLocation(), range);
            locToken.getContainingLocation().addEntity(fleet);
            fleet.setLocation(loc.x, loc.y);
            TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, false, true, 30.0f);
            fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, locToken, 1000.0f);
        }
    }
}

