/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public abstract class BlueprintOfferCreator
extends BaseHistorianOfferCreator {
    public BlueprintOfferCreator(float frequency) {
        this.setFrequency(frequency);
    }

    @Override
    public String getOfferId(BaseHistorianOffer offer) {
        return null;
    }

    public String getBlueprintIdFromOfferId(String offerId) {
        return null;
    }

    @Override
    public HistorianData.HistorianOffer createOffer(Random random, List<HistorianData.HistorianOffer> soFar) {
        String id;
        PlanetAPI planet;
        HistorianData hd = HistorianData.getInstance();
        SectorEntityToken entity = this.pickEntity(random, false);
        if ((entity == null || random.nextFloat() < this.getProbabilityRuins()) && (planet = this.pickUnexploredRuins(random)) != null) {
            entity = planet;
        }
        if (entity == null) {
            entity = BlueprintOfferCreator.createEntity(random);
        }
        if (entity == null) {
            return null;
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        HashSet<String> already = new HashSet<String>();
        for (HistorianData.HistorianOffer offer : soFar) {
            id = this.getAlreadyUsedIdFromOffer(offer);
            if (id == null) continue;
            already.add(id);
        }
        for (String id2 : hd.getGivenOffers()) {
            String bpId = this.getBlueprintIdFromOfferId(id2);
            if (bpId == null) continue;
            already.add(bpId);
        }
        for (Object spec : this.getAllSpecs()) {
            float w;
            id = this.getIdForSpec(spec);
            if (already.contains(id) || this.playerKnowsSpecAlready(id) || (w = hd.getWeightForTags(this.getTagsForSpec(spec))) <= 0.0f) continue;
            picker.add(id, w *= this.getRarityForSpec(spec));
        }
        String data = (String)picker.pick();
        if (data == null) {
            return null;
        }
        BaseHistorianOfferWithLocation offer = this.createOffer(entity, data);
        return offer;
    }

    protected abstract BaseHistorianOfferWithLocation createOffer(SectorEntityToken var1, String var2);

    protected abstract String getAlreadyUsedIdFromOffer(HistorianData.HistorianOffer var1);

    protected abstract List<Object> getAllSpecs();

    protected abstract Set<String> getTagsForSpec(Object var1);

    protected abstract String getIdForSpec(Object var1);

    protected abstract boolean playerKnowsSpecAlready(String var1);

    protected float getRarityForSpec(Object spec) {
        return 1.0f;
    }

    protected float getProbabilityRuins() {
        return 0.33f;
    }
}

