/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.util.Misc;

public class DonationOffer
extends BaseHistorianOffer {
    protected int credits;

    public DonationOffer() {
        HistorianData hd = HistorianData.getInstance();
        int tier = hd.getTier();
        if (tier == 0) {
            this.credits = 20000;
        } else if (tier == 1) {
            this.credits = 50000;
        } else if (tier >= 2) {
            this.credits = 250000;
        }
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog) {
        HistorianData hd = HistorianData.getInstance();
        dialog.getOptionPanel().addOption("... some promising leads that a " + Misc.getDGSCredits(this.credits) + " donation would let " + hd.getHimOrHer() + " pursue", this);
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        super.init(dialog);
        this.setEndConversationOnReturning(false);
        this.options.clearOptions();
        this.options.addOption("Make the donation", (Object)OptionId.DONATE);
        this.options.addOption("Steer the conversation to other topics", (Object)OptionId.NEVER_MIND);
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        String c = Misc.getDGSCredits(cargo.getCredits().get());
        String d = Misc.getDGSCredits(this.credits);
        if (cargo.getCredits().get() < (float)this.credits) {
            this.text.addPara("The asked-for donation amount is %s. You only have %s available.", Misc.getHighlightColor(), d, c);
            this.options.setEnabled((Object)OptionId.DONATE, false);
            this.options.setTooltip((Object)OptionId.DONATE, "You don't have enough credits.");
        } else {
            this.text.addPara("The asked-for donation amount is %s. You have %s available.", Misc.getHighlightColor(), d, c);
        }
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        HistorianData hd = HistorianData.getInstance();
        if (optionData == OptionId.DONATE) {
            this.setDone(true);
            this.setRemove(true);
            hd.incrTier();
            hd.setRecentlyDonated();
            Global.getSector().getPlayerFleet().getCargo().getCredits().subtract(this.credits);
            AddRemoveCommodity.addCreditsLossText(this.credits, this.text);
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.limit = RepLevel.COOPERATIVE;
            impact.delta = 0.1f;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.dialog.getTextPanel(), true), hd.getPerson());
            this.dialog.getTextPanel().addPara("The historian thanks you for your help.");
            return;
        }
        if (optionData == OptionId.NEVER_MIND) {
            this.setDone(true);
            this.dialog.getTextPanel().addPara("The historian cooperates in changing topics.");
            return;
        }
    }

    @Override
    public int getSortOrder() {
        return 1000;
    }

    public static enum OptionId {
        DONATE,
        NEVER_MIND;

    }
}

