/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.DonationOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.FighterBlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianBackstory;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.ShipBlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.SpecialItemOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.WeaponBlueprintOfferCreator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class HistorianData {
    public static final String KEY = "$core_historianData";
    public static String TIER1 = "hist1t";
    public static String TIER2 = "hist2t";
    public static String TIER3 = "hist3t";
    protected PersonAPI person;
    protected boolean introduced = false;
    protected int tier = 0;
    protected transient List<HistorianOfferCreator> creators;
    protected transient List<HistorianBackstory.HistorianBackstoryInfo> backstory;
    protected Set<String> shownBackstory = new LinkedHashSet<String>();
    protected Set<String> givenOffers = new LinkedHashSet<String>();

    public static HistorianData getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test == null) {
            test = new HistorianData();
            Global.getSector().getMemoryWithoutUpdate().set(KEY, test);
        }
        return (HistorianData)test;
    }

    public HistorianData() {
        this.person = Global.getSector().getFaction("independent").createRandomPerson();
        if (this.person.getGender() == FullName.Gender.MALE) {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "historian_male"));
        } else {
            this.person.setPortraitSprite(Global.getSettings().getSpriteName("intel", "historian_female"));
        }
        this.readResolve();
    }

    protected Object readResolve() {
        if (this.creators == null) {
            this.creators = new ArrayList<HistorianOfferCreator>();
            this.creators.add(new DonationOfferCreator());
            this.creators.add(new ShipBlueprintOfferCreator(20.0f));
            this.creators.add(new WeaponBlueprintOfferCreator(10.0f));
            this.creators.add(new FighterBlueprintOfferCreator(10.0f));
            this.creators.add(new SpecialItemOfferCreator(10.0f));
        }
        if (this.backstory == null) {
            this.backstory = new ArrayList<HistorianBackstory.HistorianBackstoryInfo>();
        }
        if (this.shownBackstory == null) {
            this.shownBackstory = new LinkedHashSet<String>();
        }
        if (this.givenOffers == null) {
            this.givenOffers = new LinkedHashSet<String>();
        }
        return this;
    }

    public HistorianBackstory.HistorianBackstoryInfo pickBackstoryBit(Random random) {
        WeightedRandomPicker<HistorianBackstory.HistorianBackstoryInfo> picker = new WeightedRandomPicker<HistorianBackstory.HistorianBackstoryInfo>(random);
        for (HistorianBackstory.HistorianBackstoryInfo info : this.backstory) {
            if (this.shownBackstory.contains(info.getId())) continue;
            picker.add(info, info.getWeight());
        }
        if (picker.isEmpty()) {
            this.shownBackstory.clear();
            for (HistorianBackstory.HistorianBackstoryInfo info : this.backstory) {
                picker.add(info, info.getWeight());
            }
        }
        return (HistorianBackstory.HistorianBackstoryInfo)picker.pick();
    }

    public List<HistorianBackstory.HistorianBackstoryInfo> getBackstory() {
        return this.backstory;
    }

    public Set<String> getShownBackstory() {
        return this.shownBackstory;
    }

    public Set<String> getGivenOffers() {
        return this.givenOffers;
    }

    public float getWeightForTags(Set<String> tags) {
        float w = 0.0f;
        if (tags.contains(TIER1)) {
            w = 1.0f;
        } else if (tags.contains(TIER2) && this.getTier() >= 1) {
            w = 5.0f;
        } else if (tags.contains(TIER3) && this.getTier() >= 2) {
            w = 10.0f;
        }
        return w;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void incrTier() {
        ++this.tier;
    }

    public boolean isMaxTier() {
        return this.getTier() >= 2;
    }

    public void setRecentlyDonated() {
        float dur = 60.0f + (float)Math.random() * 60.0f;
        Global.getSector().getMemoryWithoutUpdate().set("$historian_recentlyDonated", true, dur);
    }

    public boolean isRecentlyDonated() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$historian_recentlyDonated");
    }

    public List<HistorianOfferCreator> getCreators() {
        return this.creators;
    }

    public void setCreators(List<HistorianOfferCreator> creators) {
        this.creators = creators;
    }

    public List<HistorianOffer> getOffers(Random random, InteractionDialogAPI dialog) {
        WeightedRandomPicker<HistorianOfferCreator> limited = new WeightedRandomPicker<HistorianOfferCreator>(random);
        ArrayList<HistorianOffer> always = new ArrayList<HistorianOffer>();
        for (HistorianOfferCreator c : this.creators) {
            if (c.ignoresLimit()) {
                HistorianOffer offer = c.createOffer(random, always);
                if (offer == null) continue;
                offer.setCreator(c);
                always.add(offer);
                continue;
            }
            limited.add(c, c.getFrequency());
        }
        ArrayList<HistorianOffer> result = new ArrayList<HistorianOffer>(always);
        int num = 1 + random.nextInt(2 + this.getTier()) + always.size();
        int attempts = num + 5;
        int i = 0;
        while (i < attempts && result.size() < num) {
            HistorianOffer offer;
            HistorianOfferCreator c = (HistorianOfferCreator)limited.pick();
            if (c != null && (offer = c.createOffer(random, result)) != null) {
                offer.setCreator(c);
                result.add(offer);
            }
            ++i;
        }
        Collections.sort(result, new Comparator<HistorianOffer>(){

            @Override
            public int compare(HistorianOffer o1, HistorianOffer o2) {
                return (int)Math.signum(o1.getSortOrder() - o2.getSortOrder());
            }
        });
        return result;
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    protected String getManOrWoman() {
        String manOrWoman = "man";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            manOrWoman = "woman";
        }
        return manOrWoman;
    }

    protected String getUCHeOrShe() {
        String heOrShe = "he";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            heOrShe = "she";
        }
        return Misc.ucFirst(heOrShe);
    }

    protected String getHeOrShe() {
        String heOrShe = "he";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            heOrShe = "she";
        }
        return heOrShe;
    }

    protected String getHimOrHer() {
        String himOrHer = "him";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "her";
        }
        return himOrHer;
    }

    protected String getHimOrHerself() {
        String himOrHer = "himself";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "herself";
        }
        return himOrHer;
    }

    protected String getHisOrHer() {
        String hisOrHer = "his";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            hisOrHer = "her";
        }
        return hisOrHer;
    }

    public boolean isIntroduced() {
        return this.introduced;
    }

    public void setIntroduced(boolean introduced) {
        this.introduced = introduced;
    }

    public static interface HistorianOffer {
        public void init(InteractionDialogAPI var1);

        public void addPromptAndOption(InteractionDialogAPI var1);

        public void optionSelected(String var1, Object var2);

        public boolean shouldRemoveOffer();

        public boolean isInteractionFinished();

        public boolean shouldEndConversationOnReturning();

        public void notifyAccepted();

        public int getSortOrder();

        public HistorianOfferCreator getCreator();

        public void setCreator(HistorianOfferCreator var1);
    }

    public static interface HistorianOfferCreator {
        public HistorianOffer createOffer(Random var1, List<HistorianOffer> var2);

        public boolean ignoresLimit();

        public float getFrequency();

        public String getOfferId(BaseHistorianOffer var1);

        public void notifyAccepted(HistorianOffer var1);
    }
}

