/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events.historian;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOffer;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BaseHistorianOfferWithLocation;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.BlueprintOfferCreator;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.HistorianData;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.historian.SpecialItemOffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SpecialItemOfferCreator
extends BlueprintOfferCreator {
    public static int BASE_POINTS = Global.getSettings().getInt("historianSpecialItemBase");
    protected int numAccepted = 0;
    public static String PREFIX = "spec_";

    public SpecialItemOfferCreator(float frequency) {
        super(frequency);
    }

    @Override
    public void notifyAccepted(HistorianData.HistorianOffer offer) {
        ++this.numAccepted;
    }

    @Override
    protected BaseHistorianOfferWithLocation createOffer(SectorEntityToken entity, String data) {
        int points = (int)Math.round((double)BASE_POINTS * Math.pow(2.0, this.numAccepted));
        return new SpecialItemOffer(entity, points, data);
    }

    @Override
    protected List<Object> getAllSpecs() {
        return new ArrayList<Object>(Global.getSettings().getAllSpecialItemSpecs());
    }

    @Override
    protected String getAlreadyUsedIdFromOffer(HistorianData.HistorianOffer offer) {
        if (offer instanceof SpecialItemOffer) {
            SpecialItemOffer sio = (SpecialItemOffer)offer;
            return sio.getData();
        }
        return null;
    }

    @Override
    protected String getIdForSpec(Object spec) {
        return ((SpecialItemSpecAPI)spec).getId();
    }

    @Override
    protected Set<String> getTagsForSpec(Object spec) {
        return ((SpecialItemSpecAPI)spec).getTags();
    }

    @Override
    protected float getRarityForSpec(Object spec) {
        return ((SpecialItemSpecAPI)spec).getRarity();
    }

    @Override
    protected boolean playerKnowsSpecAlready(String id) {
        return false;
    }

    @Override
    protected float getProbabilityRuins() {
        return 0.67f;
    }

    @Override
    public String getOfferId(BaseHistorianOffer offer) {
        if (offer instanceof SpecialItemOffer) {
            return String.valueOf(PREFIX) + ((SpecialItemOffer)offer).getData();
        }
        return null;
    }

    @Override
    public String getBlueprintIdFromOfferId(String offerId) {
        if (offerId.startsWith(PREFIX)) {
            return offerId.replaceAll(PREFIX, "");
        }
        return null;
    }
}

