/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.Tuning;
import com.fs.starfarer.api.impl.campaign.intel.BaseEventManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.events.LuddicPathHostileActivityFactor;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Random;

public class LuddicPathBaseManager
extends BaseEventManager {
    public static float LUDDIC_CHURCH_INTEREST_MULT = 0.1f;
    public static float PLAYER_DEFEATED_PATHER_CRISIS_INTEREST_MULT = 0.5f;
    public static float AI_CORE_ADMIN_INTEREST = 10.0f;
    public static final String KEY = "$core_luddicPathBaseManager";
    public static final float INERTIA_DAYS_MAX = 30.0f;
    public static final float INERTIA_DAYS_MIN = 10.0f;
    public static final float CHECK_DAYS = 10.0f;
    public static final float CHECK_PROB = 0.5f;
    protected long start = 0L;
    protected IntervalUtil cellChecker = new IntervalUtil(1.0f, 3.0f);
    protected int timesSinceLastChange = 10000;
    protected int activeMod = 0;
    protected int sleeperMod = 0;
    protected LinkedHashMap<MarketAPI, LuddicPathCellsIntel> cells = new LinkedHashMap();
    protected Random random = new Random();
    protected int numDestroyed = 0;
    protected int numSpawnChecksToSkip = 0;

    public static LuddicPathBaseManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (LuddicPathBaseManager)test;
    }

    public LuddicPathBaseManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.start = Global.getSector().getClock().getTimestamp();
    }

    @Override
    protected int getMinConcurrent() {
        return Global.getSettings().getInt("minLPBases");
    }

    @Override
    protected int getMaxConcurrent() {
        return Global.getSettings().getInt("maxLPBases");
    }

    @Override
    protected float getBaseInterval() {
        return 10.0f;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.cellChecker == null) {
            this.cellChecker = new IntervalUtil(1.0f, 3.0f);
        }
        if (this.cells == null) {
            this.cells = new LinkedHashMap();
        }
        return this;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.cellChecker.advance(days);
        if (this.cellChecker.intervalElapsed()) {
            ++this.timesSinceLastChange;
            if (this.timesSinceLastChange > 50) {
                this.activeMod = Misc.random.nextInt(3);
                this.sleeperMod = Misc.random.nextInt(3);
                this.timesSinceLastChange = 0;
            }
            this.updateCellStatus();
        }
    }

    protected void updateCellStatus() {
        LuddicPathCellsIntel intel;
        int numActive;
        float fraction = Global.getSettings().getFloat("basePatherCellFraction");
        float minInterest = Global.getSettings().getFloat("minInterestForPatherCells");
        ArrayList<Pair<MarketAPI, Float>> marketAndScore = new ArrayList<Pair<MarketAPI, Float>>();
        int total = 0;
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getEconGroup() != null || market.getSize() < 4) continue;
            float score = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            ++total;
            if (!(score >= minInterest)) continue;
            marketAndScore.add(new Pair<MarketAPI, Float>(market, Float.valueOf(score)));
        }
        int numSleeper = numActive = Math.round((float)total * fraction);
        numActive += this.activeMod;
        numSleeper += this.sleeperMod;
        LinkedHashSet<MarketAPI> active = new LinkedHashSet<MarketAPI>();
        LinkedHashSet<MarketAPI> sleeper = new LinkedHashSet<MarketAPI>();
        Collections.sort(marketAndScore, new Comparator<Pair<MarketAPI, Float>>(){

            @Override
            public int compare(Pair<MarketAPI, Float> o1, Pair<MarketAPI, Float> o2) {
                return (int)Math.signum(((Float)o2.two).floatValue() - ((Float)o1.two).floatValue());
            }
        });
        int count = 0;
        for (Pair pair : marketAndScore) {
            if (count < numActive) {
                active.add((MarketAPI)pair.one);
            } else {
                if (count >= numActive + numSleeper) break;
                sleeper.add((MarketAPI)pair.one);
            }
            ++count;
        }
        for (MarketAPI marketAPI : new ArrayList<MarketAPI>(this.cells.keySet())) {
            intel = this.cells.get(marketAPI);
            if (!active.contains(marketAPI) && !sleeper.contains(marketAPI)) {
                LuddicPathCellsIntel otherIntel;
                MarketAPI other;
                int i;
                float score = LuddicPathBaseManager.getLuddicPathMarketInterest(marketAPI);
                if (intel.getInertiaTime() >= 30.0f || intel.getInertiaTime() >= 10.0f && score < minInterest) {
                    if (!intel.isEnding()) {
                        intel.endAfterDelay();
                        if (marketAPI.isPlayerOwned() || DebugFlags.PATHER_BASE_DEBUG) {
                            intel.sendUpdateIfPlayerHasIntel(LuddicPathCellsIntel.UPDATE_DISSOLVED, false);
                        }
                    }
                    this.cells.remove(marketAPI);
                    continue;
                }
                if (intel.isSleeper()) {
                    ArrayList sleeperList = new ArrayList(sleeper);
                    i = sleeperList.size() - 1;
                    while (i >= 0) {
                        other = (MarketAPI)sleeperList.get(i);
                        otherIntel = this.cells.get(other);
                        if (otherIntel == null) {
                            sleeper.remove(other);
                            break;
                        }
                        --i;
                    }
                    sleeper.add(marketAPI);
                    continue;
                }
                ArrayList activeList = new ArrayList(active);
                i = activeList.size() - 1;
                while (i >= 0) {
                    other = (MarketAPI)activeList.get(i);
                    otherIntel = this.cells.get(other);
                    if (otherIntel == null) {
                        active.remove(other);
                        break;
                    }
                    --i;
                }
                active.add(marketAPI);
                continue;
            }
            intel.setInertiaTime(0.0f);
        }
        for (MarketAPI marketAPI : active) {
            intel = this.cells.get(marketAPI);
            LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(marketAPI);
            if (intel == null) {
                intel = new LuddicPathCellsIntel(marketAPI, base == null);
                this.cells.put(marketAPI, intel);
            }
            if (base != null) {
                intel.makeActiveIfPossible();
                continue;
            }
            intel.makeSleeper();
        }
        for (MarketAPI marketAPI : sleeper) {
            intel = this.cells.get(marketAPI);
            if (intel == null) {
                intel = new LuddicPathCellsIntel(marketAPI, true);
                this.cells.put(marketAPI, intel);
            }
            intel.makeSleeper();
        }
    }

    public static float getLuddicPathMarketInterest(MarketAPI market) {
        if (market.getFactionId().equals("luddic_path")) {
            return 0.0f;
        }
        float total = 0.0f;
        String aiCoreId = market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            total += AI_CORE_ADMIN_INTEREST;
        }
        for (Industry ind : market.getIndustries()) {
            total += ind.getPatherInterest();
        }
        if (total > 0.0f) {
            total += new Random(market.getName().hashCode()).nextFloat() * 0.1f;
        }
        if (market.getFactionId().equals("luddic_church")) {
            total *= LUDDIC_CHURCH_INTEREST_MULT;
        }
        if (market.isPlayerOwned() && LuddicPathHostileActivityFactor.isPlayerDefeatedPatherExpedition()) {
            total *= PLAYER_DEFEATED_PATHER_CRISIS_INTEREST_MULT;
        }
        return total;
    }

    @Override
    protected EveryFrameScript createEvent() {
        if (this.numSpawnChecksToSkip > 0) {
            --this.numSpawnChecksToSkip;
            return null;
        }
        if (this.random.nextFloat() < 0.5f) {
            return null;
        }
        StarSystemAPI system = this.pickSystemForLPBase();
        if (system == null) {
            return null;
        }
        String factionId = "luddic_path";
        LuddicPathBaseIntel intel = new LuddicPathBaseIntel(system, factionId);
        if (intel.isDone()) {
            intel = null;
        }
        return intel;
    }

    protected StarSystemAPI pickSystemForLPBase() {
        WeightedRandomPicker<StarSystemAPI> far = new WeightedRandomPicker<StarSystemAPI>(this.random);
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(this.random);
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float usefulStuff;
            float days;
            if (system.hasTag("theme_special") || system.hasTag("theme_hidden") || (days = Global.getSector().getClock().getElapsedDaysSince(system.getLastPlayerVisitTimestamp())) < 45.0f || system.getCenter().getMemoryWithoutUpdate().contains(PirateBaseManager.RECENTLY_USED_FOR_BASE)) continue;
            float weight = 0.0f;
            if (system.hasTag("theme_misc_skip")) {
                weight = 1.0f;
            } else if (system.hasTag("theme_misc")) {
                weight = 3.0f;
            } else if (system.hasTag("theme_remnant_no_fleets")) {
                weight = 3.0f;
            } else if (system.hasTag("theme_ruins")) {
                weight = 5.0f;
            } else if (system.hasTag("theme_core_unpopulated")) {
                weight = 1.0f;
            }
            if (weight <= 0.0f || (usefulStuff = (float)(system.getCustomEntitiesWithTag("objective").size() + system.getCustomEntitiesWithTag("stable_location").size())) <= 0.0f || Misc.hasPulsar(system) || Misc.getMarketsInLocation(system).size() > 0) continue;
            float dist = system.getLocation().length();
            float distMult = 1.0f;
            if (dist > 36000.0f) {
                far.add(system, weight * usefulStuff * distMult);
                continue;
            }
            picker.add(system, weight * usefulStuff * distMult);
        }
        if (picker.isEmpty()) {
            picker.addAll(far);
        }
        return (StarSystemAPI)picker.pick();
    }

    public void incrDestroyed() {
        ++this.numDestroyed;
        this.numSpawnChecksToSkip = Math.max(this.numSpawnChecksToSkip, (Tuning.PATHER_BASE_MIN_TIMEOUT_MONTHS + Misc.random.nextInt(Tuning.PATHER_BASE_MAX_TIMEOUT_MONTHS - Tuning.PATHER_BASE_MIN_TIMEOUT_MONTHS + 1)) * 3);
    }
}

