/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.PiracyRespite;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.util.Misc;

public class EstablishedPolityScript
implements EconomyAPI.EconomyUpdateListener {
    public static String KEY = "$eps_ref";
    protected long timestamp;

    public static EstablishedPolityScript get() {
        return (EstablishedPolityScript)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public EstablishedPolityScript() {
        this.sendGainedMessage();
        EstablishedPolityScript existing = EstablishedPolityScript.get();
        if (existing != null) {
            return;
        }
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.economyUpdated();
    }

    public void sendGainedMessage() {
        MessageIntel msg = new MessageIntel();
        msg.addLine("Established Polity gained", Misc.getBasePlayerColor());
        msg.addLine("    - Colonies receive %s accessibility", Misc.getTextColor(), new String[]{"+" + Math.round(PiracyRespite.ACCESSIBILITY_BONUS * 100.0f) + "%"}, Misc.getHighlightColor());
        msg.setIcon(Global.getSettings().getSpriteName("events", "established_polity"));
        msg.setSound(Sounds.REP_GAIN);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void economyUpdated() {
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (curr.isPlayerOwned() && curr.getFaction() != null && curr.getFaction().isPlayerFaction()) {
                if (curr.hasCondition("established_polity")) continue;
                curr.addCondition("established_polity");
                continue;
            }
            if (!curr.hasCondition("established_polity")) continue;
            curr.removeCondition("established_polity");
        }
    }

    public void cleanup() {
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!curr.hasCondition("established_polity")) continue;
            curr.removeCondition("established_polity");
        }
    }

    @Override
    public boolean isEconomyListenerExpired() {
        if (!PerseanLeagueMembership.isDefeatedBlockadeOrPunEx() && !PerseanLeagueMembership.isLeagueMember()) {
            this.cleanup();
            return true;
        }
        return false;
    }
}

