/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

@Deprecated
public class HADefensiveMeasuresFactor
extends BaseEventFactor {
    public static int PATROL_HQ_POINTS = 5;
    public static float MILITARY_SIZE_MULT = 2.0f;
    public static float HIGH_COMMAND_SIZE_MULT = 3.0f;

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                tooltip.addPara("Defensive measures taken by your colonies.", 0.0f);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        MarketAPI biggest = this.getBiggestColony();
        MarketAPI mil = this.getBestMilitaryMarket();
        return biggest != null || mil != null;
    }

    @Override
    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        BaseFactorTooltip t;
        int p;
        MarketAPI biggest = this.getBiggestColony();
        MarketAPI mil = this.getBestMilitaryMarket();
        Color tc = Misc.getTextColor();
        if (biggest != null && (p = this.getColonyIncreasedDefensesScore(intel, biggest)) != 0) {
            info.addRowWithGlow(new Object[]{Alignment.LMID, tc, "    Increased defenses", Alignment.RMID, intel.getProgressColor(p), "" + p});
            t = new BaseFactorTooltip(){

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    tooltip.addPara("Based on the size and stability of the largest colony under your control. If multiple colonies have the same size, the one with higher stability is used.", 0.0f);
                    MarketAPI biggest = HADefensiveMeasuresFactor.this.getBiggestColony();
                    if (biggest != null && biggest.getStarSystem() != null) {
                        tooltip.addPara("Biggest colony: %s, size: %s, stability: %s", opad, Misc.getHighlightColor(), biggest.getName(), "" + biggest.getSize(), "" + (int)biggest.getStabilityValue());
                        float w = tooltip.getWidthSoFar();
                        float h2 = Math.round(w / 1.6f);
                        tooltip.addSectorMap(w, h2, biggest.getStarSystem(), opad);
                    }
                }
            };
            info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
        }
        p = this.getMilitaryScore(mil);
        if (mil != null && mil.hasFunctionalIndustry("highcommand")) {
            info.addRowWithGlow(new Object[]{Alignment.LMID, tc, "    High Command", Alignment.RMID, intel.getProgressColor(p), "" + p});
        } else if (Misc.isMilitary(mil)) {
            info.addRowWithGlow(new Object[]{Alignment.LMID, tc, "    Military base", Alignment.RMID, intel.getProgressColor(p), "" + p});
        } else if (mil != null && mil.hasFunctionalIndustry("patrolhq")) {
            info.addRowWithGlow(new Object[]{Alignment.LMID, tc, "    Patrol HQ", Alignment.RMID, intel.getProgressColor(p), "" + p});
        } else {
            info.addRowWithGlow(new Object[]{Alignment.LMID, Misc.getGrayColor(), "    Military infrastructure", Alignment.RMID, intel.getProgressColor(p), ""});
        }
        t = new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                int score;
                float opad = 10.0f;
                tooltip.addPara("Based on the size the largest colony under your control that has a Patrol HQ, a Military Base, or a High Command.", 0.0f);
                tooltip.addPara("A Patrol HQ reduces monthly progress by %s points. A Military Base and a High Command reduce progress by %s and %s the colony's size, respectively. Only the highest-scoring colony is used, building multiple military bases has no effect.", opad, Misc.getHighlightColor(), "" + PATROL_HQ_POINTS, (int)MILITARY_SIZE_MULT + "\u00d7", (int)HIGH_COMMAND_SIZE_MULT + "\u00d7");
                MarketAPI mil = HADefensiveMeasuresFactor.this.getBestMilitaryMarket();
                if (mil != null && mil.getStarSystem() != null && (score = -1 * HADefensiveMeasuresFactor.this.getMilitaryScore(mil)) > 0) {
                    tooltip.addPara("Best military colony: %s, size: %s, score: %s points", opad, Misc.getHighlightColor(), mil.getName(), "" + mil.getSize(), "" + score);
                    float w = tooltip.getWidthSoFar();
                    float h2 = Math.round(w / 1.6f);
                    tooltip.addSectorMap(w, h2, mil.getStarSystem(), opad);
                }
            }
        };
        info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        int p = this.getColonyIncreasedDefensesScore(intel, this.getBiggestColony()) + this.getMilitaryScore(this.getBestMilitaryMarket());
        return p;
    }

    @Override
    public float getAllProgressMult(BaseEventIntel intel) {
        return 1.0f;
    }

    public int getColonyIncreasedDefensesScore(BaseEventIntel intel, MarketAPI market) {
        if (market == null) {
            return 0;
        }
        return 0;
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Defensive measures";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) == 0) {
            return Misc.getGrayColor();
        }
        return super.getDescColor(intel);
    }

    public MarketAPI getBiggestColony() {
        List<MarketAPI> markets = Misc.getPlayerMarkets(false);
        MarketAPI biggest = null;
        float max = 0.0f;
        for (MarketAPI market : markets) {
            float size = market.getSize();
            if (!(size >= max) || size == max && biggest != null && biggest.getStabilityValue() > market.getStabilityValue()) continue;
            max = size;
            biggest = market;
        }
        return biggest;
    }

    public int getMilitaryScore(MarketAPI market) {
        if (market == null) {
            return 0;
        }
        if (market.hasFunctionalIndustry("patrolhq")) {
            return -1 * PATROL_HQ_POINTS;
        }
        if (Misc.isMilitary(market)) {
            if (market.hasFunctionalIndustry("highcommand")) {
                return -1 * Math.round((float)market.getSize() * HIGH_COMMAND_SIZE_MULT);
            }
            return -1 * Math.round((float)market.getSize() * MILITARY_SIZE_MULT);
        }
        return 0;
    }

    public MarketAPI getBestMilitaryMarket() {
        List<MarketAPI> markets = Misc.getPlayerMarkets(false);
        MarketAPI best = null;
        int max = 0;
        for (MarketAPI market : markets) {
            int curr = -1 * this.getMilitaryScore(market);
            if (curr <= max) continue;
            max = curr;
            best = market;
        }
        return best;
    }
}

