/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HegemonyHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class HegemonyAICoresActivityCause
extends BaseHostileActivityCause2 {
    public static int IGNORE_COLONY_THRESHOLD = 3;

    public HegemonyAICoresActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("The Hegemony considers the use of %s illegal, though it is unlikely to take much notice of what goes on at colonies of size %s or smaller.", 0.0f, Misc.getHighlightColor(), "AI cores", "" + IGNORE_COLONY_THRESHOLD);
                if (HegemonyAICoresActivityCause.this.isNegatedByPLMembership()) {
                    Color c = Global.getSector().getFaction("persean").getBaseUIColor();
                    LabelAPI label = tooltip.addPara("However, your membership in the Persean League makes it politically difficult for the Hegemony to pursue the matter.", opad);
                    label.setHighlight("Persean League", "politically difficult");
                    label.setHighlightColors(c, Misc.getPositiveHighlightColor());
                }
            }
        };
    }

    public boolean isNegatedByPLMembership() {
        return PerseanLeagueMembership.isLeagueMember() && this.getProgress(false) > 0;
    }

    @Override
    public String getProgressStr() {
        if (this.isNegatedByPLMembership()) {
            return "---";
        }
        return super.getProgressStr();
    }

    @Override
    public Color getProgressColor(BaseEventIntel intel) {
        if (this.isNegatedByPLMembership()) {
            return Misc.getPositiveHighlightColor();
        }
        return super.getProgressColor(intel);
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0 || this.isNegatedByPLMembership();
    }

    @Override
    public int getProgress() {
        return this.getProgress(true);
    }

    public int getProgress(boolean checkNegated) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return 0;
        }
        if (checkNegated && this.isNegatedByPLMembership()) {
            return 0;
        }
        int progress = Math.round(this.getTotalAICorePoints());
        float unit = Global.getSettings().getFloat("hegemonyProgressUnit");
        float mult = Global.getSettings().getFloat("hegemonyProgressMult");
        int rem = progress;
        float adjusted = 0.0f;
        while ((float)rem > unit) {
            adjusted += unit;
            rem = (int)((float)rem - unit);
            rem = (int)((float)rem * mult);
        }
        int reduced = Math.round(adjusted += (float)rem);
        if (progress > 0 && reduced < 1) {
            reduced = 1;
        }
        progress = reduced;
        return progress;
    }

    @Override
    public String getDesc() {
        return "AI core use";
    }

    public float getTotalAICorePoints() {
        float total = 0.0f;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            total += HegemonyAICoresActivityCause.getAICorePoints(system);
        }
        return total;
    }

    public static float getAICorePoints(StarSystemAPI system) {
        float total = 0.0f;
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        for (MarketAPI market : markets) {
            if (market.getSize() <= IGNORE_COLONY_THRESHOLD) continue;
            float interest = HegemonyAICoresActivityCause.getAICorePoints(market);
            total += interest;
        }
        return total;
    }

    public static float getAICorePoints(MarketAPI market) {
        float total = 0.0f;
        float admin = Global.getSettings().getFloat("hegemonyPointsAdmin");
        float alpha = Global.getSettings().getFloat("hegemonyPointsAlpha");
        float beta = Global.getSettings().getFloat("hegemonyPointsBeta");
        float gamma = Global.getSettings().getFloat("hegemonyPointsGamma");
        String aiCoreId = market.getAdmin().getAICoreId();
        if (aiCoreId != null) {
            total += admin;
        }
        for (Industry ind : market.getIndustries()) {
            String core = ind.getAICoreId();
            if ("alpha_core".equals(core)) {
                total += alpha;
                continue;
            }
            if ("beta_core".equals(core)) {
                total += beta;
                continue;
            }
            if (!"gamma_core".equals(core)) continue;
            total += gamma;
        }
        return total;
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (HegemonyHostileActivityFactor.isPlayerDefeatedHegemony()) {
            return 0.0f;
        }
        if (this.isNegatedByPLMembership()) {
            return 0.0f;
        }
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float total = 0.0f;
        for (MarketAPI market : markets) {
            float points = HegemonyAICoresActivityCause.getAICorePoints(market);
            total += points;
        }
        total = (float)Math.round(total * 100.0f) / 100.0f;
        return total;
    }
}

