/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.listeners.PatherCellListener;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathCellsIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class LuddicPathHostileActivityFactor
extends BaseHostileActivityFactor
implements PatherCellListener,
FleetGroupIntel.FGIEventListener {
    public static String DEFEATED_PATHER_EXPEDITION = "$defeatedPatherExpedition";
    public static String ATTACK_KEY = "$PatherAttack_ref";

    public static boolean isPlayerDefeatedPatherExpedition() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_PATHER_EXPEDITION);
    }

    public static void setPlayerDefeatedPatherExpedition() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_PATHER_EXPEDITION, true);
    }

    public LuddicPathHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Luddic Path";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        if (first) {
            return "Luddic Path";
        }
        return "Luddic Path";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("luddic_path").getBaseUIColor();
    }

    @Override
    public Color getNameColorForThreatList() {
        return Global.getSector().getFaction("luddic_path").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Advanced technology and artificial intelligence are anathema to the Luddic Path.", 0.0f);
                tooltip.addPara("Most of the Pather fleets are small, engaging in reconnaissance and demanding tithes from unwary travellers, but occasionaly a larger raiding force will make an appearance.", opad);
                LuddicPathHostileActivityFactor.addAgreementStatus(tooltip, opad);
            }
        };
    }

    public static void addAgreementStatus(TooltipMakerAPI tooltip, float initPad) {
        float opad = 10.0f;
        Color p = Misc.getPositiveHighlightColor();
        Color h = Misc.getHighlightColor();
        if (HA_CMD.playerHasPatherAgreement()) {
            if (!HA_CMD.playerPatherAgreementIsPermanent()) {
                float days = HA_CMD.getPlayerPatherAgreementDays();
                if (days < 1.0f && days > 0.0f) {
                    days = 1.0f;
                }
                days = Math.round(days);
                String dStr = "days";
                if ((int)days == 1) {
                    dStr = "day";
                }
                tooltip.addPara("You've %s a signficant amount to the Pathers, and their fleets and ground-based cells should leave your colonies alone for another %s " + dStr + ".", initPad, new Color[]{p, h}, "tithed", "" + (int)days);
            } else {
                tooltip.addPara("You've reached an understanding with the Pathers, and their fleets and ground-based cells should leave your colonies alone in the future, barring unexpected events.", initPad, p, "understanding");
            }
        } else {
            tooltip.addPara("It's possible that you might reach some kind of understanding with the Pathers, provided you find the right people to talk to.", initPad, h, "find the right people");
        }
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0 || HA_CMD.playerHasPatherAgreement() && !HA_CMD.playerPatherAgreementIsPermanent();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("luddicPathMaxFleets");
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = 0.0f;
        if ((f += this.getEffectMagnitude(system)) > 1.0f) {
            f = 1.0f;
        }
        float p = Global.getSettings().getFloat("luddicPathSmallFleetProb");
        boolean small = random.nextFloat() < p;
        int difficulty = 0;
        if (small) {
            difficulty = 1 + random.nextInt(2);
        } else {
            difficulty = 3;
            difficulty += Math.round(f * 5.0f);
            difficulty += random.nextInt(6);
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "luddic_path";
        if (small) {
            m.createStandardFleet(difficulty, factionId, loc);
        } else {
            m.createStandardFleet(difficulty, factionId, loc);
        }
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        if (!small) {
            m.triggerFleetAllowLongPursuit();
        }
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    @Override
    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    public static HAPatherCellsEventData getPatherCellData(BaseEventIntel.EventStageData stage) {
        if (stage == null) {
            return null;
        }
        if (stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData) {
            HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
            if (data.custom instanceof HAPatherCellsEventData) {
                HAPatherCellsEventData attackData = (HAPatherCellsEventData)data.custom;
                return attackData;
            }
        }
        return null;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        if (data == null) {
            return;
        }
        LabelAPI label = info.addPara("Signs of a Luddic Path attack targeting %s", initPad, tc, tc, data.market.getName());
        label.setHighlight("Luddic Path", data.market.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Luddic Path attack averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data == null) {
            return;
        }
        Color c = Global.getSector().getFaction("luddic_path").getBaseUIColor();
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        LabelAPI label = info.addPara("There are signs of an impending Luddic Path attack targeting %s. If the attack is successful, the colony will suffer a catastrophic saturation bombardment.", small, c, data.market.getName());
        label.setHighlight(data.market.getName(), "catastrophic saturation bombardment");
        label.setHighlightColors(Misc.getBasePlayerColor(), Misc.getNegativeHighlightColor());
        info.addPara("This attack represents a significant resource investment by the Pathers. If it is defeated, Luddic Path cells Sector-wide will be disrupted and Pathers will take less interest in your operations in the future.", opad, Misc.getPositiveHighlightColor(), "disrupted", "less interest");
        stage.beginResetReqList(info, true, "crisis", opad);
        label = info.addPara("The Luddic Path cells on %s are disrupted", 0.0f, Misc.getBasePlayerColor(), data.market.getName());
        label.setHighlight("Luddic Path", data.market.getName());
        label.setHighlightColors(c, Misc.getBasePlayerColor());
        info.addPara("An agreement is reached with the Luddic Path", 0.0f, Global.getSector().getFaction("luddic_path").getBaseUIColor(), "Luddic Path");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("luddic_path").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("luddic_path").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Luddic Path attack", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (HA_CMD.playerHasPatherAgreement()) {
            return 0.0f;
        }
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT && this.pickTargetMarket() != null) {
            return 10.0f;
        }
        return 0.0f;
    }

    public MarketAPI pickTargetMarket() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            LuddicPathCellsIntel cells;
            if (market.getDaysInExistence() < 180.0f && !Global.getSettings().isDevMode() || (cells = LuddicPathCellsIntel.getCellsForMarket(market)) == null || cells.isSleeper()) continue;
            float w = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
            picker.add(market, w * w);
        }
        return (MarketAPI)picker.pick();
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI market = this.pickTargetMarket();
        LuddicPathCellsIntel cells = LuddicPathCellsIntel.getCellsForMarket(market);
        if (market == null || cells == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = new HAPatherCellsEventData(cells, market);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data == null || data.market == null || data.cells == null || data.cells.isSleeper()) {
            return false;
        }
        if (!data.market.isInEconomy()) {
            return false;
        }
        LuddicPathBaseIntel base = LuddicPathCellsIntel.getClosestBase(data.market);
        if (base == null) {
            return false;
        }
        StarSystemAPI system = data.market.getStarSystem();
        if (system == null) {
            return false;
        }
        return this.startRaid(base.getMarket(), data.market, data.interest, system, stage, this.getRandomizedStageRandom(3));
    }

    @Override
    public void reportCellsDisrupted(LuddicPathCellsIntel cell) {
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data != null && data.cells == cell && stage.rollData != null) {
            this.intel.resetHA_EVENT();
        }
    }

    public static void avertOrAbortAttack() {
        HostileActivityEventIntel intel;
        if (GenericRaidFGI.get(ATTACK_KEY) != null) {
            GenericRaidFGI.get(ATTACK_KEY).finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) == null) {
            return;
        }
        BaseEventIntel.EventStageData stage = intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        HAPatherCellsEventData data = LuddicPathHostileActivityFactor.getPatherCellData(stage);
        if (data != null && stage.rollData != null) {
            intel.resetHA_EVENT();
        }
    }

    public boolean startRaid(MarketAPI source, MarketAPI target, float interest, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 14.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float w = interest;
        w += Math.max(0.0f, (float)(target.getSize() - 2)) * 10.0f;
        if (w < 0.0f) {
            w = 0.0f;
        }
        if (w > 50.0f) {
            w = 50.0f;
        }
        float f = w / 50.0f;
        float totalDifficulty = (0.25f + f * 0.75f) * 40.0f;
        Random r = this.getRandomizedStageRandom(7);
        if (r.nextFloat() < 0.33f) {
            params.style = FleetCreatorMission.FleetStyle.QUANTITY;
        }
        while (totalDifficulty > 0.0f) {
            int diff = (int)Math.min(10.0f, totalDifficulty);
            if (diff < 2) {
                diff = 2;
            }
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        LuddicPathBaseIntel base = LuddicPathBaseIntel.getIntelFor(source);
        if (base != null && Misc.isHiddenBase(source) && !base.isPlayerVisible()) {
            base.makeKnown();
            base.sendUpdateIfPlayerHasIntel(LuddicPathBaseIntel.DISCOVERED_PARAM, false);
        }
        params.memoryKey = ATTACK_KEY;
        GenericRaidFGI raid = new GenericRaidFGI(params);
        raid.setListener(this);
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        LuddicPathHostileActivityFactor.setPlayerDefeatedPatherExpedition();
        MessageIntel msg = new MessageIntel();
        msg.addLine("Luddic Path cells disrupted", Misc.getBasePlayerColor());
        msg.setIcon(Global.getSettings().getSpriteName("intel", "sleeper_cells"));
        msg.setSound(Sounds.REP_GAIN);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
        List<IntelInfoPlugin> cells = Global.getSector().getIntelManager().getIntel(LuddicPathCellsIntel.class);
        for (IntelInfoPlugin curr : cells) {
            LuddicPathCellsIntel cell = (LuddicPathCellsIntel)curr;
            cell.makeSleeper(Global.getSettings().getFloat("patherCellDisruptionDuration"));
            ListenerUtil.reportCellDisrupted(cell);
        }
    }

    public static class HAPatherCellsEventData {
        public LuddicPathCellsIntel cells;
        public MarketAPI market;
        public float interest;

        public HAPatherCellsEventData(LuddicPathCellsIntel cells, MarketAPI market) {
            this.cells = cells;
            this.market = market;
            this.interest = LuddicPathBaseManager.getLuddicPathMarketInterest(market);
        }
    }
}

