/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.PiracyRespite;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;

public class PiracyRespiteScript
implements EconomyAPI.EconomyUpdateListener {
    public static String KEY = "$prs_ref";
    public static float DURATION = -1.0f;
    protected long timestamp;

    public static PiracyRespiteScript get() {
        return (PiracyRespiteScript)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public static boolean playerHasPiracyRespite() {
        return PiracyRespiteScript.get() != null;
    }

    public PiracyRespiteScript() {
        this.sendGainedMessage();
        PiracyRespiteScript existing = PiracyRespiteScript.get();
        if (existing != null) {
            existing.resetTimestamp();
            return;
        }
        this.resetTimestamp();
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.economyUpdated();
    }

    public void sendGainedMessage() {
        MessageIntel msg = new MessageIntel();
        msg.addLine("Piracy Respite gained", Misc.getBasePlayerColor());
        if (!PiracyRespite.NEW_MODE) {
            msg.addLine("    - Colonies receive %s accessibility", Misc.getTextColor(), new String[]{"+" + Math.round(PiracyRespite.ACCESSIBILITY_BONUS * 100.0f) + "%"}, Misc.getHighlightColor());
            if (DURATION > 0.0f) {
                msg.addLine("    - Lasts for %s days", Misc.getTextColor(), new String[]{"" + (int)DURATION}, Misc.getHighlightColor());
            }
        } else {
            msg.addLine("    - Reduced shipping disruptions", Misc.getTextColor());
        }
        msg.setIcon(Global.getSettings().getSpriteName("events", "piracy_respite"));
        msg.setSound(Sounds.REP_GAIN);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
    }

    public void sendExpiredMessage() {
        MessageIntel msg = new MessageIntel();
        msg.addLine("Piracy Respite expired", Misc.getBasePlayerColor());
        msg.setIcon(Global.getSettings().getSpriteName("events", "piracy_respite"));
        msg.setSound(Sounds.REP_LOSS);
        Global.getSector().getCampaignUI().addMessage(msg, CommMessageAPI.MessageClickAction.COLONY_INFO);
    }

    public void resetTimestamp() {
        this.timestamp = Global.getSector().getClock().getTimestamp();
    }

    public float getDaysRemaining() {
        if (DURATION < 0.0f) {
            return DURATION;
        }
        float rem = DURATION - Global.getSector().getClock().getElapsedDaysSince(this.timestamp);
        if (rem < 0.0f) {
            rem = 0.0f;
        }
        return rem;
    }

    @Override
    public void commodityUpdated(String commodityId) {
    }

    @Override
    public void economyUpdated() {
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (curr.isPlayerOwned() && curr.getFaction() != null && curr.getFaction().isPlayerFaction()) {
                if (curr.hasCondition("piracy_respite")) continue;
                curr.addCondition("piracy_respite");
                continue;
            }
            if (!curr.hasCondition("piracy_respite")) continue;
            curr.removeCondition("piracy_respite");
        }
    }

    public void cleanup() {
        if (Global.getSector().getMemoryWithoutUpdate().contains(KEY)) {
            this.sendExpiredMessage();
        }
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!curr.hasCondition("piracy_respite")) continue;
            curr.removeCondition("piracy_respite");
        }
    }

    @Override
    public boolean isEconomyListenerExpired() {
        if (DURATION < 0.0f) {
            return false;
        }
        float days = this.getDaysRemaining();
        if (days <= 0.0f) {
            this.cleanup();
            return true;
        }
        return false;
    }
}

