/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;

public class RemnantHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener {
    public RemnantHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Remnant";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Remnant";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("remnant").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Remnant fleets have been sighted in your space.", opad);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        return super.getProgress(intel);
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("remnant").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return 0;
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        return null;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("remnant").getBaseUIColor();
        info.addPara("Impending Remnant attack", initPad, tc, c, "Remnant");
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Remnant attack averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        Color c = Global.getSector().getFaction("remnant").getBaseUIColor();
        if (!(stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData)) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
        if (!(data.custom instanceof MarketAPI)) {
            return;
        }
        MarketAPI target = (MarketAPI)data.custom;
        Color h = Misc.getHighlightColor();
        info.addPara("There are signs of activity at a Remnant Nexus in your system. Intel evaluates a high probability of an attack fleet being assembled to saturation-bombard " + target.getName() + ".", small, Misc.getNegativeHighlightColor(), "saturation-bombard");
        LabelAPI label = info.addPara("Defeating the attack fleet would only put off the problem, but destroying the Remnant Nexus will end the threat for good.", opad);
        label.setHighlight("Remnant Nexus", "end the threat");
        label.setHighlightColors(Global.getSector().getFaction("remnant").getBaseUIColor(), Misc.getPositiveHighlightColor());
        c = Global.getSector().getFaction("remnant").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("The %s is destroyed", 0.0f, c, "Remnant Nexus");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("remnant").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("remnant").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Remnant attack", intel, stage);
        }
        return null;
    }

    public static CampaignFleetAPI getRemnantNexus(StarSystemAPI system) {
        if (system == null) {
            return null;
        }
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!fleet.isStationMode() || !"remnant".equals(fleet.getFaction().getId())) continue;
            return fleet;
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            MarketAPI target = this.findAttackTarget(intel, stage);
            if (target == null || target.getStarSystem() == null) {
                return 0.0f;
            }
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(target.getStarSystem());
            if (nexus == null) {
                return 0.0f;
            }
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findAttackTarget(intel, stage);
        if (target == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        data.custom = target;
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = this.findAttackTarget(intel, stage);
        if (target == null || target.getStarSystem() == null) {
            return false;
        }
        CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(target.getStarSystem());
        if (nexus == null) {
            return false;
        }
        stage.rollData = null;
        return this.startAttack(nexus, target, target.getStarSystem(), stage, this.getRandomizedStageRandom(3));
    }

    public MarketAPI findAttackTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom(3));
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null) continue;
            for (MarketAPI curr : Misc.getMarketsInLocation(system, "player")) {
                picker.add(curr, curr.getSize() * curr.getSize() * curr.getSize());
            }
        }
        return (MarketAPI)picker.pick();
    }

    @Override
    public void notifyFactorRemoved() {
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this) {
            MarketAPI target;
            HostileActivityEventIntel.HAERandomEventData data = (HostileActivityEventIntel.HAERandomEventData)stage.rollData;
            if (data.custom instanceof MarketAPI && RemnantHostileActivityFactor.getRemnantNexus((target = (MarketAPI)data.custom).getStarSystem()) == null) {
                this.intel.resetHA_EVENT();
            }
        }
    }

    public boolean startAttack(CampaignFleetAPI nexus, MarketAPI target, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.makeFleetsHostile = true;
        params.remnant = true;
        params.factionId = nexus.getFaction().getId();
        MarketAPI fake = Global.getFactory().createMarket(nexus.getId(), nexus.getName(), 3);
        fake.setPrimaryEntity(nexus);
        fake.setFactionId(params.factionId);
        fake.getStats().getDynamic().getMod("fleet_quality_mod").modifyFlat("nexus_" + nexus.getId(), 1.0f);
        params.source = fake;
        params.prepDays = 0.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        params.raidParams.tryToCaptureObjectives = false;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.forcesNoun = "remnant forces";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        params.repImpact = HubMissionWithTriggers.ComplicationRepImpact.FULL;
        float fleetSizeMult = 1.0f;
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            fleetSizeMult = 0.5f;
        }
        float totalDifficulty = fleetSizeMult * 50.0f;
        totalDifficulty -= 10.0f;
        params.fleetSizes.add(10);
        while (totalDifficulty > 0.0f) {
            int min = 6;
            int max = 10;
            int diff = min + random.nextInt(max - min + 1);
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        GenericRaidFGI raid = new GenericRaidFGI(params);
        raid.setListener(this);
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
    }
}

