/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.RemnantHostileActivityFactor;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;

public class RemnantNexusActivityCause
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.5f;
    public static int PROGRESS_NEXUS_DAMAGED = Global.getSettings().getInt("remnantNexusPointsDamaged");
    public static int PROGRESS_NEXUS_NORMAL = Global.getSettings().getInt("remnantNexusPointsNormal");

    public RemnantNexusActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        LinkedHashSet seen = new LinkedHashSet();
        for (final StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null || nexus == null || seen.contains(nexus)) continue;
            int numColonies = Misc.getMarketsInLocation(system, "player").size();
            final String colonies = numColonies != 1 ? "colonies" : "colony";
            final String isOrAre = numColonies != 1 ? "are" : "is";
            String desc = "Remnant Nexus in the " + system.getNameWithLowercaseTypeShort();
            int progress = this.getProgressForNexus(nexus);
            String progressStr = "+" + progress;
            if (progress < 0) {
                progressStr = "" + progress;
            }
            Color descColor = this.getDescColor(intel);
            Color progressColor = this.getProgressColor(intel);
            info.addRowWithGlow(new Object[]{Alignment.LMID, descColor, "    " + desc, Alignment.RMID, progressColor, progressStr});
            BaseFactorTooltip t = new BaseFactorTooltip(){

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    MapParams params = new MapParams();
                    params.showSystem(system);
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, system.getNameWithLowercaseType());
                    tooltip.addPara("Your " + colonies + " in the " + system.getNameWithLowercaseTypeShort() + " " + isOrAre + " threatened by a Remnant Nexus located in the system. " + "This results in a greater risk of trade fleets being attacked, and eventual " + "existential danger for your " + colonies + ".", 0.0f, Misc.getNegativeHighlightColor(), "existential danger for your " + colonies);
                    tooltip.addPara("Even when relatively dormant, the Remnant fleets are a constant thorn in your side, wasting defensive resources and exposing your " + colonies + " to other dangers.", opad);
                    tooltip.addPara("%s should address all these concerns.", opad, Misc.getHighlightColor(), "Destroying the Nexus");
                    tooltip.addCustom(map, opad);
                }
            };
            info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
        }
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    @Override
    public int getProgress() {
        int total = 0;
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
            if (nexus == null) continue;
            total += this.getProgressForNexus(nexus);
        }
        return total;
    }

    protected int getProgressForNexus(CampaignFleetAPI nexus) {
        if (nexus == null) {
            return 0;
        }
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            return PROGRESS_NEXUS_DAMAGED;
        }
        return PROGRESS_NEXUS_NORMAL;
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        CampaignFleetAPI nexus = RemnantHostileActivityFactor.getRemnantNexus(system);
        if (nexus == null) {
            return 0.0f;
        }
        boolean damaged = nexus.getMemoryWithoutUpdate().getBoolean("$damagedStation");
        if (damaged) {
            return MAX_MAG * 0.5f;
        }
        return MAX_MAG;
    }
}

