/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class SindrianDiktatStandardActivityCause
extends BaseHostileActivityCause2 {
    public static int MIN_DIKTAT_PRODUCTION = 7;
    public static int MIN_COMPETITOR_PRODUCTION = 4;
    public static int MIN_COMPETITOR_MARKET_SIZE = 4;
    public static float PROD_PROGRESS_MULT = Global.getSettings().getFloat("diktatProgressPerUnitProdMult");
    public static float MAX_MAG = 0.5f;

    public static TriTachyonStandardActivityCause.CompetitorData computeCompetitorData(String factionId, String competitorId, String commodityId) {
        TriTachyonStandardActivityCause.CompetitorData data = new TriTachyonStandardActivityCause.CompetitorData(commodityId);
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            int prod;
            CommodityOnMarketAPI com = market.getCommodityData(commodityId);
            if (com == null || (prod = com.getMaxSupply()) <= 0) continue;
            if (factionId.equals(market.getFactionId())) {
                data.factionProdTotal += prod;
                data.factionProducers.add(market);
                data.factionMaxProd = Math.max(data.factionMaxProd, prod);
            } else if (competitorId.equals(market.getFactionId())) {
                data.competitorProdTotal += prod;
                data.competitorMaxProd = Math.max(data.competitorMaxProd, prod);
                data.competitorProducers.add(market);
                data.competitorMaxMarketSize = Math.max(data.competitorMaxMarketSize, market.getSize());
            }
            data.allProdTotal += prod;
        }
        return data;
    }

    public static List<TriTachyonStandardActivityCause.CompetitorData> computePlayerCompetitionData() {
        String factionId = "sindrian_diktat";
        ArrayList<String> commodities = new ArrayList<String>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!factionId.equals(market.getFactionId())) continue;
            for (CommodityOnMarketAPI com : market.getCommoditiesCopy()) {
                int prod;
                if (!com.isFuel() || (prod = com.getMaxSupply()) < MIN_DIKTAT_PRODUCTION) continue;
                commodities.add(com.getId());
            }
        }
        ArrayList<TriTachyonStandardActivityCause.CompetitorData> result = new ArrayList<TriTachyonStandardActivityCause.CompetitorData>();
        for (String commodityId : commodities) {
            TriTachyonStandardActivityCause.CompetitorData data = SindrianDiktatStandardActivityCause.computeCompetitorData(factionId, "player", commodityId);
            if (data.competitorMaxProd < MIN_COMPETITOR_PRODUCTION || data.competitorMaxMarketSize < MIN_COMPETITOR_MARKET_SIZE) continue;
            result.add(data);
        }
        return result;
    }

    public SindrianDiktatStandardActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                Color h = Misc.getHighlightColor();
                Color tc = Misc.getTextColor();
                tooltip.addPara("Your colony production of fuel is high enough for the Sindrian Diktat - which depends on its own fuel production for much of its economy - to take notice.", 0.0f);
                List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
                FactionAPI player = Global.getSector().getFaction("player");
                tooltip.beginTable(player, 20.0f, "Commodity", Float.valueOf(this.getTooltipWidth(tooltipParam) - 150.0f), "Production", Float.valueOf(150.0f));
                for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
                    tooltip.addRow(new Object[]{Alignment.LMID, tc, Misc.ucFirst(data.spec.getLowerCaseName()), Alignment.MID, h, "" + data.competitorMaxProd});
                }
                tooltip.addTable("", 0, opad);
                tooltip.addSpacer(5.0f);
                tooltip.addPara("Event progress is based on maximum fuel production. %s below %s per colony should be enough to divert the Diktat's attention.", opad, h, "Reducing production levels ", "" + MIN_COMPETITOR_PRODUCTION);
                tooltip.addPara("Knocking the Diktat out of the fuel production game is also an option. Much of their fuel production depends on a Domain-era Synchrotron Core installed in their production facilities on Sindria.", opad, h, "Synchrotron Core");
                MarketAPI sindria = SindrianDiktatHostileActivityFactor.getSindria(false);
                if (sindria != null && sindria.getStarSystem() != null) {
                    MapParams params = new MapParams();
                    params.showSystem(sindria.getStarSystem());
                    float w = tooltip.getWidthSoFar();
                    float ht = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, ht));
                    UIPanelAPI map = tooltip.createSectorMap(w, ht, params, String.valueOf(sindria.getName()) + " (" + sindria.getStarSystem().getNameWithLowercaseTypeShort() + ")");
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    @Override
    public int getProgress() {
        if (SindrianDiktatHostileActivityFactor.isMadeDeal() || SindrianDiktatHostileActivityFactor.isPlayerDefeatedDiktatAttack()) {
            return 0;
        }
        int total = 0;
        List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
            total += data.getProgress(PROD_PROGRESS_MULT);
        }
        return total;
    }

    @Override
    public String getDesc() {
        return "Competing fuel production";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        List<TriTachyonStandardActivityCause.CompetitorData> comp = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        float mag = 0.0f;
        for (TriTachyonStandardActivityCause.CompetitorData data : comp) {
            for (MarketAPI market : data.competitorProducers) {
                if (market.getContainingLocation() != system) continue;
                CommodityOnMarketAPI com = market.getCommodityData(data.commodityId);
                float prod = com.getMaxSupply();
                mag += prod * 0.1f;
            }
        }
        if (mag > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        return mag;
    }
}

