/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class StandardPerseanLeagueActivityCause
extends BaseHostileActivityCause2 {
    public static int LARGE_COLONY = 5;
    public static int MEDIUM_COLONY = 4;
    public static int COUNT_IF_MEDIUM = 3;
    public static float MAX_MAG = 0.5f;

    public StandardPerseanLeagueActivityCause(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Going to Kazeron and negotiating to join the League is likely to get this harassment to stop. If left unchecked, this low-grade conflict will eventually come to a head and is likely to be resolved one way or another.", 0.0f, Misc.getHighlightColor(), "join the League");
                tooltip.addPara("Event progress value is based on the number and size of colonies under your control. Requires one size %s colony, or at least %s colonies with one being at least size %s.", opad, Misc.getHighlightColor(), "" + LARGE_COLONY, "" + COUNT_IF_MEDIUM, "" + MEDIUM_COLONY);
                MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
                if (kazeron != null && kazeron.getStarSystem() != null) {
                    MapParams params = new MapParams();
                    params.showSystem(kazeron.getStarSystem());
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, String.valueOf(kazeron.getName()) + " (" + kazeron.getStarSystem().getNameWithLowercaseTypeShort() + ")");
                    tooltip.addCustom(map, opad);
                }
            }
        };
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0;
    }

    @Override
    public String getProgressStr() {
        return super.getProgressStr();
    }

    @Override
    public Color getProgressColor(BaseEventIntel intel) {
        return super.getProgressColor(intel);
    }

    @Override
    public int getProgress() {
        if (!HA_CMD.canPlayerJoinTheLeague()) {
            return 0;
        }
        if (PerseanLeagueMembership.isDefeatedBlockadeOrPunEx()) {
            return 0;
        }
        int score = 0;
        for (MarketAPI market : Misc.getPlayerMarkets(false)) {
            int size = market.getSize();
            if (size <= 4) {
                score += size;
                continue;
            }
            if (size == 5) {
                score += size + 2;
                continue;
            }
            if (size == 6) {
                score += size + 4;
                continue;
            }
            score += size + 6;
        }
        int progress = score;
        return progress;
    }

    @Override
    public String getDesc() {
        return "Colony presence and size";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (this.getProgress() <= 0) {
            return 0.0f;
        }
        return (0.4f + 0.6f * this.intel.getMarketPresenceFactor(system)) * MAX_MAG;
    }
}

