/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events.ttcr;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.EventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRCommerceRaidersDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRIndustryDisruptedFactorHint;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRTradeFleetsDestroyedFactorHint;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class TriTachyonCommerceRaiding
extends BaseEventIntel {
    public static int PROGRESS_MAX = 300;
    public static int PROGRESS_1 = 150;
    public static String KEY = "$ttcr_ref";

    public static void addFactorCreateIfNecessary(EventFactor factor, InteractionDialogAPI dialog) {
        if (TriTachyonCommerceRaiding.get() == null) {
            new TriTachyonCommerceRaiding(null, false);
        }
        if (TriTachyonCommerceRaiding.get() != null) {
            TriTachyonCommerceRaiding.get().addFactor(factor, dialog);
        }
    }

    public static TriTachyonCommerceRaiding get() {
        return (TriTachyonCommerceRaiding)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public TriTachyonCommerceRaiding(TextPanelAPI text, boolean withIntelNotification) {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.setup();
        Global.getSector().getIntelManager().addIntel(this, !withIntelNotification, text);
    }

    protected void setup() {
        this.factors.clear();
        this.stages.clear();
        this.setMaxProgress(PROGRESS_MAX);
        this.addStage((Object)Stage.START, 0);
        this.addStage((Object)Stage.SEND_MERC, PROGRESS_1, true, BaseEventIntel.StageIconSize.MEDIUM);
        this.addStage((Object)Stage.SUCCESS, PROGRESS_MAX, true, BaseEventIntel.StageIconSize.LARGE);
        this.addFactor(new TTCRCommerceRaidersDestroyedFactorHint());
        this.addFactor(new TTCRTradeFleetsDestroyedFactorHint());
        this.addFactor(new TTCRIndustryDisruptedFactorHint());
    }

    protected Object readResolve() {
        return this;
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        if (this.addEventFactorBulletPoints(info, mode, isUpdate, tc, initPad)) {
            return;
        }
        Color h = Misc.getHighlightColor();
        if (isUpdate && this.getListInfoParam() instanceof BaseEventIntel.EventStageData) {
            BaseEventIntel.EventStageData esd = (BaseEventIntel.EventStageData)this.getListInfoParam();
            if (esd.id == Stage.SEND_MERC) {
                info.addPara("Several bounty hunters were recently hired to eliminate you", tc, initPad);
            }
            if (esd.id == Stage.SUCCESS) {
                info.addPara("You've convincied Tri-Tachyon to stop attacking your interests", tc, initPad);
            }
            return;
        }
    }

    @Override
    public void addStageDescriptionText(TooltipMakerAPI info, float width, Object stageId) {
        float opad = 10.0f;
        float small = 0.0f;
        Color h = Misc.getHighlightColor();
        BaseEventIntel.EventStageData stage = this.getDataFor(stageId);
        if (stage == null) {
            return;
        }
        if (this.isStageActive(stageId)) {
            this.addStageDesc(info, stageId, small, false);
        }
    }

    public FactionAPI getFaction() {
        return Global.getSector().getFaction("tritachyon");
    }

    public void addStageDesc(TooltipMakerAPI info, Object stageId, float initPad, boolean forTooltip) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        FactionAPI faction = this.getFaction();
        Color tt = faction.getBaseUIColor();
        if (stageId == Stage.START) {
            LabelAPI label = info.addPara("The %s needs to be convinced that continued investment in acting against your interests is unprofitable in the long term. If you are able to send this message without becoming openly hostile - or smooth any ruffled feathers afterwards - this may even mark you as someone whose understanding of business realities makes them worth working with.", initPad, tt, faction.getDisplayNameLong());
            label.setHighlight(faction.getDisplayNameLong(), "worth working with");
            label.setHighlightColors(tt, Misc.getPositiveHighlightColor());
        } else if (stageId == Stage.SUCCESS) {
            info.addPara("You've convinced the %s to stop attacking your interests.", initPad, tt, faction.getDisplayNameLong());
        } else if (stageId == Stage.SEND_MERC) {
            info.addPara("Several bounty hunters were recently hired to eliminate you. You are likely to encounter them in the coming months. Resolving the matter with Tri-Tachyon before then is unlikely to make a difference in this; a contract is a contract.", initPad);
        }
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(Object stageId) {
        final BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd != null && EnumSet.of(Stage.SEND_MERC, Stage.SUCCESS).contains(esd.id)) {
            return new BaseFactorTooltip(){

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    if (esd.id == Stage.SEND_MERC) {
                        tooltip.addTitle("Bounty posted");
                    } else if (esd.id == Stage.SUCCESS) {
                        tooltip.addTitle("Success!");
                    }
                    TriTachyonCommerceRaiding.this.addStageDesc(tooltip, esd.id, opad, true);
                    esd.addProgressReq(tooltip, opad);
                }
            };
        }
        return null;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("events", "triTachyonCR_START");
    }

    @Override
    protected String getStageIconImpl(Object stageId) {
        BaseEventIntel.EventStageData esd = this.getDataFor(stageId);
        if (esd == null) {
            return null;
        }
        return Global.getSettings().getSpriteName("events", "triTachyonCR_" + ((Stage)((Object)esd.id)).name());
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Colony threats");
        tags.add("tritachyon");
        return tags;
    }

    @Override
    public Color getBarColor() {
        Color color = this.getFaction().getBaseUIColor();
        color = Misc.interpolateColor(color, Color.black, 0.25f);
        return color;
    }

    @Override
    public Color getBarProgressIndicatorColor() {
        return super.getBarProgressIndicatorColor();
    }

    @Override
    protected int getStageImportance(Object stageId) {
        return super.getStageImportance(stageId);
    }

    @Override
    protected String getName() {
        return "Tri-Tachyon Commerce Raiding";
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
    }

    @Override
    protected void notifyStageReached(BaseEventIntel.EventStageData stage) {
        if (stage.id == Stage.SEND_MERC) {
            this.sendBountyHunters();
        }
        if (stage.id == Stage.SUCCESS) {
            TriTachyonHostileActivityFactor.setPlayerCounterRaidedTriTach();
            this.endAfterDelay();
        }
    }

    @Override
    public boolean withMonthlyFactors() {
        return false;
    }

    @Override
    protected String getSoundForStageReachedUpdate(Object stageId) {
        return super.getSoundForStageReachedUpdate(stageId);
    }

    @Override
    protected String getSoundForOneTimeFactorUpdate(EventFactor factor) {
        return null;
    }

    protected void sendBountyHunters() {
        Random r = Misc.getRandom(this.random.nextLong(), 7);
        DelayedFleetEncounter e = new DelayedFleetEncounter(r, "TTCRBountyHunterWolfpack");
        e.setDelayVeryShort();
        e.setDoNotAbortWhenPlayerFleetTooStrong();
        e.setLocationOuterSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetMaxShipSize(1);
        e.triggerSetFleetDoctrineOther(5, 4);
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(r);
        picker.add("tempest_Attack", 10.0f);
        picker.add("tempest_Attack", 10.0f);
        picker.add("tempest_Attack", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("scarab_Experimental", 10.0f);
        picker.add("hyperion_Attack", 10.0f);
        picker.add("hyperion_Strike", 10.0f);
        picker.add("omen_PD", 5.0f);
        picker.add("omen_PD", 5.0f);
        picker.add("monitor_Escort", 5.0f);
        picker.add("monitor_Escort", 5.0f);
        picker.add("shade_Assault", 5.0f);
        picker.add("shade_Assault", 5.0f);
        picker.add("afflictor_Strike", 5.0f);
        picker.add("afflictor_Strike", 5.0f);
        int add = 9;
        while (!picker.isEmpty() && add > 0) {
            e.triggerAddShips((String)picker.pickAndRemove());
            --add;
        }
        e.triggerSetFleetMaxNumShips(14);
        e.triggerSetFleetDoctrineComp(5, 0, 0);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerFleetAddCommanderSkill("wolfpack_tactics", 1);
        e.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        e.triggerFleetAddCommanderSkill("flux_regulation", 1);
        e.triggerFleetAddCommanderSkill("tactical_drills", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.UNUSUALLY_HIGH);
        e.triggerFleetMakeFaster(true, 0, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_wolfpack");
        e.endCreate();
        r = Misc.getRandom(this.random.nextLong(), 3);
        e = new DelayedFleetEncounter(r, "TTCRBountyHunterPhase");
        e.setDelayVeryShort();
        e.setLocationInnerSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetDoctrineComp(0, 0, 5);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerFleetAddCommanderSkill("phase_corps", 1);
        e.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        e.triggerFleetAddCommanderSkill("flux_regulation", 1);
        e.triggerFleetAddCommanderSkill("tactical_drills", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        e.triggerFleetMakeFaster(true, 0, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_phase");
        e.endCreate();
        r = Misc.getRandom(this.random.nextLong(), 11);
        e = new DelayedFleetEncounter(r, "TTCRBountyHunterDerelict");
        e.setDelayVeryShort();
        e.setLocationCoreOnly(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.VERY_LOW, "luddic_church", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetDoctrineOther(5, 5);
        e.triggerFleetAddCommanderSkill("derelict_contingent", 1);
        e.triggerFleetAddCommanderSkill("support_doctrine", 1);
        e.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.LOWER);
        e.triggerFleetMakeFaster(true, 2, true);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("TTCRBountyHunterHail");
        e.triggerSetFleetFlagPermanent("$ttcr_derelict");
        e.endCreate();
    }

    public static enum Stage {
        START,
        SEND_MERC,
        SUCCESS;

    }
}

