/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.group.FGDurationAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.themes.WarfleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class FGRaidAction
extends FGDurationAction
implements BaseAssignmentAI.FleetActionDelegate,
GenericRaidFGI.GenericPayloadAction {
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected boolean computedSubstages = false;
    protected FGRaidParams params;
    protected CountingMap<MarketAPI> raidCount = new CountingMap();
    protected int bombardCount = 0;
    protected List<RaidSubstage> stages = new ArrayList<RaidSubstage>();
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();
    protected float originalDuration = 0.0f;

    public FGRaidAction(FGRaidParams params, float raidDays) {
        super(raidDays);
        this.originalDuration = raidDays;
        this.params = params;
        this.interval.forceIntervalElapsed();
    }

    public Object readResolve() {
        if (this.raidCount == null) {
            this.raidCount = new CountingMap();
        }
        return this;
    }

    @Override
    public void addRouteSegment(RouteManager.RouteData route) {
        RouteManager.RouteSegment segment = new RouteManager.RouteSegment(this.getDurDays(), this.params.where.getCenter());
        route.addSegment(segment);
    }

    @Override
    public void notifyFleetsSpawnedMidSegment(RouteManager.RouteSegment segment) {
        super.notifyFleetsSpawnedMidSegment(segment);
    }

    @Override
    public void notifySegmentFinished(RouteManager.RouteSegment segment) {
        super.notifySegmentFinished(segment);
        this.autoresolve();
    }

    protected void computeSubstages() {
        float dist;
        List<CampaignFleetAPI> fleets = this.intel.getFleets();
        if (fleets.isEmpty()) {
            return;
        }
        for (CampaignFleetAPI fleet : fleets) {
            if (!fleet.hasScriptOfClass(WarfleetAssignmentAI.class)) {
                WarfleetAssignmentAI script = new WarfleetAssignmentAI(fleet, true, true);
                script.setDelegate(this);
                fleet.addScript(script);
            }
            fleet.getMemoryWithoutUpdate().set("$isWarFleet", true);
            fleet.getMemoryWithoutUpdate().unset("$core_fleetBusy");
        }
        ArrayList<MarketAPI> sortedTargetMarkets = new ArrayList<MarketAPI>();
        for (MarketAPI market : Misc.getMarketsInLocation(this.params.where)) {
            if (!this.params.allowAnyHostileMarket && !this.params.allowedTargets.contains(market) || !this.params.allowNonHostileTargets && !this.intel.getFaction().isHostileTo(market.getFaction())) continue;
            sortedTargetMarkets.add(market);
        }
        final Vector2f sortLoc = new Vector2f((ReadableVector2f)fleets.get(0).getLocation());
        Collections.sort(sortedTargetMarkets, new Comparator<MarketAPI>(){

            @Override
            public int compare(MarketAPI o1, MarketAPI o2) {
                float d1 = Misc.getDistance(sortLoc, o1.getPrimaryEntity().getLocation());
                float d2 = Misc.getDistance(sortLoc, o2.getPrimaryEntity().getLocation());
                return (int)Math.signum(d1 - d2);
            }
        });
        for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("objective")) {
            WarSimScript.setNoFightingForObjective(objective, this.intel.getFaction(), 1000.0f);
        }
        ArrayList<SectorEntityToken> objectives = new ArrayList<SectorEntityToken>();
        float minDist = Float.MAX_VALUE;
        SectorEntityToken closest = null;
        for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("nav_buoy")) {
            dist = Misc.getDistance(sortLoc, objective.getLocation());
            if (!(dist < minDist)) continue;
            closest = objective;
            minDist = dist;
        }
        if (closest != null) {
            objectives.add(closest);
        }
        minDist = Float.MAX_VALUE;
        closest = null;
        for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("sensor_array")) {
            dist = Misc.getDistance(sortLoc, objective.getLocation());
            if (!(dist < minDist)) continue;
            closest = objective;
            minDist = dist;
        }
        if (closest != null) {
            objectives.add(closest);
        }
        if (!this.params.tryToCaptureObjectives) {
            objectives.clear();
        }
        if (this.params.type == FGRaidType.CONCURRENT) {
            stage = new RaidSubstage();
            stage.maxDuration = this.params.maxDurationIfSpawnedFleetsConcurrent;
            stage.objectives.addAll(objectives);
            for (MarketAPI marketAPI : sortedTargetMarkets) {
                stage.markets.add(marketAPI.getPrimaryEntity());
            }
            this.stages.add(stage);
        } else {
            if (!objectives.isEmpty()) {
                stage = new RaidSubstage();
                stage.maxDuration = this.params.maxDurationIfSpawnedFleetsPerSequentialStage;
                stage.objectives.addAll(objectives);
                this.stages.add(stage);
            }
            for (MarketAPI market : sortedTargetMarkets) {
                RaidSubstage stage = new RaidSubstage();
                stage.maxDuration = this.params.maxDurationIfSpawnedFleetsConcurrent;
                stage.markets.add(market.getPrimaryEntity());
                this.stages.add(stage);
            }
        }
        float totalDur = 0.0f;
        for (RaidSubstage raidSubstage : this.stages) {
            totalDur += raidSubstage.maxDuration;
        }
        this.setDurDays(totalDur + 10.0f);
        float f = 1.0f / Math.max(1.0f, (float)sortedTargetMarkets.size());
        for (MarketAPI market : sortedTargetMarkets) {
            MilitaryResponseScript.MilitaryResponseParams defParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "defRaid_" + market.getId(), market.getFaction(), market.getPrimaryEntity(), f, this.getDurDays());
            MilitaryResponseScript defScript = new MilitaryResponseScript(defParams);
            this.params.where.addScript(defScript);
            this.scripts.add(defScript);
        }
        this.computedSubstages = true;
    }

    public void removeAggroMilitaryScripts(boolean clearAssignments) {
        if (clearAssignments) {
            for (CampaignFleetAPI fleet : this.intel.getFleets()) {
                fleet.clearAssignments();
            }
        }
        if (this.scripts != null) {
            ArrayList<MilitaryResponseScript> remove = new ArrayList<MilitaryResponseScript>();
            for (MilitaryResponseScript s : this.scripts) {
                if (s.getParams() == null || s.getParams().responseReason == null || !s.getParams().responseReason.startsWith("raid_")) continue;
                s.forceDone();
                remove.add(s);
            }
            this.scripts.removeAll(remove);
        }
    }

    @Override
    public void setActionFinished(boolean finished) {
        if (finished && !this.finished) {
            List<CampaignFleetAPI> fleets = this.intel.getFleets();
            for (CampaignFleetAPI fleet : fleets) {
                fleet.removeScriptsOfClass(WarfleetAssignmentAI.class);
                Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", fleet.getId(), true, -1.0f);
            }
            if (this.scripts != null) {
                for (MilitaryResponseScript s : this.scripts) {
                    s.forceDone();
                }
            }
            for (SectorEntityToken objective : this.params.where.getEntitiesWithTag("objective")) {
                WarSimScript.removeNoFightingTimeoutForObjective(objective, this.intel.getFaction());
            }
        }
        super.setActionFinished(finished);
    }

    @Override
    public void directFleets(float amount) {
        super.directFleets(amount);
        if (this.isActionFinished()) {
            return;
        }
        if (this.intel.isSpawning()) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.intel.getFleets();
        if (fleets.isEmpty()) {
            this.setActionFinished(true);
            return;
        }
        if (!this.computedSubstages) {
            this.computeSubstages();
        }
        if (this.stages.isEmpty()) {
            this.setActionFinished(true);
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        RaidSubstage stage = this.stages.get(0);
        if (!stage.started) {
            stage.started = true;
            this.removeAggroMilitaryScripts(true);
            ArrayList<SectorEntityToken> targets = new ArrayList<SectorEntityToken>(stage.objectives);
            targets.addAll(stage.markets);
            this.orderFleetMovements(targets);
        }
        stage.maxDuration -= days;
        if (stage.maxDuration <= 0.0f || stage.allGoalsAchieved(this)) {
            this.stages.remove(stage);
        }
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(this.params.where.getCenter());
        if (!inSpawnRange && this.elapsed > this.originalDuration) {
            this.autoresolve();
            return;
        }
        for (SectorEntityToken obj : stage.objectives) {
            if (obj.getFaction() != this.intel.getFaction()) continue;
            WarSimScript.removeFightOrdersFor(obj, this.intel.getFaction());
        }
        boolean someRaidsFinished = false;
        for (SectorEntityToken e : stage.markets) {
            if (stage.finishedRaiding.contains(e) || this.canRaid(null, e.getMarket())) continue;
            someRaidsFinished = true;
            stage.finishedRaiding.add(e);
        }
        if (someRaidsFinished) {
            for (SectorEntityToken e : stage.markets) {
                WarSimScript.removeFightOrdersFor(e, this.intel.getFaction());
            }
            ArrayList<SectorEntityToken> remaining = new ArrayList<SectorEntityToken>();
            remaining.addAll(stage.markets);
            remaining.removeAll(stage.finishedRaiding);
            if (!remaining.isEmpty()) {
                this.orderFleetMovements(remaining);
            }
        }
        for (CampaignFleetAPI fleet : fleets) {
            if (!this.params.doNotGetSidetracked) continue;
            boolean battleNear = false;
            for (CampaignFleetAPI other : fleets) {
                CampaignFleetAIAPI ai;
                float dist;
                if (other == fleet || other.getBattle() == null) continue;
                if (other.getContainingLocation() != fleet.getContainingLocation()) {
                    // empty if block
                }
                if (!((dist = Misc.getDistance(fleet, other)) < 1000.0f) || (ai = fleet.getAI()) == null || !ai.wantsToJoin(other.getBattle(), other.getBattle().isPlayerInvolved())) continue;
                battleNear = true;
                break;
            }
            if (battleNear) continue;
            fleet.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
        }
    }

    protected void orderFleetMovements(List<SectorEntityToken> targets) {
        float responseFraction = 1.0f / Math.max(1.0f, (float)targets.size());
        for (SectorEntityToken target : targets) {
            if (!target.hasTag("objective") && !this.canRaid(null, target.getMarket())) continue;
            float rf = responseFraction;
            MilitaryResponseScript.MilitaryResponseParams aggroParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "raid_" + target.getId(), this.intel.getFaction(), target, rf, this.getDurDays());
            if (this.params.appendTargetNameToTravelText) {
                aggroParams.travelText = String.valueOf(this.params.targetTravelText != null ? String.valueOf(this.params.targetTravelText) + " " : "traveling to ") + target.getName();
            } else if (this.params.targetTravelText != null) {
                aggroParams.travelText = this.params.targetTravelText;
            }
            aggroParams.actionText = this.params.inSystemActionText != null ? this.params.inSystemActionText : "raiding system";
            MilitaryResponseScript script = new MilitaryResponseScript(aggroParams);
            this.params.where.addScript(script);
            this.scripts.add(script);
        }
    }

    public FGRaidParams getParams() {
        return this.params;
    }

    @Override
    public boolean canRaid(CampaignFleetAPI fleet, MarketAPI market) {
        if (market == null) {
            return false;
        }
        if (!market.isInEconomy()) {
            return false;
        }
        if (!(this.params.allowedTargets.contains(market) || this.params.allowedTargets.isEmpty() || this.params.allowAnyHostileMarket)) {
            return false;
        }
        if (this.raidCount.getCount(market) >= this.params.raidsPerColony) {
            return false;
        }
        if (fleet != null && !this.intel.getFleets().contains(fleet)) {
            return false;
        }
        if (this.params.bombardment != null && fleet != null) {
            float fp = fleet.getFleetPoints();
            for (CampaignFleetAPI other : this.intel.getFleets()) {
                float otherFP;
                float dist;
                if (other == fleet || other.getContainingLocation() != fleet.getContainingLocation() || (dist = Misc.getDistance(fleet, other)) > 1000.0f || !((otherFP = (float)other.getFleetPoints()) > fp * 1.2f)) continue;
                return false;
            }
        }
        FactionAPI faction = this.intel.getFaction();
        if (fleet != null) {
            faction = fleet.getFaction();
        }
        boolean hostile = market.getFaction().isHostileTo(faction);
        if (fleet != null) {
            hostile |= Misc.isFleetMadeHostileToFaction(fleet, market.getFaction());
        }
        return (this.params.allowNonHostileTargets || hostile) && !this.isActionFinished();
    }

    @Override
    public void performRaid(CampaignFleetAPI fleet, MarketAPI market) {
        this.raidCount.add(market);
        FactionAPI faction = this.intel.getFaction();
        if (fleet != null) {
            faction = fleet.getFaction();
        }
        if (this.params.bombardment != null) {
            float cost = MarketCMD.getBombardmentCost(market, fleet);
            float bombardStr = this.intel.getRoute().getExtra().getStrengthModifiedByDamage() / (float)this.intel.getApproximateNumberOfFleets() * Misc.FP_TO_BOMBARD_COST_APPROX_MULT;
            if (fleet != null) {
                bombardStr = fleet.getCargo().getMaxFuel() * 0.5f;
            }
            if (cost <= bombardStr) {
                new MarketCMD(market.getPrimaryEntity()).doBombardment(this.intel.getFaction(), this.params.bombardment);
                ++this.bombardCount;
            } else {
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyBombarded", this.intel.getFaction().getId(), true, 30.0f);
            }
        } else {
            float raidStr = this.intel.getRoute().getExtra().getStrengthModifiedByDamage() / (float)this.intel.getApproximateNumberOfFleets() * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
            if (fleet != null) {
                raidStr = MarketCMD.getRaidStr(fleet);
            }
            Industry industry = null;
            int index = this.raidCount.getCount(market) - 1;
            if (index < 0) {
                index = 0;
            }
            if (this.params.disrupt != null && index < this.params.disrupt.size()) {
                int count = 0;
                for (String industryId : this.params.disrupt) {
                    if (!market.hasIndustry(industryId)) continue;
                    if (count >= index) {
                        industry = market.getIndustry(industryId);
                        break;
                    }
                    ++count;
                }
            }
            if (this.intel instanceof GenericRaidFGI && ((GenericRaidFGI)this.intel).hasCustomRaidAction()) {
                ((GenericRaidFGI)this.intel).doCustomRaidAction(fleet, market, raidStr);
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId(), true, 30.0f);
                Misc.setRaidedTimestamp(market);
            } else if (industry != null) {
                float durMult = Global.getSettings().getFloat("punitiveExpeditionDisruptDurationMult");
                new MarketCMD(market.getPrimaryEntity()).doIndustryRaid(faction, raidStr, industry, durMult);
            } else {
                new MarketCMD(market.getPrimaryEntity()).doGenericRaid(faction, raidStr, this.params.maxStabilityLostPerRaid, this.params.raidsPerColony > 1);
            }
        }
    }

    public void autoresolve() {
        RouteManager.OptionalFleetData data;
        if (this.isActionFinished()) {
            return;
        }
        float str = WarSimScript.getFactionStrength(this.intel.getFaction(), this.params.where);
        if (!this.intel.isSpawnedFleets() && this.intel.getRoute().isExpired() && (data = this.intel.getRoute().getExtra()) != null) {
            str += data.getStrengthModifiedByDamage();
        }
        boolean playerTargeted = false;
        if (this.intel instanceof GenericRaidFGI) {
            playerTargeted = ((GenericRaidFGI)this.intel).getParams().playerTargeted;
        }
        float enemyStr = WarSimScript.getEnemyStrength(this.intel.getFaction(), this.params.where, playerTargeted);
        float origStr = str;
        float strMult = 1.0f;
        for (MarketAPI target : Misc.getMarketsInLocation(this.params.where)) {
            if (!this.params.allowAnyHostileMarket && !this.params.allowedTargets.contains(target) || !this.params.allowNonHostileTargets && !this.intel.getFaction().isHostileTo(target.getFaction())) continue;
            float defensiveStr = enemyStr + WarSimScript.getStationStrength(target.getFaction(), this.params.where, target.getPrimaryEntity());
            float damage = 0.5f * defensiveStr / Math.max(str, 1.0f);
            if (damage > 0.75f) {
                damage = 0.75f;
            }
            strMult *= 1.0f - damage;
            if (defensiveStr >= str) continue;
            Industry station = Misc.getStationIndustry(target);
            if (station != null) {
                OrbitalStation.disrupt(station);
                station.reapply();
            }
            int i = 0;
            while (i < this.params.raidsPerColony) {
                this.performRaid(null, target);
                ++i;
            }
            str = origStr * strMult;
        }
        if (this.intel.isSpawnedFleets() && strMult < 1.0f) {
            for (CampaignFleetAPI fleet : this.intel.getFleets()) {
                FleetFactoryV3.applyDamageToFleet(fleet, 1.0f - strMult, false, this.intel.getRandom());
            }
        }
        if (!this.intel.isSpawnedFleets() && strMult < 1.0f) {
            RouteManager.OptionalFleetData extra = this.intel.getRoute().getExtra();
            if (extra != null) {
                if (extra.damage == null) {
                    extra.damage = Float.valueOf(0.0f);
                }
                extra.damage = Float.valueOf(1.0f - (1.0f - extra.damage.floatValue()) * strMult);
                if (extra.damage.floatValue() > 1.0f) {
                    extra.damage = Float.valueOf(1.0f);
                }
            }
        } else if (this.intel.isSpawnedFleets() && this.getSuccessFraction() <= 0.0f) {
            this.intel.abort();
        }
        this.setActionFinished(true);
    }

    @Override
    public String getRaidApproachText(CampaignFleetAPI fleet, MarketAPI market) {
        if (this.params.raidApproachText != null) {
            return String.valueOf(this.params.raidApproachText) + " " + market.getName();
        }
        return null;
    }

    @Override
    public String getRaidActionText(CampaignFleetAPI fleet, MarketAPI market) {
        if (this.params.raidActionText != null) {
            return String.valueOf(this.params.raidActionText) + " " + market.getName();
        }
        return null;
    }

    @Override
    public String getRaidPrepText(CampaignFleetAPI fleet, SectorEntityToken from) {
        return null;
    }

    @Override
    public String getRaidInSystemText(CampaignFleetAPI fleet) {
        return null;
    }

    @Override
    public String getRaidDefaultText(CampaignFleetAPI fleet) {
        return null;
    }

    public CountingMap<MarketAPI> getRaidCount() {
        return this.raidCount;
    }

    @Override
    public float getSuccessFraction() {
        int totalGoal = this.params.raidsPerColony * this.params.allowedTargets.size();
        if (totalGoal < 1) {
            totalGoal = 1;
        }
        int achieved = this.raidCount.getTotal();
        if (this.params.bombardment != null) {
            achieved = this.bombardCount;
        }
        return Math.max(0.0f, (float)achieved / (float)totalGoal);
    }

    @Override
    public Color getSystemNameHighlightColor() {
        MarketAPI largest = null;
        int max = 0;
        boolean player = false;
        for (MarketAPI target : Misc.getMarketsInLocation(this.params.where)) {
            if (!this.params.allowAnyHostileMarket && !this.params.allowedTargets.contains(target) || !this.params.allowNonHostileTargets && !this.intel.getFaction().isHostileTo(target.getFaction())) continue;
            int size = target.getSize();
            if (size > max) {
                largest = target;
                max = size;
            }
            if (!target.isPlayerOwned()) continue;
            player = true;
        }
        if (player) {
            return Misc.getBasePlayerColor();
        }
        if (largest != null) {
            return largest.getFaction().getBaseUIColor();
        }
        return Misc.getTextColor();
    }

    @Override
    public StarSystemAPI getWhere() {
        return this.params.where;
    }

    public static class FGRaidParams {
        public StarSystemAPI where;
        public FGRaidType type = FGRaidType.CONCURRENT;
        public boolean doNotGetSidetracked = true;
        public boolean tryToCaptureObjectives = true;
        public boolean allowAnyHostileMarket = false;
        public float maxDurationIfSpawnedFleetsConcurrent = 90.0f;
        public float maxDurationIfSpawnedFleetsPerSequentialStage = 45.0f;
        public int maxStabilityLostPerRaid = 3;
        public int raidsPerColony = 2;
        public String raidApproachText = null;
        public String raidActionText = null;
        public String targetTravelText = null;
        public boolean appendTargetNameToTravelText = true;
        public String inSystemActionText = null;
        public MarketCMD.BombardType bombardment = null;
        public List<String> disrupt = new ArrayList<String>();
        public boolean allowNonHostileTargets = false;
        public List<MarketAPI> allowedTargets = new ArrayList<MarketAPI>();

        public void setBombardment(MarketCMD.BombardType type) {
            this.bombardment = type;
            this.raidApproachText = "moving to bombard";
            this.raidActionText = "bombarding";
            this.raidsPerColony = 1;
        }

        public void setDisrupt(String ... industries) {
            String[] stringArray = industries;
            int n = industries.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.disrupt.add(id);
                ++n2;
            }
            this.raidsPerColony = Math.min(this.disrupt.size(), 3);
            if (this.raidsPerColony < 1) {
                this.raidsPerColony = 1;
            }
        }
    }

    public static enum FGRaidType {
        CONCURRENT,
        SEQUENTIAL;

    }

    public static class RaidSubstage {
        protected boolean started = false;
        public float maxDuration;
        public List<SectorEntityToken> objectives = new ArrayList<SectorEntityToken>();
        public List<SectorEntityToken> markets = new ArrayList<SectorEntityToken>();
        public List<SectorEntityToken> finishedRaiding = new ArrayList<SectorEntityToken>();

        protected Object readResolve() {
            if (this.objectives == null) {
                this.objectives = new ArrayList<SectorEntityToken>();
            }
            if (this.markets == null) {
                this.markets = new ArrayList<SectorEntityToken>();
            }
            if (this.finishedRaiding == null) {
                this.finishedRaiding = new ArrayList<SectorEntityToken>();
            }
            return this;
        }

        public boolean allGoalsAchieved(FGRaidAction action) {
            if (this.markets.isEmpty()) {
                for (SectorEntityToken curr : this.objectives) {
                    if (curr.getFaction() == action.intel.getFaction()) continue;
                    return false;
                }
            }
            for (SectorEntityToken curr : this.markets) {
                if (action.raidCount.getCount(curr.getMarket()) >= action.params.raidsPerColony) continue;
                return false;
            }
            return true;
        }
    }
}

