/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGTravelAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGWaitAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RouteFleetAssignmentAI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public abstract class FleetGroupIntel
extends BaseIntelPlugin
implements RouteManager.RouteFleetSpawner {
    public static String ABORT_UPDATE = "abort_update";
    public static String FLEET_LAUNCH_UPDATE = "fleet_launch_update";
    public static final String KEY_SPAWN_FP = "$core_fgiSpawnFP";
    public static final String NEVER_STRAGGLER = "$core_fgiNeverStraggler";
    public static final String KEY_POTENTIAL_STRAGGLER = "$core_fgiMaybeStraggler";
    public static final String KEY_STRAGGLER_RETURN_COUNTDOWN = "$core_fgiStragglerReturnCountdown";
    public static boolean DEBUG = false;
    protected Random random = new Random();
    protected List<FGAction> actions = new ArrayList<FGAction>();
    protected RouteManager.RouteData route;
    protected RouteManager.RouteSegment prevSegment;
    protected List<CampaignFleetAPI> fleets = new ArrayList<CampaignFleetAPI>();
    protected boolean spawnedFleets = false;
    protected boolean doIncrementalSpawn = true;
    protected List<CampaignFleetAPI> spawning = new ArrayList<CampaignFleetAPI>();
    protected LocationAPI spawnLocation = null;
    protected float spawnDelay = 0.0f;
    protected float elapsed = 0.0f;
    protected boolean aborted = false;
    protected float totalFPSpawned = 0.0f;
    protected float fleetAbortsMissionFPFraction = 0.33f;
    protected float groupAbortsMissionFPFraction = 0.33f;
    protected SectorEntityToken returnLocation;
    protected FactionAPI faction;
    protected int approximateNumberOfFleets = 3;
    protected FGIEventListener listener;
    protected boolean sourceWasEverMilitaryMarket = false;
    protected boolean sendFleetLaunchUpdate = false;
    protected boolean failedButNotDefeated = false;

    public FleetGroupIntel() {
        Global.getSector().addScript(this);
    }

    protected Object readResolve() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this;
    }

    public float getETAUntil(String actionId) {
        return this.getETAUntil(actionId, false);
    }

    public float getETAUntil(String actionId, boolean untilEndOfAction) {
        float eta = this.getDelayRemaining();
        for (FGAction action : this.actions) {
            if (action.getId() != null && action.getId().equals(actionId)) {
                if (untilEndOfAction) {
                    eta += action.getEstimatedDaysToComplete();
                }
                return eta;
            }
            eta += action.getEstimatedDaysToComplete();
        }
        return 0.0f;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    protected boolean isSourceFunctionalMilitaryMarket() {
        if (this.getSource() == null) {
            return false;
        }
        MarketAPI market = this.getSource().getMarket();
        if (market == null || market.isPlanetConditionMarketOnly()) {
            return false;
        }
        if (market.hasCondition("decivilized")) {
            return false;
        }
        Industry b = market.getIndustry("militarybase");
        if (b == null) {
            b = market.getIndustry("highcommand");
        }
        return b != null && !b.isDisrupted() && b.isFunctional();
    }

    public boolean isInPreLaunchDelay() {
        return this.route != null && this.route.getElapsed() <= 0.0f && this.route.getDelay() > 0.0f;
    }

    public void setPreFleetDeploymentDelay(float delay) {
        if (this.route != null) {
            this.route.setDelay(delay);
        }
    }

    public float getDelayRemaining() {
        if (!this.isInPreLaunchDelay() || this.route == null) {
            return 0.0f;
        }
        return this.route.getDelay();
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(float elapsed) {
        this.elapsed = elapsed;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.elapsed += amount;
        if (this.isEnded() || this.isEnding() || this.isAborted()) {
            return;
        }
        if (this.route == null) {
            return;
        }
        if (this.isInPreLaunchDelay()) {
            this.sendFleetLaunchUpdate = true;
            boolean mil = this.isSourceFunctionalMilitaryMarket();
            this.sourceWasEverMilitaryMarket |= mil;
            if (!mil && this.sourceWasEverMilitaryMarket) {
                this.abort();
                return;
            }
            return;
        }
        if (this.sendFleetLaunchUpdate) {
            this.sendFleetLaunchUpdate = false;
            this.sendUpdateIfPlayerHasIntel((Object)FLEET_LAUNCH_UPDATE, !this.isPlayerTargeted());
        }
        if (!this.isSucceeded() && !this.isEnding() && !this.isAborted() && this.shouldAbort()) {
            this.abort();
            return;
        }
        if (!this.spawnedFleets) {
            if (!this.isSucceeded() && this.route.getExtra() != null && this.route.getExtra().damage != null && 1.0f - this.route.getExtra().damage.floatValue() < this.getGroupAbortsMissionFPFraction()) {
                this.abort();
                return;
            }
            RouteManager.RouteSegment curr = this.route.getCurrent();
            if ((curr != this.prevSegment || this.route.isExpired()) && this.prevSegment != null && this.prevSegment.custom instanceof FGAction) {
                FGAction action = (FGAction)this.prevSegment.custom;
                action.notifySegmentFinished(this.prevSegment);
                this.actions.remove(action);
                this.notifyActionFinished(action);
                if (this.route.isExpired()) {
                    this.finish(false);
                    return;
                }
            }
            this.prevSegment = curr;
        } else {
            this.handleIncrementalSpawning(amount);
            this.pruneDestroyedOrDamagedFleetsAndAbortIfNeeded();
            if (this.actions.isEmpty()) {
                this.finish(false);
                return;
            }
            FGAction action = this.actions.get(0);
            if (action.isActionFinished()) {
                this.actions.remove(0);
                this.notifyActionFinished(action);
                return;
            }
            action.directFleets(amount);
            if (action.isActionFinished()) {
                this.actions.remove(0);
                this.notifyActionFinished(action);
                return;
            }
        }
    }

    protected boolean shouldAbort() {
        return false;
    }

    protected boolean shouldSendIntelUpdateWhenActionFinished(FGAction action) {
        FGWaitAction wait;
        if (action instanceof FGWaitAction && (this.isAborted() || !this.isFailed())) {
            return false;
        }
        if (action instanceof FGWaitAction && (wait = (FGWaitAction)action).getOrigDurDays() <= 0.0f) {
            return false;
        }
        return action != null && action.getId() != null;
    }

    protected void notifyActionFinished(FGAction action) {
        if (action != null && this.shouldSendIntelUpdateWhenActionFinished(action)) {
            this.sendUpdateIfPlayerHasIntel((Object)action.getId(), !this.isPlayerTargeted());
        }
    }

    protected void pruneDestroyedOrDamagedFleetsAndAbortIfNeeded() {
        if (this.isSucceeded()) {
            ArrayList<CampaignFleetAPI> remove = new ArrayList<CampaignFleetAPI>();
            for (CampaignFleetAPI fleet : this.fleets) {
                if (fleet.isAlive()) continue;
                remove.add(fleet);
            }
            this.fleets.removeAll(remove);
            return;
        }
        this.checkStragglers();
        ArrayList<CampaignFleetAPI> remove = new ArrayList<CampaignFleetAPI>();
        float totalFP = 0.0f;
        for (CampaignFleetAPI fleet : this.fleets) {
            float spawnFP = fleet.getMemoryWithoutUpdate().getFloat(KEY_SPAWN_FP);
            if (!fleet.isAlive()) {
                remove.add(fleet);
                continue;
            }
            if ((float)fleet.getFleetPoints() <= spawnFP * this.getFleetAbortsMissionFPFraction()) {
                remove.add(fleet);
                this.giveReturnAssignments(fleet);
                continue;
            }
            totalFP += (float)fleet.getFleetPoints();
        }
        this.fleets.removeAll(remove);
        if (totalFP < this.totalFPSpawned * this.getGroupAbortsMissionFPFraction()) {
            this.abort();
            return;
        }
    }

    protected void checkStragglers() {
        ArrayList<CampaignFleetAPI> remove = new ArrayList<CampaignFleetAPI>();
        CountingMap<LocationAPI> fleetLocs = new CountingMap<LocationAPI>();
        for (CampaignFleetAPI fleet : this.fleets) {
            fleetLocs.add(fleet.getContainingLocation());
        }
        LocationAPI withMostFleets = null;
        int maxCount = 0;
        for (LocationAPI loc : fleetLocs.keySet()) {
            int count = fleetLocs.getCount(loc);
            if (count <= maxCount) continue;
            withMostFleets = loc;
            maxCount = count;
        }
        if (withMostFleets == null) {
            return;
        }
        Vector2f com = new Vector2f();
        float weight = 0.0f;
        for (CampaignFleetAPI fleet : this.fleets) {
            if (fleet.getContainingLocation() != withMostFleets) continue;
            float w = fleet.getFleetPoints();
            Vector2f loc = new Vector2f((ReadableVector2f)fleet.getLocation());
            loc.scale(w);
            Vector2f.add((Vector2f)com, (Vector2f)loc, (Vector2f)com);
            weight += w;
        }
        if (weight < 1.0f) {
            weight = 1.0f;
        }
        com.scale(1.0f / weight);
        FGAction action = this.getCurrentAction();
        boolean canBeStragglers = action != null && (action instanceof FGTravelAction || action instanceof FGWaitAction);
        int maybeStragglers = 0;
        for (CampaignFleetAPI fleet : this.fleets) {
            MemoryAPI mem;
            boolean potentialStraggler;
            boolean bl = potentialStraggler = fleet.getContainingLocation() != withMostFleets;
            if (!potentialStraggler) {
                potentialStraggler |= Misc.getDistance(fleet.getLocation(), com) > 4000.0f;
            }
            if (fleet.getMemoryWithoutUpdate().getBoolean(NEVER_STRAGGLER) || !canBeStragglers) {
                potentialStraggler = false;
            }
            if ((mem = fleet.getMemoryWithoutUpdate()).contains(KEY_POTENTIAL_STRAGGLER)) {
                ++maybeStragglers;
            }
            if (!potentialStraggler && mem.contains(KEY_POTENTIAL_STRAGGLER)) {
                mem.unset(KEY_POTENTIAL_STRAGGLER);
                mem.unset(KEY_STRAGGLER_RETURN_COUNTDOWN);
                continue;
            }
            if (mem.contains(KEY_POTENTIAL_STRAGGLER) && !mem.contains(KEY_STRAGGLER_RETURN_COUNTDOWN)) {
                remove.add(fleet);
                this.giveReturnAssignments(fleet);
                continue;
            }
            if (!potentialStraggler || mem.contains(KEY_POTENTIAL_STRAGGLER)) continue;
            mem.set(KEY_POTENTIAL_STRAGGLER, true);
            mem.set(KEY_STRAGGLER_RETURN_COUNTDOWN, true, this.getPotentialStragglerCountdownDays());
        }
        this.fleets.removeAll(remove);
    }

    protected float getPotentialStragglerCountdownDays() {
        return 30.0f;
    }

    public boolean isFailedButNotDefeated() {
        return this.failedButNotDefeated;
    }

    public void setFailedButNotDefeated(boolean failedButNotDefeated) {
        this.failedButNotDefeated = failedButNotDefeated;
    }

    public void abort() {
        this.finish(true);
    }

    public void finish(boolean isAbort) {
        boolean wasEnding = this.isEnding();
        this.aborted = isAbort;
        this.endAfterDelay();
        if (!isAbort) {
            this.setFailedButNotDefeated(true);
        }
        if (this.spawnedFleets && !this.actions.isEmpty() && !this.actions.get(0).isActionFinished()) {
            this.actions.get(0).setActionFinished(true);
        }
        if (this.route != null) {
            this.route.expire();
            RouteManager.getInstance().removeRoute(this.route);
        }
        this.giveFleetsReturnAssignments();
        if (!wasEnding && isAbort) {
            this.sendUpdateIfPlayerHasIntel((Object)ABORT_UPDATE, !this.isPlayerTargeted());
            if (this.listener != null) {
                this.listener.reportFGIAborted(this);
            }
        }
    }

    public boolean isSpawning() {
        return this.spawning != null && !this.spawning.isEmpty();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    protected void giveFleetsReturnAssignments() {
        for (CampaignFleetAPI fleet : this.fleets) {
            this.giveReturnAssignments(fleet);
        }
    }

    protected void giveReturnAssignments(CampaignFleetAPI fleet) {
        fleet.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true);
        if (this.returnLocation != null) {
            Misc.giveStandardReturnAssignments(fleet, this.returnLocation, null, true);
        } else {
            Misc.giveStandardReturnToSourceAssignments(fleet, true);
        }
    }

    protected void createRoute(String factionId, int approximateTotalDifficultyPoints, int approximateNumberOfFleets, Object custom) {
        this.createRoute(factionId, approximateTotalDifficultyPoints, approximateNumberOfFleets, custom, null);
    }

    protected void createRoute(String factionId, int approximateTotalDifficultyPoints, int approximateNumberOfFleets, Object custom, GenericRaidFGI.GenericRaidParams params) {
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData();
        extra.strength = Float.valueOf(FleetGroupIntel.getApproximateStrengthForTotalDifficultyPoints(factionId, approximateTotalDifficultyPoints));
        extra.factionId = this.faction.getId();
        if (params != null && params.source != null) {
            extra.quality = Float.valueOf(Misc.getShipQuality(params.source, extra.factionId));
        }
        this.route = RouteManager.getInstance().addRoute("FGI_" + this.getClass().getSimpleName(), null, Misc.genRandomSeed(), extra, this, custom);
        for (FGAction action : this.actions) {
            int before = this.route.getSegments().size();
            action.addRouteSegment(this.route);
            int after = this.route.getSegments().size();
            int i = before;
            while (i < after) {
                this.route.getSegments().get((int)i).custom = action;
                ++i;
            }
        }
        this.approximateNumberOfFleets = approximateNumberOfFleets;
    }

    public void setRoute(RouteManager.RouteData route) {
        this.route = route;
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        RouteManager.getInstance().removeRoute(route);
        if (this.isSpawnedFleets()) {
            return null;
        }
        if (this.isEnded() || this.isEnding()) {
            return null;
        }
        if (route == null || route.getCurrent() == null) {
            this.abort();
            return null;
        }
        RouteManager.RouteSegment curr = route.getCurrent();
        while (!this.actions.isEmpty()) {
            FGAction action = this.actions.get(0);
            if (action == curr.custom) break;
            this.actions.remove(0);
        }
        if (this.actions.isEmpty()) {
            this.abort();
            return null;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": about to spawn fleets");
        }
        this.spawnFleets();
        this.setSpawnedFleets(true);
        if (this.doIncrementalSpawn && route.getElapsed() < 0.1f) {
            this.spawning.addAll(this.fleets);
            this.fleets.clear();
            for (CampaignFleetAPI fleet : this.spawning) {
                if (this.spawnLocation == null) {
                    this.spawnLocation = fleet.getContainingLocation();
                }
                fleet.getContainingLocation().removeEntity(fleet);
            }
            this.handleIncrementalSpawning(0.1f);
        } else {
            for (CampaignFleetAPI fleet : this.fleets) {
                int fp = fleet.getFleetPoints();
                fleet.getMemoryWithoutUpdate().set(KEY_SPAWN_FP, fp);
                this.totalFPSpawned += (float)fp;
            }
        }
        this.actions.get(0).notifyFleetsSpawnedMidSegment(curr);
        return null;
    }

    public void setNeverStraggler(CampaignFleetAPI fleet) {
        if (fleet == null) {
            return;
        }
        fleet.getMemoryWithoutUpdate().set(NEVER_STRAGGLER, true);
    }

    public void handleIncrementalSpawning(float amount) {
        if (this.spawning == null || this.spawning.isEmpty() || this.spawnLocation == null) {
            return;
        }
        float days = Misc.getDays(amount);
        this.spawnDelay -= days;
        if (this.spawnDelay <= 0.0f) {
            this.spawnDelay = 0.25f + (float)Math.random() * 0.25f;
            CampaignFleetAPI fleet = this.spawning.remove(0);
            this.spawnLocation.addEntity(fleet);
            if (this.getSource() != null) {
                fleet.setLocation(this.getSource().getLocation().x, this.getSource().getLocation().y);
            }
            this.fleets.add(fleet);
            int fp = fleet.getFleetPoints();
            this.totalFPSpawned += (float)fp;
            if (this.spawning.isEmpty()) {
                this.spawning = null;
                this.spawnLocation = null;
            }
        }
    }

    public boolean isDoIncrementalSpawn() {
        return this.doIncrementalSpawn;
    }

    public void setDoIncrementalSpawn(boolean doIncrementalSpawn) {
        this.doIncrementalSpawn = doIncrementalSpawn;
    }

    public float getTotalFPSpawned() {
        return this.totalFPSpawned;
    }

    public void setTotalFPSpawned(float totalFPSpawned) {
        this.totalFPSpawned = totalFPSpawned;
    }

    public void setSpawnedFleets(boolean spawnedFleets) {
        this.spawnedFleets = spawnedFleets;
    }

    public RouteManager.RouteSegment getSegmentForAction(FGAction action) {
        for (RouteManager.RouteSegment seg : this.getRoute().getSegments()) {
            if (seg.custom != action) continue;
            return seg;
        }
        return null;
    }

    public void removeAction(String id) {
        FGAction action = this.getAction(id);
        if (action != null) {
            this.actions.remove(action);
        }
    }

    public FGAction getAction(String id) {
        for (FGAction curr : this.actions) {
            if (curr.getId() == null || !curr.getId().equals(id)) continue;
            return curr;
        }
        return null;
    }

    public boolean isCurrent(String id) {
        FGAction action = this.getAction(id);
        return action != null && action == this.getCurrentAction();
    }

    public FGAction getCurrentAction() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(0);
    }

    public boolean isSpawnedFleets() {
        return this.spawnedFleets;
    }

    public int getApproximateNumberOfFleets() {
        return this.approximateNumberOfFleets;
    }

    public void setApproximateNumberOfFleets(int approximateNumberOfFleets) {
        this.approximateNumberOfFleets = approximateNumberOfFleets;
    }

    public List<CampaignFleetAPI> getFleets() {
        return this.fleets;
    }

    public static RouteFleetAssignmentAI.TravelState getTravelState(RouteManager.RouteSegment segment) {
        if (segment.isInSystem()) {
            return RouteFleetAssignmentAI.TravelState.IN_SYSTEM;
        }
        if (segment.hasLeaveSystemPhase() && segment.getLeaveProgress() < 1.0f) {
            return RouteFleetAssignmentAI.TravelState.LEAVING_SYSTEM;
        }
        if (segment.hasEnterSystemPhase() && segment.getEnterProgress() > 0.0f) {
            return RouteFleetAssignmentAI.TravelState.ENTERING_SYSTEM;
        }
        return RouteFleetAssignmentAI.TravelState.IN_HYPER_TRANSIT;
    }

    public static LocationAPI getLocation(RouteManager.RouteSegment segment) {
        return FleetGroupIntel.getLocationForState(segment, FleetGroupIntel.getTravelState(segment));
    }

    public static LocationAPI getLocationForState(RouteManager.RouteSegment segment, RouteFleetAssignmentAI.TravelState state) {
        switch (state) {
            case ENTERING_SYSTEM: {
                if (segment.to != null) {
                    return segment.to.getContainingLocation();
                }
                return segment.from.getContainingLocation();
            }
            case IN_HYPER_TRANSIT: {
                return Global.getSector().getHyperspace();
            }
            case IN_SYSTEM: {
                return segment.from.getContainingLocation();
            }
            case LEAVING_SYSTEM: {
                return segment.from.getContainingLocation();
            }
        }
        return null;
    }

    public static void setLocationAndCoordinates(CampaignFleetAPI fleet, RouteManager.RouteSegment current) {
        RouteFleetAssignmentAI.TravelState state = FleetGroupIntel.getTravelState(current);
        if (state == RouteFleetAssignmentAI.TravelState.LEAVING_SYSTEM) {
            float p = current.getLeaveProgress();
            SectorEntityToken jp = RouteLocationCalculator.findJumpPointToUse(fleet, current.from);
            if (jp == null) {
                jp = current.from;
            }
            RouteLocationCalculator.setLocation(fleet, p, current.from, jp);
        } else if (state == RouteFleetAssignmentAI.TravelState.ENTERING_SYSTEM) {
            float p = current.getEnterProgress();
            SectorEntityToken jp = RouteLocationCalculator.findJumpPointToUse(fleet, current.to);
            if (jp == null) {
                jp = current.to;
            }
            RouteLocationCalculator.setLocation(fleet, p, jp, current.to);
        } else if (state == RouteFleetAssignmentAI.TravelState.IN_SYSTEM) {
            float p = current.getTransitProgress();
            RouteLocationCalculator.setLocation(fleet, p, current.from, current.to);
        } else if (state == RouteFleetAssignmentAI.TravelState.IN_HYPER_TRANSIT) {
            float p = current.getTransitProgress();
            SectorEntityToken t1 = Global.getSector().getHyperspace().createToken(current.from.getLocationInHyperspace().x, current.from.getLocationInHyperspace().y);
            SectorEntityToken t2 = Global.getSector().getHyperspace().createToken(current.to.getLocationInHyperspace().x, current.to.getLocationInHyperspace().y);
            RouteLocationCalculator.setLocation(fleet, p, t1, t2);
        }
    }

    public List<FGAction> getActions() {
        return this.actions;
    }

    public void addAction(FGAction action, String id) {
        action.setId(id);
        this.addAction(action);
    }

    public void addAction(FGAction action) {
        action.setIntel(this);
        this.actions.add(action);
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    public SectorEntityToken getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(SectorEntityToken returnLocation) {
        this.returnLocation = returnLocation;
    }

    public float getFleetAbortsMissionFPFraction() {
        return this.fleetAbortsMissionFPFraction;
    }

    public void setFleetAbortsMissionFPFraction(float fleetAbortsMissionFPFraction) {
        this.fleetAbortsMissionFPFraction = fleetAbortsMissionFPFraction;
    }

    public float getGroupAbortsMissionFPFraction() {
        return this.groupAbortsMissionFPFraction;
    }

    public void setGroupAbortsMissionFPFraction(float groupAbortsMissionFPFraction) {
        this.groupAbortsMissionFPFraction = groupAbortsMissionFPFraction;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    public void setFaction(String factionId) {
        this.faction = Global.getSector().getFaction(factionId);
    }

    public void setFaction(FactionAPI faction) {
        this.faction = faction;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public RouteManager.RouteData getRoute() {
        return this.route;
    }

    public static float getApproximateStrengthForTotalDifficultyPoints(String factionId, int points) {
        FactionAPI faction;
        float mult = 50.0f;
        if (factionId != null && (faction = Global.getSector().getFaction(factionId)).getCustomBoolean("pirateBehavior")) {
            mult = 35.0f;
        }
        return (float)points * mult;
    }

    public static void computeSampleFleetStrengths() {
        String factionId = null;
        factionId = "luddic_church";
        factionId = "luddic_path";
        factionId = "tritachyon";
        factionId = "sindrian_diktat";
        factionId = "remnant";
        factionId = "pirates";
        factionId = "persean";
        factionId = "hegemony";
        factionId = "independent";
        System.out.println("---------------------------------");
        System.out.println("FACTION: " + factionId);
        System.out.println("Difficulty\tStd\tQuality\tQuantity");
        int j = 0;
        while (j < 1) {
            int i = 1;
            while (i <= 10) {
                Vector2f loc = new Vector2f();
                float strStandard = 0.0f;
                float strQuality = 0.0f;
                float strQuantity = 0.0f;
                FleetCreatorMission m = new FleetCreatorMission(new Random());
                m.beginFleet();
                m.createStandardFleet(i, factionId, loc);
                CampaignFleetAPI fleet = m.createFleet();
                if (fleet != null) {
                    strStandard = fleet.getEffectiveStrength();
                }
                m = new FleetCreatorMission(new Random());
                m.beginFleet();
                m.createQualityFleet(i, factionId, loc);
                fleet = m.createFleet();
                if (fleet != null) {
                    strQuality = fleet.getEffectiveStrength();
                }
                m = new FleetCreatorMission(new Random());
                m.beginFleet();
                m.createQuantityFleet(i, factionId, loc);
                fleet = m.createFleet();
                if (fleet != null) {
                    strQuantity = fleet.getEffectiveStrength();
                }
                System.out.println(i + "\t\t" + (int)strStandard + "\t" + (int)strQuality + "\t" + (int)strQuantity);
                ++i;
            }
            System.out.println("---------------------------------");
            ++j;
        }
    }

    protected abstract boolean isPlayerTargeted();

    protected abstract void spawnFleets();

    protected abstract SectorEntityToken getSource();

    protected abstract SectorEntityToken getDestination();

    protected abstract String getBaseName();

    protected abstract void addNonUpdateBulletPoints(TooltipMakerAPI var1, Color var2, Object var3, IntelInfoPlugin.ListInfoMode var4, float var5);

    protected abstract void addUpdateBulletPoints(TooltipMakerAPI var1, Color var2, Object var3, IntelInfoPlugin.ListInfoMode var4, float var5);

    protected void addStatusSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        StarSystemAPI system;
        Set<String> tags = super.getIntelTags(map);
        tags.add("Military");
        if (Misc.isHyperspaceAnchor(this.getDestination()) && (system = Misc.getStarSystemForAnchor(this.getDestination())) != null && !Misc.getMarketsInLocation(system, "player").isEmpty()) {
            tags.add("Colony threats");
        }
        if (this.getDestination() != null && this.getDestination().getContainingLocation() != null && !Misc.getMarketsInLocation(this.getDestination().getContainingLocation(), "player").isEmpty()) {
            tags.add("Colony threats");
        }
        tags.add(this.getFaction().getId());
        return tags;
    }

    @Override
    public String getSortString() {
        return "Fleet Group Movement";
    }

    public String getSuccessPostfix() {
        return " - Successful";
    }

    public String getFailurePostfix() {
        if (this.isInPreLaunchDelay()) {
            return " - Aborted";
        }
        if (this.isFailedButNotDefeated()) {
            return " - Failed";
        }
        return " - Defeated";
    }

    @Override
    public String getName() {
        String base = this.getBaseName();
        if (this.isSucceeded()) {
            return String.valueOf(base) + this.getSuccessPostfix();
        }
        if (this.isFailed() || this.isAborted()) {
            return String.valueOf(base) + this.getFailurePostfix();
        }
        return base;
    }

    public boolean isSucceeded() {
        return false;
    }

    public boolean isFailed() {
        return this.isAborted();
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.setParaFontDefault();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    @Override
    public String getIcon() {
        return this.getFaction().getCrest();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return super.getSortTier();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.getDestination();
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        SectorEntityToken src = this.getSource();
        SectorEntityToken dest = this.getDestination();
        if (src == null || dest == null || src.getContainingLocation() == dest.getContainingLocation()) {
            return null;
        }
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        IntelInfoPlugin.ArrowData arrow = new IntelInfoPlugin.ArrowData(src, dest);
        arrow.color = this.getFactionForUIColors().getBaseUIColor();
        arrow.width = 20.0f;
        result.add(arrow);
        return result;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        Object param = this.getListInfoParam();
        boolean bl = isUpdate = param != null;
        if (!isUpdate) {
            this.addNonUpdateBulletPoints(info, tc, param, mode, initPad);
        } else {
            this.addUpdateBulletPoints(info, tc, param, mode, initPad);
        }
        this.unindent(info);
    }

    protected void addFactionBulletPoint(TooltipMakerAPI info, Color tc, float initPad) {
        info.addPara("Faction: " + this.faction.getDisplayName(), initPad, tc, this.faction.getBaseUIColor(), this.faction.getDisplayName());
    }

    protected void addArrivedBulletPoint(String destName, Color destHL, TooltipMakerAPI info, Color tc, float initPad) {
        LabelAPI label = info.addPara("Arrived at " + destName, tc, initPad);
        if (destHL != null) {
            String hl = this.getNameWithNoType(destName);
            label.setHighlightColor(destHL);
            label.highlightLast(hl);
        }
    }

    public String getNameWithNoType(String systemName) {
        String hl = systemName;
        if (hl != null) {
            if (hl.endsWith(" system")) {
                hl = hl.replaceAll(" system", "");
            }
            if (hl.endsWith(" nebula")) {
                hl = hl.replaceAll(" nebula", "");
            }
            if (hl.endsWith(" star system")) {
                hl = hl.replaceAll(" star system", "");
            }
        }
        return hl;
    }

    protected void addETABulletPoints(String destName, Color destHL, boolean withDepartedText, float eta, ETAType type, TooltipMakerAPI info, Color tc, float initPad) {
        Color h = Misc.getHighlightColor();
        String hl = this.getNameWithNoType(destName);
        if (type == ETAType.DEPLOYMENT) {
            if ((int)eta <= 0) {
                info.addPara("Fleet deployment imminent", tc, initPad);
            } else {
                String days = (int)eta == 1 ? "day" : "days";
                info.addPara("Estimated %s " + days + " until fleet deployment", initPad, tc, h, "" + (int)eta);
            }
            return;
        }
        if (type == ETAType.DEPARTURE) {
            if ((int)eta <= 0) {
                info.addPara("Departure imminent", tc, initPad);
            } else {
                String days = (int)eta == 1 ? "day" : "days";
                info.addPara("Estimated %s " + days + " until departure", initPad, tc, h, "" + (int)eta);
            }
            return;
        }
        LabelAPI label = null;
        if (withDepartedText && eta <= 0.0f) {
            label = info.addPara("Operating in the " + destName, tc, initPad);
            if (destHL != null && label != null) {
                label.setHighlightColor(destHL);
                label.highlightLast(hl);
            }
        } else {
            String pre;
            if (withDepartedText) {
                pre = "Departed for ";
                if (type == ETAType.RETURNING) {
                    pre = "Returning to ";
                }
                label = info.addPara(String.valueOf(pre) + destName, tc, initPad);
                if (destHL != null && label != null) {
                    label.setHighlightColor(destHL);
                    label.setHighlight(hl);
                }
                initPad = 0.0f;
            }
            if ((int)eta > 0) {
                String days = (int)eta == 1 ? "day" : "days";
                String post = " until arrival";
                if (type == ETAType.RETURNING) {
                    post = " until return";
                }
                if (!withDepartedText) {
                    if (type == ETAType.RETURNING) {
                        post = String.valueOf(post) + " to " + destName;
                    } else if (type == ETAType.ARRIVING) {
                        post = String.valueOf(post) + " at " + destName;
                    }
                }
                label = info.addPara("Estimated %s " + days + post, initPad, tc, h, "" + (int)eta);
                if (!withDepartedText && destHL != null && label != null) {
                    label.setHighlightColors(h, destHL);
                    label.setHighlight("" + (int)eta, hl);
                }
            } else {
                pre = "Arrival at ";
                if (type == ETAType.RETURNING) {
                    pre = "Return to ";
                }
                label = info.addPara(String.valueOf(pre) + destName + " is imminent", tc, initPad);
                if (destHL != null && label != null) {
                    label.setHighlightColor(destHL);
                    label.highlightLast(hl);
                }
            }
        }
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        this.addBasicDescription(info, width, height, opad);
        this.addAssessmentSection(info, width, height, opad);
        this.addStatusSection(info, width, height, opad);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
    }

    protected void showMarketsInDanger(TooltipMakerAPI info, float opad, float width, StarSystemAPI system, List<MarketAPI> targets, String safeStr, String riskStr, String riskStrHighlight) {
        Color h = Misc.getHighlightColor();
        float raidStr = this.getRoute().getExtra().getStrengthModifiedByDamage();
        float defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), system, this.isPlayerTargeted());
        ArrayList<MarketAPI> safe = new ArrayList<MarketAPI>();
        ArrayList<MarketAPI> unsafe = new ArrayList<MarketAPI>();
        for (MarketAPI market : targets) {
            float defensiveStr = defenderStr + WarSimScript.getStationStrength(market.getFaction(), system, market.getPrimaryEntity());
            if (defensiveStr > raidStr * 1.25f) {
                safe.add(market);
                continue;
            }
            unsafe.add(market);
        }
        if (safe.size() == targets.size()) {
            info.addPara("However, all colonies " + safeStr + ", " + "owing to their orbital defenses.", opad);
        } else {
            info.addPara("The following colonies " + riskStr, opad, Misc.getNegativeHighlightColor(), riskStrHighlight);
            FactionAPI f = Global.getSector().getPlayerFaction();
            FleetGroupIntel.addMarketTable(info, f.getBaseUIColor(), f.getDarkUIColor(), f.getBrightUIColor(), unsafe, width, opad);
        }
    }

    public int getRelativeFGStrength(StarSystemAPI target) {
        float raidStr = this.getRoute().getExtra().getStrengthModifiedByDamage();
        float defenderStr = 0.0f;
        if (target != null) {
            defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), target, this.isPlayerTargeted());
        }
        if (raidStr < defenderStr * 0.75f) {
            return -1;
        }
        if (raidStr < defenderStr * 1.25f) {
            return 0;
        }
        return 1;
    }

    protected boolean addStrengthDesc(TooltipMakerAPI info, float opad, StarSystemAPI system, String forces, String outcomeFailure, String outcomeUncertain, String outcomeSuccess) {
        Color h = Misc.getHighlightColor();
        float raidStr = this.getRoute().getExtra().getStrengthModifiedByDamage();
        float defenderStr = 0.0f;
        if (system != null) {
            defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), system, this.isPlayerTargeted());
        }
        String strDesc = Misc.getStrengthDesc(raidStr);
        int numFleets = this.getApproximateNumberOfFleets();
        String fleets = "fleets";
        if (numFleets == 1) {
            fleets = "fleet";
        }
        String defenderDesc = "";
        String defenderHighlight = "";
        Color defenderHighlightColor = h;
        boolean potentialDanger = false;
        String outcome = null;
        if (raidStr < defenderStr * 0.75f) {
            defenderDesc = "The defending fleets are superior";
            defenderHighlightColor = Misc.getPositiveHighlightColor();
            defenderHighlight = "superior";
            outcome = outcomeFailure;
        } else if (raidStr < defenderStr * 1.25f) {
            defenderDesc = "The defending fleets are evenly matched";
            defenderHighlightColor = h;
            defenderHighlight = "evenly matched";
            outcome = outcomeUncertain;
            potentialDanger = true;
        } else {
            defenderDesc = "The defending fleets are outmatched";
            defenderHighlightColor = Misc.getNegativeHighlightColor();
            defenderHighlight = "outmatched";
            outcome = outcomeSuccess;
            potentialDanger = true;
        }
        defenderDesc = outcome != null ? String.valueOf(defenderDesc) + ", and " + outcome + "." : String.valueOf(defenderDesc) + ".";
        defenderDesc = " " + defenderDesc;
        if (system == null) {
            defenderDesc = "";
        }
        LabelAPI label = info.addPara("The " + forces + " are " + "projected to be %s and likely comprised of %s " + fleets + "." + defenderDesc, opad, h, strDesc, "" + numFleets);
        label.setHighlight(strDesc, "" + numFleets, defenderHighlight);
        label.setHighlightColors(h, h, defenderHighlightColor);
        return potentialDanger;
    }

    protected boolean addStrengthDesc(TooltipMakerAPI info, float opad, MarketAPI target, String forces, String outcomeFailure, String outcomeUncertain, String outcomeSuccess) {
        Color h = Misc.getHighlightColor();
        float raidStr = this.getRoute().getExtra().getStrengthModifiedByDamage();
        float defenderStr = 0.0f;
        StarSystemAPI system = target.getStarSystem();
        if (system != null) {
            defenderStr = WarSimScript.getEnemyStrength(this.getFaction(), system, this.isPlayerTargeted());
        }
        defenderStr += WarSimScript.getStationStrength(target.getFaction(), system, target.getPrimaryEntity());
        String strDesc = Misc.getStrengthDesc(raidStr);
        int numFleets = this.getApproximateNumberOfFleets();
        String fleets = "fleets";
        if (numFleets == 1) {
            fleets = "fleet";
        }
        String defenderDesc = "";
        String defenderHighlight = "";
        Color defenderHighlightColor = h;
        boolean potentialDanger = false;
        String outcome = null;
        if (raidStr < defenderStr * 0.75f) {
            defenderDesc = "The defending forces are superior";
            defenderHighlightColor = Misc.getPositiveHighlightColor();
            defenderHighlight = "superior";
            outcome = outcomeFailure;
        } else if (raidStr < defenderStr * 1.25f) {
            defenderDesc = "The defending forces are evenly matched";
            defenderHighlightColor = h;
            defenderHighlight = "evenly matched";
            outcome = outcomeUncertain;
            potentialDanger = true;
        } else {
            defenderDesc = "The defending forces are outmatched";
            defenderHighlightColor = Misc.getNegativeHighlightColor();
            defenderHighlight = "outmatched";
            outcome = outcomeSuccess;
            potentialDanger = true;
        }
        defenderDesc = outcome != null ? String.valueOf(defenderDesc) + ", and " + outcome + "." : String.valueOf(defenderDesc) + ".";
        defenderDesc = " " + defenderDesc;
        if (system == null) {
            defenderDesc = "";
        }
        LabelAPI label = info.addPara("The " + forces + " are " + "projected to be %s and likely comprised of %s " + fleets + "." + defenderDesc, opad, h, strDesc, "" + numFleets);
        label.setHighlight(strDesc, "" + numFleets, defenderHighlight);
        label.setHighlightColors(h, h, defenderHighlightColor);
        return potentialDanger;
    }

    public FGIEventListener getListener() {
        return this.listener;
    }

    public void setListener(FGIEventListener listener) {
        this.listener = listener;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return FleetGroupIntel.getSoundStandardUpdate();
        }
        return FleetGroupIntel.getSoundMajorPosting();
    }

    public static enum ETAType {
        ARRIVING,
        RETURNING,
        DEPARTURE,
        DEPLOYMENT;

    }

    public static interface FGIEventListener {
        public void reportFGIAborted(FleetGroupIntel var1);
    }
}

