/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.EstablishedPolityScript;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PerseanLeaguePunitiveExpedition
extends GenericRaidFGI {
    public static final String PLPE_FLEET = "$PLPE_fleet";
    public static String KEY = "$PLPE_ref";
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public static PerseanLeaguePunitiveExpedition get() {
        return (PerseanLeaguePunitiveExpedition)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public PerseanLeaguePunitiveExpedition(GenericRaidFGI.GenericRaidParams params) {
        super(params);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public String getNoun() {
        return "punitive expedition";
    }

    @Override
    public String getForcesNoun() {
        return super.getForcesNoun();
    }

    @Override
    public String getBaseName() {
        return String.valueOf(Misc.ucFirst(this.getFaction().getPersonNamePrefix())) + " " + "Punitive Expedition";
    }

    @Override
    protected CampaignFleetAPI createFleet(int size, float damage) {
        Random r = this.getRandom();
        Vector2f loc = this.origin.getLocationInHyperspace();
        FleetCreatorMission m = new FleetCreatorMission(r);
        m.setFleetTypeMedium("taskForce");
        m.beginFleet();
        m.createFleet(this.params.style, size, this.params.factionId, loc);
        if (size >= 8) {
            m.triggerSetFleetDoctrineOther(5, 0);
        }
        m.triggerSetFleetFlag(PLPE_FLEET);
        m.setFleetSource(this.params.source);
        this.setFleetCreatorQualityFromRoute(m);
        m.setFleetDamageTaken(damage);
        m.triggerSetWarFleet();
        m.triggerMakeLowRepImpact();
        m.triggerMakeAlwaysSpreadTOffHostility();
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    @Override
    public void abort() {
        if (!this.isAborted()) {
            PerseanLeagueMembership.setDefeatedPunEx(true);
            new EstablishedPolityScript();
            for (CampaignFleetAPI curr : this.getFleets()) {
                curr.getMemoryWithoutUpdate().unset(PLPE_FLEET);
            }
        }
        super.abort();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed() && this.isCurrent(PAYLOAD_ACTION)) {
            String reason = "PLPunEx";
            for (CampaignFleetAPI curr : this.getFleets()) {
                Misc.setFlagWithReason(curr.getMemoryWithoutUpdate(), "$cfai_makeHostile", reason, true, 1.0f);
            }
        }
    }
}

