/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class TTMercenaryAttack
extends GenericRaidFGI {
    public static final String TTMA_FLEET = "$TTMA_fleet";
    public static final String TTMA_COMMAND = "$TTMA_command";
    public static String KEY = "$TTMA_ref";
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected transient boolean merc = false;

    public static TTMercenaryAttack get() {
        return (TTMercenaryAttack)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public TTMercenaryAttack(GenericRaidFGI.GenericRaidParams params) {
        super(params);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public String getNoun() {
        return "mercenary attack";
    }

    @Override
    public String getForcesNoun() {
        return super.getForcesNoun();
    }

    @Override
    public String getBaseName() {
        return "Tri-Tachyon Mercenary Attack";
    }

    @Override
    protected String getFleetCreationFactionOverride(int size) {
        if (this.getRandom().nextFloat() < 0.5f || size == 10) {
            this.merc = true;
            return "mercenary";
        }
        this.merc = false;
        return "tritachyon";
    }

    @Override
    protected void configureFleet(int size, FleetCreatorMission m) {
        boolean lightDetachment;
        m.triggerSetFleetFlag(TTMA_FLEET);
        if (size == 10) {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_3);
            m.triggerSetFleetFlag(TTMA_COMMAND);
        } else if (this.getRandom().nextFloat() < 0.5f) {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_1);
        } else {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_2);
        }
        m.triggerMakeNonHostileToFaction("tritachyon");
        m.triggerMakeNonHostileToFaction("sindrian_diktat");
        m.triggerMakeNonHostileToFaction("pirates");
        if (this.merc) {
            m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
            m.triggerFleetAddCommanderSkill("tactical_drills", 1);
        } else {
            m.triggerFleetAddCommanderSkill("phase_corps", 1);
            m.triggerFleetAddCommanderSkill("flux_regulation", 1);
        }
        if (size == 10) {
            m.triggerFleetAddCommanderSkill("electronic_warfare", 1);
            m.triggerFleetAddCommanderSkill("support_doctrine", 1);
        }
        int tugs = 0;
        if (size == 10) {
            tugs = 2;
        } else if (this.merc) {
            tugs = this.getRandom().nextInt(3);
        }
        boolean bl = lightDetachment = size <= 5;
        if (lightDetachment) {
            m.triggerSetFleetMaxShipSize(3);
        }
        m.triggerFleetMakeFaster(true, tugs, true);
    }

    @Override
    protected void configureFleet(int size, CampaignFleetAPI fleet) {
        boolean hasCombatCapital = false;
        boolean hasCivCapital = false;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.isCapital()) continue;
            hasCombatCapital |= !member.isCivilian();
            hasCivCapital |= member.isCivilian();
        }
        if (size == 10) {
            fleet.setName("Tactistar Operations Command");
            fleet.getCommander().setRankId(Ranks.SPACE_ADMIRAL);
            this.setNeverStraggler(fleet);
        } else if (hasCombatCapital) {
            fleet.setName("Tactistar Assault Detachment");
            fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
        } else if (hasCivCapital) {
            fleet.setName("Tactistar Support Detachment");
            fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
        } else {
            fleet.setName("Tactistar Light Detachment");
            fleet.getCommander().setRankId(Ranks.SPACE_COMMANDER);
        }
    }

    @Override
    public void abort() {
        if (!this.isAborted()) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                curr.getMemoryWithoutUpdate().unset(TTMA_FLEET);
            }
        }
        super.abort();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed() && this.isCurrent(PAYLOAD_ACTION)) {
            String reason = "TTMA";
            for (CampaignFleetAPI curr : this.getFleets()) {
                Misc.setFlagWithReason(curr.getMemoryWithoutUpdate(), "$cfai_makeHostile", reason, true, 1.0f);
            }
        }
    }

    @Override
    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        boolean reversible;
        TTMercenaryAttack attack = TTMercenaryAttack.get();
        StarSystemAPI target = TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem();
        boolean bl = reversible = attack != null && !attack.isSpawning() && !attack.isFailed() && !attack.isSucceeded() && !attack.isAborted() && !attack.isEnding() && !attack.isEnded() && target != null;
        if (reversible) {
            info.addPara("Mercenary companies are notoriously flexible in their allegiances.", opad, Misc.getHighlightColor(), "notoriously flexible");
        }
    }
}

