/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRMercenariesBribedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TriTachyonCommerceRaiding;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.TTMercenaryAttack;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class TTMercenaryReversedAttack
extends GenericRaidFGI {
    public static final String TTMAR_FLEET = "$TTMAR_fleet";
    public static final String TTMAR_COMMAND = "$TTMAR_command";
    public static String KEY = "$TTMAR_ref";
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public static TTMercenaryReversedAttack get() {
        return (TTMercenaryReversedAttack)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public static void sendReversedAttack(InteractionDialogAPI dialog) {
        TTMercenaryAttack attack = TTMercenaryAttack.get();
        if (attack == null || attack.isEnding()) {
            return;
        }
        Random random = new Random();
        StarSystemAPI target = TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem();
        if (target == null) {
            return;
        }
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(), false);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        SectorEntityToken origin = pf.getContainingLocation().createToken(pf.getLocation());
        MarketAPI fake = Global.getFactory().createMarket("fake", "an independent world", 5);
        fake.setFactionId("independent");
        fake.setPrimaryEntity(origin);
        origin.setMarket(fake);
        params.source = fake;
        params.prepDays = 0.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = target;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        LinkedHashSet<String> disrupt = new LinkedHashSet<String>();
        for (MarketAPI market : Misc.getMarketsInLocation(target, "tritachyon")) {
            params.raidParams.allowedTargets.add(market);
            params.raidParams.allowNonHostileTargets = true;
            for (Industry ind : market.getIndustries()) {
                if (ind.getSpec().hasTag("unraidable")) continue;
                disrupt.add(ind.getId());
            }
        }
        params.raidParams.disrupt.addAll(disrupt);
        params.raidParams.raidsPerColony = Math.min(disrupt.size(), 4);
        if (disrupt.isEmpty()) {
            params.raidParams.raidsPerColony = 2;
        }
        if (params.raidParams.allowedTargets.isEmpty()) {
            return;
        }
        params.factionId = "independent";
        TTMercenaryReversedAttack reverse = new TTMercenaryReversedAttack(params);
        reverse.setSpawnedFleets(true);
        reverse.setDoIncrementalSpawn(false);
        reverse.getFleets().addAll(attack.getFleets());
        reverse.setTotalFPSpawned(attack.getTotalFPSpawned());
        reverse.setApproximateNumberOfFleets(attack.getApproximateNumberOfFleets());
        reverse.getRoute().setExtra(attack.getRoute().getExtra());
        reverse.removeAction(GenericRaidFGI.RETURN_ACTION);
        attack.finish(false);
        attack.getFleets().clear();
        attack.endImmediately();
        String reasonTTMA = "TTMA";
        String reasonTTMAR = "TTMAR";
        for (CampaignFleetAPI fleet : reverse.getFleets()) {
            MemoryAPI mem = fleet.getMemoryWithoutUpdate();
            fleet.clearAssignments();
            mem.unset(Misc.FLEET_RETURNING_TO_DESPAWN);
            mem.set(TTMAR_FLEET, true);
            if (mem.getBoolean("$TTMA_command")) {
                mem.set(TTMAR_COMMAND, true);
            }
            mem.unset("$TTMA_command");
            mem.unset("$TTMA_fleet");
            Misc.makeNonHostileToFaction(fleet, "sindrian_diktat", false, -1.0f);
            Misc.makeNonHostileToFaction(fleet, "tritachyon", false, -1.0f);
            Misc.setFlagWithReason(mem, "$cfai_makeHostile", reasonTTMA, false, -1.0f);
            Misc.setFlagWithReason(mem, "$cfai_makeNonHostile", reasonTTMAR, true, -1.0f);
        }
        reverse.setImportant(true);
        Global.getSector().getIntelManager().addIntel(reverse, false, dialog.getTextPanel());
        TriTachyonCommerceRaiding.addFactorCreateIfNecessary(new TTCRMercenariesBribedFactor(), dialog);
    }

    public TTMercenaryReversedAttack(GenericRaidFGI.GenericRaidParams params) {
        super(params);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    public String getNoun() {
        return "mercenary attack";
    }

    @Override
    public String getForcesNoun() {
        return super.getForcesNoun();
    }

    @Override
    public String getBaseName() {
        return "Mercenary Counter-raid";
    }

    @Override
    public void abort() {
        if (!this.isAborted()) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                curr.getMemoryWithoutUpdate().unset(TTMAR_FLEET);
            }
        }
        super.abort();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed() && this.isCurrent(PAYLOAD_ACTION)) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                Misc.makeHostileToFaction(curr, "tritachyon", 1.0f);
            }
        }
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.remove("Colony threats");
        return tags;
    }
}

