/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.CampaignObjective;
import com.fs.starfarer.api.impl.campaign.CommRelayEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class CommSnifferIntel
extends BaseIntelPlugin {
    public static final String UNINSTALL = "uninstall";
    protected SectorEntityToken relay;
    protected IntervalUtil check = new IntervalUtil(15.0f, 45.0f);
    protected Boolean uninstalled = null;

    public static CommSnifferIntel getExistingSnifferIntelForRelay(SectorEntityToken relay) {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
            CommSnifferIntel intel = (CommSnifferIntel)p;
            if (intel.getRelay() != relay) continue;
            return intel;
        }
        return null;
    }

    public CommSnifferIntel(SectorEntityToken relay) {
        this.relay = relay;
        Global.getSector().getIntelManager().addIntel(this, true);
        Global.getSector().addScript(this);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
        CustomCampaignEntityPlugin plugin = this.relay.getCustomPlugin();
        if (plugin instanceof CampaignObjective) {
            CampaignObjective o = (CampaignObjective)((Object)plugin);
            o.setHacked(false);
        }
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        float days = Misc.getDays(amount);
        this.check.advance(days);
        if (this.check.intervalElapsed()) {
            float p = this.getCurrLoseProb();
            if ((float)Math.random() < p) {
                this.endAfterDelay();
                this.sendUpdateIfPlayerHasIntel(new Object(), false);
                return;
            }
        }
        if (!this.relay.isAlive() || !((CommRelayEntityPlugin)this.relay.getCustomPlugin()).isHacked().booleanValue()) {
            this.endAfterDelay();
            this.sendUpdateIfPlayerHasIntel(new Object(), false);
            return;
        }
    }

    public SectorEntityToken getRelay() {
        return this.relay;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    protected float getMax() {
        return Global.getSettings().getInt("maxCommSniffersBeforeChanceToLose");
    }

    protected float getBaseLoseProb() {
        return Global.getSettings().getFloat("probToLoseSnifferPerMonthPerExtra");
    }

    protected float getCurrLoseProb() {
        float curr = 0.0f;
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
            CommSnifferIntel intel = (CommSnifferIntel)p;
            if (intel.isEnding()) continue;
            curr += 1.0f;
        }
        float max = this.getMax();
        if (curr <= max) {
            return 0.0f;
        }
        float p = (curr - max) * this.getBaseLoseProb();
        if (p > 1.0f) {
            p = 1.0f;
        }
        return p;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(Global.getSector().getPlayerFaction().getLogo(), width, 128.0f, opad);
        String name = this.relay.getName();
        if (name.equals(this.relay.getCustomEntitySpec().getDefaultName())) {
            name = name.toLowerCase();
        }
        if (this.isEnding()) {
            if (this.uninstalled != null) {
                info.addPara("You've uninstalled the comm sniffer at " + name + ".", opad);
            } else {
                info.addPara("The comm sniffer installed at " + name + " is no longer responding to status queries.", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        } else {
            info.addPara("You have installed a comm sniffer at " + name + ".", opad);
            if (!this.relay.isInHyperspace()) {
                info.addPara("It is providing you with up-to-date local intel for the " + this.relay.getContainingLocation().getNameWithLowercaseType() + ".", opad);
            }
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            float p = this.getCurrLoseProb();
            String danger = null;
            Color dangerColor = null;
            if (!(p <= 0.0f)) {
                if (p <= 0.33f) {
                    danger = "low";
                    dangerColor = Misc.getPositiveHighlightColor();
                } else if (p <= 0.67f) {
                    danger = "medium";
                    dangerColor = h;
                } else {
                    danger = "high";
                    dangerColor = Misc.getNegativeHighlightColor();
                }
            }
            int num = 0;
            for (IntelInfoPlugin i : Global.getSector().getIntelManager().getIntel(CommSnifferIntel.class)) {
                CommSnifferIntel intel = (CommSnifferIntel)i;
                if (intel.isEnding()) continue;
                ++num;
            }
            String sniffers = "sniffers";
            String any = "any of them";
            if (num == 1) {
                sniffers = "sniffer";
                any = "it";
            }
            if (danger == null) {
                info.addPara("You have %s comm " + sniffers + " installed in the comm network. " + "There is no danger of " + any + " being detected and cleared out.", opad, h, "" + num);
            } else {
                LabelAPI label = info.addPara("You have %s comm " + sniffers + " installed in the comm network. The probability " + "of " + any + " being detected and cleared out is %s.", opad, h, "" + num, danger);
                label.setHighlight("" + num, danger);
                label.setHighlightColors(h, dangerColor);
            }
            ButtonAPI button = this.addGenericButton(info, width, "Uninstall comm sniffer", UNINSTALL);
            button.setShortcut(22, true);
        }
    }

    public void uninstall() {
        this.buttonPressConfirmed(UNINSTALL, null);
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == UNINSTALL) {
            this.endImmediately();
            this.uninstalled = true;
            if (ui != null) {
                ui.recreateIntelUI();
            }
        }
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        prompt.addPara("Uninstalling this comm sniffer will reduce the chance that the remaining comm sniffers are detected.", 0.0f);
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        return true;
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "comm_sniffer");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Comm sniffers");
        return tags;
    }

    @Override
    public String getSortString() {
        return "Comm Sniffer";
    }

    @Override
    public String getName() {
        String base = "Comm Sniffer";
        if (this.isEnding()) {
            if (this.uninstalled != null) {
                return String.valueOf(base) + " - Uninstalled";
            }
            return String.valueOf(base) + " - Lost";
        }
        if (this.isNew()) {
            return String.valueOf(base) + " Installed";
        }
        return base;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.relay;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return this.isEnded();
    }

    @Override
    public String getCommMessageSound() {
        return CommSnifferIntel.getSoundMinorMessage();
    }
}

