/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class MapMarkerIntel
extends FleetLogIntel {
    public static String BUTTON_EDIT = "button_edit";
    protected SectorEntityToken entity;
    protected SectorEntityToken copy;
    protected String title;
    protected String text;
    private boolean withDesc;
    private boolean withDeleteButton = true;
    private boolean withTimestamp = true;
    protected transient String discoveredPrefixOverride = null;

    public MapMarkerIntel() {
    }

    public MapMarkerIntel(SectorEntityToken entity, String title, String text, String icon, boolean withDesc) {
        this.init(entity, title, text, icon, withDesc);
    }

    protected void init(SectorEntityToken entity, String title, String text, String icon, boolean withDesc) {
        this.init(entity, title, text, icon, withDesc, null);
    }

    protected void init(SectorEntityToken entity, String title, String text, String icon, boolean withDesc, TextPanelAPI textPanel) {
        DebrisFieldTerrainPlugin debris;
        CampaignTerrainAPI terrain;
        this.entity = entity;
        this.withDesc = withDesc;
        if (entity instanceof CampaignTerrainAPI && (terrain = (CampaignTerrainAPI)entity).getPlugin() instanceof DebrisFieldTerrainPlugin && (debris = (DebrisFieldTerrainPlugin)terrain.getPlugin()).isScavenged()) {
            this.setKeepExploredDebrisField(true);
        }
        if (entity instanceof CampaignFleetAPI && !((CampaignFleetAPI)entity).isStationMode()) {
            this.copy = MapMarkerIntel.makeDoubleWithSameOrbit(entity);
            this.copy.getContainingLocation().addEntity(this.copy);
            this.setRemoveTrigger(this.copy);
        } else {
            this.setRemoveTrigger(this.entity);
        }
        this.title = title;
        this.text = text;
        this.setIcon(icon);
        this.setListInfoParam(DISCOVERED_PARAM);
        Global.getSector().getIntelManager().addIntel(this, false, textPanel);
        this.setListInfoParam(null);
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
        if (this.copy != null && this.copy.getContainingLocation() != null) {
            this.copy.getContainingLocation().removeEntity(this.copy);
        }
    }

    public static SectorEntityToken makeDoubleWithSameOrbit(SectorEntityToken entity) {
        SectorEntityToken copy = entity.getContainingLocation().createToken(entity.getLocation().x, entity.getLocation().y);
        if (entity.getOrbit() != null) {
            copy.setOrbit(entity.getOrbit().makeCopy());
        }
        return copy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public void setEntity(SectorEntityToken entity) {
        this.entity = entity;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isWithDesc() {
        return this.withDesc;
    }

    public void setWithDesc(boolean withDesc) {
        this.withDesc = withDesc;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        boolean isUpdate = this.getListInfoParam() != null;
        this.bullet(info);
        if (this.text != null && !this.text.isEmpty()) {
            String str = this.text;
            if (this.endsInPunct(str, true)) {
                str = str.substring(0, str.length() - 1);
            }
            info.addPara(str, tc, initPad);
            initPad = 0.0f;
        }
        this.addExtraBulletPoints(info, tc, initPad, mode);
        this.unindent(info);
    }

    protected void addExtraBulletPoints(TooltipMakerAPI info, Color tc, float initPad, IntelInfoPlugin.ListInfoMode mode) {
    }

    protected boolean endsInPunct(String str, boolean forBulletPoint) {
        String punct = ",.?!:;";
        if (forBulletPoint) {
            punct = ",.:;";
        }
        String end = "" + str.charAt(str.length() - 1);
        return punct.contains(end);
    }

    protected boolean withTextInDesc() {
        return true;
    }

    protected boolean withCustomVisual() {
        return false;
    }

    protected boolean withCustomDescription() {
        return false;
    }

    protected void addCustomVisual(TooltipMakerAPI info, float width, float height) {
    }

    protected void addCustomDescription(TooltipMakerAPI info, float width, float height) {
    }

    protected void addPostDescriptionSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    public boolean isWithDeleteButton() {
        return this.withDeleteButton;
    }

    public void setWithDeleteButton(boolean withDeleteButton) {
        this.withDeleteButton = withDeleteButton;
    }

    public boolean isWithTimestamp() {
        return this.withTimestamp;
    }

    public void setWithTimestamp(boolean withTimestamp) {
        this.withTimestamp = withTimestamp;
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        boolean addedDesc = false;
        if (this.withDesc) {
            if (this.withCustomVisual()) {
                this.addCustomVisual(info, width, height);
            } else if (this.entity.getCustomInteractionDialogImageVisual() != null) {
                info.addImage(this.entity.getCustomInteractionDialogImageVisual().getSpriteName(), width, opad);
            }
            if (this.withCustomDescription()) {
                this.addCustomDescription(info, width, height);
                addedDesc = true;
            } else if (this.entity.getCustomDescriptionId() != null) {
                Description desc = Global.getSettings().getDescription(this.entity.getCustomDescriptionId(), Description.Type.CUSTOM);
                info.addPara(desc.getText1(), opad);
                addedDesc = true;
            }
        }
        if (this.text != null && !this.text.trim().isEmpty() && this.withTextInDesc()) {
            if (addedDesc) {
                this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
            } else {
                info.addPara(String.valueOf(this.text) + (this.endsInPunct(this.text, false) ? "" : "."), opad);
            }
        }
        this.addPostDescriptionSection(info, width, height, opad);
        if (this.isWithTimestamp()) {
            this.addLogTimestamp(info, tc, opad);
        }
        if (this.getClass() == MapMarkerIntel.class) {
            ButtonAPI button = info.addButton("Edit", BUTTON_EDIT, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
            button.setShortcut(20, true);
            if (this.isWithDeleteButton()) {
                info.addSpacer(-opad);
            }
        }
        if (this.isWithDeleteButton()) {
            this.addDeleteButton(info, width);
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_EDIT) {
            ui.showEditIntelMarkerDialog(this);
            return;
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        if (this.getClass() == MapMarkerIntel.class) {
            tags.add("Marker");
        }
        return tags;
    }

    @Override
    public String getSortString() {
        return super.getSortString();
    }

    public String getDiscoveredPrefixOverride() {
        return this.discoveredPrefixOverride;
    }

    public void setDiscoveredPrefixOverride(String discoveredPrefixOverride) {
        this.discoveredPrefixOverride = discoveredPrefixOverride;
    }

    @Override
    public String getName() {
        String prefix = "";
        if (this.getListInfoParam() == DISCOVERED_PARAM && this.getClass() != MapMarkerIntel.class) {
            prefix = "Discovered: ";
            if (this.discoveredPrefixOverride != null) {
                prefix = this.discoveredPrefixOverride;
            }
        }
        return String.valueOf(prefix) + this.title;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.copy != null) {
            return this.copy;
        }
        return this.entity;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return super.shouldRemoveIntel();
    }

    @Override
    public boolean isHidden() {
        return this.hidden != null;
    }
}

