/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.MapMarkerIntel;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Set;

public class RemnantNexusIntel
extends MapMarkerIntel {
    public RemnantNexusIntel(CampaignFleetAPI entity) {
        String title = entity.getNameWithFactionKeepCase();
        String text = null;
        this.setSound("ui_discovered_entity");
        this.setWithDeleteButton(false);
        this.init(entity, title, text, null, true);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "remnant_nexus");
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.entity.getFaction();
    }

    public boolean isDamaged() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$damagedStation");
    }

    @Override
    protected boolean withTextInDesc() {
        return false;
    }

    @Override
    protected boolean withCustomVisual() {
        return true;
    }

    @Override
    protected boolean withCustomDescription() {
        return true;
    }

    @Override
    protected void addCustomVisual(TooltipMakerAPI info, float width, float height) {
        info.addImage(Global.getSector().getFaction("remnant").getLogo(), width, 10.0f);
    }

    @Override
    protected void addCustomDescription(TooltipMakerAPI info, float width, float height) {
        Description desc = Global.getSettings().getDescription("remnant_station2", Description.Type.SHIP);
        if (desc != null) {
            float opad = 10.0f;
            info.addPara(desc.getText1FirstPara(), opad);
            if (this.isDamaged()) {
                info.addPara("The station's long arc gapes with empty sockets where weapons platforms and citadels were once present. Despite the obvious damage, the station is armed and operational.", opad);
            }
        }
    }

    public static RemnantNexusIntel getNexusIntel(SectorEntityToken entity) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(RemnantNexusIntel.class)) {
            if (((RemnantNexusIntel)intel).getEntity() != entity) continue;
            return (RemnantNexusIntel)intel;
        }
        return null;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("remnant");
        if (!Misc.getMarketsInLocation(this.entity.getStarSystem(), "player").isEmpty()) {
            tags.add("Colony threats");
        }
        return tags;
    }
}

