/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;

public class RemoteSurveyDataForPlanetIntel
extends FleetLogIntel {
    protected PlanetAPI planet;
    protected String minClass;

    public RemoteSurveyDataForPlanetIntel(PlanetAPI planet) {
        this.planet = planet;
        this.setSound("ui_discovered_entity");
        this.setIconId("remote_survey_data");
        this.setRemoveTrigger(planet);
        this.setRemoveSurveyedPlanet(true);
        this.minClass = this.pickMinClass();
        this.setListInfoParam(DISCOVERED_PARAM);
        Global.getSector().getIntelManager().addIntel(this, false, null);
        this.setListInfoParam(null);
    }

    public String pickMinClass() {
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        String type = plugin.getSurveyDataType(this.planet);
        int typeNum = 0;
        if ("survey_data_1".equals(type)) {
            typeNum = 1;
        } else if ("survey_data_2".equals(type)) {
            typeNum = 2;
        } else if ("survey_data_3".equals(type)) {
            typeNum = 3;
        } else if ("survey_data_4".equals(type)) {
            typeNum = 4;
        } else if ("survey_data_5".equals(type)) {
            typeNum = 5;
        }
        Random random = Misc.getRandom(Misc.getSalvageSeed(this.planet, true), 0);
        if (random.nextBoolean()) {
            --typeNum;
        }
        if (typeNum < 1) {
            typeNum = 1;
        }
        switch (typeNum) {
            case 1: {
                return "Class I";
            }
            case 2: {
                return "Class II";
            }
            case 3: {
                return "Class III";
            }
            case 4: {
                return "Class IV";
            }
        }
        return "Class V";
    }

    @Override
    protected String getName() {
        String name = "Remote Survey: " + this.minClass + "+ " + this.planet.getTypeNameWithWorld();
        return name;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        initPad = 0.0f;
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        TooltipMakerAPI.PlanetInfoParams params = new TooltipMakerAPI.PlanetInfoParams();
        params.showConditions = true;
        params.showName = true;
        params.withClass = true;
        params.classStrOverride = String.valueOf(this.minClass) + "+";
        params.scaleEvenWhenShowingName = true;
        params.conditionsYOffset = 32.0f;
        params.showHazardRating = true;
        info.showPlanetInfo(this.planet, width, width / 1.62f, params, opad + params.conditionsYOffset);
        info.addPara("A remote survey has indicated that " + this.planet.getName() + " is " + this.minClass + " or higher " + "and is likely the most promising candidate " + "for a full survey operation in the " + this.planet.getStarSystem().getNameWithLowercaseTypeShort() + ".", opad + 18.0f, h, String.valueOf(this.minClass) + " or higher", "most promising candidate");
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.remove("Fleet log");
        tags.add("Exploration");
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.planet;
    }
}

