/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionSpecAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class SimUpdateIntel
extends FleetLogIntel {
    protected LinkedHashSet<String> addedFactions;
    protected LinkedHashSet<String> addedVariants;

    public SimUpdateIntel(LinkedHashSet<String> addedFactions, LinkedHashSet<String> addedVariants) {
        this.addedFactions = addedFactions;
        this.addedVariants = addedVariants;
        Global.getSector().getIntelManager().addIntel(this);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        this.bullet(info);
        if (!this.addedFactions.isEmpty()) {
            String factions = this.addedFactions.size() == 1 ? "faction" : "factions";
            info.addPara("%s new " + factions, initPad, tc, h, "" + this.addedFactions.size());
            initPad = 0.0f;
        }
        if (!this.addedVariants.isEmpty()) {
            String variants = this.addedVariants.size() == 1 ? "variant" : "variants";
            info.addPara("%s new hull " + variants, initPad, tc, h, "" + this.addedVariants.size());
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        if (!this.addedFactions.isEmpty()) {
            info.addSpacer(0.0f);
            info.addSectionHeading("Factions", Alignment.MID, opad);
            info.addPara("New simulator factions available. New factions are are made available by encountering their fleets, or deserters from the faction, in battle.", opad);
            float initPad = opad;
            for (String fid : this.addedFactions) {
                FactionSpecAPI spec = Global.getSettings().getFactionSpec(fid);
                TooltipMakerAPI para = info.beginImageWithText(spec.getCrest(), 32.0f);
                para.addPara(Misc.ucFirst(spec.getDisplayName()), spec.getBaseUIColor(), 0.0f);
                info.addImageWithText(initPad);
                initPad = 3.0f;
            }
        }
        if (!this.addedVariants.isEmpty()) {
            info.addSpacer(0.0f);
            float extra = 0.0f;
            if (!this.addedFactions.isEmpty()) {
                extra = 2.0f;
            }
            info.addSectionHeading("Ship variants", Alignment.MID, opad + extra);
            info.addPara("New simulator opponents available. New ships are made available by encountering and destroying them in battle.", opad);
            ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
            for (String vid : this.addedVariants) {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, vid);
                members.add(member);
            }
            int cols = 7;
            float iconSize = width / (float)cols;
            int rows = members.size() / cols;
            if (rows * cols < members.size()) {
                ++rows;
            }
            info.addShipList(cols, rows, iconSize, Misc.getBasePlayerColor(), members, opad);
        }
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "simulator_update");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        return tags;
    }

    @Override
    public String getName() {
        return "Simulator Update";
    }
}

