/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.punitive;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.command.WarSimScript;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.intel.raid.ActionStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class PEActionStage
extends ActionStage
implements BaseAssignmentAI.FleetActionDelegate {
    protected MarketAPI target;
    protected boolean playerTargeted = false;
    protected List<MilitaryResponseScript> scripts = new ArrayList<MilitaryResponseScript>();
    protected boolean gaveOrders = true;
    protected float untilAutoresolve = 30.0f;

    public PEActionStage(PunitiveExpeditionIntel raid, MarketAPI target) {
        super(raid);
        this.target = target;
        this.playerTargeted = target.isPlayerOwned();
        this.untilAutoresolve = 15.0f + 5.0f * (float)Math.random();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.untilAutoresolve -= days;
        if (DebugFlags.PUNITIVE_EXPEDITION_DEBUG || DebugFlags.FAST_RAIDS) {
            this.untilAutoresolve -= days * 100.0f;
        }
        if (!this.gaveOrders) {
            this.gaveOrders = true;
            this.removeMilScripts();
            float duration = 100.0f;
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "PE_" + Misc.genUID() + this.target.getId(), this.intel.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript script = new MilitaryResponseScript(params);
            this.target.getContainingLocation().addScript(script);
            this.scripts.add(script);
            MilitaryResponseScript.MilitaryResponseParams defParams = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "defPE_" + Misc.genUID() + this.target.getId(), this.target.getFaction(), this.target.getPrimaryEntity(), 1.0f, duration);
            MilitaryResponseScript defScript = new MilitaryResponseScript(defParams);
            this.target.getContainingLocation().addScript(defScript);
            this.scripts.add(defScript);
        }
    }

    protected void removeMilScripts() {
        if (this.scripts != null) {
            for (MilitaryResponseScript s : this.scripts) {
                s.forceDone();
            }
        }
    }

    @Override
    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
        if (this.status != RaidIntel.RaidStageStatus.ONGOING) {
            return;
        }
        boolean inSpawnRange = RouteManager.isPlayerInSpawnRange(this.target.getPrimaryEntity());
        if (!inSpawnRange && this.untilAutoresolve <= 0.0f) {
            this.autoresolve();
            return;
        }
        if (!this.target.isInEconomy() || !this.target.isPlayerOwned()) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            return;
        }
    }

    @Override
    public String getRaidActionText(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            return "bombarding " + market.getName();
        }
        return "raiding " + market.getName();
    }

    @Override
    public String getRaidApproachText(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            return "moving in to bombard " + market.getName();
        }
        return "moving in to raid " + market.getName();
    }

    @Override
    public void performRaid(CampaignFleetAPI fleet, MarketAPI market) {
        this.removeMilScripts();
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        PunitiveExpeditionManager.PunExGoal goal = intel.getGoal();
        this.status = RaidIntel.RaidStageStatus.SUCCESS;
        if (goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
            float cost = MarketCMD.getBombardmentCost(market, fleet);
            float maxCost = intel.getRaidFP() / intel.getNumFleets() * Misc.FP_TO_BOMBARD_COST_APPROX_MULT;
            if (fleet != null) {
                maxCost = fleet.getCargo().getMaxFuel() * 0.25f;
            }
            if (cost <= maxCost) {
                new MarketCMD(market.getPrimaryEntity()).doBombardment(intel.getFaction(), MarketCMD.BombardType.SATURATION);
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.SUCCESS);
            } else {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.BOMBARD_FAIL);
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyBombarded", intel.getFaction().getId(), true, 30.0f);
            }
        } else {
            float str = intel.getRaidFPAdjusted() / intel.getNumFleets() * Misc.FP_TO_GROUND_RAID_STR_APPROX_MULT;
            if (fleet != null) {
                str = MarketCMD.getRaidStr(fleet);
            }
            float durMult = Global.getSettings().getFloat("punitiveExpeditionDisruptDurationMult");
            boolean raidSuccess = new MarketCMD(market.getPrimaryEntity()).doIndustryRaid(intel.getFaction(), str, intel.targetIndustry, durMult);
            if (raidSuccess) {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.SUCCESS);
            } else {
                intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.RAID_FAIL);
                this.status = RaidIntel.RaidStageStatus.FAILURE;
                Misc.setFlagWithReason(market.getMemoryWithoutUpdate(), "$recentlyRaided", intel.getFaction().getId(), true, 30.0f);
                Misc.setRaidedTimestamp(market);
            }
        }
        if (intel.getOutcome() != null) {
            if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
                intel.sendOutcomeUpdate();
            } else {
                this.removeMilScripts();
                this.giveReturnOrdersToStragglers(this.getRoutes());
            }
        }
    }

    protected void autoresolve() {
        float str = WarSimScript.getFactionStrength(this.intel.getFaction(), this.target.getStarSystem());
        float enemyStr = WarSimScript.getFactionStrength(this.target.getFaction(), this.target.getStarSystem());
        float defensiveStr = enemyStr + WarSimScript.getStationStrength(this.target.getFaction(), this.target.getStarSystem(), this.target.getPrimaryEntity());
        if (defensiveStr >= str) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            this.removeMilScripts();
            this.giveReturnOrdersToStragglers(this.getRoutes());
            PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
            intel.setOutcome(PunitiveExpeditionIntel.PunExOutcome.TASK_FORCE_DEFEATED);
            return;
        }
        Industry station = Misc.getStationIndustry(this.target);
        if (station != null) {
            OrbitalStation.disrupt(station);
        }
        this.performRaid(null, this.target);
    }

    @Override
    protected void updateRoutes() {
        this.resetRoutes();
        this.gaveOrders = false;
        ((PunitiveExpeditionIntel)this.intel).sendEnteredSystemUpdate();
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            if (this.target.getStarSystem() != null) {
                route.addSegment(new RouteManager.RouteSegment(Math.min(5.0f, this.untilAutoresolve), this.target.getStarSystem().getCenter()));
            }
            route.addSegment(new RouteManager.RouteSegment(1000.0f, this.target.getPrimaryEntity()));
        }
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        block15: {
            float opad;
            block14: {
                int curr = this.intel.getCurrentStage();
                int index = this.intel.getStageIndex(this);
                Color h = Misc.getHighlightColor();
                Color g = Misc.getGrayColor();
                Color tc = Misc.getTextColor();
                float pad = 3.0f;
                opad = 10.0f;
                if (curr < index) {
                    return;
                }
                if (this.status == RaidIntel.RaidStageStatus.ONGOING && curr == index) {
                    info.addPara("The expedition forces are currently in-system.", opad);
                    return;
                }
                PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
                if (intel.getOutcome() == null) break block14;
                switch (intel.getOutcome()) {
                    case BOMBARD_FAIL: {
                        info.addPara("The ground defenses of " + this.target.getName() + " were sufficient to prevent bombardment.", opad);
                        break;
                    }
                    case RAID_FAIL: {
                        info.addPara("The raiding forces have been repelled by the ground defenses of " + this.target.getName() + ".", opad);
                        break;
                    }
                    case SUCCESS: {
                        if (intel.goal == PunitiveExpeditionManager.PunExGoal.BOMBARD) {
                            if (!this.target.isInEconomy()) {
                                info.addPara("The expeditionary force has successfully bombarded " + this.target.getName() + ", destroying the colony outright.", opad);
                                break;
                            }
                            info.addPara("The expeditionary force has successfully bombarded " + this.target.getName() + ".", opad);
                            break;
                        }
                        if (intel.getTargetIndustry() != null) {
                            info.addPara("The expeditionary force has disrupted " + intel.getTargetIndustry().getCurrentName() + " operations for %s days.", opad, h, "" + Math.round(intel.getTargetIndustry().getDisruptedDays()));
                            break;
                        }
                        break block15;
                    }
                    case TASK_FORCE_DEFEATED: {
                        info.addPara("The expeditionary force has been defeated by the defenders of " + this.target.getName() + ".", opad);
                        break;
                    }
                    case COLONY_NO_LONGER_EXISTS: {
                        info.addPara("The expedition has been aborted.", opad);
                    }
                }
                break block15;
            }
            if (this.status == RaidIntel.RaidStageStatus.SUCCESS) {
                info.addPara("The expeditionary force has succeeded.", opad);
            } else {
                info.addPara("The expeditionary force has failed.", opad);
            }
        }
    }

    @Override
    public boolean canRaid(CampaignFleetAPI fleet, MarketAPI market) {
        PunitiveExpeditionIntel intel = (PunitiveExpeditionIntel)this.intel;
        if (intel.getOutcome() != null) {
            return false;
        }
        return market == this.target;
    }

    @Override
    public String getRaidPrepText(CampaignFleetAPI fleet, SectorEntityToken from) {
        return "orbiting " + from.getName();
    }

    @Override
    public String getRaidInSystemText(CampaignFleetAPI fleet) {
        return "traveling";
    }

    @Override
    public String getRaidDefaultText(CampaignFleetAPI fleet) {
        return "traveling";
    }

    @Override
    public boolean isPlayerTargeted() {
        return this.playerTargeted;
    }
}

