/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class ANewHope
extends HubMissionWithSearch {
    protected PersonAPI robed_man;
    protected MarketAPI volturn;
    public static float MISSION_DAYS = 120.0f;
    protected int payment;
    protected int paymentHigh;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$anh_ref", "$anh_inProgress")) {
            return false;
        }
        this.setPersonOverride(null);
        this.robed_man = this.getImportantPerson(People.ROBEDMAN);
        if (this.robed_man == null) {
            return false;
        }
        this.volturn = Global.getSector().getEconomy().getMarket("volturn");
        if (this.volturn == null) {
            return false;
        }
        if (!this.volturn.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_VOLTURN);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.payment = 10000;
        this.paymentHigh = 17000;
        this.makeImportant(this.volturn, "$anh_tookTheJob", Stage.GO_TO_VOLTURN);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$anh_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginEnteredLocationTrigger(this.volturn.getStarSystem(), new Object[]{false, Stage.GO_TO_VOLTURN});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "sindrian_diktat", "patrolSmall", this.volturn.getStarSystem());
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsPlayer(this.volturn.getPlanetEntity(), 90.0f, ANewHope.getUnits(0.25f));
        this.triggerSpawnFleetAtPickedLocation("$anh_diktatPatrol", null);
        this.triggerSetFleetMissionRef("$ahn_ref");
        this.triggerOrderFleetInterceptPlayer();
        this.triggerFleetMakeImportant(null, Stage.GO_TO_VOLTURN);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$anh_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$anh_stage", this.getCurrentStage());
        this.set("$anh_payment", Misc.getWithDGS(this.payment));
        this.set("$anh_paymentHigh", Misc.getWithDGS(this.paymentHigh));
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        info.addImage(this.robed_man.getPortraitSprite(), width, 128.0f, opad);
        if (this.currentStage == Stage.GO_TO_VOLTURN) {
            info.addPara("Deliver the mysterious old man, the kid, and their robot to Volturn in the Askonia system. Avoid patrols; they may be wanted by the authorities.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_VOLTURN) {
            info.addPara("Go to Volturn in the Askonia system", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Passage To Volturn";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    public static enum Stage {
        GO_TO_VOLTURN,
        COMPLETED;

    }
}

