/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;

public class LuddicPilgrimTransport
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 60.0f;
    public static float MIN_VALUE = 10000.0f;
    public static float MAX_VALUE = 20000.0f;
    public static float PROB_RICH = 0.5f;
    protected MarketAPI source_market;
    protected StarSystemAPI destination_system;
    protected SectorEntityToken destination_entity;
    protected int quantity;
    protected String destination_shrine;
    protected Variation variation;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (!this.setGlobalReference("$lpt_ref", "$lpt_inProgress")) {
            return false;
        }
        this.source_market = createdAt;
        if (!(this.source_market.getId().equals("chicomoztoc") || this.source_market.getId().equals("mazalot") || this.source_market.getId().equals("ilm") || this.source_market.getId().equals("volturn") || this.source_market.getId().equals("jangala") || this.source_market.getId().equals("epiphany") || this.source_market.getId().equals("cibola") || this.source_market.getId().equals("madeira") || this.source_market.getId().equals("chalcedon") || this.source_market.getId().equals("tartessus") || this.source_market.getId().equals("hesperus") || this.source_market.getId().equals("fikenhild") || this.source_market.getId().equals("athulf") || this.source_market.getId().equals("suddene"))) {
            return false;
        }
        if (this.rollProbability(PROB_RICH)) {
            this.variation = Variation.RICH;
            float value = MIN_VALUE + this.getQuality() * (MAX_VALUE - MIN_VALUE);
            this.setCreditReward((int)((value *= 0.9f + this.genRandom.nextFloat() * 0.2f) * 0.5f), (int)(value * 0.7f));
        } else {
            this.variation = Variation.POOR;
        }
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(Ranks.POST_PILGRIM);
            this.setGiverImportance(PersonImportance.VERY_LOW);
            this.setGiverFaction("luddic_church");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$lpt_ref")) {
            return false;
        }
        this.setRepFactionChangesNone();
        this.setIconName("campaignMissions", "luddic_pilgrim_transport");
        this.destination_shrine = this.pickOne("gilead", "beholder_station");
        if (this.destination_shrine.equals("gilead")) {
            this.destination_system = Global.getSector().getStarSystem("canaan");
            this.destination_entity = Global.getSector().getEconomy().getMarket("gilead").getPlanetEntity();
            if (this.destination_entity == null) {
                return false;
            }
            if (!this.destination_entity.getMarket().getFactionId().equals("luddic_church")) {
                return false;
            }
        } else if (this.destination_shrine.equals("beholder_station")) {
            this.destination_system = Global.getSector().getStarSystem("kumari kandam");
            Iterator<SectorEntityToken> iterator = this.destination_system.getEntitiesWithTag("luddic_shrine").iterator();
            if (iterator.hasNext()) {
                SectorEntityToken beholder_station;
                this.destination_entity = beholder_station = iterator.next();
            }
        }
        if (!this.setEntityMissionRef(this.destination_entity, "$lpt_ref")) {
            return false;
        }
        this.makeImportant(this.destination_entity, "$lpt_target", Stage.TRANSPORT);
        this.setStartingStage((Object)Stage.TRANSPORT);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.destination_entity, "$lpt_completed");
        this.setNoAbandon();
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$lpt_barEvent", this.isBarEvent());
        this.set("$lpt_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$lpt_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$lpt_heOrShe", this.getPerson().getHeOrShe());
        this.set("$lpt_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$lpt_himOrHer", this.getPerson().getHimOrHer());
        this.set("$lpt_HeOrShe", String.valueOf(this.getPerson().getHeOrShe().substring(0, 1).toUpperCase()) + this.getPerson().getHeOrShe().substring(1));
        this.set("$lpt_HisOrHer", String.valueOf(this.getPerson().getHisOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHisOrHer().substring(1));
        this.set("$lpt_HimOrHer", String.valueOf(this.getPerson().getHimOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHimOrHer().substring(1));
        if (this.variation == Variation.POOR) {
            this.set("$lpt_wealth", "poor");
        } else {
            this.set("$lpt_wealth", "rich");
        }
        this.set("$lpt_personName", this.getPerson().getNameString());
        this.set("$lpt_systemName", this.destination_system.getNameWithLowercaseTypeShort());
        this.set("$lpt_entityName", this.destination_entity.getName());
        this.set("$lpt_sourceName", this.source_market.getName());
        this.set("$lpt_dist", this.getDistanceLY(this.destination_entity));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TRANSPORT) {
            info.addPara("Transport a small party of Luddic pilgrims to " + this.destination_entity.getName() + " in the " + this.destination_system.getNameWithLowercaseTypeShort() + ".", opad, h, Misc.getWithDGS(this.quantity));
            info.addPara("The pilgrims will expect to arrive at the shrine within " + MISSION_DAYS + " days.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TRANSPORT) {
            info.addPara("Transport a small party of Luddic pilgrims to " + this.destination_entity.getName() + " in the " + this.destination_system.getNameWithLowercaseTypeShort(), pad, tc, h, Misc.getWithDGS(this.quantity));
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Luddic Pilgrim Transport";
    }

    public static enum Stage {
        TRANSPORT,
        COMPLETED,
        FAILED;

    }

    public static enum Variation {
        RICH,
        POOR;

    }
}

