/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.PlayerFleetPersonnelTracker;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Voices;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class MercsOnTheRun
extends HubMissionWithBarEvent {
    public static float BASE_PRICE_MULT = 0.75f;
    protected FleetMemberAPI member;
    protected int price;
    protected int quantity;
    protected MarketAPI market;
    protected String commodity;
    protected int totalPrice;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverFaction("independent");
            this.setGiverPost(Ranks.POST_MARINE_SQUAD_LEADER);
            this.setGiverVoice(Voices.SPACER);
            this.setGiverImportance(this.pickLowImportance());
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        this.market = person.getMarket();
        if (this.market == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$motr_ref")) {
            return false;
        }
        this.commodity = "marines";
        this.quantity = 30 + this.genRandom.nextInt(21);
        float _price = this.market.getSupplyPrice(this.commodity, 1.0, true);
        float unitPrice = (int)(_price * BASE_PRICE_MULT);
        if (unitPrice > 50.0f) {
            unitPrice = unitPrice / 10.0f * 10.0f;
        }
        if (unitPrice < 1.0f && unitPrice > 0.0f) {
            unitPrice = 1.0f;
        }
        this.price = (int)(unitPrice * (float)this.quantity);
        this.setRepFactionChangesTiny();
        this.setRepPersonChangesVeryLow();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$motr_ref2", this);
        this.set("$motr_barEvent", this.isBarEvent());
        this.set("$motr_price", this.price);
        this.set("$motr_numberOfMarines", this.quantity);
        this.set("$motr_priceText", Misc.getWithDGS(this.price));
        this.set("$motr_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$motr_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$motr_member", this.member);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("buyMarines".equals(action)) {
            PlayerFleetPersonnelTracker.getInstance().update();
            PlayerFleetPersonnelTracker.getInstance().getMarineData().addXP(this.quantity);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Mercs On The Run";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.currentStage = new Object();
        this.abort();
        for (CampaignFleetAPI fleet : this.getPerson().getMarket().getContainingLocation().getFleets()) {
            if (fleet.getFaction().isPlayerFaction() || !Misc.isPatrol(fleet)) continue;
            fleet.getMemoryWithoutUpdate().set("$patrolExtraSuspicion", Float.valueOf(1.0f));
        }
    }
}

