/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class TacticallyBombardColony
extends HubMissionWithBarEvent
implements ColonyPlayerHostileActListener {
    public static float PROB_PATROL_ENCOUNTER_AFTER = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    protected MarketAPI market;

    protected void createBarGiver(MarketAPI createdAt) {
        String post;
        ArrayList<String> posts = new ArrayList<String>();
        posts.add(Ranks.POST_AGENT);
        if (createdAt.getSize() >= 6) {
            posts.add(Ranks.POST_ADMINISTRATOR);
        }
        if (Misc.isMilitary(createdAt)) {
            posts.add(Ranks.POST_BASE_COMMANDER);
        }
        if (Misc.hasOrbitalStation(createdAt)) {
            posts.add(Ranks.POST_STATION_COMMANDER);
        }
        if ((post = this.pickOne(posts)) == null) {
            return;
        }
        this.setGiverRank(this.pickOne(Ranks.GROUND_CAPTAIN, Ranks.GROUND_COLONEL, Ranks.GROUND_MAJOR, Ranks.SPACE_COMMANDER, Ranks.SPACE_CAPTAIN, Ranks.SPACE_ADMIRAL));
        this.setGiverTags("military");
        this.setGiverPost(post);
        this.setGiverImportance(this.pickHighImportance());
        this.findOrCreateGiver(createdAt, false, false);
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (barEvent) {
            this.createBarGiver(createdAt);
        }
        if (!Misc.isMilitary(createdAt)) {
            return false;
        }
        PersonAPI person = this.getPerson();
        if (person == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$tabo_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireMarketIsNot(createdAt);
        this.requireMarketFactionNotPlayer();
        this.requireMarketFactionHostileTo(createdAt.getFactionId());
        this.requireMarketTacticallyBombardable();
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        float q = this.getQuality();
        if (q <= 0.0f) {
            this.preferMarketSizeAtMost(4);
        } else if ((double)q <= 0.25) {
            this.preferMarketSizeAtMost(5);
        } else if ((double)q <= 0.5) {
            this.preferMarketSizeAtMost(6);
        } else if ((double)q <= 0.75) {
            this.preferMarketSizeAtMost(7);
        }
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$tabo_ref")) {
            return false;
        }
        this.makeImportant(this.market, "$tabo_target", Stage.BOMBARD);
        this.setStartingStage((Object)Stage.BOMBARD);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.market, "$tabo_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_NO_PENALTY});
        this.connectWithMarketDecivilized((Object)Stage.BOMBARD, (Object)Stage.FAILED_NO_PENALTY, this.market);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED_NO_PENALTY, createdAt);
        this.connectWithHostilitiesEnded((Object)Stage.BOMBARD, (Object)Stage.FAILED_NO_PENALTY, person, this.market);
        this.setStageOnHostilitiesEnded((Object)Stage.FAILED_NO_PENALTY, person, this.market);
        this.setCreditReward(BaseHubMission.CreditReward.VERY_HIGH, this.market.getSize());
        if (this.market.getSize() <= 4) {
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateSmallPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        } else if (this.market.getSize() <= 6) {
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateSmallPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        } else {
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
            this.triggerCreateSmallPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$tabo_barEvent", this.isBarEvent());
        this.set("$tabo_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$tabo_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$tabo_personName", this.getPerson().getNameString());
        this.set("$tabo_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$tabo_marketName", this.market.getName());
        this.set("$tabo_marketOnOrAt", this.market.getOnOrAt());
        this.set("$tabo_dist", this.getDistanceLY(this.market));
        int fuel = this.getBombardmentFuel(this.market);
        this.set("$tabo_fuel", Misc.getWithDGS(fuel));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOMBARD) {
            TacticallyBombardColony.addStandardMarketDesc("Perform a tactical bombardment of", this.market, info, opad);
            this.addBombardmentInfo(this.market, info, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOMBARD) {
            info.addPara("Tactically bombard " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Bombard " + this.market.getName();
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        if (this.market == market) {
            if ((!this.isEnded() || this.isEnding()) && this.rollProbability(PROB_PATROL_ENCOUNTER_AFTER)) {
                DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
                e.setDelayMedium();
                e.setLocationCoreOnly(true, market.getFactionId());
                e.beginCreate();
                e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, market.getFactionId(), "patrolLarge", new Vector2f());
                e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
                e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
                e.triggerSetPatrol();
                e.triggerSetStandardAggroInterceptFlags();
                e.triggerSetFleetMemoryValue("$tabo_marketName", market.getName());
                e.triggerSetFleetGenericHailPermanent("TABOPatrolHail");
                e.endCreate();
            }
            Global.getSector().getListenerManager().removeListener(this);
            market.getMemoryWithoutUpdate().set("$tabo_bombardedColony", true, 1.0f);
        }
    }

    public static enum Stage {
        BOMBARD,
        COMPLETED,
        FAILED,
        FAILED_NO_PENALTY;

    }
}

