/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GACelestialObject
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_HOLOARTS = 0.33f;
    public static float PROB_PATHERS = 0.5f;
    public static float PROB_SLIPUP = 0.33f;
    public static float PROB_PULSAR = 0.33f;
    public static float PROB_BLACK_HOLE = 0.5f;
    public static float PROB_NOT_ASTEROIDS = 0.5f;
    protected StarSystemAPI system;
    protected Variation variation;
    protected CampaignTerrainAPI object;
    protected boolean holoarts = false;
    protected boolean slipUp = false;
    protected int patherTithe = 0;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaCO_ref")) {
            return false;
        }
        this.pickDepartmentAllTags(GADepartments.SCIENCE, GADepartments.WEIRD);
        if (this.rollProbability(PROB_HOLOARTS)) {
            this.department = "Holoart Studies";
            this.holoarts = true;
        }
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core");
        this.requireTerrainType(ReqMode.ANY, "asteroid_belt", "asteroid_field", "debris_field", "magnetic_field", "nebula", "ring");
        if (this.rollProbability(PROB_NOT_ASTEROIDS)) {
            this.preferTerrainType(ReqMode.NOT_ANY, "asteroid_belt", "asteroid_field");
        }
        if (!this.holoarts) {
            if (this.rollProbability(PROB_PULSAR)) {
                this.preferSystemHasPulsar();
            } else if (this.rollProbability(PROB_BLACK_HOLE)) {
                this.preferSystemBlackHole();
            }
        } else {
            this.preferSystemNotPulsar();
            this.preferSystemNotBlackHole();
        }
        this.preferSystemUnexplored();
        this.preferTerrainInDirectionOfOtherMissions();
        this.object = this.pickTerrain();
        if (this.object == null) {
            return false;
        }
        this.system = this.object.getStarSystem();
        this.setStartingStage((Object)Stage.GO_TO_OBJECT);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        SectorEntityToken node = this.spawnMissionNode(new BaseHubMission.LocData(this.object));
        this.makeImportant(node, "$gaCO_object", Stage.GO_TO_OBJECT);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaCO_scanCompleted");
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaCO_gaveScannerToPathers");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.system, new Object[0]);
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        this.variation = this.system.hasPulsar() ? Variation.PULSAR : (this.system.hasBlackHole() ? Variation.BLACK_HOLE : Variation.BASIC);
        this.slipUp = this.rollProbability(PROB_SLIPUP);
        if (this.rollProbability(PROB_PATHERS)) {
            this.patherTithe = this.genRoundNumber(10000, 15000);
            this.beginWithinHyperspaceRangeTrigger(this.object, 1.0f, false, new Object[]{Stage.GO_TO_OBJECT});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_path", "patrolMedium", this.object);
            this.triggerFleetPatherNoDefaultTithe();
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerMakeAllFleetFlagsPermanent();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerPickLocationAroundEntity(node, 1000.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaCO_patherPermanentFlag", null);
            this.triggerFleetAllowLongPursuit();
            this.triggerOrderFleetPatrol(node);
            this.triggerSetFleetMemoryValue("$gaCO_patherTithe", Misc.getWithDGS(this.patherTithe));
            this.triggerFleetMakeImportant("$gaCO_patherMissionInProgress", Stage.GO_TO_OBJECT);
            this.endTrigger();
        }
        this.setMapMarkerNameColorBasedOnStar(this.system);
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaCO_department", this.department);
        this.set("$gaCO_holoarts", this.holoarts);
        this.set("$gaCO_slipUp", this.slipUp);
        this.set("$gaCO_objectAOrAn", GACelestialObject.getTerrainNameAOrAn(this.object));
        this.set("$gaCO_celestialObjectNameWithTypeShort", this.getObjectNameWithTypeShort());
        this.set("$gaCO_celestialObjectNameWithTypeLong", this.getObjectNameWithTypeLong());
        this.set("$gaCO_celestialObjectName", GACelestialObject.getTerrainName(this.object));
        this.set("$gaCO_celestialObjectType", GACelestialObject.getTerrainType(this.object));
        this.set("$gaCO_starName", this.system.getNameWithNoType());
        this.set("$gaCO_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$gaCO_dist", this.getDistanceLY(this.object));
        this.set("$gaCO_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaCO_variation", (Object)this.variation);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OBJECT) {
            String extra = "";
            if (this.variation == Variation.BLACK_HOLE) {
                extra = " Avoid the black hole located in-system.";
            } else if (this.variation == Variation.PULSAR) {
                extra = " Avoid the beam of the in-system pulsar.";
            }
            info.addPara("Run a scan package on " + this.getObjectNameWithTypeShort() + " located in the " + this.system.getNameWithLowercaseTypeShort() + "." + extra, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OBJECT) {
            info.addPara("Scan " + GACelestialObject.getTerrainTypeAOrAn(this.object) + " " + GACelestialObject.getTerrainType(this.object) + " in the " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    protected String getObjectNameWithTypeLong() {
        if (GACelestialObject.hasSpecialName(this.object)) {
            return String.valueOf(GACelestialObject.getTerrainName(this.object)) + " - that's " + GACelestialObject.getTerrainTypeAOrAn(this.object) + " " + GACelestialObject.getTerrainType(this.object);
        }
        return String.valueOf(GACelestialObject.getTerrainTypeAOrAn(this.object)) + " " + GACelestialObject.getTerrainType(this.object);
    }

    protected String getObjectNameWithTypeShort() {
        if (GACelestialObject.hasSpecialName(this.object)) {
            return String.valueOf(GACelestialObject.getTerrainName(this.object)) + ", " + GACelestialObject.getTerrainTypeAOrAn(this.object) + " " + GACelestialObject.getTerrainType(this.object);
        }
        return String.valueOf(GACelestialObject.getTerrainTypeAOrAn(this.object)) + " " + GACelestialObject.getTerrainType(this.object);
    }

    @Override
    public String getBaseName() {
        return "Scan Celestial Object";
    }

    public static enum Stage {
        GO_TO_OBJECT,
        COMPLETED,
        FAILED;

    }

    public static enum Variation {
        BASIC,
        PULSAR,
        BLACK_HOLE;

    }
}

