/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GAFCReplaceArchon;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class GAFindingCoureuse
extends GABaseMission {
    protected PersonAPI baird;
    protected PersonAPI arroyo;
    protected PersonAPI coureuse;
    protected PersonAPI siyavong;
    protected PersonAPI zal;
    protected PersonAPI laicailleArchon;
    protected PersonAPI kapteynAgent;
    protected SectorEntityToken groombridge;
    protected StarSystemAPI probeSystem;
    protected int bribeCost;
    protected int sellOutPrice;
    protected int kapteynBribeCost;
    protected int kapteynBarBribeCost;
    protected SectorEntityToken scavengerFleet;
    protected SectorEntityToken probeEmpty;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaFC_ref", "$gaFC_inProgress")) {
            return false;
        }
        this.setName("Finding Coureuse");
        MarketAPI laicaille = Global.getSector().getEconomy().getMarket("laicaille_habitat");
        MarketAPI kapteyn = Global.getSector().getEconomy().getMarket("station_kapteyn");
        MarketAPI fikenhild = Global.getSector().getEconomy().getMarket("fikenhild");
        if (laicaille == null || kapteyn == null || fikenhild == null) {
            return false;
        }
        this.baird = this.getImportantPerson(People.BAIRD);
        this.arroyo = this.getImportantPerson(People.ARROYO);
        this.coureuse = this.getImportantPerson(People.COUREUSE);
        this.siyavong = this.getImportantPerson(People.SIYAVONG);
        this.zal = this.getImportantPerson(People.ZAL);
        this.laicailleArchon = Global.getSector().getImportantPeople().getPerson(People.LAICAILLE_ARCHON);
        this.kapteynAgent = Global.getSector().getFaction("pirates").createRandomPerson(this.genRandom);
        this.kapteynAgent.setRankId(Ranks.CITIZEN);
        this.kapteynAgent.setPostId(Ranks.POST_SHADY);
        this.kapteynAgent.setImportance(PersonImportance.MEDIUM);
        this.kapteynAgent.addTag("underworld");
        kapteyn.getCommDirectory().addPerson(this.kapteynAgent);
        kapteyn.addPerson(this.kapteynAgent);
        if (this.baird == null || this.arroyo == null || this.coureuse == null || this.siyavong == null || this.laicailleArchon == null || this.kapteynAgent == null) {
            return false;
        }
        this.groombridge = Global.getSector().getEntityById("groombridge_habitat");
        if (this.groombridge == null) {
            return false;
        }
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_misc", "theme_misc_skip", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core", "system_already_used_for_story");
        this.requireSystemNotAlreadyUsedForStory();
        this.requireSystemNotHasPulsar();
        this.preferSystemOnFringeOfSector();
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.probeSystem = this.pickSystem();
        if (this.probeSystem == null) {
            return false;
        }
        SectorEntityToken probe1 = this.spawnEntity("generic_probe", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.probeSystem));
        SectorEntityToken probe2 = this.spawnEntity("generic_probe", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN_NOT_NEAR_STAR, null, this.probeSystem));
        SectorEntityToken probe3 = this.spawnEntity("generic_probe", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.UNCOMMON, null, this.probeSystem));
        if (probe1 == null || probe2 == null || probe3 == null) {
            return false;
        }
        probe1.setCustomDescriptionId("ga_hyperprobe");
        probe2.setCustomDescriptionId("ga_hyperprobe");
        probe3.setCustomDescriptionId("ga_hyperprobe");
        WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(this.genRandom);
        picker.add(probe1, 1.0f);
        picker.add(probe2, 1.0f);
        picker.add(probe3, 1.0f);
        this.probeEmpty = (SectorEntityToken)picker.pick();
        this.probeEmpty.addTag("empty");
        this.addProbeScavengerFleet();
        this.addPatherAmbushFleet();
        this.spawnTriTachMercFleet();
        this.bribeCost = this.genRoundNumber(15000, 25000);
        this.sellOutPrice = this.genRoundNumber(40000, 50000);
        this.kapteynBribeCost = this.genRoundNumber(30000, 40000);
        this.kapteynBarBribeCost = this.genRoundNumber(5000, 8000);
        this.setStoryMission();
        this.setStartingStage((Object)Stage.CHOOSE_PATH);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.makeImportant(fikenhild, "$gaFC_coureuseInvestigation", Stage.INVESTIGATE_FIKENHILD);
        this.makeImportant(probe1, "$gaFC_probe", Stage.FOLLOW_THE_EXPERIMENTS);
        this.makeImportant(probe2, "$gaFC_probe", Stage.FOLLOW_THE_EXPERIMENTS);
        this.makeImportant(probe3, "$gaFC_probe", Stage.FOLLOW_THE_EXPERIMENTS);
        probe1.getMemoryWithoutUpdate().set("$gaProbeGeneric", true);
        probe2.getMemoryWithoutUpdate().set("$gaProbeGeneric", true);
        probe3.getMemoryWithoutUpdate().set("$gaProbeGeneric", true);
        this.makeImportant(this.laicailleArchon, "$gaFC_clue", Stage.SEARCH_ISIRAH);
        this.makeImportant(this.laicailleArchon, "$gaFC_confront", Stage.CONFRONT_ARCHON);
        this.makeImportant(laicaille, "$gaFC_safehouse", Stage.VISIT_COUREUSE);
        this.makeImportant(this.baird.getMarket(), "$gaFC_returnHere", Stage.RETURN_TO_ACADEMY);
        this.setStageOnGlobalFlag((Object)Stage.INVESTIGATE_FIKENHILD, "$gaFC_pickedBranchFikenhild");
        this.setStageOnGlobalFlag((Object)Stage.FOLLOW_THE_EXPERIMENTS, "$gaFC_pickedBranchProbes");
        this.setStageOnGlobalFlag((Object)Stage.SEARCH_ISIRAH, "$gaFC_searchIsirah");
        this.setStageOnGlobalFlag((Object)Stage.CONFRONT_ARCHON, "$gaFC_confrontArchon");
        this.setStageOnGlobalFlag((Object)Stage.VISIT_COUREUSE, "$gaFC_visitCoureuse");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaFC_returnToAcademy");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaFC_completed");
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerUnhideCommListing(this.coureuse);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerHideCommListing(this.coureuse);
        this.endTrigger();
        float baseDelay = this.genDelay(14.0f);
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerRunScriptAfterDelay(this.genDelay(baseDelay), new GAFCReplaceArchon());
        this.triggerSetGlobalMemoryValue("$gaFC_missionCompleted", true);
        this.triggerMakeNonStoryCritical(this.coureuse.getMarket(), this.arroyo.getMarket(), this.siyavong.getMarket(), this.zal.getMarket(), this.laicailleArchon.getMarket(), this.kapteynAgent.getMarket());
        this.endTrigger();
        this.setSystemWasUsedForStory((Object)Stage.CHOOSE_PATH, this.probeSystem);
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("postFikenhildCleanup".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_triedToSeeCavin");
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_beingConspicuous");
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_triedToSeeCavin");
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_knowSiyavongContact");
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_knockedAnyway");
            Global.getSector().getMemoryWithoutUpdate().unset("$gaFC_madeSiyavongAngry");
            MarketAPI fikenhild = Global.getSector().getEconomy().getMarket("fikenhild");
            if (fikenhild != null) {
                fikenhild.getMemoryWithoutUpdate().unset("$visitedA");
                fikenhild.getMemoryWithoutUpdate().unset("$visitedB");
                fikenhild.getMemoryWithoutUpdate().unset("$visitedC");
            }
            return true;
        }
        if ("dropStolenProbe".equals(action)) {
            SectorEntityToken scavenger = this.getEntityFromGlobal("$gaFC_probeScavenger");
            CustomCampaignEntityAPI probe4 = this.probeSystem.addCustomEntity(null, "Ejected Cargo Pod", "cargo_pod_special", "neutral");
            probe4.setLocation(scavenger.getLocation().x, scavenger.getLocation().y);
            probe4.addTag("gaFC_lootedProbe");
            probe4.getMemoryWithoutUpdate().set("$gaProbeGeneric", true);
            Misc.makeImportant(probe4, this.getMissionId());
            this.makeUnimportant(scavenger);
            this.makeUnimportant(this.probeEmpty);
            return true;
        }
        if ("foundEmptyProbe".equals(action)) {
            SectorEntityToken scavenger = this.getEntityFromGlobal("$gaFC_probeScavenger");
            Misc.makeImportant(scavenger, this.getMissionId());
            return true;
        }
        if (dialog != null && action.equals("showKapteynBarAgent")) {
            this.showPersonInfo(this.kapteynAgent, dialog, false, false);
            return true;
        }
        if ("soldOutIsirahLead".equals(action)) {
            this.spawnTriTachInvestigators();
            this.spawnTriTachInvestigators();
            this.spawnTriTachInvestigators();
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaFC_stage", this.getCurrentStage());
        this.set("$gaFC_starName", this.probeSystem.getNameWithNoType());
        this.set("$gaFC_siyavong", this.siyavong);
        this.set("$gaFC_bribeCost", Misc.getWithDGS(this.bribeCost));
        this.set("$gaFC_kapteynBribeCost", Misc.getWithDGS(this.kapteynBribeCost));
        this.set("$gaFC_kapteynBarBribeCost", Misc.getWithDGS(this.kapteynBarBribeCost));
        this.set("$gaFC_sellOutPrice", Misc.getWithDGS(this.sellOutPrice));
        this.set("$gaFC_KBAheOrShe", this.kapteynAgent.getHeOrShe());
        this.set("$gaFC_KBAHeOrShe", String.valueOf(this.kapteynAgent.getHeOrShe().substring(0, 1).toUpperCase()) + this.kapteynAgent.getHeOrShe().substring(1));
        this.set("$gaFC_KBAhisOrHer", this.kapteynAgent.getHisOrHer());
        this.set("$gaFC_KBAHisOrHet", String.valueOf(this.kapteynAgent.getHisOrHer().substring(0, 1).toUpperCase()) + this.kapteynAgent.getHisOrHer().substring(1));
        this.set("$gaFC_KBAhimOrHer", this.kapteynAgent.getHimOrHer());
        this.set("$gaFC_KBAHimOrHet", String.valueOf(this.kapteynAgent.getHimOrHer().substring(0, 1).toUpperCase()) + this.kapteynAgent.getHimOrHer().substring(1));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        FactionAPI heg = Global.getSector().getFaction("hegemony");
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("You've found Academician Scylla Coureuse and brought her out of hiding to return her to work on Baird's secret project at the Galatia Academy.", opad);
        } else {
            info.addPara("Find Scylla Coureuse, a former academician of the Galatia Academy who went into hiding after the Hegemony crackdown on hyperspace experimentation.", opad, heg.getBaseUIColor(), "Hegemony");
        }
        if (this.currentStage == Stage.INVESTIGATE_FIKENHILD) {
            info.addPara("Talk to contacts on Fikenhild associated with Scylla Coureuse to find a lead to her current location - or attract the attention of someone who knows where she is.", opad);
        } else if (this.currentStage == Stage.FOLLOW_THE_EXPERIMENTS) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.probeSystem)) + " and search for the experimental packages possibly being used by Coureuse.", opad);
        } else if (this.currentStage == Stage.SEARCH_ISIRAH) {
            info.addPara("Search the Isirah system for Scylla Coureuse. Talk to people who might be involved in hiding her and search for signs of her research.", opad);
        } else if (this.currentStage == Stage.CONFRONT_ARCHON) {
            info.addPara("Confront the archon of Laicaille Habitat about hiding Scylla Coureuse on the station.", opad);
        } else if (this.currentStage == Stage.VISIT_COUREUSE) {
            info.addPara("Visit the safehouse of Scylla Coureuse and convince her to come back to the Galatia Academy.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and talk to Provost Baird.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.CHOOSE_PATH) {
            info.addPara("Find former academician Scylla Coureuse", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INVESTIGATE_FIKENHILD) {
            info.addPara("Talk to associates of Scylla Coureuse on Fikenhild to find a lead to her location or attract attention from someone who knows where she is", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.FOLLOW_THE_EXPERIMENTS) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.probeSystem)) + " and search for the experimental packages possibly being used by Coureuse", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.SEARCH_ISIRAH) {
            info.addPara("Search the Isirah system for Scylla Coureuse, talk to people who might be hiding her, and search for signs of her research.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.CONFRONT_ARCHON) {
            info.addPara("Confront the archon of Laicaille Habitat about hiding Scylla Coureuse on the station", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.VISIT_COUREUSE) {
            info.addPara("Go to the safehouse of Scylla Coureuse and convince her to return to the Galatia Academy", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and talk to Provost Baird", tc, pad);
        }
        return false;
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    protected void addProbeScavengerFleet() {
        this.beginWithinHyperspaceRangeTrigger(this.probeSystem, 3.0f, false, new Object[]{Stage.FOLLOW_THE_EXPERIMENTS});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.LOWER, "scavengers", "scavengerMedium", this.probeSystem);
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.FEWER, HubMissionWithTriggers.OfficerQuality.LOWER);
        this.triggerSetFleetFaction("independent");
        this.triggerMakeLowRepImpact();
        this.triggerFleetSetAvoidPlayerSlowly();
        this.triggerMakeFleetIgnoredByOtherFleets();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerPickLocationAtInSystemJumpPoint(this.probeSystem);
        this.triggerSetEntityToPickedJumpPoint();
        this.triggerPickLocationAroundEntity(1500.0f);
        this.triggerSpawnFleetAtPickedLocation("$gaFCProbe_scavengerPermanentFlag", null);
        this.triggerFleetSetTravelActionText("exploring system");
        this.triggerFleetSetPatrolActionText("searching for salvage");
        this.triggerOrderFleetPatrolEntity(false);
        this.triggerFleetAddDefeatTrigger("gaFCScavengerDefeated");
        this.triggerSaveGlobalFleetRef("$gaFC_probeScavenger");
        this.endTrigger();
    }

    protected void addPatherAmbushFleet() {
        this.beginGlobalFlagTrigger("$gaFC_triggerPatherAmbush", new Object[]{Stage.FOLLOW_THE_EXPERIMENTS});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.VERY_LOW, "luddic_path", "patrolSmall", this.probeSystem);
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerFleetPatherNoDefaultTithe();
        this.triggerPickLocationAtClosestToPlayerJumpPoint(this.probeSystem);
        this.triggerSetEntityToPickedJumpPoint();
        this.triggerFleetSetPatrolActionText("waiting");
        this.triggerPickLocationTowardsEntity(null, 15.0f, GAFindingCoureuse.getUnits(1.0f));
        this.triggerSpawnFleetAtPickedLocation("$gaFC_patherProbeAmbush", null);
        this.triggerSetFleetMissionRef("$gaFC_ref");
        this.triggerFleetMakeImportant(null, Stage.FOLLOW_THE_EXPERIMENTS);
        this.triggerOrderFleetInterceptPlayer();
        this.endTrigger();
    }

    protected void spawnTriTachMercFleet() {
        StarSystemAPI isirah = Global.getSector().getStarSystem("isirah");
        this.beginWithinHyperspaceRangeTrigger(isirah, 3.0f, true, new Object[]{Stage.SEARCH_ISIRAH});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "mercenary", "mercPrivateer", isirah);
        this.triggerSetFleetFaction("independent");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeNonHostile();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsPlayer(isirah.getHyperspaceAnchor(), 90.0f, GAFindingCoureuse.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaFC_isirahMerc", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerSetFleetMissionRef("$gaFC_ref");
        this.triggerFleetMakeImportant(null, Stage.SEARCH_ISIRAH);
        this.endTrigger();
    }

    protected void spawnTriTachInvestigators() {
        StarSystemAPI isirah = Global.getSector().getStarSystem("isirah");
        this.beginWithinHyperspaceRangeTrigger(isirah, 3.0f, false, new Object[]{Stage.SEARCH_ISIRAH});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "tritachyon", "mercBountyHunter", isirah);
        this.triggerSetFleetFaction("tritachyon");
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerFleetSetTravelActionText("traveling");
        this.triggerFleetSetPatrolActionText("searching system");
        this.triggerPickLocationTowardsPlayer(isirah.getHyperspaceAnchor(), 90.0f, GAFindingCoureuse.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaFC_isirahTriTach", null);
        this.triggerOrderFleetPatrol(isirah, true, "objective", "planet");
        this.triggerOrderFleetPatrol(new SectorEntityToken[0]);
        this.endTrigger();
    }

    public static enum Stage {
        CHOOSE_PATH,
        INVESTIGATE_FIKENHILD,
        FOLLOW_THE_EXPERIMENTS,
        SEARCH_ISIRAH,
        CONFRONT_ARCHON,
        VISIT_COUREUSE,
        RETURN_TO_ACADEMY,
        COMPLETED;

    }
}

