/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.askonia;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddShip;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class TheUsurpers
extends HubMissionWithSearch {
    public static float EXTACT_AGENT_RAID_DIFFICULTY = 200.0f;
    protected PersonAPI ram;
    protected PersonAPI hyder;
    protected PersonAPI caden;
    protected PersonAPI macario;
    protected PersonAPI patrolSecond;
    protected MarketAPI umbra;
    protected MarketAPI sindria;
    protected MarketAPI volturn;
    protected SectorEntityToken debris;
    protected int marineLosses;
    protected int marineLossesMin;
    protected int marineLossesMax;
    protected int xpRewardLow;
    protected int xpRewardMedium;
    protected int xpRewardHigh;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$sdtu_ref", "$sdtu_inProgress")) {
            return false;
        }
        this.setPersonOverride(null);
        this.ram = this.getImportantPerson(People.RAM);
        if (this.ram == null) {
            return false;
        }
        this.hyder = this.getImportantPerson(People.HYDER);
        if (this.hyder == null) {
            return false;
        }
        this.caden = this.getImportantPerson(People.CADEN);
        if (this.caden == null) {
            return false;
        }
        this.macario = this.getImportantPerson(People.MACARIO);
        if (this.macario == null) {
            return false;
        }
        this.umbra = this.getMarket("umbra");
        if (this.umbra == null) {
            return false;
        }
        if (!this.umbra.getFactionId().equals("pirates")) {
            return false;
        }
        this.volturn = this.getMarket("volturn");
        if (this.volturn == null) {
            return false;
        }
        if (!this.volturn.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.sindria = this.getMarket("sindria");
        if (this.sindria == null) {
            return false;
        }
        if (!this.sindria.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.MEET_RAM);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.marineLossesMax = 4;
        this.marineLossesMin = 1;
        this.marineLosses = this.marineLossesMin + this.genRandom.nextInt(this.marineLossesMax - this.marineLossesMin + 1);
        this.xpRewardLow = 2000;
        this.xpRewardMedium = 5000;
        this.xpRewardHigh = 12000;
        this.patrolSecond = Global.getSector().getFaction("sindrian_diktat").createRandomPerson(this.genRandom);
        this.patrolSecond.setRankId(Ranks.SPACE_LIEUTENANT);
        this.patrolSecond.setPostId(Ranks.POST_FLEET_COMMANDER);
        this.makeImportant(this.volturn, "$sdtu_meetRamOnVolturn", Stage.MEET_RAM);
        this.makeImportant(this.hyder, "$sdtu_meetHyder", Stage.MEET_HYDER);
        this.makeImportant(this.macario, "$sdtu_didHyderMeeting", Stage.RETURN_TO_MACARIO);
        this.makeImportant(this.umbra, "$sdtu_extractAgent", Stage.EXTRACT_AGENT);
        this.makeImportant(this.caden, "$sdtu_meetCaden", Stage.MEET_CADEN);
        this.makeImportant(this.macario, "$sdtu_didCadenMeeting", Stage.AGAIN_WTH_MACARIO);
        this.makeImportant(this.macario, "$sdtu_deliverNews", Stage.DELIVER_NEWS);
        this.connectWithGlobalFlag((Object)Stage.MEET_RAM, (Object)Stage.INTERCEPT_FLEET, "$sdtu_interceptFleet");
        this.connectWithGlobalFlag((Object)Stage.INTERCEPT_FLEET, (Object)Stage.MEET_HYDER, "$sdtu_meetHyder");
        this.connectWithGlobalFlag((Object)Stage.MEET_HYDER, (Object)Stage.RETURN_TO_MACARIO, "$sdtu_reportToMacario1");
        this.connectWithGlobalFlag((Object)Stage.RETURN_TO_MACARIO, (Object)Stage.EXTRACT_AGENT, "$sdtu_extractAgent");
        this.connectWithGlobalFlag((Object)Stage.EXTRACT_AGENT, (Object)Stage.MEET_CADEN, "$sdtu_meetCaden");
        this.connectWithGlobalFlag((Object)Stage.MEET_CADEN, (Object)Stage.AGAIN_WTH_MACARIO, "$sdtu_reportToMacario2");
        this.connectWithGlobalFlag((Object)Stage.AGAIN_WTH_MACARIO, (Object)Stage.EMERGENCY_INTERCEPT, "$sdtu_emergencyIntercept");
        this.connectWithGlobalFlag((Object)Stage.EMERGENCY_INTERCEPT, (Object)Stage.DELIVER_NEWS, "$sdtu_deliverNews");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$sdtu_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.INTERCEPT_FLEET});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "sindrian_diktat", "patrolMedium", this.sindria.getStarSystem());
        this.triggerMakeNonHostile();
        this.triggerMakeNoRepImpact();
        this.triggerMakeFleetIgnoredByOtherFleets();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerPickLocationAroundEntity(this.volturn.getPlanetEntity(), 800.0f);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.triggerFleetMakeImportant(null, Stage.INTERCEPT_FLEET);
        this.triggerFleetAddDefeatTrigger("sdtuPatrolDefeated");
        this.triggerSaveGlobalFleetRef("$sdtu_traitorPatrol");
        this.triggerSetPatrol();
        this.triggerOrderFleetPatrol(this.sindria.getStarSystem());
        this.triggerSpawnFleetAtPickedLocation("$sdtu_interceptFleet", null);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.EXTRACT_AGENT});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.umbra.getPlanetEntity());
        this.triggerFleetSetName("ARC Raider Flotilla");
        this.triggerSetFleetFaction("pirates");
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerSetStandardAggroPirateFlags();
        this.triggerPickLocationTowardsPlayer(this.umbra.getPlanetEntity(), 90.0f, TheUsurpers.getUnits(0.25f));
        this.triggerPickLocationAroundEntity(this.umbra.getPlanetEntity(), 200.0f);
        this.triggerSpawnFleetAtPickedLocation("$sdtu_antisFleet", null);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.MEET_CADEN});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGER, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolLarge", this.umbra.getPlanetEntity());
        this.triggerFleetSetName("ARC Raider Patrol");
        this.triggerSetFleetFaction("pirates");
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerSetStandardAggroPirateFlags();
        this.triggerPickLocationAroundEntity(this.umbra.getPlanetEntity(), 500.0f);
        this.triggerSpawnFleetAtPickedLocation("$sdtu_antisRevengeFleet", null);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$sdtu_missionCompleted", true);
        this.triggerMakeNonStoryCritical(this.volturn, this.umbra, this.sindria);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$sdtu_stage", this.getCurrentStage());
        this.set("$sdtu_extractAgentRaidDifficulty", Float.valueOf(EXTACT_AGENT_RAID_DIFFICULTY));
        this.set("$sdtu_marineLosses", this.marineLosses);
        this.set("$sdtu_patrolSecond", this.patrolSecond);
        this.set("$sdtu_xpRewardLow", this.xpRewardLow);
        this.set("$sdtu_xpRewardMedium", this.xpRewardMedium);
        this.set("$sdtu_xpRewardHigh", this.xpRewardHigh);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("spawnDebris".equals(action)) {
            StarSystemAPI system = this.sindria.getStarSystem();
            DebrisFieldTerrainPlugin.DebrisFieldParams p = new DebrisFieldTerrainPlugin.DebrisFieldParams(150.0f, -1.0f, 1.0E7f, 0.0f);
            p.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
            p.baseSalvageXP = 500L;
            this.debris = Misc.addDebrisField(system, p, StarSystemGenerator.random);
            SalvageSpecialAssigner.assignSpecialForDebrisField(this.debris);
            this.debris.getMemoryWithoutUpdate().set("$sdtuAgentDebris", true);
            List<SectorEntityToken> jumpPoints = system.getJumpPoints();
            this.debris.setCircularOrbit(jumpPoints.get(jumpPoints.size() - 1), 90.0f, 200.0f, 100.0f);
            Misc.makeImportant(this.debris, this.getMissionId());
            this.beginStageTrigger(new Object[]{Stage.EMERGENCY_INTERCEPT});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercPrivateer", system);
            this.triggerSetFleetFaction("independent");
            this.triggerFleetSetName("Mercenary Bounty Hunter");
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerMakeHostileAndAggressive();
            this.triggerMakeNoRepImpact();
            this.triggerPickLocationAroundEntity(this.debris, 500.0f);
            this.triggerSpawnFleetAtPickedLocation("$sdtu_merc", null);
            this.triggerOrderFleetPatrol(true, this.debris);
            this.endTrigger();
            return true;
        }
        if ("makeDerbisUnimportant".equals(action)) {
            if (this.debris != null) {
                Misc.makeUnimportant(this.debris, this.getMissionId());
            }
            return true;
        }
        if ("shootEm".equals(action)) {
            Global.getSoundPlayer().playSound("storyevent_diktat_execution", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("endMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
            Global.getSoundPlayer().pauseMusic();
            return true;
        }
        if ("playMusicMacario".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_market_hostile", true);
            return true;
        }
        if ("playMusicCaden".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_encounter_hostile", true);
            return true;
        }
        if ("playMusicHyder".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_encounter_friendly", true);
            return true;
        }
        if ("playMusicSons".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_market_friendly", true);
            return true;
        }
        if ("resumeMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(false);
            Global.getSoundPlayer().restartCurrentMusic();
            return true;
        }
        if ("giveKineticBlasters".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addWeapons("kineticblaster", 3);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "ship_weapons", cargo);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        if ("giveGigacannon".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addWeapons("gigacannon", 2);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "ship_weapons", cargo);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        if ("giveExecutor".equals(action)) {
            String variantId = "executor_Hull";
            ShipVariantAPI variant = Global.getSettings().getVariant(variantId).clone();
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
            Global.getSector().getPlayerFleet().getFleetData().addFleetMember(member);
            AddShip.addShipGainText(member, dialog.getTextPanel());
            return true;
        }
        if ("replacePatrolLeader".equals(action)) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
            fleet.setCommander(this.patrolSecond);
            fleet.getAI().addAssignmentAtStart(FleetAssignment.STANDING_DOWN, fleet, 0.5f + 0.5f * (float)Math.random(), null);
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            BattleAPI b = pf.getBattle();
            if (b != null) {
                b.leave(pf, false);
            }
            return true;
        }
        if ("tryMakeHyderImportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Askonia System Defense Armada")) continue;
                Misc.makeImportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeHyderUnimportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Askonia System Defense Armada")) continue;
                Misc.makeUnimportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeCadenImportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Lion's Guard Grand Armada")) continue;
                Misc.makeImportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeCadenUnimportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Lion's Guard Grand Armada")) continue;
                Misc.makeUnimportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("makeMercHostile".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getMemoryWithoutUpdate().contains("$sdtu_merc")) continue;
                fleet.getMemoryWithoutUpdate().set("$cfai_longPursuit", true);
                Misc.makeHostile(fleet);
                AbilityPlugin eb = fleet.getAbility("emergency_burn");
                if (eb == null || !eb.isUsable()) continue;
                eb.activate();
            }
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.MEET_RAM) {
            info.addPara("Meet Yannick Ram at his safehouse on Volturn. He has a plan to save the Sindrian Diktat from itself.", opad);
            TheUsurpers.addStandardMarketDesc("Ram gave you coordinates to his safehouse " + this.volturn.getOnOrAt(), this.volturn, info, opad);
        } else if (this.currentStage == Stage.INTERCEPT_FLEET) {
            info.addPara("Find and intercept a Sindrian Diktat patrol fleet led by the 'treasonous' officer. It can be found in the Askonia system.", opad);
        } else if (this.currentStage == Stage.MEET_HYDER) {
            info.addPara("Use the 'treasonous' officer as leverage to gain access to Deputy Star Marshal Hyder. She can be found in command of the Askonia System Defense Armada, a large warfleet patrolling the Askonia star system.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_MACARIO) {
            info.addPara("Report back to Macario about your conversation with Hyder.", opad);
            TheUsurpers.addStandardMarketDesc("Chief High Inspector-General Macario is based " + this.sindria.getOnOrAt(), this.sindria, info, opad);
        } else if (this.currentStage == Stage.EXTRACT_AGENT) {
            info.addPara("Extract a known double-agent who, while working for Horacio Caden, has betrayed the Sindrian Diktat.", opad);
            TheUsurpers.addStandardMarketDesc("The 'treasonous' double-agent is based " + this.umbra.getOnOrAt(), this.umbra, info, opad);
        } else if (this.currentStage == Stage.MEET_CADEN) {
            info.addPara("Use the 'treasonous' agent as leverage to gain access to Guard High Lieutenant-Executor Caden. He can be found in command of the Lion's Guard Grand Armada, a large warfleet patrolling the Askonia star system.", opad);
        } else if (this.currentStage == Stage.AGAIN_WTH_MACARIO) {
            info.addPara("Report back to Macario about your conversation with Caden.", opad);
            TheUsurpers.addStandardMarketDesc("Chief High Inspector-General Macario is based " + this.sindria.getOnOrAt(), this.sindria, info, opad);
        } else if (this.currentStage == Stage.EMERGENCY_INTERCEPT) {
            info.addPara("Intercept and assist or capture Macario's agent at the Fringe Jump-point of Askonia.", opad);
        } else if (this.currentStage == Stage.DELIVER_NEWS) {
            info.addPara("Report back to Macario with news of his agent's demise.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.MEET_RAM) {
            info.addPara("Meet Yannick Ram at his safehouse on Volturn.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INTERCEPT_FLEET) {
            info.addPara("Intercept the traitor's patrol fleet in the Askonia system.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.MEET_HYDER) {
            info.addPara("Speak with Oxana Hyder. She commands the Askonia System Defense Armada.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_MACARIO) {
            info.addPara("Talk to Macario, on Sindria, about Hyder.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.EXTRACT_AGENT) {
            info.addPara("Extract the double agent from Umbra.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.MEET_CADEN) {
            info.addPara("Speak with Horacio Caden. He commands the Lion's Guard Grand Armada.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.AGAIN_WTH_MACARIO) {
            info.addPara("Talk to Macario, on Sindria, about Caden.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.EMERGENCY_INTERCEPT) {
            info.addPara("Intercept Macario's agent at the given location.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.DELIVER_NEWS) {
            info.addPara("Return to Macario, on Sindria, with news of his agent's death.", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "The Usurpers";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    public static enum Stage {
        MEET_RAM,
        INTERCEPT_FLEET,
        MEET_HYDER,
        RETURN_TO_MACARIO,
        EXTRACT_AGENT,
        MEET_CADEN,
        AGAIN_WTH_MACARIO,
        EMERGENCY_INTERCEPT,
        DELIVER_NEWS,
        COMPLETED;

    }
}

