/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class BaseCustomBounty
extends HubMissionWithBarEvent
implements FleetEventListener {
    public static int NUM_TO_TRACK_FOR_DIFFICULTY = 3;
    protected PersonAPI target;
    protected CustomBountyCreator creator;
    protected CustomBountyCreator creatorLow;
    protected CustomBountyCreator creatorNormal;
    protected CustomBountyCreator creatorHigh;
    protected CustomBountyCreator.CustomBountyData data;
    protected CustomBountyCreator.CustomBountyData dataLow;
    protected CustomBountyCreator.CustomBountyData dataNormal;
    protected CustomBountyCreator.CustomBountyData dataHigh;
    protected transient Class creatorOverride;
    protected transient Integer difficultyOverride;
    protected transient CustomBountyCreator showCreator;
    protected transient CustomBountyCreator.CustomBountyData showData;

    public String getAggregateDataKey() {
        return "$" + this.getMissionId() + "_aggregateData";
    }

    public AggregateBountyData getAggregateData() {
        MemoryAPI memory = Global.getSector().getMemoryWithoutUpdate();
        AggregateBountyData data = (AggregateBountyData)memory.get(this.getAggregateDataKey());
        if (data == null) {
            data = new AggregateBountyData();
            memory.set(this.getAggregateDataKey(), data);
        }
        return data;
    }

    public List<CustomBountyCreator> getCreators() {
        return new ArrayList<CustomBountyCreator>();
    }

    protected int pickDifficulty(DifficultyChoice choice) {
        if (this.difficultyOverride != null) {
            return this.difficultyOverride;
        }
        AggregateBountyData d = this.getAggregateData();
        float total = 0.0f;
        float count = 0.0f;
        for (Integer diff : d.completedDifficulty) {
            total += (float)diff.intValue();
            count += 1.0f;
        }
        float difficulty = total;
        if (count > 0.0f) {
            difficulty /= Math.max(count, (float)NUM_TO_TRACK_FOR_DIFFICULTY);
            difficulty = (int)difficulty;
        }
        int min = 0;
        int max = 10;
        switch (choice) {
            case LOW: {
                min = 0;
                max -= 3;
                difficulty = Math.min(difficulty - 3.0f, (float)((int)(difficulty / 2.0f)));
                break;
            }
            case NORMAL: {
                ++min;
                --max;
                difficulty += 1.0f;
                break;
            }
            case HIGH: {
                min = 4;
                difficulty += 3.0f;
            }
        }
        int result = Math.round(difficulty);
        if (result < min) {
            result = min;
        }
        if (result > max) {
            result = max;
        }
        return result;
    }

    protected CustomBountyCreator pickCreator(int difficulty, DifficultyChoice choice) {
        if (this.creatorOverride != null) {
            try {
                return (CustomBountyCreator)this.creatorOverride.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        WeightedRandomPicker<CustomBountyCreator> picker = new WeightedRandomPicker<CustomBountyCreator>(this.genRandom);
        float quality = this.getQuality();
        float maxDiff = 10.0f;
        for (CustomBountyCreator curr : this.getCreators()) {
            float probToSkip;
            int threshold;
            if (curr.getMinDifficulty() > difficulty || curr.getMaxDifficulty() < difficulty || choice == DifficultyChoice.HIGH && difficulty >= (threshold = CBStats.getThresholdNotHigh(this.getClass())) || choice == DifficultyChoice.NORMAL && difficulty >= (threshold = CBStats.getThresholdNotNormal(this.getClass())) || this.rollProbability(probToSkip = (1.1f - quality) * (float)curr.getMinDifficulty() / maxDiff)) continue;
            picker.add(curr, curr.getFrequency(this, difficulty));
        }
        return (CustomBountyCreator)picker.pick();
    }

    protected void createBarGiver(MarketAPI createdAt) {
    }

    public void setTestMode(Class c, int difficulty) {
        this.genRandom = Misc.random;
        this.difficultyOverride = difficulty;
        this.creatorOverride = c;
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.createBarGiver(createdAt);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        String id = this.getMissionId();
        if (!this.setPersonMissionRef(person, "$" + id + "_ref")) {
            return false;
        }
        this.setStartingStage((Object)Stage.BOUNTY);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_NO_PENALTY});
        this.connectWithMemoryFlag((Object)Stage.BOUNTY, (Object)Stage.COMPLETED, person, "$" + id + "_completed");
        this.connectWithMemoryFlag((Object)Stage.BOUNTY, (Object)Stage.FAILED, person, "$" + id + "_failed");
        this.addTag("Bounties");
        int dLow = this.pickDifficulty(DifficultyChoice.LOW);
        this.creatorLow = this.pickCreator(dLow, DifficultyChoice.LOW);
        if (this.creatorLow != null) {
            this.dataLow = this.creatorLow.createBounty(createdAt, this, dLow, (Object)Stage.BOUNTY);
        }
        if (this.dataLow == null || this.dataLow.fleet == null) {
            return false;
        }
        int dNormal = this.pickDifficulty(DifficultyChoice.NORMAL);
        this.creatorNormal = this.pickCreator(dNormal, DifficultyChoice.NORMAL);
        if (this.creatorNormal != null) {
            this.dataNormal = this.creatorNormal.createBounty(createdAt, this, dNormal, (Object)Stage.BOUNTY);
        }
        if (this.dataNormal == null || this.dataNormal.fleet == null) {
            return false;
        }
        int dHigh = this.pickDifficulty(DifficultyChoice.HIGH);
        this.creatorHigh = this.pickCreator(dHigh, DifficultyChoice.HIGH);
        if (this.creatorHigh != null) {
            this.dataHigh = this.creatorHigh.createBounty(createdAt, this, dHigh, (Object)Stage.BOUNTY);
        }
        return this.dataHigh != null && this.dataHigh.fleet != null;
    }

    @Override
    protected void updateInteractionDataImpl() {
        String id = this.getMissionId();
        this.set("$" + id + "_barEvent", this.isBarEvent());
        this.set("$" + id + "_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$" + id + "_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$bcb_barEvent", this.isBarEvent());
        this.set("$bcb_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$bcb_reward", Misc.getWithDGS(this.getCreditsReward()));
        if (this.showData != null && this.showCreator != null) {
            this.showCreator.updateInteractionData(this, this.showData);
            this.set("$" + id + "_difficultyNum", this.showData.difficulty);
            this.set("$bcb_difficultyNum", this.showData.difficulty);
            if (this.showData.system != null) {
                this.set("$" + id + "_systemName", this.showData.system.getNameWithLowercaseType());
                this.set("$" + id + "_dist", this.getDistanceLY(this.showData.system.getCenter()));
                this.set("$bcb_systemName", this.showData.system.getNameWithLowercaseType());
                this.set("$bcb_dist", this.getDistanceLY(this.showData.system.getCenter()));
            }
            if (this.showData.market != null) {
                this.set("$" + id + "_targetMarketName", this.showData.market.getName());
                this.set("$bcb_targetMarketName", this.showData.market.getName());
                this.set("$" + id + "_targetMarketOnOrAt", this.showData.market.getOnOrAt());
                this.set("$bcb_targetMarketOnOrAt", this.showData.market.getOnOrAt());
            }
            this.set("$" + id + "_days", "" + (int)this.showCreator.getBountyDays());
            this.set("$bcb_days", "" + (int)this.showCreator.getBountyDays());
            if (this.showData.fleet != null) {
                PersonAPI p = this.showData.fleet.getCommander();
                this.set("$" + id + "_targetHeOrShe", p.getHeOrShe());
                this.set("$" + id + "_targetHisOrHer", p.getHisOrHer());
                this.set("$" + id + "_targetHimOrHer", p.getHimOrHer());
                this.set("$" + id + "_targetName", p.getNameString());
                this.set("$bcb_targetHeOrShe", p.getHeOrShe());
                this.set("$bcb_targetHisOrHer", p.getHisOrHer());
                this.set("$bcb_targetHimOrHer", p.getHimOrHer());
                this.set("$bcb_targetName", p.getNameString());
                this.set("$" + id + "_TargetHeOrShe", Misc.ucFirst(p.getHeOrShe()));
                this.set("$" + id + "_TargetHisOrHer", Misc.ucFirst(p.getHisOrHer()));
                this.set("$" + id + "_TargetHimOrHer", Misc.ucFirst(p.getHimOrHer()));
                this.set("$bcb_TargetHeOrShe", Misc.ucFirst(p.getHeOrShe()));
                this.set("$bcb_TargetHisOrHer", Misc.ucFirst(p.getHisOrHer()));
                this.set("$bcb_TargetHimOrHer", Misc.ucFirst(p.getHimOrHer()));
                this.set("$bcb_fleetName", this.showData.fleet.getName());
            }
        }
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("showBountyDetail".equals(action)) {
            String id = this.getMissionId();
            MemoryAPI memory = memoryMap.get("local");
            DifficultyChoice difficulty = Enum.valueOf(DifficultyChoice.class, memory.getString("$" + id + "_difficulty"));
            this.showCreator = this.creatorLow;
            this.showData = this.dataLow;
            switch (difficulty) {
                case LOW: {
                    this.showCreator = this.creatorLow;
                    this.showData = this.dataLow;
                    break;
                }
                case NORMAL: {
                    this.showCreator = this.creatorNormal;
                    this.showData = this.dataNormal;
                    break;
                }
                case HIGH: {
                    this.showCreator = this.creatorHigh;
                    this.showData = this.dataHigh;
                }
            }
            this.setCreditRewardApplyRelMult(this.showData.baseReward);
            this.updateInteractionData(dialog, memoryMap);
            String trigger = String.valueOf(this.showCreator.getId()) + "OfferDesc";
            FireBest.fire(null, dialog, memoryMap, trigger);
            if (this.showData != null && this.showData.system != null) {
                String icon = this.showCreator.getIconName();
                if (icon == null) {
                    icon = this.getIcon();
                }
                String text = null;
                LinkedHashSet<String> tags = new LinkedHashSet<String>();
                tags.add("Missions");
                Color color = Misc.getBasePlayerColor();
                if (this.showData.system.getCenter() != null && this.showData.system.getCenter().getMarket() != null) {
                    color = this.showData.system.getCenter().getMarket().getTextColorForFactionOrPlanet();
                } else if (this.showData.system.getCenter() instanceof PlanetAPI) {
                    color = Misc.setAlpha(((PlanetAPI)this.showData.system.getCenter()).getSpec().getIconColor(), 255);
                    color = Misc.setBrightness(color, 235);
                }
                dialog.getVisualPanel().showMapMarker(this.showData.system.getCenter(), "Target: " + this.showData.system.getNameWithLowercaseTypeShort(), color, true, icon, text, tags);
            }
            return true;
        }
        if ("showBountyAssessment".equals(action) && this.showCreator != null) {
            this.showCreator.addIntelAssessment(dialog.getTextPanel(), this, this.showData);
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        SectorEntityToken station;
        MarketAPI market;
        String id = this.getMissionId();
        MemoryAPI memory = memoryMap.get("local");
        DifficultyChoice difficulty = Enum.valueOf(DifficultyChoice.class, memory.getString("$" + id + "_difficulty"));
        ArrayList<BaseHubMission.Abortable> abort = new ArrayList<BaseHubMission.Abortable>();
        switch (difficulty) {
            case LOW: {
                this.creator = this.creatorLow;
                this.data = this.dataLow;
                abort.addAll(this.dataNormal.abortWhenOtherVersionAccepted);
                abort.addAll(this.dataHigh.abortWhenOtherVersionAccepted);
                break;
            }
            case NORMAL: {
                this.creator = this.creatorNormal;
                this.data = this.dataNormal;
                abort.addAll(this.dataLow.abortWhenOtherVersionAccepted);
                abort.addAll(this.dataHigh.abortWhenOtherVersionAccepted);
                break;
            }
            case HIGH: {
                this.creator = this.creatorHigh;
                this.data = this.dataHigh;
                abort.addAll(this.dataLow.abortWhenOtherVersionAccepted);
                abort.addAll(this.dataNormal.abortWhenOtherVersionAccepted);
            }
        }
        for (BaseHubMission.Abortable curr : abort) {
            curr.abort(this, false);
        }
        this.creatorHigh = null;
        this.creatorNormal = null;
        this.creatorLow = null;
        this.dataHigh = null;
        this.dataNormal = null;
        this.dataLow = null;
        MarketAPI createdAt = this.getPerson().getMarket();
        if (createdAt == null) {
            createdAt = dialog.getInteractionTarget().getMarket();
        }
        if (this.creator.getIconName() != null) {
            this.setIconName(this.creator.getIconName());
        }
        this.creator.notifyAccepted(createdAt, this, this.data);
        this.target = this.data.fleet.getCommander();
        this.data.fleet.addEventListener(this);
        this.makeImportant(this.data.fleet, "$" + id + "_target", Stage.BOUNTY);
        if (this.data.fleet.isHidden() && (market = Misc.getStationMarket(this.data.fleet)) != null && (station = Misc.getStationEntity(market, this.data.fleet)) != null) {
            this.makeImportant(station, "$" + id + "_target", Stage.BOUNTY);
        }
        if (!this.data.fleet.getFaction().isNeutralFaction()) {
            this.addTag(this.data.fleet.getFaction().getId());
        }
        if (this.creator.getBountyDays() > 0.0f) {
            this.setTimeLimit((Object)Stage.FAILED, this.creator.getBountyDays(), this.creator.getSystemWithNoTimeLimit(this.data), new Object[0]);
        }
        this.setCreditRewardApplyRelMult(this.data.baseReward);
        this.setRepRewardPerson(Float.valueOf(this.data.repPerson));
        this.setRepRewardFaction(Float.valueOf(this.data.repFaction));
        super.accept(dialog, memoryMap);
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOUNTY) {
            if (this.currentStage == Stage.BOUNTY) {
                this.creator.addTargetLocationAndDescription(info, width, height, this, this.data);
            }
            this.creator.addFleetDescription(info, width, height, this, this.data);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOUNTY && this.data.system != null) {
            this.creator.addTargetLocationAndDescriptionBulletPoint(info, tc, pad, this, this.data);
            return true;
        }
        return false;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return super.getMapLocation(map);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void endSuccessImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.creator.notifyCompleted(this, this.data);
        AggregateBountyData d = this.getAggregateData();
        d.completedDifficulty.add(this.data.difficulty);
        while (d.completedDifficulty.size() > NUM_TO_TRACK_FOR_DIFFICULTY) {
            d.completedDifficulty.remove(0);
        }
    }

    @Override
    protected void endFailureImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.creator.notifyFailed(this, this.data);
        AggregateBountyData d = this.getAggregateData();
        d.completedDifficulty.add(0);
        while (d.completedDifficulty.size() > NUM_TO_TRACK_FOR_DIFFICULTY) {
            d.completedDifficulty.remove(0);
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        boolean playerInvolved;
        if (this.isDone() || this.result != null) {
            return;
        }
        float distToPlayer = Misc.getDistance(fleet, Global.getSector().getPlayerFleet());
        boolean bl = playerInvolved = battle.isPlayerInvolved() || fleet.isInCurrentLocation() && distToPlayer < 2000.0f;
        if (battle.isInvolved(fleet) && !playerInvolved) {
            boolean cancelBounty;
            boolean bl2 = cancelBounty = fleet.isStationMode() && fleet.getFlagship() == null || !fleet.isStationMode() && fleet.getFlagship() != null && fleet.getFlagship().getCaptain() != this.target;
            if (cancelBounty) {
                String id = this.getMissionId();
                this.getPerson().getMemoryWithoutUpdate().set("$" + id + "_failed", true);
                return;
            }
        }
        if (!playerInvolved || !battle.isInvolved(fleet) || battle.onPlayerSide(fleet)) {
            return;
        }
        if (fleet.isStationMode() ? fleet.getFlagship() != null : fleet.getFlagship() != null && fleet.getFlagship().getCaptain() == this.target) {
            return;
        }
        String id = this.getMissionId();
        this.getPerson().getMemoryWithoutUpdate().set("$" + id + "_completed", true);
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isDone() || this.result != null) {
            return;
        }
        if (this.data.fleet == fleet) {
            String id = this.getMissionId();
            this.getPerson().getMemoryWithoutUpdate().set("$" + id + "_failed", true);
        }
    }

    @Override
    public String getBaseName() {
        if (this.creator != null) {
            return this.creator.getBaseBountyName(this, this.data);
        }
        return "Bounty";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "bounty";
    }

    @Override
    public String getPostfixForState() {
        String post = super.getPostfixForState();
        if (!(post = post.replaceFirst(" - ", "")).isEmpty()) {
            post = " (" + post + ")";
        }
        if (this.creator != null) {
            return String.valueOf(this.creator.getBountyNamePostfix(this, this.data)) + post;
        }
        return super.getPostfixForState();
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public static class AggregateBountyData {
        public List<Integer> completedDifficulty = new ArrayList<Integer>();
    }

    public static enum DifficultyChoice {
        LOW,
        NORMAL,
        HIGH;

    }

    public static enum Stage {
        BOUNTY,
        COMPLETED,
        FAILED,
        FAILED_NO_PENALTY;

    }
}

