/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;

public class CBMerc
extends BaseCustomBountyCreator {
    public static float PROB_SMALL_FLEET = 0.5f;
    public static float PROB_SOME_PHASE_IN_SMALL_FLEET = 0.5f;
    public static float PROB_CARRIER_BASED_LARGE_FLEET = 0.33f;
    public static float PROB_SOME_PHASE_IN_LARGE_FLEET = 0.5f;

    @Override
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        return super.getFrequency(mission, difficulty) * CBStats.MERC_FREQ;
    }

    @Override
    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - Elite Mercenary";
    }

    protected StarSystemAPI findSystem(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        mission.requireSystemInterestingAndNotUnsafeOrCore();
        mission.requireSystemNotHasPulsar();
        StarSystemAPI system = mission.pickSystem();
        return system;
    }

    protected boolean isAggro() {
        return true;
    }

    @Override
    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        data.system = this.findSystem(createdAt, mission, difficulty, bountyStage);
        if (data.system == null) {
            return null;
        }
        boolean smallFleet = mission.rollProbability(PROB_SMALL_FLEET);
        boolean smallUsePhase = mission.rollProbability(PROB_SOME_PHASE_IN_SMALL_FLEET);
        boolean largeUsePhase = mission.rollProbability(PROB_SOME_PHASE_IN_LARGE_FLEET);
        boolean largeUseCarriers = mission.rollProbability(PROB_CARRIER_BASED_LARGE_FLEET);
        this.beginFleet(mission, data);
        if (smallFleet) {
            data.custom1 = true;
            if (difficulty <= 6) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", data.system);
                mission.triggerSetFleetMaxShipSize(1);
                mission.triggerSetFleetDoctrineOther(1, 4);
            } else if (difficulty <= 7) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", data.system);
                mission.triggerSetFleetMaxShipSize(2);
                mission.triggerSetFleetDoctrineOther(2, 4);
            } else if (difficulty <= 8) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", data.system);
                mission.triggerSetFleetMaxShipSize(3);
                mission.triggerSetFleetDoctrineOther(3, 4);
            } else if (difficulty <= 9) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", data.system);
                mission.triggerSetFleetDoctrineOther(4, 4);
            } else if (difficulty <= 10) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "mercBountyHunter", data.system);
                mission.triggerSetFleetDoctrineOther(5, 4);
            }
            mission.triggerSetFleetMaxNumShips(12);
            if (smallUsePhase) {
                if (difficulty <= 8) {
                    mission.triggerSetFleetDoctrineComp(0, 0, 5);
                } else {
                    mission.triggerSetFleetDoctrineComp(4, 0, 3);
                }
            } else {
                mission.triggerSetFleetDoctrineComp(5, 0, 0);
            }
            mission.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
            mission.triggerFleetAddCommanderSkill("wolfpack_tactics", 1);
            mission.triggerFleetAddCommanderSkill("electronic_warfare", 1);
            mission.triggerFleetAddCommanderSkill("flux_regulation", 1);
            mission.triggerFleetAddCommanderSkill("tactical_drills", 1);
            mission.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.UNUSUALLY_HIGH);
        } else {
            if (difficulty <= 6) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercBountyHunter", data.system);
            } else if (difficulty <= 7) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercPrivateer", data.system);
            } else if (difficulty <= 8) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercArmada", data.system);
            } else if (difficulty <= 9) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "mercenary", "mercArmada", data.system);
            } else if (difficulty <= 10) {
                mission.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.SMOD_2, "mercenary", "mercArmada", data.system);
            }
            if (largeUseCarriers) {
                mission.triggerSetFleetDoctrineComp(3, 4, 0);
                mission.triggerFleetAddCommanderSkill("carrier_group", 1);
                mission.triggerFleetAddCommanderSkill("fighter_uplink", 1);
            } else if (largeUsePhase) {
                mission.triggerSetFleetDoctrineComp(3, 0, 2);
                mission.triggerFleetAddCommanderSkill("phase_corps", 1);
                mission.triggerFleetAddCommanderSkill("flux_regulation", 1);
            } else {
                mission.triggerSetFleetDoctrineComp(5, 0, 0);
                mission.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
                mission.triggerFleetAddCommanderSkill("electronic_warfare", 1);
            }
            mission.triggerSetFleetDoctrineOther(3, 3);
            mission.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        }
        mission.triggerSetFleetNoCommanderSkills();
        mission.triggerFleetAddCommanderSkill("crew_training", 1);
        mission.triggerSetFleetFaction("independent");
        if (this.isAggro()) {
            mission.triggerMakeHostileAndAggressive();
            mission.triggerMakeNoRepImpact();
        }
        mission.triggerFleetAllowLongPursuit();
        mission.triggerDoNotShowFleetDesc();
        mission.triggerFleetSetAllWeapons();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "salvageable", "planet", "objective");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.MERC_MULT, mission);
        return data;
    }

    @Override
    public void updateInteractionData(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        String id = mission.getMissionId();
        if (data.custom1 != null) {
            mission.set("$" + id + "_smallMerc", data.difficulty);
            mission.set("$bcb_smallMerc", data.difficulty);
        } else {
            mission.unset("$" + id + "_smallMerc");
            mission.unset("$bcb_smallMerc");
        }
    }

    @Override
    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    @Override
    public int getMinDifficulty() {
        return 6;
    }
}

