/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBounty;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBDerelict;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBDeserter;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBEnemyStation;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBMerc;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBPather;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBPirate;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnant;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnantPlus;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnantStation;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;

public class MilitaryCustomBounty
extends BaseCustomBounty {
    public static List<CustomBountyCreator> CREATORS = new ArrayList<CustomBountyCreator>();

    static {
        CREATORS.add(new CBPirate());
        CREATORS.add(new CBDeserter());
        CREATORS.add(new CBDerelict());
        CREATORS.add(new CBMerc());
        CREATORS.add(new CBPather());
        CREATORS.add(new CBRemnant());
        CREATORS.add(new CBRemnantPlus());
        CREATORS.add(new CBRemnantStation());
        CREATORS.add(new CBEnemyStation());
    }

    @Override
    public List<CustomBountyCreator> getCreators() {
        return CREATORS;
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if ("pirates".equals(createdAt.getFaction().getId())) {
            return false;
        }
        return super.create(createdAt, barEvent);
    }

    @Override
    protected void createBarGiver(MarketAPI createdAt) {
        ArrayList<String> posts = new ArrayList<String>();
        if (Misc.isMilitary(createdAt)) {
            posts.add(Ranks.POST_BASE_COMMANDER);
        }
        if (Misc.hasOrbitalStation(createdAt)) {
            posts.add(Ranks.POST_STATION_COMMANDER);
        }
        if (posts.isEmpty()) {
            posts.add(Ranks.POST_GENERIC_MILITARY);
        }
        String post = this.pickOne(posts);
        this.setGiverPost(post);
        if (post.equals(Ranks.POST_GENERIC_MILITARY)) {
            this.setGiverRank(Ranks.SPACE_COMMANDER);
            this.setGiverImportance(this.pickImportance());
        } else if (post.equals(Ranks.POST_BASE_COMMANDER)) {
            this.setGiverRank(Ranks.GROUND_COLONEL);
            this.setGiverImportance(this.pickImportance());
        } else if (post.equals(Ranks.POST_STATION_COMMANDER)) {
            this.setGiverRank(Ranks.SPACE_CAPTAIN);
            this.setGiverImportance(this.pickHighImportance());
        }
        this.setGiverTags("military");
        this.findOrCreateGiver(createdAt, false, false);
        this.setGiverIsPotentialContactOnSuccess();
    }
}

