/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.HasMemory;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetInterceptPlayerIfNearby;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetStopPursuingPlayer;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionTrigger;
import com.fs.starfarer.api.impl.campaign.missions.hub.TriggerFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public abstract class HubMissionWithTriggers
extends BaseHubMission {
    protected transient boolean useQualityInsteadOfQualityFraction = false;
    public static float DEFAULT_MIN_DIST_FROM_PLAYER = 3000.0f;
    protected transient MissionTrigger currTrigger = null;

    public CreateFleetAction getPreviousCreateFleetAction() {
        int i = this.currTrigger.getActions().size() - 1;
        while (i >= 0) {
            MissionTrigger.TriggerAction action = this.currTrigger.getActions().get(i);
            if (action instanceof CreateFleetAction) {
                return (CreateFleetAction)action;
            }
            --i;
        }
        return null;
    }

    public void triggerMovePersonToMarket(PersonAPI person, MarketAPI market, boolean alwaysAddToComms) {
        this.triggerCustomAction(new MovePersonToMarket(person, market, alwaysAddToComms));
    }

    public void triggerIncreaseMarketHostileTimeout(MarketAPI market, float days) {
        this.triggerCustomAction(new IncreaseMarketHostileTimeout(market, days));
    }

    public void triggerRunScriptAfterDelay(float delay, Script script) {
        this.triggerCustomAction(new RunScriptAfterDelay(delay, script));
    }

    public void triggerAddTagAfterDelay(float delay, StarSystemAPI system, String tag) {
        this.triggerCustomAction(new AddTagAfterDelay(delay, system, tag));
    }

    public void triggerSetMemoryValueAfterDelay(float delay, HasMemory hasMemory, String key, Object value) {
        this.triggerSetMemoryValueAfterDelay(delay, hasMemory.getMemory(), key, value);
    }

    public void triggerSetMemoryValueAfterDelay(float delay, MemoryAPI memory, String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAfterDelay(delay, memory, key, value));
    }

    public void triggerSetGlobalMemoryValueAfterDelay(float delay, String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAfterDelay(delay, Global.getSector().getMemory(), key, value));
    }

    public float genDelay(float base) {
        return base * StarSystemGenerator.getNormalRandom(this.genRandom, 0.75f, 1.25f);
    }

    public void triggerUnhideCommListing(PersonAPI person) {
        this.triggerCustomAction(new UnhideCommListing(person));
    }

    public void triggerHideCommListing(PersonAPI person) {
        this.triggerCustomAction(new HideCommListing(person));
    }

    public void triggerSaveGlobalEntityRef(String key) {
        this.triggerSaveEntityRef(Global.getSector().getMemoryWithoutUpdate(), key);
    }

    public void triggerSaveEntityRef(MemoryAPI memory, String key) {
        this.triggerCustomAction(new SaveEntityReferenceAction(memory, key));
    }

    public void triggerSaveGlobalFleetRef(String key) {
        this.triggerSaveFleetRef(Global.getSector().getMemoryWithoutUpdate(), key);
    }

    public void triggerSaveFleetRef(MemoryAPI memory, String key) {
        this.triggerCustomAction(new SaveFleetReferenceAction(memory, key));
    }

    public SectorEntityToken getEntityFromGlobal(String key) {
        return Global.getSector().getMemoryWithoutUpdate().getEntity(key);
    }

    public void triggerCreateFleet(FleetSize size, FleetQuality quality, String factionId, String type, StarSystemAPI roughlyWhere) {
        this.triggerCustomAction(new CreateFleetAction(type, roughlyWhere.getLocation(), size, quality, factionId));
    }

    public void triggerCreateFleet(FleetSize size, FleetQuality quality, String factionId, String type, SectorEntityToken roughlyWhere) {
        this.triggerCustomAction(new CreateFleetAction(type, roughlyWhere.getLocationInHyperspace(), size, quality, factionId));
    }

    public void triggerCreateFleet(FleetSize size, FleetQuality quality, String factionId, String type, Vector2f locInHyper) {
        this.triggerCustomAction(new CreateFleetAction(type, locInHyper, size, quality, factionId));
    }

    public void triggerAutoAdjustFleetSize(FleetSize min, FleetSize max) {
        float f = this.getQualityFraction();
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.fSizeOverride = Float.valueOf(min.maxFPFraction + (max.maxFPFraction - min.maxFPFraction) * f);
        this.autoAdjustFleetTypeName();
    }

    public void triggerSetFleetSizeFraction(float fractionOfMax) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.fSizeOverride = Float.valueOf(fractionOfMax);
    }

    public void triggerSetFleetCombatFleetPoints(float combatFleetPointsOverride) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.combatFleetPointsOverride = Float.valueOf(combatFleetPointsOverride);
    }

    public void triggerAutoAdjustFleetQuality(FleetQuality min, FleetQuality max) {
        float f = this.getQualityFraction();
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.fQualityMod = Float.valueOf(min.qualityMod + (max.qualityMod - min.qualityMod) * f);
        cfa.fQualitySMods = Math.round((float)min.numSMods + (float)(max.numSMods - min.numSMods) * f);
        if (cfa.fQualitySMods <= 0) {
            cfa.fQualitySMods = null;
        }
    }

    public void triggerAutoAdjustOfficerNum(OfficerNum min, OfficerNum max) {
        float f = this.getQualityFraction();
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.oNum = (OfficerNum)((Object)this.pickEnum(f, this.getEnums(min, max)));
    }

    public void triggerAutoAdjustOfficerQuality(OfficerQuality min, OfficerQuality max) {
        float f = this.getQualityFraction();
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.oQuality = (OfficerQuality)((Object)this.pickEnum(f, this.getEnums(min, max)));
    }

    public void triggerSetFleetQuality(FleetQuality quality) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa != null) {
            cfa.fQuality = quality;
        }
    }

    public void triggerSetFleetSize(FleetSize size) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa != null) {
            cfa.fSize = size;
        }
    }

    public void triggerRandomizeFleetStrengthMinor() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        FleetSize size = cfa.fSize;
        if (size == null) {
            size = FleetSize.MEDIUM;
        }
        float min = size.maxFPFraction - (size.maxFPFraction - size.prev().maxFPFraction) / 2.0f;
        float max = size.maxFPFraction + (size.next().maxFPFraction - size.maxFPFraction) / 2.0f;
        cfa.fSizeOverride = Float.valueOf(min + (max - min) * this.genRandom.nextFloat());
        FleetQuality fq = cfa.fQuality;
        if (fq == null) {
            fq = FleetQuality.DEFAULT;
        }
        min = fq.qualityMod - (fq.qualityMod - fq.prev().qualityMod) / 2.0f;
        max = fq.qualityMod + (fq.next().qualityMod - fq.qualityMod) / 2.0f;
        cfa.fQualityMod = Float.valueOf(min + (max - min) * this.genRandom.nextFloat());
    }

    public void triggerAutoAdjustFleetStrengthModerate() {
        OfficerQuality oQuality;
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        FleetSize size = cfa.fSize;
        if (size == null) {
            size = FleetSize.MEDIUM;
        }
        this.triggerAutoAdjustFleetSize(size.prev(), size.next());
        FleetQuality fq = cfa.fQuality;
        if (fq == null) {
            fq = FleetQuality.DEFAULT;
        }
        FleetQuality limit = FleetQuality.VERY_HIGH;
        FleetQuality next = fq;
        int steps = 1;
        while (next.next().ordinal() <= limit.ordinal() && steps > 0) {
            next = next.next();
            --steps;
        }
        limit = FleetQuality.LOWER;
        FleetQuality prev = fq;
        steps = 1;
        while (prev.prev().ordinal() >= limit.ordinal() && steps > 0) {
            prev = prev.prev();
            --steps;
        }
        this.triggerAutoAdjustFleetQuality(prev, next);
        OfficerNum oNum = cfa.oNum;
        if (oNum == null) {
            oNum = OfficerNum.DEFAULT;
        }
        if (oNum == OfficerNum.FEWER || oNum == OfficerNum.DEFAULT) {
            switch (oNum) {
                case FEWER: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.FEWER, OfficerNum.DEFAULT);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.DEFAULT, OfficerNum.MORE);
                }
            }
        }
        if ((oQuality = cfa.oQuality) == null) {
            oQuality = OfficerQuality.DEFAULT;
        }
        if (oQuality == OfficerQuality.LOWER || oQuality == OfficerQuality.DEFAULT) {
            switch (oQuality) {
                case LOWER: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.LOWER, OfficerQuality.DEFAULT);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.DEFAULT, OfficerQuality.HIGHER);
                }
            }
        }
    }

    public void triggerAutoAdjustFleetStrengthMajor() {
        OfficerQuality oQuality;
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        FleetSize size = cfa.fSize;
        if (size == null) {
            size = FleetSize.MEDIUM;
        }
        this.triggerAutoAdjustFleetSize(size.prev().prev(), size.next().next());
        FleetQuality fq = cfa.fQuality;
        if (fq == null) {
            fq = FleetQuality.DEFAULT;
        }
        FleetQuality limit = FleetQuality.VERY_HIGH;
        FleetQuality next = fq;
        int steps = 2;
        while (next.next().ordinal() <= limit.ordinal() && steps > 0) {
            next = next.next();
            --steps;
        }
        limit = FleetQuality.LOWER;
        FleetQuality prev = fq;
        steps = 2;
        while (prev.prev().ordinal() >= limit.ordinal() && steps > 0) {
            prev = prev.prev();
            --steps;
        }
        this.triggerAutoAdjustFleetQuality(prev, next);
        OfficerNum oNum = cfa.oNum;
        if (oNum == null) {
            oNum = OfficerNum.DEFAULT;
        }
        if (oNum == OfficerNum.FEWER || oNum == OfficerNum.DEFAULT) {
            switch (oNum) {
                case FEWER: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.FEWER, OfficerNum.DEFAULT);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.DEFAULT, OfficerNum.MORE);
                }
            }
        }
        if ((oQuality = cfa.oQuality) == null) {
            oQuality = OfficerQuality.DEFAULT;
        }
        if (oQuality == OfficerQuality.LOWER || oQuality == OfficerQuality.DEFAULT) {
            switch (oQuality) {
                case LOWER: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.LOWER, OfficerQuality.DEFAULT);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.DEFAULT, OfficerQuality.HIGHER);
                }
            }
        }
    }

    public void triggerAutoAdjustFleetStrengthExtreme() {
        OfficerQuality oQuality;
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        FleetSize size = cfa.fSize;
        if (size == null) {
            size = FleetSize.MEDIUM;
        }
        this.triggerAutoAdjustFleetSize(size.prev().prev(), size.next().next().next());
        FleetQuality fq = cfa.fQuality;
        if (fq == null) {
            fq = FleetQuality.DEFAULT;
        }
        FleetQuality limit = FleetQuality.SMOD_1;
        FleetQuality next = fq;
        int steps = 3;
        while (next.next().ordinal() <= limit.ordinal() && steps > 0) {
            next = next.next();
            --steps;
        }
        limit = FleetQuality.LOWER;
        FleetQuality prev = fq;
        steps = 2;
        while (prev.prev().ordinal() >= limit.ordinal() && steps > 0) {
            prev = prev.prev();
            --steps;
        }
        this.triggerAutoAdjustFleetQuality(prev, next);
        OfficerNum oNum = cfa.oNum;
        if (oNum == null) {
            oNum = OfficerNum.DEFAULT;
        }
        if (oNum == OfficerNum.FEWER || oNum == OfficerNum.DEFAULT || oNum == OfficerNum.MORE) {
            switch (oNum) {
                case FEWER: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.FEWER, OfficerNum.MORE);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.FEWER, OfficerNum.ALL_SHIPS);
                    break;
                }
                case MORE: {
                    this.triggerAutoAdjustOfficerNum(OfficerNum.DEFAULT, OfficerNum.ALL_SHIPS);
                }
            }
        }
        if ((oQuality = cfa.oQuality) == null) {
            oQuality = OfficerQuality.DEFAULT;
        }
        if (oQuality == OfficerQuality.LOWER || oQuality == OfficerQuality.DEFAULT) {
            switch (oQuality) {
                case LOWER: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.LOWER, OfficerQuality.DEFAULT);
                    break;
                }
                case DEFAULT: {
                    this.triggerAutoAdjustOfficerQuality(OfficerQuality.DEFAULT, OfficerQuality.HIGHER);
                }
            }
        }
    }

    public void setUseQualityInsteadOfQualityFraction(boolean temporarilyUseQualityInsteadOfQualityFraction) {
        this.useQualityInsteadOfQualityFraction = temporarilyUseQualityInsteadOfQualityFraction;
    }

    protected float getQualityFraction() {
        float f;
        float quality = this.getQuality();
        if (this.useQualityInsteadOfQualityFraction) {
            return quality;
        }
        float minQuality = this.getMinQuality();
        float maxQuality = this.getMaxQuality();
        float base = this.getBaseQuality();
        if (quality < base) {
            float range = base - minQuality;
            f = 0.0f;
            if (range > 0.0f) {
                f = (quality - minQuality) / range;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            f *= 0.5f;
        } else {
            float range = maxQuality - base;
            f = 1.0f;
            if (range > 0.0f) {
                f = (quality - base) / range;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            f = 0.5f + f * 0.5f;
        }
        return f;
    }

    protected Object[] getEnums(Enum from, Enum to) {
        return EnumSet.range(from, to).toArray();
    }

    protected Object pickEnum(float f, Object ... enums) {
        float rem;
        float num = enums.length;
        if ((rem = (f *= num - 1.0f) - (float)((int)f)) < 0.2f) {
            rem = 0.0f;
        }
        if (rem > 0.8f) {
            rem = 1.0f;
        }
        int index = (int)f;
        if (this.genRandom.nextFloat() < rem) {
            ++index;
        }
        if (index > enums.length - 1) {
            index = enums.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return enums[index];
    }

    public void triggerSetFleetCompositionNoSupportShips() {
        this.triggerSetFleetComposition(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void triggerSetFleetComposition(float freighterMult, float tankerMult, float transportMult, float linerMult, float utilityMult) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.freighterMult = freighterMult > 0.0f ? Float.valueOf(freighterMult) : null;
        cfa.tankerMult = tankerMult > 0.0f ? Float.valueOf(tankerMult) : null;
        cfa.transportMult = transportMult > 0.0f ? Float.valueOf(transportMult) : null;
        cfa.linerMult = linerMult > 0.0f ? Float.valueOf(linerMult) : null;
        cfa.utilityMult = utilityMult > 0.0f ? Float.valueOf(utilityMult) : null;
    }

    public void triggerSetFleetDoctrineComp(int warships, int carriers, int phaseShips) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.doctrineOverride == null) {
            FactionAPI faction = Global.getSector().getFaction(cfa.params.factionId);
            cfa.params.doctrineOverride = faction.getDoctrine().clone();
        }
        cfa.params.doctrineOverride.setWarships(warships);
        cfa.params.doctrineOverride.setCarriers(carriers);
        cfa.params.doctrineOverride.setPhaseShips(phaseShips);
    }

    public void triggerAddShips(String ... variants) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.addShips == null) {
            cfa.params.addShips = new ArrayList<String>();
        }
        String[] stringArray = variants;
        int n = variants.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            cfa.params.addShips.add(id);
            ++n2;
        }
    }

    public void triggerSetFleetProbabilityCombatFreighters(float prob) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.doctrineOverride == null) {
            FactionAPI faction = Global.getSector().getFaction(cfa.params.factionId);
            cfa.params.doctrineOverride = faction.getDoctrine().clone();
        }
        cfa.params.doctrineOverride.setCombatFreighterProbability(prob);
    }

    public void triggerSetFleetDoctrineQuality(int officerQuality, int shipQuality, int numShips) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.doctrineOverride == null) {
            FactionAPI faction = Global.getSector().getFaction(cfa.params.factionId);
            cfa.params.doctrineOverride = faction.getDoctrine().clone();
        }
        if (officerQuality >= 0) {
            cfa.params.doctrineOverride.setOfficerQuality(officerQuality);
        }
        if (shipQuality >= 0) {
            cfa.params.doctrineOverride.setShipQuality(shipQuality);
        }
        if (numShips >= 0) {
            cfa.params.doctrineOverride.setNumShips(numShips);
        }
    }

    public void triggerSetFleetDoctrineOther(int shipSize, int aggression) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.doctrineOverride == null) {
            FactionAPI faction = Global.getSector().getFaction(cfa.params.factionId);
            cfa.params.doctrineOverride = faction.getDoctrine().clone();
        }
        if (shipSize >= 0) {
            cfa.params.doctrineOverride.setShipSize(shipSize);
        }
        if (aggression >= 0) {
            cfa.params.doctrineOverride.setAggression(aggression);
        }
    }

    public void triggerSetFleetDoctrineRandomize(float randomizeProb) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.doctrineOverride == null) {
            FactionAPI faction = Global.getSector().getFaction(cfa.params.factionId);
            cfa.params.doctrineOverride = faction.getDoctrine().clone();
        }
        cfa.params.doctrineOverride.setAutofitRandomizeProbability(randomizeProb);
    }

    public void triggerSetFleetSizeAndQuality(FleetSize size, FleetQuality quality, String fleetType) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.fSize = size;
        cfa.fQuality = quality;
        cfa.params.fleetType = fleetType;
        cfa.fSizeOverride = null;
    }

    public void triggerSetFleetType(String fleetType) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.fleetType = fleetType;
    }

    public void triggerSetFleetOfficers(OfficerNum num, OfficerQuality quality) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.oNum = num;
        cfa.oQuality = quality;
    }

    public void triggerFleetSetCommander(PersonAPI commander) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.commander = commander;
    }

    public void triggerSetFleetNoCommanderSkills() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.noCommanderSkills = true;
    }

    public void triggerSetFleetMaxShipSize(int max) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.maxShipSize = max;
    }

    public void triggerSetFleetMinShipSize(int min) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.minShipSize = min;
    }

    public void triggerSetFleetMaxNumShips(int num) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.maxNumShips = num;
    }

    public void triggerFleetSetSingleShipOnly() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.onlyRetainFlagship = true;
    }

    public void triggerFleetSetFlagship(String variantId) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.flagshipVariantId = variantId;
    }

    public void triggerFleetSetFlagship(ShipVariantAPI variant) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.params.flagshipVariant = variant;
    }

    public void triggerFleetRemoveInflater() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.removeInflater = true;
    }

    public void triggerFleetSetShipPickMode(FactionAPI.ShipPickMode mode) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.shipPickMode = mode;
    }

    public void triggerFleetSetAllWeapons() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.allWeapons = true;
    }

    public void triggerSetFleetFaction(String factionId) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.faction = factionId;
    }

    public void triggerFleetSetName(String name) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.nameOverride = name;
    }

    public void triggerFleetSetNoFactionInName() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.noFactionInName = true;
    }

    public void triggerFleetDoNotIntegrateAICores() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        cfa.doNotIntegrateAICores = true;
    }

    public FleetParamsV3 triggerGetFleetParams() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        return cfa.params;
    }

    public void triggerSetFleetCommander(final PersonAPI commander) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa != null && cfa.params != null) {
            cfa.params.commander = commander;
        } else {
            this.triggerCustomAction(new MissionTrigger.TriggerAction(){

                @Override
                public void doAction(MissionTrigger.TriggerActionContext context) {
                    context.fleet.setCommander(commander);
                    context.fleet.getFleetData().ensureHasFlagship();
                }
            });
        }
    }

    public void triggerFleetMakeImportantPermanent(String flag) {
        this.triggerCustomAction(new FleetMakeImportantAction(flag, null));
    }

    public void triggerFleetMakeImportant(String flag, Enum ... stages) {
        this.triggerCustomAction(new FleetMakeImportantAction(flag, stages));
    }

    public void triggerEntityMakeImportant(String flag, Enum ... stages) {
        this.triggerCustomAction(new EntityMakeImportantAction(flag, stages));
    }

    public void triggerSetFleetFlagsWithReasonPermanent(String ... flags) {
        this.triggerCustomAction(new SetFleetFlagsWithReasonAction(this.getReason(), true, flags));
    }

    public void triggerSetFleetFlagsWithReason(String ... flags) {
        this.triggerCustomAction(new SetFleetFlagsWithReasonAction(this.getReason(), false, flags));
    }

    public void triggerUnsetFleetFlagsWithReason(String ... flags) {
        this.triggerCustomAction(new UnsetFleetFlagsWithReasonAction(this.getReason(), flags));
    }

    public void triggerSetPersonMissionRef(String key) {
        this.triggerCustomAction(new SetPersonMissionRefAction(key));
    }

    public void triggerSetFleetMissionRef(String key) {
        this.triggerCustomAction(new SetFleetMissionRefAction(key));
    }

    public void triggerSetFleetMemoryValue(String key, Object value) {
        this.triggerCustomAction(new SetFleetMemoryValueAction(key, value));
    }

    public void triggerSetMemoryValue(HasMemory withMemory, String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAction(withMemory.getMemoryWithoutUpdate(), key, value, true));
    }

    public void triggerSetMemoryValuePermanent(HasMemory withMemory, String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAction(withMemory.getMemoryWithoutUpdate(), key, value, false));
    }

    public void triggerSetGlobalMemoryValue(String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAction(Global.getSector().getMemoryWithoutUpdate(), key, value, true));
    }

    public void triggerSetGlobalMemoryValuePermanent(String key, Object value) {
        this.triggerCustomAction(new SetMemoryValueAction(Global.getSector().getMemoryWithoutUpdate(), key, value, false));
    }

    public void triggerSetFleetFlagPermanent(String flag) {
        this.triggerCustomAction(new SetFleetFlagAction(flag, true, null));
    }

    public void triggerSetFleetGenericHailPermanent(String commsTrigger) {
        this.triggerSetFleetGenericHail(commsTrigger, null);
    }

    public void triggerSetFleetGenericHail(String commsTrigger, Object ... stages) {
        if (stages == null || stages.length <= 0) {
            this.triggerSetFleetFlagPermanent("$genericHail");
        } else {
            this.triggerSetFleetFlag("$genericHail", stages);
        }
        this.triggerSetFleetMemoryValue("$genericHail_openComms", commsTrigger);
    }

    public void triggerSetFleetGenericHailIfNonHostilePermanent(String commsTrigger) {
        this.triggerSetFleetGenericHail(commsTrigger, null);
    }

    public void triggerSetFleetGenericHailIfNonHostile(String commsTrigger, Object ... stages) {
        if (stages == null || stages.length <= 0) {
            this.triggerSetFleetFlagPermanent("$genericHail_nonHostile");
        } else {
            this.triggerSetFleetFlag("$genericHail_nonHostile", stages);
        }
        this.triggerSetFleetMemoryValue("$genericHail_openComms", commsTrigger);
    }

    public void triggerSetFleetFlag(String flag) {
        this.triggerCustomAction(new SetFleetFlagAction(flag, false, null));
    }

    public void triggerSetEntityFlagPermanent(String flag) {
        this.triggerCustomAction(new SetEntityFlagAction(flag, true, null));
    }

    public void triggerSetEntityFlag(String flag) {
        this.triggerCustomAction(new SetEntityFlagAction(flag, false, null));
    }

    public void triggerSetFleetFlagPermanent(String flag, Object ... stages) {
        this.triggerCustomAction(new SetFleetFlagAction(flag, true, stages));
    }

    public void triggerSetFleetFlag(String flag, Object ... stages) {
        this.triggerCustomAction(new SetFleetFlagAction(flag, false, stages));
    }

    public void triggerUnsetFleetFlag(String flag) {
        this.triggerCustomAction(new UnsetFleetFlagsAction(flag));
    }

    public void triggerSetEntityFlagPermanent(String flag, Object ... stages) {
        this.triggerCustomAction(new SetEntityFlagAction(flag, true, stages));
    }

    public void triggerSetEntityFlag(String flag, Object ... stages) {
        this.triggerCustomAction(new SetEntityFlagAction(flag, false, stages));
    }

    public void triggerUnsetEntityFlag(String flag) {
        this.triggerCustomAction(new UnsetEntityFlagsAction(flag));
    }

    public void triggerMakeHostileAndAggressive() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeHostile", "$cfai_makeAggressive");
        this.triggerSetFleetFlag("$cfai_makeAggressiveLastsOneBattle");
    }

    public void triggerMakeFleetIgnoreOtherFleetsExceptPlayer() {
        this.triggerMakeFleetIgnoreOtherFleets();
        this.triggerMakeFleetNotIgnorePlayer();
    }

    public void triggerMakeFleetNotIgnorePlayer() {
        this.triggerSetFleetFlag("$cfai_doNotIgnorePlayer");
    }

    public void triggerMakeFleetIgnoreOtherFleets() {
        this.triggerSetFleetFlag("$cfai_ignoreOtherFleets");
    }

    public void triggerMakeFleetIgnoredByOtherFleets() {
        this.triggerSetFleetFlag("$cfai_ignoredByOtherFleets");
    }

    public void triggerMakeFleetAllowDisengage() {
        this.triggerSetFleetFlag("$cfai_makeAllowDisengage");
    }

    public void makeHostileAndAggressive(CampaignFleetAPI fleet, boolean permanent) {
        this.setFlagWithReason(fleet, "$cfai_makeHostile", permanent);
        this.setFlagWithReason(fleet, "$cfai_makeAggressive", permanent);
        this.setFlag(fleet, "$cfai_makeAggressiveLastsOneBattle", permanent);
    }

    public void triggerMakeNonHostile() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeNonHostile");
    }

    public void triggerMakeHostile() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeHostile");
    }

    public void triggerMakeHostileToPlayerTradeFleets() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeHostileToPlayerTradeFleets");
    }

    public void triggerMakeHostileToAllTradeFleets() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeHostileToAllTradeFleets");
    }

    public void triggerMakeHostileWhileTransponderOff() {
        this.triggerSetFleetFlagsWithReason("$cfai_makeHostileWhileTOff");
    }

    public void triggerMakeLowRepImpact() {
        this.triggerSetFleetFlagsWithReason("$lowRepImpact");
    }

    public void triggerMakeEveryoneJoinBattleAgainst() {
        this.triggerSetFleetFlagsWithReason("$everyoneJoinsBattleAgainst");
    }

    public void triggerMakeAlwaysSpreadTOffHostility() {
        this.triggerSetFleetFlagsWithReason("$alwaysSpreadTOffHostility");
    }

    public void triggerMakeNoRepImpact() {
        this.triggerSetFleetFlagsWithReason("$lowRepImpact", "$noRepImpact");
    }

    public void triggerPatrolAllowTransponderOff() {
        this.triggerSetFleetFlag("$patrolAllowTOff");
    }

    public void triggerDoNotShowFleetDesc() {
        this.triggerSetFleetFlagPermanent("$shownFleetDescAlready");
    }

    public void triggerFleetForceAutofitOnAllShips() {
        this.triggerSetFleetFlag("$overrideNoAutofit");
    }

    public void triggerFleetOnlyEngageableWhenVisibleToPlayer() {
        this.triggerSetFleetFlag("$canOnlyBeEngagedWhenVisibleToPlayer");
    }

    public void triggerFleetNoJump() {
        this.triggerSetFleetFlagPermanent("$cfai_noJump");
    }

    public void triggerFleetAllowJump() {
        this.triggerUnsetFleetFlag("$cfai_noJump");
    }

    public void triggerSetFleetNotBusy() {
        this.triggerUnsetFleetFlag("$core_fleetBusy");
    }

    public void triggerSetPatrol() {
        this.triggerSetFleetFlagPermanent("$isPatrol");
    }

    public void triggerSetFleetHasslePlayer(String hassleType) {
        this.triggerSetFleetFlag("$willHasslePlayer");
        this.triggerSetFleetMemoryValue("$hassleType", hassleType);
    }

    public void triggerSetFleetExtraSmugglingSuspicion(float extraSuspicion) {
        this.triggerSetFleetMemoryValue("$patrolExtraSuspicion", Float.valueOf(extraSuspicion));
    }

    public void triggerMakeNonHostileToFaction(String factionId) {
        String flag = "$cfai_makeNonHostile_" + factionId;
        this.triggerSetFleetFlag(flag);
    }

    public void triggerMakeHostileToFaction(String factionId) {
        String flag = "$cfai_makeHostile_" + factionId;
        this.triggerSetFleetFlag(flag);
    }

    public void triggerSetPirateFleet() {
        this.triggerSetFleetFlagPermanent("$isPirate");
    }

    public void triggerSetTraderFleet() {
        this.triggerSetFleetFlagPermanent("$isTradeFleet");
    }

    public void triggerSetWarFleet() {
        this.triggerSetFleetFlagPermanent("$isWarFleet");
    }

    public void triggerSetSmugglerFleet() {
        this.triggerSetFleetFlagPermanent("$isSmuggler");
    }

    public void triggerFleetAllowLongPursuit() {
        this.triggerSetFleetFlagPermanent("$cfai_longPursuit");
    }

    public void triggerFleetPatherAllowTithe() {
        this.triggerUnsetFleetFlag("$LP_titheAskedFor");
    }

    public void triggerFleetPatherNoDefaultTithe() {
        this.triggerSetFleetFlagPermanent("$LP_titheAskedFor");
    }

    public void triggerFleetUnsetAllowLongPursuit() {
        this.triggerUnsetFleetFlag("$cfai_longPursuit");
    }

    public void triggerFleetSetAvoidPlayerSlowly() {
        this.triggerSetFleetFlag("$cfai_avoidPlayerSlowly");
    }

    public void triggerUnsetAvoidPlayerSlowly() {
        this.triggerUnsetFleetFlag("$cfai_avoidPlayerSlowly");
    }

    public void triggerSetFleetAlwaysPursue() {
        this.triggerSetFleetFlag("$cfai_makeAlwaysPursue");
    }

    public void triggerUnsetFleetAlwaysPursue() {
        this.triggerUnsetFleetFlag("$cfai_makeAlwaysPursue");
    }

    public void triggerSetStandardHostilePirateFlags() {
        this.triggerSetPirateFleet();
        this.triggerMakeHostile();
        this.triggerMakeLowRepImpact();
    }

    public void triggerSetStandardHostileNonPirateFlags() {
        this.triggerMakeHostile();
        this.triggerMakeLowRepImpact();
    }

    public void triggerSetStandardAggroPirateFlags() {
        this.triggerSetPirateFleet();
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
    }

    public void triggerSetStandardAggroNonPirateFlags() {
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
    }

    public void triggerRemoveAbilities(String ... abilities) {
        this.triggerCustomAction(new RemoveAbilitiesAction(abilities));
    }

    public void triggerAddAbilities(String ... abilities) {
        this.triggerCustomAction(new AddAbilitiesAction(abilities));
    }

    public void triggerSetInflater(FleetInflater inflater) {
        this.triggerCustomAction(new SetInflaterAction(inflater));
    }

    public void triggerSetRemnantConfig() {
        this.triggerSetRemnantConfig(false);
    }

    public void triggerSetRemnantConfigDormant() {
        this.triggerSetRemnantConfig(true);
    }

    public void triggerSetRemnantConfig(boolean dormant) {
        long seed = Misc.seedUniquifier() ^ this.genRandom.nextLong();
        this.triggerCustomAction(new SetRemnantConfigAction(dormant, seed));
    }

    public void triggerSetRemnantConfigActive() {
        this.triggerSetRemnantConfig();
        this.triggerAddAbilities("emergency_burn");
        this.triggerAddAbilities("sensor_burst");
        this.triggerAddAbilities("go_dark");
        this.triggerFleetAllowJump();
    }

    public void triggerAddCustomDrop(CargoAPI cargo) {
        this.triggerCustomAction(new AddCustomDropAction(cargo));
    }

    public void triggerAddCommodityDrop(String commodityId, int quantity, boolean dropQuantityBasedOnShipsDestroyed) {
        this.triggerCustomAction(new AddCommodityDropAction(quantity, commodityId, dropQuantityBasedOnShipsDestroyed));
    }

    public void triggerAddCommodityFractionDrop(String commodityId, float fraction) {
        this.triggerCustomAction(new AddCommodityFractionDropAction(fraction, commodityId));
    }

    public void triggerAddWeaponDrop(String weaponId, int quantity) {
        this.triggerCustomAction(new AddWeaponDropAction(quantity, weaponId));
    }

    public void triggerAddFighterLPCDrop(String wingId, int quantity) {
        this.triggerCustomAction(new AddFighterLPCDropAction(wingId, quantity));
    }

    public void triggerAddHullmodDrop(String hullmodId) {
        this.triggerCustomAction(new AddHullmodDropAction(hullmodId));
    }

    public void triggerAddSpecialItemDrop(String itemId, String data) {
        this.triggerCustomAction(new AddSpecialItemDropAction(data, itemId));
    }

    public void triggerSpawnFleetAtPickedLocation() {
        this.triggerSpawnFleetAtPickedLocation(null, null);
    }

    public void triggerSpawnFleetAtPickedLocation(String flag, String refKey) {
        this.triggerSpawnFleetAtPickedLocation(200.0f, flag, refKey);
    }

    public void triggerSpawnFleetAtPickedLocation(float range, String flag, String refKey) {
        this.triggerCustomAction(new SpawnFleetAtPickedLocationAction(range));
        if (flag != null) {
            this.triggerSetFleetFlag(flag);
        }
        if (refKey != null) {
            this.triggerSetFleetMissionRef(refKey);
        }
    }

    public void triggerSpawnFleetNear(SectorEntityToken entity, String flag, String refKey) {
        this.triggerSpawnFleetNear(entity, 200.0f, flag, refKey);
    }

    public void triggerSpawnFleetNear(SectorEntityToken entity, float range, String flag, String refKey) {
        this.triggerCustomAction(new SpawnFleetNearAction(entity, range));
        if (flag != null) {
            this.triggerSetFleetFlag(flag);
        }
        if (refKey != null) {
            this.triggerSetFleetMissionRef(refKey);
        }
    }

    public void triggerPickSetLocation(LocationAPI location, Vector2f coordinates) {
        this.triggerCustomAction(new PickSetLocationAction(coordinates, location));
    }

    public void triggerPickLocationInHyperspace(StarSystemAPI system) {
        this.triggerCustomAction(new PickLocationInHyperspaceAction(system));
    }

    public void triggerPickLocationFromEntityTowardsPlayer(float arc, float dist) {
        this.triggerPickLocationTowardsPlayer(null, arc, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationTowardsPlayer(SectorEntityToken entity, float arc, float dist) {
        this.triggerPickLocationTowardsPlayer(entity, arc, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationFromEntityTowardsPlayer(float arc, float minDist, float maxDist) {
        this.triggerPickLocationAwayFromPlayer(null, arc, DEFAULT_MIN_DIST_FROM_PLAYER, minDist, maxDist);
    }

    public void triggerPickLocationTowardsPlayer(SectorEntityToken entity, float arc, float minDist, float maxDist) {
        this.triggerPickLocationAwayFromPlayer(entity, arc, DEFAULT_MIN_DIST_FROM_PLAYER, minDist, maxDist);
    }

    public void triggerPickLocationFromEntityTowardsPlayer(float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationTowardsPlayerAction(null, arc, minDist, maxDist, minDistFromPlayer));
    }

    public void triggerPickLocationTowardsPlayer(SectorEntityToken entity, float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationTowardsPlayerAction(entity, arc, minDist, maxDist, minDistFromPlayer));
    }

    public void triggerPickLocationTowardsEntity(SectorEntityToken entity, float arc, float dist) {
        this.triggerPickLocationTowardsEntity(entity, arc, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationTowardsEntity(SectorEntityToken entity, float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationTowardsEntityAction(entity, arc, minDist, maxDist, minDistFromPlayer));
    }

    public void triggerPickLocationFromEntityAwayFromPlayer(float arc, float dist) {
        this.triggerPickLocationAwayFromPlayer(null, arc, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationFromEntityAwayFromPlayer(float arc, float minDist, float maxDist) {
        this.triggerPickLocationAwayFromPlayer(null, arc, DEFAULT_MIN_DIST_FROM_PLAYER, minDist, maxDist);
    }

    public void triggerPickLocationFromEntityAwayFromPlayer(float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationAwayFromPlayerAction(minDist, null, maxDist, arc, minDistFromPlayer));
    }

    public void triggerPickLocationAwayFromPlayer(SectorEntityToken entity, float arc, float dist) {
        this.triggerPickLocationAwayFromPlayer(entity, arc, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationAwayFromPlayer(SectorEntityToken entity, float arc, float minDist, float maxDist) {
        this.triggerPickLocationAwayFromPlayer(entity, arc, DEFAULT_MIN_DIST_FROM_PLAYER, minDist, maxDist);
    }

    public void triggerPickLocationAwayFromPlayer(SectorEntityToken entity, float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationAwayFromPlayerAction(minDist, entity, maxDist, arc, minDistFromPlayer));
    }

    public void triggerPickLocationAroundPlayer(float dist) {
        this.triggerPickLocationAroundPlayer(dist, dist);
    }

    public void triggerPickLocationAroundPlayer(float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationAroundPlayerAction(maxDist, minDist));
    }

    public void triggerPickLocationAroundEntity(float dist) {
        this.triggerPickLocationAroundEntity(null, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationAroundEntity(SectorEntityToken entity, float dist) {
        this.triggerPickLocationAroundEntity(entity, DEFAULT_MIN_DIST_FROM_PLAYER, dist, dist);
    }

    public void triggerPickLocationAroundEntity(SectorEntityToken entity, float minDist, float maxDist) {
        this.triggerPickLocationAroundEntity(entity, DEFAULT_MIN_DIST_FROM_PLAYER, minDist, maxDist);
    }

    public void triggerPickLocationAroundEntity(SectorEntityToken entity, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationAroundEntityAction(minDist, entity, maxDist, minDistFromPlayer));
    }

    public void triggerPickLocationAtInSystemJumpPoint(StarSystemAPI system) {
        this.triggerPickLocationAtInSystemJumpPoint(system, DEFAULT_MIN_DIST_FROM_PLAYER);
    }

    public void triggerPickLocationAtInSystemJumpPoint(StarSystemAPI system, float minDistFromPlayer) {
        this.triggerCustomAction(new PickLocationAtInSystemJumpPointAction(system, minDistFromPlayer));
    }

    public void triggerPickLocationAtClosestToPlayerJumpPoint(StarSystemAPI system) {
        this.triggerPickLocationAtClosestToPlayerJumpPoint(system, DEFAULT_MIN_DIST_FROM_PLAYER);
    }

    public void triggerPickLocationAtClosestToPlayerJumpPoint(StarSystemAPI system, float minDistFromPlayer) {
        this.triggerCustomAction(new PickLocationAtClosestToPlayerJumpPointAction(system, minDistFromPlayer));
    }

    public void triggerPickLocationAtClosestToEntityJumpPoint(StarSystemAPI system, SectorEntityToken entity) {
        this.triggerCustomAction(new PickLocationAtClosestToEntityJumpPointAction(system, entity, 0.0f));
    }

    public void triggerPickLocationAtClosestToEntityJumpPoint(StarSystemAPI system, SectorEntityToken entity, float minDistFromEntity) {
        this.triggerCustomAction(new PickLocationAtClosestToEntityJumpPointAction(system, entity, minDistFromEntity));
    }

    public void triggerPickLocationWithinArc(float dir, float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerPickLocationWithinArc(null, dir, arc, minDistFromPlayer, minDist, maxDist);
    }

    public void triggerPickLocationWithinArc(SectorEntityToken entity, float dir, float arc, float minDistFromPlayer, float minDist, float maxDist) {
        this.triggerCustomAction(new PickLocationWithinArcAction(arc, entity, maxDist, minDist, minDistFromPlayer, dir));
    }

    public void triggerSetEntityToPickedJumpPoint() {
        this.triggerCustomAction(new SetEntityToPickedJumpPoint());
    }

    public void triggerFleetSetPatrolActionText(String patrolText) {
        this.triggerCustomAction(new FleetSetPatrolActionText(patrolText));
    }

    public void triggerFleetSetPatrolLeashRange(float dist) {
        this.triggerSetFleetMemoryValue("$cfai_patrolDist", Float.valueOf(dist));
    }

    public void triggerFleetSetTravelActionText(String travelText) {
        this.triggerCustomAction(new FleetSetTravelActionText(travelText));
    }

    public void triggerOrderFleetPatrol(StarSystemAPI system) {
        this.triggerCustomAction(new OrderFleetPatrolSystemAction(system));
    }

    public void triggerOrderFleetPatrol(SectorEntityToken ... patrolPoints) {
        this.triggerOrderFleetPatrol(null, false, patrolPoints);
    }

    public void triggerOrderFleetPatrol(boolean randomizeLocation, SectorEntityToken ... patrolPoints) {
        this.triggerOrderFleetPatrol(null, randomizeLocation, patrolPoints);
    }

    public void triggerOrderFleetPatrol(StarSystemAPI system, boolean randomizeLocation, SectorEntityToken ... patrolPoints) {
        this.triggerCustomAction(new OrderFleetPatrolPointsAction(patrolPoints, randomizeLocation, system));
    }

    public void triggerOrderFleetPatrol(StarSystemAPI system, boolean randomizeLocation, String ... tags) {
        this.triggerCustomAction(new OrderFleetPatrolTagsAction(system, randomizeLocation, tags));
    }

    public void triggerOrderExtraPatrolPoints(SectorEntityToken ... points) {
        int i = this.currTrigger.getActions().size() - 1;
        while (i >= 0) {
            MissionTrigger.TriggerAction action = this.currTrigger.getActions().get(i);
            if (action instanceof OrderFleetPatrolTagsAction) {
                OrderFleetPatrolTagsAction a = (OrderFleetPatrolTagsAction)action;
                if (a.added == null) {
                    a.added = new ArrayList<SectorEntityToken>();
                }
                SectorEntityToken[] sectorEntityTokenArray = points;
                int n = points.length;
                int n2 = 0;
                while (n2 < n) {
                    SectorEntityToken curr = sectorEntityTokenArray[n2];
                    if (curr != null) {
                        a.added.add(curr);
                    }
                    ++n2;
                }
                return;
            }
            if (action instanceof OrderFleetPatrolPointsAction) {
                OrderFleetPatrolPointsAction a = (OrderFleetPatrolPointsAction)action;
                SectorEntityToken[] sectorEntityTokenArray = points;
                int n = points.length;
                int n3 = 0;
                while (n3 < n) {
                    SectorEntityToken curr = sectorEntityTokenArray[n3];
                    if (curr != null) {
                        a.patrolPoints.add(curr);
                    }
                    ++n3;
                }
                return;
            }
            --i;
        }
    }

    public void triggerOrderFleetPatrolEntity(boolean moveToNearEntity) {
        this.triggerCustomAction(new OrderFleetPatrolSpawnedEntity(moveToNearEntity));
    }

    public void triggerOrderFleetPatrolHyper(StarSystemAPI system) {
        this.triggerOrderFleetPatrol(system, false, system.getHyperspaceAnchor());
    }

    public void triggerFleetAddDefeatTrigger(String trigger) {
        this.triggerCustomAction(new AddFleetDefeatTriggerAction(trigger, false));
    }

    public void triggerFleetAddDefeatTriggerPermanent(String trigger) {
        this.triggerCustomAction(new AddFleetDefeatTriggerAction(trigger, true));
    }

    public void triggerMakeFleetGoAwayAfterDefeat() {
        this.triggerCustomAction(new AddFleetDefeatTriggerAction("GoAwayAfterDefeatTrigger", true));
    }

    public void triggerOrderFleetInterceptPlayer() {
        this.triggerOrderFleetInterceptPlayer(false, true);
    }

    public void triggerOrderFleetInterceptPlayer(boolean makeHostile, boolean allowLongPursuit) {
        this.triggerCustomAction(new OrderFleetInterceptPlayerAction(makeHostile));
        if (allowLongPursuit) {
            this.triggerFleetAllowLongPursuit();
        }
    }

    public void triggerOrderFleetMaybeEBurn() {
        this.triggerOrderFleetEBurn(0.5f);
    }

    public void triggerOrderFleetEBurn(float probabilityToEBurn) {
        if (this.genRandom.nextFloat() < probabilityToEBurn) {
            this.triggerCustomAction(new OrderFleetEBurn());
        }
    }

    public void triggerOrderFleetAttackLocation(SectorEntityToken entity) {
        this.triggerOrderFleetPatrol(null, false, entity);
    }

    public void triggerFleetNoAutoDespawn() {
        this.triggerCustomAction(new FleetNoAutoDespawnAction());
    }

    public void triggerFleetStopPursuingPlayerUnlessInStage(Object ... stages) {
        this.triggerCustomAction(new OrderFleetStopPursuingPlayerUnlessInStage(this, stages));
    }

    public void triggerFleetInterceptPlayerWithinRange(boolean mustBeStrongEnoughToFight, float maxRange, boolean repeatable, float repeatDelay, Object ... stages) {
        this.triggerCustomAction(new OrderFleetInterceptNearbyPlayerInStage(this, mustBeStrongEnoughToFight, maxRange, repeatable, repeatDelay, stages));
        this.triggerFleetStopPursuingPlayerUnlessInStage(stages);
    }

    public void triggerFleetInterceptPlayerNearby(boolean mustBeStrongEnoughToFight, Object ... stages) {
        this.triggerFleetInterceptPlayerWithinRange(mustBeStrongEnoughToFight, 500.0f, true, 5.0f, stages);
    }

    public void triggerFleetInterceptPlayerOnSight(boolean mustBeStrongEnoughToFight, Object ... stages) {
        this.triggerFleetInterceptPlayerWithinRange(mustBeStrongEnoughToFight, 10000.0f, true, 5.0f, stages);
    }

    public static Vector2f pickLocationWithinArc(Random random, SectorEntityToken entity, float dir, float arc, float minDistToPlayer, float minDist, float maxDist) {
        float angleIncr = 10.0f;
        float distIncr = (maxDist - minDist) / 5.0f;
        if (distIncr < 1000.0f) {
            distIncr = (maxDist - minDist) / 2.0f;
        }
        if (distIncr < 1.0f) {
            distIncr = 1.0f;
        }
        WeightedRandomPicker<Vector2f> picker = new WeightedRandomPicker<Vector2f>(random);
        float currAngle = dir - arc / 2.0f;
        while (currAngle < dir + arc / 2.0f) {
            float dist = minDist;
            while (dist <= maxDist) {
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(currAngle);
                loc.scale(dist);
                Vector2f.add((Vector2f)entity.getLocation(), (Vector2f)loc, (Vector2f)loc);
                picker.add(loc);
                dist += distIncr;
            }
            currAngle += angleIncr;
        }
        WeightedRandomPicker<Vector2f> copy = new WeightedRandomPicker<Vector2f>(random);
        copy.addAll(picker);
        StarSystemAPI system = entity.getStarSystem();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        Vector2f pick = null;
        LocationAPI containingLocation = entity.getContainingLocation();
        while (!picker.isEmpty()) {
            Vector2f loc = (Vector2f)picker.pickAndRemove();
            if (HubMissionWithTriggers.isNearCorona(system, loc)) continue;
            float distToPlayer = Float.MAX_VALUE;
            if (playerFleet != null && playerFleet.getContainingLocation() == containingLocation && (distToPlayer = Misc.getDistance(playerFleet.getLocation(), loc)) < minDistToPlayer) continue;
            pick = loc;
        }
        if (pick == null) {
            pick = (Vector2f)copy.pick();
        }
        float distToPlayer = Float.MAX_VALUE;
        if (playerFleet != null && playerFleet.getContainingLocation() == containingLocation && (distToPlayer = Misc.getDistance(playerFleet.getLocation(), pick)) < minDistToPlayer) {
            Vector2f away = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(playerFleet.getLocation(), pick));
            away.scale(minDistToPlayer);
            Vector2f.add((Vector2f)playerFleet.getLocation(), (Vector2f)away, (Vector2f)away);
            pick = away;
        }
        return pick;
    }

    public static boolean isNearCorona(StarSystemAPI system, Vector2f loc) {
        if (system == null) {
            return false;
        }
        for (PlanetAPI planet : system.getPlanets()) {
            float radius;
            float dist;
            StarCoronaTerrainPlugin corona;
            if (!planet.isStar() || (corona = Misc.getCoronaFor(planet)) == null || !((dist = Misc.getDistance(planet.getLocation(), loc)) < (radius = corona.getParams().middleRadius + corona.getParams().bandWidthInEngine * 0.5f) + 500.0f)) continue;
            return true;
        }
        return false;
    }

    public void triggerCustomAction(MissionTrigger.TriggerAction action) {
        this.currTrigger.getActions().add(action);
    }

    public void beginGlobalFlagTrigger(String flag, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.GlobalBooleanChecker(flag), stages);
    }

    public void beginDaysElapsedTrigger(float days, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.DaysElapsedChecker(days, this), stages);
    }

    public void beginDaysElapsedTrigger(float days, Object stage, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.DaysElapsedChecker(days, this.getData(stage)), stages);
    }

    public void beginInCommRelayRangeTrigger(Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.InCommRelayRangeChecker(), stages);
    }

    public void beginEnteredLocationTrigger(LocationAPI location, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.EnteredLocationChecker(location), stages);
    }

    public void beginInRangeOfEntityTrigger(SectorEntityToken entity, float range, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.InRangeOfEntityChecker(entity, range), stages);
    }

    public void beginWithinHyperspaceRangeTrigger(SectorEntityToken entity, float rangeLY, boolean requirePlayerInHyperspace, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.InHyperRangeOfEntityChecker(entity, rangeLY, requirePlayerInHyperspace), stages);
    }

    public void beginWithinHyperspaceRangeTrigger(StarSystemAPI system, float rangeLY, boolean requirePlayerInHyperspace, Object ... stages) {
        this.beginWithinHyperspaceRangeTrigger(system.getCenter(), rangeLY, requirePlayerInHyperspace, stages);
    }

    public void beginWithinHyperspaceRangeTrigger(MarketAPI market, float rangeLY, boolean requirePlayerInHyperspace, Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.InHyperRangeOfEntityChecker(market.getPrimaryEntity(), rangeLY, requirePlayerInHyperspace), stages);
    }

    public void beginStageTrigger(Object ... stages) {
        this.beginCustomTrigger(new BaseHubMission.AlwaysTrueChecker(), stages);
    }

    public void beginCustomTrigger(BaseHubMission.ConditionChecker condition, Object ... stages) {
        this.checkExistingTrigger();
        this.currTrigger = new MissionTrigger();
        this.currTrigger.setCondition(condition);
        if (stages != null) {
            Object[] objectArray = stages;
            int n = stages.length;
            int n2 = 0;
            while (n2 < n) {
                Object stage = objectArray[n2];
                this.currTrigger.getStages().add(stage);
                ++n2;
            }
        }
    }

    public void endTrigger() {
        if (this.currTrigger == null) {
            throw new RuntimeException("endTrigger() called without a corresponding beginTrigger()");
        }
        this.triggers.add(this.currTrigger);
        this.currTrigger = null;
    }

    protected void checkExistingTrigger() {
        if (this.currTrigger != null) {
            throw new RuntimeException("Already began a trigger, call endTrigger() to finish it");
        }
    }

    public MissionTrigger getCurrTrigger() {
        return this.currTrigger;
    }

    public void setCurrTrigger(MissionTrigger currTrigger) {
        this.currTrigger = currTrigger;
    }

    public void triggerSpawnEntity(String entityId, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnEntityAction(entityId, data));
    }

    public void triggerSpawnDebrisField(float radius, float density, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnDebrisFieldAction(radius, density, data));
    }

    public void triggerDespawnEntity(SectorEntityToken entity) {
        this.triggerCustomAction(new DespawnEntityAction(entity));
    }

    public void triggerSpawnDerelictHull(String hullId, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnDerelictAction(hullId, null, null, data));
    }

    public void triggerSpawnDerelict(String factionId, DerelictShipEntityPlugin.DerelictType type, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnDerelictAction(null, factionId, type, data));
    }

    public void triggerSpawnDerelict(DerelictShipEntityPlugin.DerelictType type, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnDerelictAction(type, data));
    }

    public void triggerSpawnDerelict(DerelictShipEntityPlugin.DerelictShipData shipData, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnDerelictAction(shipData, data));
    }

    public void triggerSpawnShipGraveyard(String factionId, int minShips, int maxShips, BaseHubMission.LocData data) {
        this.triggerCustomAction(new SpawnShipGraveyardAction(factionId, minShips, maxShips, data));
    }

    public void triggerMakeMissionNodeDiscoverable() {
        this.triggerCustomAction(new MakeDiscoverableAction(1000.0f, 200.0f));
    }

    public void triggerMakeDiscoverable(float range, float xp) {
        this.triggerCustomAction(new MakeDiscoverableAction(range, xp));
    }

    public void triggerFleetAddTags(String ... tags) {
        this.triggerCustomAction(new AddTagsAction(tags));
    }

    public void triggerAddTags(SectorEntityToken entity, String ... tags) {
        this.triggerCustomAction(new GenericAddTagsAction(entity, tags));
    }

    public void triggerRemoveTags(SectorEntityToken entity, String ... tags) {
        this.triggerCustomAction(new GenericRemoveTagsAction(entity, tags));
    }

    public void triggerMakeNonStoryCritical(MemoryAPI ... memoryArray) {
        this.triggerCustomAction(new MakeNonStoryCriticalAction(memoryArray));
    }

    public void triggerMakeNonStoryCritical(String ... markets) {
        String[] stringArray = markets;
        int n = markets.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            MarketAPI market = Global.getSector().getEconomy().getMarket(id);
            if (market != null) {
                this.triggerCustomAction(new MakeNonStoryCriticalAction(market.getMemory()));
            }
            ++n2;
        }
    }

    public void triggerMakeNonStoryCritical(MarketAPI ... markets) {
        MarketAPI[] marketAPIArray = markets;
        int n = markets.length;
        int n2 = 0;
        while (n2 < n) {
            MarketAPI market = marketAPIArray[n2];
            this.triggerCustomAction(new MakeNonStoryCriticalAction(market.getMemory()));
            ++n2;
        }
    }

    public void triggerFleetAddCommanderSkill(String skill, int level) {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa != null && cfa.params != null && cfa.params.commander != null) {
            cfa.params.commander.getStats().setSkillLevel(skill, level);
        } else {
            this.triggerCustomAction(new AddCommanderSkillAction(skill, level));
        }
    }

    public void triggerMakeAllFleetFlagsPermanent() {
        this.triggerCustomAction(new MakeFleetFlagsPermanentAction(true));
    }

    public void triggerUndoMakeAllFleetFlagsPermanent() {
        this.triggerCustomAction(new MakeFleetFlagsPermanentAction(false));
    }

    public static CampaignFleetAPI createFleet(FleetSize size, FleetQuality quality, OfficerNum oNum, OfficerQuality oQuality, String factionId, String fleetFactionId, String type, Vector2f locInHyper) {
        CreateFleetAction action = new CreateFleetAction(type, locInHyper, size, quality, factionId);
        action.oNum = oNum;
        action.oQuality = oQuality;
        action.faction = fleetFactionId;
        MissionTrigger.TriggerActionContext context = new MissionTrigger.TriggerActionContext(null);
        action.doAction(context);
        return context.fleet;
    }

    public void triggerCreateSmallPatrolAroundMarket(MarketAPI market, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(market, null, stage, FleetSize.VERY_SMALL, "patrolMedium", extraSuspicion);
    }

    public void triggerCreateMediumPatrolAroundMarket(MarketAPI market, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(market, null, stage, FleetSize.MEDIUM, "patrolMedium", extraSuspicion);
    }

    public void triggerCreateLargePatrolAroundMarket(MarketAPI market, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(market, null, stage, FleetSize.LARGE, "patrolLarge", extraSuspicion);
    }

    public void triggerCreateSmallPatrol(MarketAPI from, String factionId, SectorEntityToken entityToPatrol, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(from, factionId, entityToPatrol, stage, FleetSize.VERY_SMALL, "patrolMedium", extraSuspicion);
    }

    public void triggerCreateMediumPatrol(MarketAPI from, String factionId, SectorEntityToken entityToPatrol, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(from, factionId, entityToPatrol, stage, FleetSize.MEDIUM, "patrolMedium", extraSuspicion);
    }

    public void triggerCreateLargePatrol(MarketAPI from, String factionId, SectorEntityToken entityToPatrol, Object stage, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(from, factionId, entityToPatrol, stage, FleetSize.LARGE, "patrolLarge", extraSuspicion);
    }

    public void triggerCreatePatrolAroundMarket(MarketAPI market, SectorEntityToken entityToPatrol, Object stage, FleetSize size, String fleetType, float extraSuspicion) {
        this.triggerCreatePatrolAroundMarket(market, null, entityToPatrol, stage, size, fleetType, extraSuspicion);
    }

    public void triggerCreatePatrolAroundMarket(MarketAPI market, String factionId, SectorEntityToken entityToPatrol, Object stage, FleetSize size, String fleetType, float extraSuspicion) {
        if (entityToPatrol == null) {
            entityToPatrol = market.getPrimaryEntity();
        }
        if (factionId == null) {
            factionId = market.getFactionId();
        }
        this.beginWithinHyperspaceRangeTrigger(entityToPatrol, 1.0f, false, stage);
        this.triggerCreateFleet(size, FleetQuality.DEFAULT, factionId, fleetType, entityToPatrol);
        this.triggerAutoAdjustFleetStrengthModerate();
        this.triggerMakeAllFleetFlagsPermanent();
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (faction.getCustomBoolean("pirateBehavior")) {
            this.triggerSetPirateFleet();
        } else {
            this.triggerSetPatrol();
        }
        this.triggerPickLocationAroundEntity(entityToPatrol, 100.0f);
        this.triggerSpawnFleetAtPickedLocation(null, null);
        this.triggerOrderFleetPatrol(entityToPatrol);
        this.triggerSetFleetExtraSmugglingSuspicion(extraSuspicion);
        this.triggerSetFleetNotBusy();
        if (market != null) {
            this.triggerSetFleetMemoryValue("$sourceMarket", market.getId());
        }
        this.endTrigger();
    }

    public ComplicationSpawn pickComplicationSpawnType() {
        WeightedRandomPicker<ComplicationSpawn> picker = new WeightedRandomPicker<ComplicationSpawn>(this.genRandom);
        picker.add(ComplicationSpawn.APPROACHING_SYSTEM);
        picker.add(ComplicationSpawn.ENTERING_SYSTEM);
        picker.add(ComplicationSpawn.EXITING_SYSTEM);
        return (ComplicationSpawn)((Object)picker.pick());
    }

    public void triggerRandomizeFleetProperties() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (this.genRandom.nextFloat() < 0.33f && cfa.fSize != FleetSize.TINY && this.getQuality() > 0.25f) {
            cfa.fSize = cfa.fSize.prev();
            if (cfa.fQuality == null) {
                cfa.fQuality = FleetQuality.DEFAULT;
            }
            cfa.fQuality = cfa.fQuality.next();
            if (cfa.oNum == null) {
                cfa.oNum = OfficerNum.DEFAULT;
            }
            cfa.oNum = cfa.oNum.next();
        } else if (this.genRandom.nextFloat() < 0.5f && cfa.fSize != FleetSize.MAXIMUM) {
            cfa.fSize = cfa.fSize.next();
            if (cfa.fQuality == null) {
                cfa.fQuality = FleetQuality.DEFAULT;
            }
            cfa.fQuality = cfa.fQuality.prev();
        }
    }

    public void triggerComplicationBegin(Object stage, ComplicationSpawn spawnType, StarSystemAPI system, String factionId, String thing, String thingItOrThey, String thingDesc, int paymentOffered, boolean aggressiveIfDeclined, ComplicationRepImpact repImpact, String failTrigger) {
        if (spawnType == ComplicationSpawn.APPROACHING_OR_ENTERING) {
            spawnType = this.pickComplicationSpawnType();
        }
        if ("them".equals(thingItOrThey)) {
            thingItOrThey = "they";
        }
        if (spawnType == ComplicationSpawn.APPROACHING_SYSTEM) {
            this.beginWithinHyperspaceRangeTrigger(system.getCenter(), 3.0f, true, stage);
        } else if (spawnType == ComplicationSpawn.ENTERING_SYSTEM) {
            this.beginEnteredLocationTrigger(system, stage);
        } else if (spawnType == ComplicationSpawn.EXITING_SYSTEM) {
            this.beginWithinHyperspaceRangeTrigger(system, 1.0f, true, stage);
        }
        this.triggerCreateFleet(FleetSize.LARGE, FleetQuality.DEFAULT, factionId, "patrolMedium", system);
        this.triggerSetFleetMissionRef("$" + this.getMissionId() + "_ref");
        this.triggerSetFleetMissionRef("$fwt_ref");
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (aggressiveIfDeclined) {
            this.triggerSetPirateFleet();
            this.triggerMakeHostileAndAggressive();
        }
        if (repImpact == ComplicationRepImpact.LOW) {
            this.triggerMakeLowRepImpact();
        } else if (repImpact == ComplicationRepImpact.NONE) {
            this.triggerMakeNoRepImpact();
        }
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        if (faction.getCustomBoolean("spawnsAsIndependent")) {
            this.triggerSetFleetFaction("independent");
            this.triggerSetFleetMemoryValue("$fwt_originalFaction", factionId);
        }
        if (spawnType == ComplicationSpawn.APPROACHING_SYSTEM) {
            this.triggerPickLocationTowardsPlayer(system.getHyperspaceAnchor(), 90.0f, HubMissionWithTriggers.getUnits(1.5f));
        } else if (spawnType == ComplicationSpawn.ENTERING_SYSTEM) {
            this.triggerPickLocationTowardsPlayer(system.getCenter(), 90.0f, 2000.0f);
        } else if (spawnType == ComplicationSpawn.EXITING_SYSTEM) {
            this.triggerPickLocationAroundPlayer(2000.0f);
        }
        this.triggerOrderFleetInterceptPlayer();
        this.triggerFleetStopPursuingPlayerUnlessInStage(stage);
        this.triggerSpawnFleetAtPickedLocation("$fwt_wantsThing", null);
        this.triggerSetFleetMemoryValue("$fwt_aggressive", aggressiveIfDeclined);
        this.triggerSetFleetMemoryValue("$fwt_thing", this.getWithoutArticle(thing));
        this.triggerSetFleetMemoryValue("$fwt_Thing", Misc.ucFirst(this.getWithoutArticle(thing)));
        this.triggerSetFleetMemoryValue("$fwt_theThing", thing);
        this.triggerSetFleetMemoryValue("$fwt_TheThing", Misc.ucFirst(thing));
        this.triggerSetFleetMemoryValue("$fwt_payment", Misc.getWithDGS(paymentOffered));
        this.triggerSetFleetMemoryValue("$fwt_itOrThey", thingItOrThey);
        this.triggerSetFleetMemoryValue("$fwt_ItOrThey", Misc.ucFirst(thingItOrThey));
        String thingItOrThem = "them";
        if ("it".equals(thingItOrThey)) {
            thingItOrThem = "it";
        }
        this.triggerSetFleetMemoryValue("$fwt_itOrThem", thingItOrThem);
        this.triggerSetFleetMemoryValue("$fwt_ItOrThem", Misc.ucFirst(thingItOrThem));
        this.triggerSetFleetMemoryValue("$fwt_thingDesc", thingDesc);
        this.triggerSetFleetMemoryValue("$fwt_ThingDesc", Misc.ucFirst(thingDesc));
        if (failTrigger == null) {
            failTrigger = "FWTDefaultFailTrigger";
        }
        this.triggerSetFleetMemoryValue("$fwt_missionFailTrigger", failTrigger);
        this.triggerFleetMakeImportant(null, (Enum)stage);
    }

    public void triggerComplicationEnd(boolean randomizeAndAdjustFleetSize) {
        if (randomizeAndAdjustFleetSize) {
            this.triggerRandomizeFleetProperties();
            this.setUseQualityInsteadOfQualityFraction(true);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.setUseQualityInsteadOfQualityFraction(false);
        }
        this.autoAdjustFleetTypeName();
        this.endTrigger();
    }

    public void autoAdjustFleetTypeName() {
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa.params.fleetType != null && cfa.fSizeOverride != null && (cfa.params.fleetType.equals("patrolSmall") || cfa.params.fleetType.equals("patrolMedium") || cfa.params.fleetType.equals("patrolLarge"))) {
            cfa.params.fleetType = cfa.fSizeOverride.floatValue() <= 0.2f ? "patrolSmall" : (cfa.fSizeOverride.floatValue() < 0.7f ? "patrolMedium" : "patrolLarge");
        } else if (cfa.params.fleetType != null && cfa.fSizeOverride != null && (cfa.params.fleetType.equals("scavengerSmall") || cfa.params.fleetType.equals("scavengerMedium") || cfa.params.fleetType.equals("scavengerLarge"))) {
            cfa.params.fleetType = cfa.fSizeOverride.floatValue() <= 0.2f ? "scavengerSmall" : (cfa.fSizeOverride.floatValue() < 0.7f ? "scavengerMedium" : "scavengerLarge");
        }
    }

    public void triggerFleetSetWarnAttack(String warnCommsTrigger, String attackCommsTrigger, Object ... stages) {
        this.triggerSetFleetFlag("$warnAttack", stages);
        this.triggerSetFleetMemoryValue("$warnAttack_warningComms", warnCommsTrigger);
        this.triggerSetFleetMemoryValue("$warnAttack_attackComms", attackCommsTrigger);
        this.triggerFleetInterceptPlayerOnSight(true, stages);
        CreateFleetAction cfa = this.getPreviousCreateFleetAction();
        if (cfa != null && cfa.params != null && cfa.params.factionId != null) {
            this.triggerSetFleetMemoryValue("$warnAttack_factionId", cfa.params.factionId);
        }
    }

    public void triggerFleetAddTugsFlag(int tugs) {
        this.triggerCustomAction(new FleetAddTugs(tugs));
    }

    public void triggerFleetMakeFaster(boolean navigationSkill, int numTugs, boolean allowLongPursuit) {
        if (navigationSkill) {
            this.triggerFleetAddCommanderSkill("navigation", 1);
        }
        if (numTugs > 0) {
            this.triggerFleetAddTugsFlag(numTugs);
        }
        if (allowLongPursuit) {
            this.triggerFleetAllowLongPursuit();
        }
    }

    public static void addTugsToFleet(CampaignFleetAPI fleet, int tugs, Random random) {
        int max = Global.getSettings().getInt("maxShipsInAIFleet");
        if (fleet.getNumMembersFast() + tugs > max) {
            FleetFactoryV3.pruneFleet(max - tugs, 0, fleet, 100000.0f, random);
        }
        FactionAPI faction = fleet.getFaction();
        int i = 0;
        while (i < tugs) {
            FactionAPI.ShipPickParams params = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.ALL);
            List<ShipRolePick> picks = faction.pickShip("tug", params, null, random);
            Iterator<ShipRolePick> iterator = picks.iterator();
            if (iterator.hasNext()) {
                ShipRolePick pick = iterator.next();
                FleetMemberAPI member = fleet.getFleetData().addFleetMember(pick.variantId);
                member.updateStats();
                member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
            }
            ++i;
        }
    }

    public void setFleetDamageTaken(float damage) {
        this.getPreviousCreateFleetAction().damage = Float.valueOf(damage);
    }

    public void setFleetSource(MarketAPI ... preferred) {
        if (preferred == null) {
            return;
        }
        MarketAPI[] marketAPIArray = preferred;
        int n = preferred.length;
        int n2 = 0;
        while (n2 < n) {
            MarketAPI market = marketAPIArray[n2];
            if (!market.hasCondition("decivilized")) {
                this.getPreviousCreateFleetAction().params.setSource(market, true);
                break;
            }
            ++n2;
        }
    }

    public void setFleetSource(String ... preferred) {
        if (preferred == null) {
            return;
        }
        String[] stringArray = preferred;
        int n = preferred.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            MarketAPI market = Global.getSector().getEconomy().getMarket(id);
            if (market != null && !market.hasCondition("decivilized")) {
                this.getPreviousCreateFleetAction().params.setSource(market, true);
                break;
            }
            ++n2;
        }
    }

    public static class AddAbilitiesAction
    implements MissionTrigger.TriggerAction {
        protected String[] abilities;

        public AddAbilitiesAction(String ... abilities) {
            this.abilities = abilities;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.abilities;
            int n = this.abilities.length;
            int n2 = 0;
            while (n2 < n) {
                String ability = stringArray[n2];
                context.fleet.addAbility(ability);
                ++n2;
            }
        }
    }

    public static class AddCommanderSkillAction
    implements MissionTrigger.TriggerAction {
        protected String skill;
        protected int level;

        public AddCommanderSkillAction(String skill, int level) {
            this.skill = skill;
            this.level = level;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.getCommanderStats().setSkillLevel(this.skill, this.level);
        }
    }

    public static class AddCommodityDropAction
    implements MissionTrigger.TriggerAction {
        protected int quantity;
        protected String commodityId;
        protected boolean dropQuantityBasedOnShipsDestroyed;

        public AddCommodityDropAction(int quantity, String commodityId, boolean dropQuantityBasedOnShipsDestroyed) {
            this.quantity = quantity;
            this.commodityId = commodityId;
            this.dropQuantityBasedOnShipsDestroyed = dropQuantityBasedOnShipsDestroyed;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (this.dropQuantityBasedOnShipsDestroyed) {
                context.fleet.getCargo().addCommodity(this.commodityId, this.quantity);
            } else {
                CargoAPI cargo = Global.getFactory().createCargo(true);
                cargo.addCommodity(this.commodityId, this.quantity);
                BaseSalvageSpecial.addExtraSalvage(context.fleet, cargo);
            }
        }
    }

    public static class AddCommodityFractionDropAction
    implements MissionTrigger.TriggerAction {
        protected float fraction;
        protected String commodityId;
        protected boolean dropQuantityBasedOnShipsDestroyed;

        public AddCommodityFractionDropAction(float fraction, String commodityId) {
            this.fraction = fraction;
            this.commodityId = commodityId;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.commodityId);
            float capacity = context.fleet.getCargo().getMaxCapacity();
            if (spec.isFuel()) {
                capacity = context.fleet.getCargo().getMaxFuel();
            } else if (spec.isPersonnel()) {
                capacity = context.fleet.getCargo().getMaxPersonnel();
            }
            int quantity = Math.round(this.fraction * capacity);
            if (quantity > 0) {
                context.fleet.getCargo().addCommodity(this.commodityId, quantity);
            }
        }
    }

    public static class AddCustomDropAction
    implements MissionTrigger.TriggerAction {
        protected CargoAPI cargo;

        public AddCustomDropAction(CargoAPI cargo) {
            this.cargo = cargo;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            BaseSalvageSpecial.addExtraSalvage(context.fleet, this.cargo);
        }
    }

    public static class AddFighterLPCDropAction
    implements MissionTrigger.TriggerAction {
        protected String wingId;
        protected int quantity;

        public AddFighterLPCDropAction(String wingId, int quantity) {
            this.wingId = wingId;
            this.quantity = quantity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            CargoAPI cargo = Global.getFactory().createCargo(true);
            cargo.addFighters(this.wingId, this.quantity);
            BaseSalvageSpecial.addExtraSalvage(context.fleet, cargo);
        }
    }

    public static class AddFleetDefeatTriggerAction
    implements MissionTrigger.TriggerAction {
        protected String trigger;
        protected boolean permanent;

        public AddFleetDefeatTriggerAction(String trigger, boolean permanent) {
            this.trigger = trigger;
            this.permanent = permanent;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            ((BaseHubMission)context.mission).addFleetDefeatTrigger(context.fleet, this.trigger, this.permanent);
        }
    }

    public static class AddHullmodDropAction
    implements MissionTrigger.TriggerAction {
        protected String hullmodId;

        public AddHullmodDropAction(String hullmodId) {
            this.hullmodId = hullmodId;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            CargoAPI cargo = Global.getFactory().createCargo(true);
            cargo.addHullmods(this.hullmodId, 1);
            BaseSalvageSpecial.addExtraSalvage(context.fleet, cargo);
        }
    }

    public static class AddSpecialItemDropAction
    implements MissionTrigger.TriggerAction {
        protected String data;
        protected String itemId;

        public AddSpecialItemDropAction(String data, String itemId) {
            this.data = data;
            this.itemId = itemId;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            CargoAPI cargo = Global.getFactory().createCargo(true);
            cargo.addSpecial(new SpecialItemData(this.itemId, this.data), 1.0f);
            BaseSalvageSpecial.addExtraSalvage(context.fleet, cargo);
        }
    }

    public static class AddTagAfterDelay
    implements MissionTrigger.TriggerAction,
    EveryFrameScript {
        protected String tag;
        protected float delay;
        protected StarSystemAPI system;

        public AddTagAfterDelay(float delay, StarSystemAPI system, String tag) {
            this.delay = delay;
            this.system = system;
            this.tag = tag;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Global.getSector().addScript(this);
        }

        @Override
        public boolean isDone() {
            return this.delay < 0.0f;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void advance(float amount) {
            if (this.delay < 0.0f) {
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.delay -= days;
            if (this.delay < 0.0f) {
                this.system.addTag(this.tag);
            }
        }
    }

    public static class AddTagsAction
    implements MissionTrigger.TriggerAction {
        protected String[] tags;

        public AddTagsAction(String ... tags) {
            this.tags = tags;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                context.fleet.addTag(tag);
                ++n2;
            }
        }
    }

    public static class AddWeaponDropAction
    implements MissionTrigger.TriggerAction {
        protected int quantity;
        protected String weaponId;

        public AddWeaponDropAction(int quantity, String weaponId) {
            this.quantity = quantity;
            this.weaponId = weaponId;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            CargoAPI cargo = Global.getFactory().createCargo(true);
            cargo.addWeapons(this.weaponId, this.quantity);
            BaseSalvageSpecial.addExtraSalvage(context.fleet, cargo);
        }
    }

    public static enum ComplicationRepImpact {
        NONE,
        LOW,
        FULL;

    }

    public static enum ComplicationSpawn {
        APPROACHING_OR_ENTERING,
        APPROACHING_SYSTEM,
        ENTERING_SYSTEM,
        EXITING_SYSTEM;

    }

    public static class CreateFleetAction
    implements MissionTrigger.TriggerAction {
        public long seed = Misc.genRandomSeed();
        public FleetParamsV3 params;
        public FleetSize fSize;
        public Float fSizeOverride;
        public Float combatFleetPointsOverride;
        public FleetQuality fQuality;
        public Float fQualityMod;
        public Integer fQualitySMods;
        public OfficerNum oNum;
        public OfficerQuality oQuality;
        public Boolean doNotIntegrateAICores;
        public String faction = null;
        public Float freighterMult = null;
        public Float tankerMult = null;
        public Float linerMult = null;
        public Float transportMult = null;
        public Float utilityMult = null;
        public Float qualityMod = null;
        public Float qualityOverride = null;
        public Float damage = null;
        public Boolean allWeapons;
        public FactionAPI.ShipPickMode shipPickMode;
        public Boolean removeInflater;
        public String nameOverride = null;
        public Boolean noFactionInName = null;

        public CreateFleetAction(String type, Vector2f locInHyper, FleetSize fSize, FleetQuality fQuality, String factionId) {
            this.params = new FleetParamsV3(locInHyper, factionId, null, type, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.params.ignoreMarketFleetSizeMult = true;
            this.fSize = fSize;
            this.fQuality = fQuality;
            this.freighterMult = Float.valueOf(0.1f);
            this.tankerMult = Float.valueOf(0.1f);
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            DefaultFleetInflater inflater;
            Random random = null;
            random = context.mission != null ? ((BaseHubMission)context.mission).genRandom : Misc.random;
            FactionAPI faction = Global.getSector().getFaction(this.params.factionId);
            float maxPoints = faction.getApproximateMaxFPPerFleet(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
            float min = this.fSize.maxFPFraction - (this.fSize.maxFPFraction - this.fSize.prev().maxFPFraction) / 2.0f;
            float max = this.fSize.maxFPFraction + (this.fSize.next().maxFPFraction - this.fSize.maxFPFraction) / 2.0f;
            float fraction = min + (max - min) * random.nextFloat();
            float excess = 0.0f;
            if (this.fSizeOverride != null) {
                fraction = this.fSizeOverride.floatValue() * (0.95f + random.nextFloat() * 0.1f);
            } else {
                int numShipsDoctrine = 1;
                if (this.params.doctrineOverride != null) {
                    numShipsDoctrine = this.params.doctrineOverride.getNumShips();
                } else if (faction != null) {
                    numShipsDoctrine = faction.getDoctrine().getNumShips();
                }
                float doctrineMult = FleetFactoryV3.getDoctrineNumShipsMult(numShipsDoctrine);
                fraction *= 0.75f * doctrineMult;
                if (fraction > FleetSize.MAXIMUM.maxFPFraction) {
                    excess = fraction - FleetSize.MAXIMUM.maxFPFraction;
                    fraction = FleetSize.MAXIMUM.maxFPFraction;
                }
            }
            float combatPoints = fraction * maxPoints;
            if (this.combatFleetPointsOverride != null) {
                combatPoints = this.combatFleetPointsOverride.floatValue();
            }
            FactionDoctrineAPI doctrine = this.params.doctrineOverride;
            if (excess > 0.0f) {
                int added;
                if (doctrine == null) {
                    doctrine = faction.getDoctrine().clone();
                }
                if ((added = Math.round(excess / 0.1f)) > 0) {
                    doctrine.setOfficerQuality(Math.min(5, doctrine.getOfficerQuality() + added));
                    doctrine.setShipQuality(doctrine.getShipQuality() + added);
                }
            }
            if (this.freighterMult == null) {
                this.freighterMult = Float.valueOf(0.0f);
            }
            if (this.tankerMult == null) {
                this.tankerMult = Float.valueOf(0.0f);
            }
            if (this.linerMult == null) {
                this.linerMult = Float.valueOf(0.0f);
            }
            if (this.transportMult == null) {
                this.transportMult = Float.valueOf(0.0f);
            }
            if (this.utilityMult == null) {
                this.utilityMult = Float.valueOf(0.0f);
            }
            if (this.qualityMod == null) {
                this.qualityMod = Float.valueOf(0.0f);
            }
            this.params.combatPts = combatPoints;
            this.params.freighterPts = combatPoints * this.freighterMult.floatValue();
            this.params.tankerPts = combatPoints * this.tankerMult.floatValue();
            this.params.transportPts = combatPoints * this.transportMult.floatValue();
            this.params.linerPts = combatPoints * this.linerMult.floatValue();
            this.params.utilityPts = combatPoints * this.utilityMult.floatValue();
            this.params.qualityMod = this.qualityMod.floatValue();
            this.params.doctrineOverride = doctrine;
            this.params.random = random;
            if (this.fQuality != null) {
                switch (this.fQuality) {
                    case VERY_LOW: {
                        if (this.fQualityMod != null) {
                            this.params.qualityMod += this.fQuality.qualityMod;
                            break;
                        }
                        this.params.qualityOverride = Float.valueOf(0.0f);
                        break;
                    }
                    case LOWER: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        break;
                    }
                    case DEFAULT: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        break;
                    }
                    case HIGHER: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        break;
                    }
                    case VERY_HIGH: {
                        if (this.fQualityMod != null) {
                            this.params.qualityMod += this.fQuality.qualityMod;
                            break;
                        }
                        this.params.qualityMod += this.fQuality.qualityMod;
                        break;
                    }
                    case SMOD_1: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        this.params.averageSMods = this.fQuality.numSMods;
                        break;
                    }
                    case SMOD_2: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        this.params.averageSMods = this.fQuality.numSMods;
                        break;
                    }
                    case SMOD_3: {
                        this.params.qualityMod += this.fQuality.qualityMod;
                        this.params.averageSMods = this.fQuality.numSMods;
                    }
                }
            }
            if (this.fQualityMod != null) {
                this.params.qualityMod += this.fQualityMod.floatValue();
            }
            if (this.fQualitySMods != null) {
                this.params.averageSMods = this.fQualitySMods;
            }
            if (this.oNum != null) {
                switch (this.oNum) {
                    case NONE: {
                        this.params.withOfficers = false;
                        break;
                    }
                    case FC_ONLY: {
                        this.params.officerNumberMult = 0.0f;
                        break;
                    }
                    case FEWER: {
                        this.params.officerNumberMult = 0.5f;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case MORE: {
                        this.params.officerNumberMult = 1.5f;
                        break;
                    }
                    case ALL_SHIPS: {
                        this.params.officerNumberBonus = Global.getSettings().getInt("maxShipsInAIFleet");
                    }
                }
            }
            if (this.oQuality != null) {
                switch (this.oQuality) {
                    case LOWER: {
                        this.params.officerLevelBonus = -3;
                        this.params.officerLevelLimit = Global.getSettings().getInt("officerMaxLevel") - 1;
                        this.params.commanderLevelLimit = Global.getSettings().getInt("maxAIFleetCommanderLevel") - 2;
                        if (this.params.commanderLevelLimit >= this.params.officerLevelLimit) break;
                        this.params.commanderLevelLimit = this.params.officerLevelLimit;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case HIGHER: {
                        this.params.officerLevelBonus = 2;
                        this.params.officerLevelLimit = Global.getSettings().getInt("officerMaxLevel") + 1;
                        break;
                    }
                    case UNUSUALLY_HIGH: {
                        this.params.officerLevelBonus = 4;
                        this.params.officerLevelLimit = SalvageSpecialAssigner.EXCEPTIONAL_PODS_OFFICER_LEVEL;
                        break;
                    }
                    case AI_GAMMA: 
                    case AI_BETA: 
                    case AI_BETA_OR_GAMMA: 
                    case AI_ALPHA: 
                    case AI_OMEGA: 
                    case AI_MIXED: {
                        this.params.aiCores = this.oQuality;
                    }
                }
                if (this.doNotIntegrateAICores != null) {
                    this.params.doNotIntegrateAICores = this.doNotIntegrateAICores;
                }
            }
            if (this.shipPickMode != null) {
                this.params.modeOverride = this.shipPickMode;
            }
            this.params.updateQualityAndProducerFromSourceMarket();
            if (this.qualityOverride != null) {
                this.params.qualityOverride = Float.valueOf(this.qualityOverride.floatValue() + this.params.qualityMod);
            }
            context.fleet = FleetFactoryV3.createFleet(this.params);
            context.fleet.setFacing(random.nextFloat() * 360.0f);
            if (this.faction != null) {
                context.fleet.setFaction(this.faction, true);
            }
            if (this.nameOverride != null) {
                context.fleet.setName(this.nameOverride);
            }
            if (this.noFactionInName != null && this.noFactionInName.booleanValue()) {
                context.fleet.setNoFactionInName(this.noFactionInName);
            }
            if (this.removeInflater != null && this.removeInflater.booleanValue()) {
                context.fleet.setInflater(null);
            } else if (context.fleet.getInflater() instanceof DefaultFleetInflater && (inflater = (DefaultFleetInflater)context.fleet.getInflater()).getParams() instanceof DefaultFleetInflaterParams) {
                DefaultFleetInflaterParams p = (DefaultFleetInflaterParams)inflater.getParams();
                if (this.allWeapons != null) {
                    p.allWeapons = this.allWeapons;
                }
                if (this.shipPickMode != null) {
                    p.mode = this.shipPickMode;
                }
            }
            context.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", true);
            context.allFleets.add(context.fleet);
            if (!context.fleet.hasScriptOfClass(MissionFleetAutoDespawn.class)) {
                context.fleet.addScript(new MissionFleetAutoDespawn(context.mission, context.fleet));
            }
            if (this.damage != null) {
                FleetFactoryV3.applyDamageToFleet(context.fleet, this.damage.floatValue(), false, random);
            }
        }
    }

    public static class DespawnEntityAction
    implements MissionTrigger.TriggerAction {
        protected SectorEntityToken entity;

        public DespawnEntityAction(SectorEntityToken entity) {
            this.entity = entity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Misc.fadeAndExpire(this.entity);
        }
    }

    public static class EntityMakeImportantAction
    implements MissionTrigger.TriggerAction {
        protected String flag;
        protected Enum[] stages;

        public EntityMakeImportantAction(String flag, Enum ... stages) {
            this.flag = flag;
            this.stages = stages;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            BaseHubMission bhm = (BaseHubMission)context.mission;
            bhm.makeImportant(context.entity, this.flag, this.stages);
            if (Arrays.asList(this.stages).contains(bhm.getCurrentStage())) {
                Misc.makeImportant(context.entity.getMemoryWithoutUpdate(), bhm.getReason());
                bhm.changes.add(new BaseHubMission.MadeImportant(context.entity.getMemoryWithoutUpdate(), bhm.getReason()));
                if (this.flag != null) {
                    context.entity.getMemoryWithoutUpdate().set(this.flag, true);
                    bhm.changes.add(new BaseHubMission.VariableSet(context.entity.getMemoryWithoutUpdate(), this.flag, true));
                }
            }
        }
    }

    public static class FleetAddTugs
    implements MissionTrigger.TriggerAction {
        int numTugs = 0;

        public FleetAddTugs(int numTugs) {
            this.numTugs = numTugs;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (context.fleet != null) {
                HubMissionWithTriggers.addTugsToFleet(context.fleet, this.numTugs, ((BaseHubMission)context.mission).genRandom);
            }
        }
    }

    public static class FleetMakeImportantAction
    implements MissionTrigger.TriggerAction {
        protected String flag;
        protected Enum[] stages;

        public FleetMakeImportantAction(String flag, Enum ... stages) {
            this.flag = flag;
            this.stages = stages;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            BaseHubMission bhm = (BaseHubMission)context.mission;
            bhm.makeImportant(context.fleet, this.flag, this.stages);
            if (this.stages != null && Arrays.asList(this.stages).contains(bhm.getCurrentStage())) {
                Misc.makeImportant(context.fleet.getMemoryWithoutUpdate(), bhm.getReason());
                bhm.changes.add(new BaseHubMission.MadeImportant(context.fleet.getMemoryWithoutUpdate(), bhm.getReason()));
                if (this.flag != null) {
                    context.fleet.getMemoryWithoutUpdate().set(this.flag, true);
                    bhm.changes.add(new BaseHubMission.VariableSet(context.fleet.getMemoryWithoutUpdate(), this.flag, true));
                }
            }
        }
    }

    public static class FleetNoAutoDespawnAction
    implements MissionTrigger.TriggerAction {
        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        }
    }

    public static enum FleetQuality {
        VERY_LOW(-1.0f, 0),
        LOWER(-0.5f, 0),
        DEFAULT(0.0f, 0),
        HIGHER(0.5f, 0),
        VERY_HIGH(1.0f, 0),
        SMOD_1(1.5f, 1),
        SMOD_2(1.5f, 2),
        SMOD_3(1.5f, 3);

        public float qualityMod;
        public int numSMods;
        private static FleetQuality[] vals;

        static {
            vals = FleetQuality.values();
        }

        private FleetQuality(float qualityMod, int numSMods) {
            this.qualityMod = qualityMod;
            this.numSMods = numSMods;
        }

        public FleetQuality next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public FleetQuality prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    public static class FleetSetPatrolActionText
    implements MissionTrigger.TriggerAction {
        protected String text;

        public FleetSetPatrolActionText(String text) {
            this.text = text;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.patrolText = this.text;
        }
    }

    public static class FleetSetTravelActionText
    implements MissionTrigger.TriggerAction {
        protected String text;

        public FleetSetTravelActionText(String text) {
            this.text = text;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.travelText = this.text;
        }
    }

    public static enum FleetSize {
        TINY(0.06f),
        VERY_SMALL(0.1f),
        SMALL(0.2f),
        MEDIUM(0.35f),
        LARGE(0.5f),
        LARGER(0.6f),
        VERY_LARGE(0.7f),
        HUGE(0.9f),
        MAXIMUM(1.1f);

        public float maxFPFraction;
        private static FleetSize[] vals;

        static {
            vals = FleetSize.values();
        }

        private FleetSize(float maxFPFraction) {
            this.maxFPFraction = maxFPFraction;
        }

        public FleetSize next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public FleetSize prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    public static class GenericAddTagsAction
    implements MissionTrigger.TriggerAction {
        protected String[] tags;
        protected SectorEntityToken entity;

        public GenericAddTagsAction(SectorEntityToken entity, String ... tags) {
            this.tags = tags;
            this.entity = entity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.entity.addTag(tag);
                ++n2;
            }
        }
    }

    public static class GenericRemoveTagsAction
    implements MissionTrigger.TriggerAction {
        protected String[] tags;
        protected SectorEntityToken entity;

        public GenericRemoveTagsAction(SectorEntityToken entity, String ... tags) {
            this.tags = tags;
            this.entity = entity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.entity.removeTag(tag);
                ++n2;
            }
        }
    }

    public static class HideCommListing
    implements MissionTrigger.TriggerAction {
        protected PersonAPI person;

        public HideCommListing(PersonAPI person) {
            this.person = person;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (this.person.getMarket() != null) {
                MarketAPI market = this.person.getMarket();
                if (market.getCommDirectory().getEntryForPerson(this.person) == null) {
                    market.getCommDirectory().addPerson(this.person);
                }
                if (market.getCommDirectory().getEntryForPerson(this.person) != null) {
                    market.getCommDirectory().getEntryForPerson(this.person).setHidden(true);
                }
            }
        }
    }

    public static class IncreaseMarketHostileTimeout
    implements MissionTrigger.TriggerAction {
        protected MarketAPI market;
        protected float days;

        public IncreaseMarketHostileTimeout(MarketAPI market, float days) {
            this.market = market;
            this.days = days;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Misc.increaseMarketHostileTimeout(this.market, this.days);
        }
    }

    public static class MakeDiscoverableAction
    implements MissionTrigger.TriggerAction {
        protected float range;
        protected float xp;

        public MakeDiscoverableAction(float range, float xp) {
            this.range = range;
            this.xp = xp;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            ((BaseHubMission)context.mission).makeDiscoverable(context.entity, this.range, this.xp);
        }
    }

    public static class MakeFleetFlagsPermanentAction
    implements MissionTrigger.TriggerAction {
        protected boolean permanent;

        public MakeFleetFlagsPermanentAction(boolean permanent) {
            this.permanent = permanent;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.makeAllFleetFlagsPermanent = this.permanent;
        }
    }

    public static class MakeNonStoryCriticalAction
    implements MissionTrigger.TriggerAction {
        protected MemoryAPI[] memoryArray;

        public MakeNonStoryCriticalAction(MemoryAPI ... memoryArray) {
            this.memoryArray = memoryArray;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            BaseHubMission bhm = (BaseHubMission)context.mission;
            MemoryAPI[] memoryAPIArray = this.memoryArray;
            int n = this.memoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryAPI memory = memoryAPIArray[n2];
                Misc.makeNonStoryCritical(memory, bhm.getReason());
                ++n2;
            }
        }
    }

    public static class MovePersonToMarket
    implements MissionTrigger.TriggerAction {
        protected PersonAPI person;
        protected MarketAPI market;
        protected boolean alwaysAddToComms;

        public MovePersonToMarket(PersonAPI person, MarketAPI market, boolean alwaysAddToComms) {
            this.person = person;
            this.market = market;
            this.alwaysAddToComms = alwaysAddToComms;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Misc.moveToMarket(this.person, this.market, this.alwaysAddToComms);
        }
    }

    public static enum OfficerNum {
        NONE,
        FC_ONLY,
        FEWER,
        DEFAULT,
        MORE,
        ALL_SHIPS;

        private static OfficerNum[] vals;

        static {
            vals = OfficerNum.values();
        }

        public OfficerNum next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public OfficerNum prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    public static enum OfficerQuality {
        LOWER,
        DEFAULT,
        HIGHER,
        UNUSUALLY_HIGH,
        AI_GAMMA,
        AI_BETA,
        AI_BETA_OR_GAMMA,
        AI_ALPHA,
        AI_OMEGA,
        AI_MIXED;

        private static OfficerQuality[] vals;

        static {
            vals = OfficerQuality.values();
        }

        public OfficerQuality next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public OfficerQuality prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    public static class OrderFleetEBurn
    implements MissionTrigger.TriggerAction {
        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            AbilityPlugin eb = context.fleet.getAbility("emergency_burn");
            if (eb != null && eb.isUsable()) {
                eb.activate();
            }
        }
    }

    public static class OrderFleetInterceptNearbyPlayerInStage
    implements MissionTrigger.TriggerAction {
        protected List<Object> stages;
        protected BaseHubMission mission;
        protected float maxRange;
        protected boolean repeatable;
        protected boolean mustBeStrongEnoughToFight;
        protected float repeatDelay;

        public OrderFleetInterceptNearbyPlayerInStage(BaseHubMission mission, boolean mustBeStrongEnoughToFight, float maxRange, boolean repeatable, float repeatDelay, Object ... stages) {
            this.mission = mission;
            this.mustBeStrongEnoughToFight = mustBeStrongEnoughToFight;
            this.maxRange = maxRange;
            this.repeatable = repeatable;
            this.repeatDelay = repeatDelay;
            this.stages = Arrays.asList(stages);
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.addScript(new MissionFleetInterceptPlayerIfNearby(context.fleet, this.mission, this.mustBeStrongEnoughToFight, this.maxRange, this.repeatable, this.repeatDelay, this.stages));
        }
    }

    public static class OrderFleetInterceptPlayerAction
    implements MissionTrigger.TriggerAction {
        protected boolean makeHostile;

        public OrderFleetInterceptPlayerAction(boolean makeHostile) {
            this.makeHostile = makeHostile;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            TransmitterTrapSpecial.makeFleetInterceptPlayer(context.fleet, false, false, this.makeHostile, 1000.0f);
            if (!context.fleet.hasScriptOfClass(MissionFleetAutoDespawn.class)) {
                context.fleet.addScript(new MissionFleetAutoDespawn(context.mission, context.fleet));
            }
        }
    }

    public static class OrderFleetPatrolPointsAction
    implements MissionTrigger.TriggerAction {
        protected List<SectorEntityToken> patrolPoints = new ArrayList<SectorEntityToken>();
        protected boolean randomizeLocation;
        protected StarSystemAPI system;

        public OrderFleetPatrolPointsAction(SectorEntityToken[] patrolPoints, boolean randomizeLocation, StarSystemAPI system) {
            SectorEntityToken[] sectorEntityTokenArray = patrolPoints;
            int n = patrolPoints.length;
            int n2 = 0;
            while (n2 < n) {
                SectorEntityToken curr = sectorEntityTokenArray[n2];
                this.patrolPoints.add(curr);
                ++n2;
            }
            this.randomizeLocation = randomizeLocation;
            this.system = system;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.addScript(new TriggerFleetAssignmentAI(context.travelText, context.patrolText, context.mission, this.system, this.randomizeLocation, context.fleet, this.patrolPoints.toArray(new SectorEntityToken[0])));
        }
    }

    public static class OrderFleetPatrolSpawnedEntity
    implements MissionTrigger.TriggerAction {
        protected boolean moveToNearEntity;

        public OrderFleetPatrolSpawnedEntity(boolean moveToNearEntity) {
            this.moveToNearEntity = moveToNearEntity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            SectorEntityToken entity = context.entity;
            if (entity == null) {
                entity = context.jumpPoint;
            }
            if (entity == null) {
                entity = context.token;
            }
            if (entity == null) {
                entity = context.planet;
            }
            context.fleet.addScript(new TriggerFleetAssignmentAI(context.travelText, context.patrolText, context.mission, context.entity.getContainingLocation(), this.moveToNearEntity, context.fleet, entity));
        }
    }

    public static class OrderFleetPatrolSystemAction
    implements MissionTrigger.TriggerAction {
        protected StarSystemAPI system;

        public OrderFleetPatrolSystemAction(StarSystemAPI system) {
            this.system = system;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.addScript(new TriggerFleetAssignmentAI(context.travelText, context.patrolText, context.mission, this.system, false, context.fleet, null));
        }
    }

    public static class OrderFleetPatrolTagsAction
    implements MissionTrigger.TriggerAction {
        protected List<SectorEntityToken> added;
        protected StarSystemAPI system;
        protected boolean randomizeLocation;
        protected String[] tags;

        public OrderFleetPatrolTagsAction(StarSystemAPI system, boolean randomizeLocation, String ... tags) {
            this.system = system;
            this.randomizeLocation = randomizeLocation;
            this.tags = tags;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            ArrayList<SectorEntityToken> points = new ArrayList<SectorEntityToken>();
            block0: for (SectorEntityToken entity : this.system.getAllEntities()) {
                String[] stringArray = this.tags;
                int n = this.tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    if (entity.hasTag(tag)) {
                        points.add(entity);
                        continue block0;
                    }
                    ++n2;
                }
            }
            if (this.added != null) {
                points.addAll(this.added);
            }
            context.fleet.addScript(new TriggerFleetAssignmentAI(context.travelText, context.patrolText, context.mission, this.system, this.randomizeLocation, context.fleet, points.toArray(new SectorEntityToken[0])));
        }
    }

    public static class OrderFleetStopPursuingPlayerUnlessInStage
    implements MissionTrigger.TriggerAction {
        protected List<Object> stages;
        protected BaseHubMission mission;

        public OrderFleetStopPursuingPlayerUnlessInStage(BaseHubMission mission, Object ... stages) {
            this.mission = mission;
            this.stages = Arrays.asList(stages);
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.addScript(new MissionFleetStopPursuingPlayer(context.fleet, this.mission, this.stages));
        }
    }

    public static class PickLocationAroundEntityAction
    implements MissionTrigger.TriggerAction {
        protected float minDist;
        protected SectorEntityToken entity;
        protected float maxDist;
        protected float minDistFromPlayer;

        public PickLocationAroundEntityAction(float minDist, SectorEntityToken entity, float maxDist, float minDistFromPlayer) {
            this.minDist = minDist;
            this.entity = entity;
            this.maxDist = maxDist;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            if (this.entity == null) {
                this.entity = context.entity;
            }
            if (this.entity == null) {
                this.entity = context.jumpPoint;
            }
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, this.entity, 0.0f, 360.0f, this.minDistFromPlayer, this.minDist, this.maxDist);
            context.containingLocation = this.entity.getContainingLocation();
        }
    }

    public static class PickLocationAroundPlayerAction
    implements MissionTrigger.TriggerAction {
        protected float maxDist;
        protected float minDist;

        public PickLocationAroundPlayerAction(float maxDist, float minDist) {
            this.maxDist = maxDist;
            this.minDist = minDist;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, playerFleet, 0.0f, 360.0f, this.minDist, this.minDist, this.maxDist);
            context.containingLocation = playerFleet.getContainingLocation();
        }
    }

    public static class PickLocationAtClosestToEntityJumpPointAction
    implements MissionTrigger.TriggerAction {
        protected StarSystemAPI system;
        protected float minDistFromEntity;
        protected SectorEntityToken entity;

        public PickLocationAtClosestToEntityJumpPointAction(StarSystemAPI system, SectorEntityToken entity, float minDistFromEntity) {
            this.system = system;
            this.entity = entity;
            this.minDistFromEntity = minDistFromEntity;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(((BaseHubMission)context.mission).genRandom);
            SectorEntityToken closest = null;
            float minDist = Float.MAX_VALUE;
            for (SectorEntityToken jp : this.system.getJumpPoints()) {
                if (this.system.isCurrentLocation()) {
                    float dist = Misc.getDistance(jp, this.entity);
                    if (!(dist < minDist)) continue;
                    closest = jp;
                    minDist = dist;
                    continue;
                }
                picker.add(jp);
            }
            if (closest != null) {
                picker.add(closest);
            }
            SectorEntityToken pick = (SectorEntityToken)picker.pick();
            Vector2f loc = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, pick, 0.0f, 360.0f, this.minDistFromEntity, 0.0f, 0.0f);
            context.jumpPoint = pick;
            context.coordinates = loc;
            context.containingLocation = this.system;
        }
    }

    public static class PickLocationAtClosestToPlayerJumpPointAction
    implements MissionTrigger.TriggerAction {
        protected StarSystemAPI system;
        protected float minDistFromPlayer;

        public PickLocationAtClosestToPlayerJumpPointAction(StarSystemAPI system, float minDistFromPlayer) {
            this.system = system;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(((BaseHubMission)context.mission).genRandom);
            SectorEntityToken closest = null;
            float minDist = Float.MAX_VALUE;
            for (SectorEntityToken jp : this.system.getJumpPoints()) {
                if (this.system.isCurrentLocation()) {
                    float dist = Misc.getDistance(jp, Global.getSector().getPlayerFleet());
                    if (!(dist < minDist)) continue;
                    closest = jp;
                    minDist = dist;
                    continue;
                }
                picker.add(jp);
            }
            if (closest != null) {
                picker.add(closest);
            }
            SectorEntityToken pick = (SectorEntityToken)picker.pick();
            Vector2f loc = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, pick, 0.0f, 360.0f, this.minDistFromPlayer, 0.0f, 0.0f);
            context.jumpPoint = pick;
            context.coordinates = loc;
            context.containingLocation = this.system;
        }
    }

    public static class PickLocationAtInSystemJumpPointAction
    implements MissionTrigger.TriggerAction {
        protected StarSystemAPI system;
        protected float minDistFromPlayer;

        public PickLocationAtInSystemJumpPointAction(StarSystemAPI system, float minDistFromPlayer) {
            this.system = system;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(((BaseHubMission)context.mission).genRandom);
            picker.addAll(this.system.getJumpPoints());
            SectorEntityToken pick = (SectorEntityToken)picker.pick();
            Vector2f loc = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, pick, 0.0f, 360.0f, this.minDistFromPlayer, 0.0f, 0.0f);
            context.jumpPoint = pick;
            context.coordinates = loc;
            context.containingLocation = this.system;
        }
    }

    public static class PickLocationAwayFromPlayerAction
    implements MissionTrigger.TriggerAction {
        protected float minDist;
        protected SectorEntityToken entity;
        protected float maxDist;
        protected float arc;
        protected float minDistFromPlayer;

        public PickLocationAwayFromPlayerAction(float minDist, SectorEntityToken entity, float maxDist, float arc, float minDistFromPlayer) {
            this.minDist = minDist;
            this.entity = entity;
            this.maxDist = maxDist;
            this.arc = arc;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            if (this.entity == null) {
                this.entity = context.entity;
            }
            if (this.entity == null) {
                this.entity = context.jumpPoint;
            }
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            float dir = Misc.getAngleInDegrees(playerFleet.getLocation(), this.entity.getLocation());
            if (playerFleet.getContainingLocation() != this.entity.getContainingLocation()) {
                dir = ((BaseHubMission)context.mission).genRandom.nextFloat() * 360.0f;
            }
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, this.entity, dir, this.arc, this.minDistFromPlayer, this.minDist, this.maxDist);
            context.containingLocation = this.entity.getContainingLocation();
        }
    }

    public static class PickLocationInHyperspaceAction
    implements MissionTrigger.TriggerAction {
        protected StarSystemAPI system;

        public PickLocationInHyperspaceAction(StarSystemAPI system) {
            this.system = system;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, this.system.getHyperspaceAnchor(), 0.0f, 360.0f, 2000.0f, 0.0f, 1000.0f);
            context.containingLocation = Global.getSector().getHyperspace();
        }
    }

    public static class PickLocationTowardsEntityAction
    implements MissionTrigger.TriggerAction {
        protected SectorEntityToken entity;
        protected float arc;
        protected float minDist;
        protected float maxDist;
        protected float minDistFromPlayer;

        public PickLocationTowardsEntityAction(SectorEntityToken entity, float arc, float minDist, float maxDist, float minDistFromPlayer) {
            this.entity = entity;
            this.arc = arc;
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            if (this.entity == null) {
                this.entity = context.entity;
            }
            if (this.entity == null) {
                this.entity = context.jumpPoint;
            }
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            float dir = Misc.getAngleInDegrees(playerFleet.getLocation(), this.entity.getLocation());
            if (playerFleet.getContainingLocation() != this.entity.getContainingLocation()) {
                dir = ((BaseHubMission)context.mission).genRandom.nextFloat() * 360.0f;
            }
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, playerFleet, dir, this.arc, this.minDistFromPlayer, this.minDist, this.maxDist);
            context.containingLocation = this.entity.getContainingLocation();
        }
    }

    public static class PickLocationTowardsPlayerAction
    implements MissionTrigger.TriggerAction {
        protected SectorEntityToken entity;
        protected float arc;
        protected float minDist;
        protected float maxDist;
        protected float minDistFromPlayer;

        public PickLocationTowardsPlayerAction(SectorEntityToken entity, float arc, float minDist, float maxDist, float minDistFromPlayer) {
            this.entity = entity;
            this.arc = arc;
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.minDistFromPlayer = minDistFromPlayer;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            if (this.entity == null) {
                this.entity = context.entity;
            }
            if (this.entity == null) {
                this.entity = context.jumpPoint;
            }
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            float dir = Misc.getAngleInDegrees(playerFleet.getLocation(), this.entity.getLocation());
            dir += 180.0f;
            if (playerFleet.getContainingLocation() != this.entity.getContainingLocation()) {
                dir = ((BaseHubMission)context.mission).genRandom.nextFloat() * 360.0f;
            }
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, this.entity, dir, this.arc, this.minDistFromPlayer, this.minDist, this.maxDist);
            context.containingLocation = this.entity.getContainingLocation();
        }
    }

    public static class PickLocationWithinArcAction
    implements MissionTrigger.TriggerAction {
        protected float arc;
        protected SectorEntityToken entity;
        protected float maxDist;
        protected float minDist;
        protected float minDistFromPlayer;
        protected float dir;

        public PickLocationWithinArcAction(float arc, SectorEntityToken entity, float maxDist, float minDist, float minDistFromPlayer, float dir) {
            this.arc = arc;
            this.entity = entity;
            this.maxDist = maxDist;
            this.minDist = minDist;
            this.minDistFromPlayer = minDistFromPlayer;
            this.dir = dir;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Vector2f pick;
            if (this.entity == null) {
                this.entity = context.entity;
            }
            if (this.entity == null) {
                this.entity = context.jumpPoint;
            }
            context.coordinates = pick = HubMissionWithTriggers.pickLocationWithinArc(((BaseHubMission)context.mission).genRandom, this.entity, this.dir, this.arc, this.minDistFromPlayer, this.minDist, this.maxDist);
            context.containingLocation = this.entity.getContainingLocation();
        }
    }

    public static class PickSetLocationAction
    implements MissionTrigger.TriggerAction {
        protected Vector2f coordinates;
        protected LocationAPI location;

        public PickSetLocationAction(Vector2f coordinates, LocationAPI location) {
            this.coordinates = coordinates;
            this.location = location;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.coordinates = this.coordinates;
            context.containingLocation = this.location;
        }
    }

    public static class RemoveAbilitiesAction
    implements MissionTrigger.TriggerAction {
        protected String[] abilities;

        public RemoveAbilitiesAction(String ... abilities) {
            this.abilities = abilities;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.abilities;
            int n = this.abilities.length;
            int n2 = 0;
            while (n2 < n) {
                String ability = stringArray[n2];
                context.fleet.removeAbility(ability);
                ++n2;
            }
        }
    }

    public static class RunScriptAfterDelay
    implements MissionTrigger.TriggerAction,
    EveryFrameScript {
        protected float delay;
        protected Script script;

        public RunScriptAfterDelay(float delay, Script script) {
            this.script = script;
            this.delay = delay;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Global.getSector().addScript(this);
        }

        @Override
        public boolean isDone() {
            return this.delay < 0.0f;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void advance(float amount) {
            if (this.delay < 0.0f) {
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.delay -= days;
            if (this.delay < 0.0f && this.script != null) {
                this.script.run();
                this.script = null;
            }
        }
    }

    public static class SaveEntityReferenceAction
    implements MissionTrigger.TriggerAction {
        protected MemoryAPI memory;
        protected String key;

        public SaveEntityReferenceAction(MemoryAPI memory, String key) {
            this.memory = memory;
            this.key = key;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            this.memory.set(this.key, context.entity);
            ((BaseHubMission)context.mission).changes.add(new BaseHubMission.VariableSet(this.memory, this.key, true));
        }
    }

    public static class SaveFleetReferenceAction
    implements MissionTrigger.TriggerAction {
        protected MemoryAPI memory;
        protected String key;

        public SaveFleetReferenceAction(MemoryAPI memory, String key) {
            this.memory = memory;
            this.key = key;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            this.memory.set(this.key, context.fleet);
            ((BaseHubMission)context.mission).changes.add(new BaseHubMission.VariableSet(this.memory, this.key, true));
        }
    }

    public static class SetEntityFlagAction
    implements MissionTrigger.TriggerAction {
        protected String flag;
        protected Object[] stages;
        protected boolean permanent;

        public SetEntityFlagAction(String flag, boolean permanent, Object ... stages) {
            this.flag = flag;
            this.permanent = permanent;
            this.stages = stages;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            ((BaseHubMission)context.mission).setFlag(context.entity, this.flag, this.permanent, this.stages);
        }
    }

    public static class SetEntityToPickedJumpPoint
    implements MissionTrigger.TriggerAction {
        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.entity = context.jumpPoint;
        }
    }

    public static class SetFleetFactionAction
    implements MissionTrigger.TriggerAction {
        protected String factionId;

        public SetFleetFactionAction(String factionId) {
            this.factionId = factionId;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.setFaction(this.factionId, true);
        }
    }

    public static class SetFleetFlagAction
    implements MissionTrigger.TriggerAction {
        protected String flag;
        protected Object[] stages;
        protected boolean permanent;

        public SetFleetFlagAction(String flag, boolean permanent, Object ... stages) {
            this.flag = flag;
            this.permanent = permanent;
            this.stages = stages;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (context.makeAllFleetFlagsPermanent) {
                this.permanent = true;
            }
            ((BaseHubMission)context.mission).setFlag(context.fleet, this.flag, this.permanent, this.stages);
        }
    }

    public static class SetFleetFlagsWithReasonAction
    implements MissionTrigger.TriggerAction {
        protected String[] flags;
        protected String reason;
        protected boolean permanent;

        public SetFleetFlagsWithReasonAction(String reason, boolean permanent, String ... flags) {
            this.permanent = permanent;
            this.flags = flags;
            this.reason = reason;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            BaseHubMission bhm = (BaseHubMission)context.mission;
            String[] stringArray = this.flags;
            int n = this.flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                Misc.setFlagWithReason(context.fleet.getMemoryWithoutUpdate(), flag, this.reason, true, -1.0f);
                if (context.makeAllFleetFlagsPermanent) {
                    this.permanent = true;
                }
                if (!this.permanent && bhm != null) {
                    String requiredKey = String.valueOf(flag) + "_" + this.reason;
                    bhm.changes.add(new BaseHubMission.VariableSet(context.fleet.getMemoryWithoutUpdate(), requiredKey, true));
                }
                ++n2;
            }
        }
    }

    public static class SetFleetMemoryValueAction
    implements MissionTrigger.TriggerAction {
        protected String key;
        protected Object value;

        public SetFleetMemoryValueAction(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.getMemoryWithoutUpdate().set(this.key, this.value);
        }
    }

    public static class SetFleetMissionRefAction
    implements MissionTrigger.TriggerAction {
        protected String key;

        public SetFleetMissionRefAction(String key) {
            this.key = key;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.getMemoryWithoutUpdate().set(this.key, context.mission);
        }
    }

    public static class SetInflaterAction
    implements MissionTrigger.TriggerAction {
        protected FleetInflater inflater;

        public SetInflaterAction(FleetInflater inflater) {
            this.inflater = inflater;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.fleet.setInflater(this.inflater);
        }
    }

    public static class SetMemoryValueAction
    implements MissionTrigger.TriggerAction {
        protected String key;
        protected Object value;
        protected MemoryAPI memory;
        protected boolean removeOnMissionOver;

        public SetMemoryValueAction(MemoryAPI memory, String key, Object value, boolean removeOnMissionOver) {
            this.memory = memory;
            this.key = key;
            this.value = value;
            this.removeOnMissionOver = removeOnMissionOver;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            this.memory.set(this.key, this.value);
            BaseHubMission bhm = (BaseHubMission)context.mission;
            bhm.changes.add(new BaseHubMission.VariableSet(this.memory, this.key, this.removeOnMissionOver));
        }
    }

    public static class SetMemoryValueAfterDelay
    implements MissionTrigger.TriggerAction,
    EveryFrameScript {
        protected String key;
        protected Object value;
        protected MemoryAPI memory;
        protected float delay;

        public SetMemoryValueAfterDelay(float delay, MemoryAPI memory, String key, Object value) {
            this.memory = memory;
            this.key = key;
            this.value = value;
            this.delay = delay;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (this.delay <= 0.0f) {
                this.memory.set(this.key, this.value);
            } else {
                Global.getSector().addScript(this);
            }
        }

        @Override
        public boolean isDone() {
            return this.delay < 0.0f;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }

        @Override
        public void advance(float amount) {
            if (this.delay < 0.0f) {
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.delay -= days;
            if (this.delay < 0.0f) {
                this.memory.set(this.key, this.value);
            }
        }
    }

    public static class SetPersonMissionRefAction
    implements MissionTrigger.TriggerAction {
        protected String key;

        public SetPersonMissionRefAction(String key) {
            this.key = key;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.person.getMemoryWithoutUpdate().set(this.key, context.mission);
        }
    }

    public static class SetRemnantConfigAction
    implements MissionTrigger.TriggerAction {
        protected boolean dormant;
        protected long seed;

        public SetRemnantConfigAction(boolean dormant, long seed) {
            this.dormant = dormant;
            this.seed = seed;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            Random random = new Random(this.seed);
            RemnantSeededFleetManager.initRemnantFleetProperties(random, context.fleet, this.dormant);
        }
    }

    public static class SpawnDebrisFieldAction
    implements MissionTrigger.TriggerAction {
        protected float radius;
        protected float density;
        protected BaseHubMission.LocData data;

        public SpawnDebrisFieldAction(float radius, float density, BaseHubMission.LocData data) {
            this.radius = radius;
            this.density = density;
            this.data = data;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            SectorEntityToken entity;
            context.entity = entity = ((BaseHubMission)context.mission).spawnDebrisField(this.radius, this.density, this.data);
        }
    }

    public static class SpawnDerelictAction
    implements MissionTrigger.TriggerAction {
        protected String hullId;
        protected String factionId;
        protected DerelictShipEntityPlugin.DerelictType type;
        protected DerelictShipEntityPlugin.DerelictShipData shipData;
        protected BaseHubMission.LocData data;

        public SpawnDerelictAction(String hullId, String factionId, DerelictShipEntityPlugin.DerelictType type, BaseHubMission.LocData data) {
            this.hullId = hullId;
            this.factionId = factionId;
            this.data = data;
            this.type = type;
        }

        public SpawnDerelictAction(DerelictShipEntityPlugin.DerelictType type, BaseHubMission.LocData data) {
            this.data = data;
            this.type = type;
        }

        public SpawnDerelictAction(DerelictShipEntityPlugin.DerelictShipData shipData, BaseHubMission.LocData data) {
            this.shipData = shipData;
            this.data = data;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            SectorEntityToken entity = null;
            entity = this.hullId != null ? ((BaseHubMission)context.mission).spawnDerelictHull(this.hullId, this.data) : (this.factionId != null ? ((BaseHubMission)context.mission).spawnDerelict(this.factionId, this.type, this.data) : (this.shipData != null ? ((BaseHubMission)context.mission).spawnDerelict(this.shipData, this.data) : ((BaseHubMission)context.mission).spawnDerelictOfType(this.type, this.data)));
            context.entity = entity;
        }
    }

    public static class SpawnEntityAction
    implements MissionTrigger.TriggerAction {
        protected String entityId;
        protected BaseHubMission.LocData data;

        public SpawnEntityAction(String entityId, BaseHubMission.LocData data) {
            this.entityId = entityId;
            this.data = data;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            SectorEntityToken entity;
            context.entity = entity = ((BaseHubMission)context.mission).spawnEntity(this.entityId, this.data);
        }
    }

    public static class SpawnFleetAtPickedLocationAction
    implements MissionTrigger.TriggerAction {
        protected float range;

        public SpawnFleetAtPickedLocationAction(float range) {
            this.range = range;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            context.containingLocation.addEntity(context.fleet);
            Vector2f loc = Misc.getPointWithinRadius(context.coordinates, this.range);
            context.fleet.setLocation(loc.x, loc.y);
        }
    }

    public static class SpawnFleetNearAction
    implements MissionTrigger.TriggerAction {
        protected SectorEntityToken entity;
        protected float range;

        public SpawnFleetNearAction(SectorEntityToken entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            this.entity.getContainingLocation().addEntity(context.fleet);
            Vector2f loc = Misc.getPointWithinRadius(this.entity.getLocation(), this.range);
            context.fleet.setLocation(loc.x, loc.y);
        }
    }

    public static class SpawnShipGraveyardAction
    implements MissionTrigger.TriggerAction {
        protected String factionId;
        protected int minShips;
        protected int maxShips;
        protected BaseHubMission.LocData data;

        public SpawnShipGraveyardAction(String factionId, int minShips, int maxShips, BaseHubMission.LocData data) {
            this.factionId = factionId;
            this.minShips = minShips;
            this.maxShips = maxShips;
            this.data = data;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            ((BaseHubMission)context.mission).spawnShipGraveyard(this.factionId, this.minShips, this.maxShips, this.data);
        }
    }

    public static class UnhideCommListing
    implements MissionTrigger.TriggerAction {
        protected PersonAPI person;

        public UnhideCommListing(PersonAPI person) {
            this.person = person;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            if (this.person.getMarket() != null) {
                MarketAPI market = this.person.getMarket();
                if (market.getCommDirectory().getEntryForPerson(this.person) == null) {
                    market.getCommDirectory().addPerson(this.person);
                }
                if (market.getCommDirectory().getEntryForPerson(this.person) != null) {
                    market.getCommDirectory().getEntryForPerson(this.person).setHidden(false);
                }
            }
        }
    }

    public static class UnsetEntityFlagsAction
    implements MissionTrigger.TriggerAction {
        protected String[] flags;

        public UnsetEntityFlagsAction(String ... flags) {
            this.flags = flags;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.flags;
            int n = this.flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                context.entity.getMemoryWithoutUpdate().unset(flag);
                ++n2;
            }
        }
    }

    public static class UnsetFleetFlagsAction
    implements MissionTrigger.TriggerAction {
        protected String[] flags;

        public UnsetFleetFlagsAction(String ... flags) {
            this.flags = flags;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.flags;
            int n = this.flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                context.fleet.getMemoryWithoutUpdate().unset(flag);
                ++n2;
            }
        }
    }

    public static class UnsetFleetFlagsWithReasonAction
    implements MissionTrigger.TriggerAction {
        protected String[] flags;
        protected String reason;

        public UnsetFleetFlagsWithReasonAction(String reason, String ... flags) {
            this.reason = reason;
            this.flags = flags;
        }

        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            String[] stringArray = this.flags;
            int n = this.flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                Misc.setFlagWithReason(context.fleet.getMemoryWithoutUpdate(), flag, this.reason, false, -1.0f);
                ++n2;
            }
        }
    }
}

