/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IntelMarkerIntel
extends BaseIntelPlugin {
    protected SectorEntityToken loc;
    protected String title;
    protected String icon;
    protected String text;
    protected LinkedHashSet<String> tags = new LinkedHashSet();
    protected FactionAPI faction;

    public IntelMarkerIntel(FactionAPI faction, SectorEntityToken loc, String icon, String title, String text, Set<String> tags) {
        this.faction = faction;
        this.loc = loc;
        this.icon = icon;
        this.title = title;
        this.text = text;
        this.tags.addAll(tags);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float pad = 3.0f;
        float opad = 10.0f;
        c = Misc.getHighlightColor();
        info.addPara(this.title, c, 0.0f);
    }

    @Override
    public String getSortString() {
        return this.title;
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_0;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.text != null && !this.text.isEmpty()) {
            info.addPara(this.text, tc, opad);
        }
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>(this.tags);
        tags.add("New");
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.loc;
    }

    @Override
    public List<IntelInfoPlugin.ArrowData> getArrowData(SectorMapAPI map) {
        ArrayList<IntelInfoPlugin.ArrowData> result = new ArrayList<IntelInfoPlugin.ArrowData>();
        IntelInfoPlugin.ArrowData d = new IntelInfoPlugin.ArrowData(Global.getSector().getPlayerFleet(), this.loc);
        result.add(d);
        return result;
    }

    @Override
    public Color getCircleBorderColorOverride() {
        return Misc.getHighlightColor();
    }
}

