/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.luddic;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class LostOutpostCrewReturnLuddicFind
extends HubMissionWithBarEvent {
    public static String LOCR_LUDDIC_PLANET_KEY = "$locr_luddicPlanet";
    public static String LOCR_LUDDIC = "$locr_luddic";
    public static String LOCRL_LUDDIC_DISCOVERED = "$locr_luddicDiscovered";
    public static String LOCR_LUDDIC_TRANSPORT_KEY = "$locr_luddicTransport";
    protected int rewardAmount;
    protected int rewardAmountHigher;
    protected MarketAPI market;
    protected SectorEntityToken target;
    protected SectorEntityToken target_system;
    protected SectorEntityToken luddic_transport;
    protected PersonAPI person;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$locrlf_ref", "$locrlf_inProgress")) {
            return false;
        }
        this.person = this.getPerson();
        if (this.person == null) {
            return false;
        }
        if (this.person.getFaction().getId() != "luddic_church") {
            return false;
        }
        if (Global.getSector().getMemoryWithoutUpdate().is(LOCRL_LUDDIC_DISCOVERED, true)) {
            return false;
        }
        this.target = Global.getSector().getMemoryWithoutUpdate().getEntity(LOCR_LUDDIC_PLANET_KEY);
        if (this.target == null) {
            return false;
        }
        if (!Global.getSector().getMemoryWithoutUpdate().contains(LOCR_LUDDIC_PLANET_KEY)) {
            return false;
        }
        this.luddic_transport = Global.getSector().getMemoryWithoutUpdate().getEntity(LOCR_LUDDIC_TRANSPORT_KEY);
        if (this.luddic_transport == null) {
            return false;
        }
        this.target_system = this.target.getStarSystem().getCenter();
        if (barEvent) {
            String post = null;
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverImportance(this.pickImportance());
            this.setGiverTags("trade");
            post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_PORTMASTER, Ranks.POST_MERCHANT, Ranks.POST_GUILDMASTER, Ranks.POST_COMMUNE_LEADER, Ranks.POST_ADMINISTRATOR);
            this.findOrCreateGiver(createdAt, false, false);
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_BASE_COMMANDER) || post.equals(Ranks.POST_ADMINISTRATOR)) {
                this.setGiverImportance(this.pickHighImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
        }
        if (!this.setPersonMissionRef(this.person, "$locrlf_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.market = createdAt;
        if (this.market == null) {
            return false;
        }
        this.market.getMemoryWithoutUpdate().set("$locrlf_market", true);
        this.makeImportant(this.luddic_transport, "$locrlf_target", Stage.SEARCH);
        this.makeImportant(this.target.getStarSystem().getHyperspaceAnchor(), null, Stage.SEARCH);
        this.makeImportant(this.person, "$locrlf_return", Stage.RETURN);
        this.setStartingStage((Object)Stage.SEARCH);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.connectWithGlobalFlag((Object)Stage.SEARCH, (Object)Stage.RETURN, "$locrlf_foundHeretics");
        this.connectWithGlobalFlag((Object)Stage.RETURN, (Object)Stage.COMPLETED, "$locrlf_completed");
        this.rewardAmount = 24000;
        this.rewardAmountHigher = 36000;
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$locrlf_barEvent", this.isBarEvent());
        this.set("$locrlf_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$locrlf_heOrShe", this.getPerson().getHeOrShe());
        this.set("$locrlf_himOrHer", this.getPerson().getHimOrHer());
        this.set("$locrlf_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$locrlf_HeOrShe", String.valueOf(this.getPerson().getHeOrShe().substring(0, 1).toUpperCase()) + this.getPerson().getHeOrShe().substring(1));
        this.set("$locrlf_HisOrHer", String.valueOf(this.getPerson().getHisOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHisOrHer().substring(1));
        this.set("$locrlf_HimOrHer", String.valueOf(this.getPerson().getHimOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHimOrHer().substring(1));
        this.set("$locrlf_rewardAmount", Misc.getWithDGS(this.rewardAmount));
        this.set("$locrlf_rewardAmountHigher", Misc.getWithDGS(this.rewardAmountHigher));
        this.set("$locrlf_person", this.getPerson());
        this.set("$locrlf_personName", this.getPerson().getNameString());
        this.set("$locrlf_systemName", this.target.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$locrlf_transportName", this.luddic_transport.getName());
        this.set("$locrlf_dist", this.getDistanceLY(this.target));
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("addPersonToMarket".equals(action)) {
            Misc.moveToMarket(this.person, this.market, true);
            if (this.person.getMarket() == null) {
                return false;
            }
            if (this.person.getMarket().getCommDirectory() == null) {
                return false;
            }
            if (this.person.getMarket().getCommDirectory().getEntryForPerson(this.person.getId()) == null) {
                return false;
            }
            this.person.getMarket().getCommDirectory().getEntryForPerson(this.person.getId()).setHidden(false);
            return true;
        }
        return false;
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.SEARCH) {
            info.addPara("Search the " + this.target_system.getStarSystem().getNameWithLowercaseTypeShort() + " for the lost group of Luddic heretics.", opad);
        } else if (this.currentStage == Stage.RETURN) {
            info.addPara("Return to " + this.person.getNameString() + " to report that you found " + "the lost Luddic heretics.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.SEARCH) {
            info.addPara("Search for the Luddic heretics in the " + this.target_system.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN) {
            info.addPara("Return with news of the Luddic heretics to " + this.person.getNameString() + ".", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "The Stray Flock";
    }

    public static enum Stage {
        SEARCH,
        COMPLETED,
        RETURN,
        FAILED;

    }
}

