/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.luddic;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.LuddicShrineIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LuddicPilgrimsPath
extends HubMissionWithSearch {
    public static String VISITED_SHRINE_JANGALA = "$lpp_visitedShrineJangala";
    public static String VISITED_SHRINE_KILLA = "$lpp_visitedShrineKilla";
    public static String VISITED_SHRINE_VOLTURN = "$lpp_visitedShrineVolturn";
    public static String VISITED_SHRINE_CHICOMOZTOC = "$lpp_visitedShrineChicomoztoc";
    public static String VISITED_SHRINE_GILEAD = "$lpp_visitedShrineGilead";
    public static String VISITED_SHRINE_BEHOLDER = "$lpp_visitedShrineBeholder";
    protected int xpRewardBase = 10000;
    protected int xpRewardIncrease = 2000;
    protected int num_rewards_given = 0;
    protected MarketAPI volturn;
    protected MarketAPI gilead;
    protected MarketAPI jangala;
    protected MarketAPI hesperus;
    protected SectorEntityToken killa;
    protected SectorEntityToken beholder_station;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$lpp_ref", "$lpp_inProgress")) {
            return false;
        }
        this.volturn = Global.getSector().getEconomy().getMarket("volturn");
        if (this.volturn == null) {
            return false;
        }
        this.gilead = Global.getSector().getEconomy().getMarket("gilead");
        if (this.gilead == null) {
            return false;
        }
        this.jangala = Global.getSector().getEconomy().getMarket("jangala");
        if (this.jangala == null) {
            return false;
        }
        this.hesperus = Global.getSector().getEconomy().getMarket("hesperus");
        if (this.hesperus == null) {
            return false;
        }
        StarSystemAPI yma = Global.getSector().getStarSystem("yma");
        Iterator<SectorEntityToken> iterator = yma.getEntitiesWithTag("luddic_shrine").iterator();
        if (iterator.hasNext()) {
            SectorEntityToken curr;
            this.killa = curr = iterator.next();
        }
        if (this.killa == null) {
            return false;
        }
        StarSystemAPI kumarikandam = Global.getSector().getStarSystem("kumari kandam");
        Iterator<SectorEntityToken> iterator2 = kumarikandam.getEntitiesWithTag("luddic_shrine").iterator();
        if (iterator2.hasNext()) {
            SectorEntityToken curr;
            this.beholder_station = curr = iterator2.next();
        }
        if (this.beholder_station == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.VISIT_SHRINES);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_GILEAD, "$lpp_visitedAllShrines");
        this.makeImportant(this.gilead, "$lpp_finishPilgrimage", Stage.RETURN_TO_GILEAD);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$lpp_completed");
        this.setName("The Pilgrim's Path");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerMakeNonStoryCritical("jangala", "hesperus", "gilead", "volturn");
        this.triggerSetGlobalMemoryValue("$lpp_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$lpp_stage", this.getCurrentStage());
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("giveVisitXP".equals(action)) {
            ++this.num_rewards_given;
            long xp_to_give = this.num_rewards_given * this.xpRewardIncrease + this.xpRewardBase;
            Global.getSector().getPlayerStats().addXP(xp_to_give, dialog.getTextPanel());
            return true;
        }
        if ("giveLastVisitXP".equals(action)) {
            ++this.num_rewards_given;
            long xp_to_give = this.num_rewards_given * this.xpRewardIncrease + this.xpRewardBase;
            int visited_shrines = this.getNumberOfShrinesVisited();
            if (this.num_rewards_given < visited_shrines) {
                int i = this.num_rewards_given;
                while (i < visited_shrines) {
                    xp_to_give += (long)(i * this.xpRewardIncrease + this.xpRewardBase);
                    ++i;
                }
            }
            Global.getSector().getPlayerStats().addXP(xp_to_give, dialog.getTextPanel());
            return true;
        }
        if ("checkShrinesVisited".equals(action)) {
            int visited_shrines = this.getNumberOfShrinesVisited();
            int numberOfShrinesToComplete = 6;
            System.out.print("checkShrinesVisited = " + Integer.toString(visited_shrines));
            if (visited_shrines >= numberOfShrinesToComplete) {
                Global.getSector().getMemoryWithoutUpdate().set("$lpp_visitedAllShrines", true);
            }
            return true;
        }
        if ("postMissionCleanup".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().unset("$lpp_didHesperusFirstShrineAttempt");
            Global.getSector().getMemoryWithoutUpdate().unset("$lpp_didHookStart");
            this.gilead.getMemoryWithoutUpdate().unset("$lpp_finishPilgrimage");
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.getFactionForUIColors();
        PersonAPI person = this.getPerson();
        info.addImage(Global.getSettings().getSpriteName("illustrations", "luddic_shrine"), width, opad);
        this.addDescriptionForCurrentStage(info, width, height);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.VISIT_SHRINES) {
            info.addPara("Visit the six shrines of the Pilgrim's Path. The pilgrimage is traditionally completed by returning to Gilead, in the Canaan system.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_GILEAD) {
            info.addPara("Return to the shrine of Gilead in the Canaan system to complete the Pilgrim's Path.", opad);
        }
        LuddicShrineIntel.addShowShrinesButton(this, width, height, info);
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.VISIT_SHRINES) {
            info.addPara("Visit the six Luddic shrines", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_GILEAD) {
            info.addPara("Complete the pilgrimage on Gilead, in the Canaan system", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Pilgrim's Path";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == LuddicShrineIntel.BUTTON_SHOW_SHRINES) {
            LuddicShrineIntel.toggleShrineList(this, ui);
            return;
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    public int getNumberOfShrinesVisited() {
        int count = 0;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicShrineIntel.class)) {
            LuddicShrineIntel shrine = (LuddicShrineIntel)intel;
            if (!LuddicShrineIntel.isVisited(shrine.getEntity())) continue;
            ++count;
        }
        System.out.print(" Shrine count found = " + count);
        return count;
    }

    public static int getTotalShrines() {
        return Global.getSector().getIntelManager().getIntel(LuddicShrineIntel.class).size();
    }

    public static enum Stage {
        VISIT_SHRINES,
        RETURN_TO_GILEAD,
        COMPLETED;

    }
}

